/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.testFramework.JavaPsiTestCase;
import com.intellij.testFramework.VfsTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaResolveTestCase
extends JavaPsiTestCase {
    protected static final String MARKER = "<ref>";
    private Document myDocument;

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myDocument != null) {
                FileDocumentManager.getInstance().reloadFromDisk(this.myDocument);
                this.myDocument = null;
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected PsiReference configureByFile(@NotNull String filePath) throws Exception {
        if (filePath == null) {
            JavaResolveTestCase.$$$reportNull$$$0(0);
        }
        return this.configureByFile(filePath, null);
    }

    protected PsiReference configureByFile(@NotNull String filePath, @Nullable VirtualFile parentDir) throws Exception {
        if (filePath == null) {
            JavaResolveTestCase.$$$reportNull$$$0(1);
        }
        VirtualFile vFile = VfsTestUtil.findFileByCaseSensitivePath((String)(this.getTestDataPath() + filePath));
        JavaResolveTestCase.assertNotNull((String)("file " + filePath + " not found"), (Object)vFile);
        String fileText = StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)vFile));
        return this.configureByFileText(fileText, vFile.getName(), parentDir);
    }

    protected PsiReference configureByFileText(String fileText, String fileName) throws Exception {
        return this.configureByFileText(fileText, fileName, null);
    }

    protected PsiReference configureByFileText(String fileText, String fileName, @Nullable VirtualFile parentDir) throws Exception {
        int offset = fileText.indexOf(MARKER);
        JavaResolveTestCase.assertTrue((String)String.format("Expected to find %s marker in file but was none", MARKER), (offset >= 0 ? 1 : 0) != 0);
        fileText = fileText.substring(0, offset) + fileText.substring(offset + MARKER.length());
        if (parentDir == null) {
            this.myFile = this.createFile(this.myModule, fileName, fileText);
        } else {
            VirtualFile existing = parentDir.findChild(fileName);
            if (existing != null) {
                this.myDocument = FileDocumentManager.getInstance().getDocument(existing);
                JavaResolveTestCase.assertNotNull((Object)this.myDocument);
                String finalFileText = fileText;
                ApplicationManager.getApplication().runWriteAction(() -> this.myDocument.setText((CharSequence)finalFileText));
                this.myFile = PsiManager.getInstance((Project)this.getProject()).findFile(existing);
                JavaResolveTestCase.assertNotNull((Object)this.myFile);
                JavaResolveTestCase.assertEquals((String)fileText, (String)this.myFile.getText());
            } else {
                this.myFile = this.createFile(this.myModule, parentDir, fileName, fileText);
            }
        }
        PsiReference ref = this.myFile.findReferenceAt(offset);
        JavaResolveTestCase.assertNotNull((Object)ref);
        return ref;
    }

    @Override
    @NotNull
    protected String getTestDataPath() {
        String string = PathManagerEx.getTestDataPath() + "/psi/resolve/";
        if (string == null) {
            JavaResolveTestCase.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/JavaResolveTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/JavaResolveTestCase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureByFile";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

