/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToggleStateAction
extends ToggleAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(BaseToggleStateAction.class);

    @NotNull
    protected abstract String getBoundString(@NotNull CharSequence var1, int var2, int var3);

    @Nullable
    protected String getExistingBoundString(@NotNull CharSequence text, int startOffset) {
        if (text == null) {
            BaseToggleStateAction.$$$reportNull$$$0(0);
        }
        return String.valueOf(text.charAt(startOffset));
    }

    protected abstract boolean shouldMoveToWordBounds();

    @NotNull
    protected abstract IElementType getTargetNodeType();

    @NotNull
    protected SelectionState getCommonState(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            BaseToggleStateAction.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            BaseToggleStateAction.$$$reportNull$$$0(2);
        }
        SelectionState selectionState = MarkdownActionUtil.getCommonParentOfType(element1, element2, this.getTargetNodeType()) == null ? SelectionState.NO : SelectionState.YES;
        if (selectionState == null) {
            BaseToggleStateAction.$$$reportNull$$$0(3);
        }
        return selectionState;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseToggleStateAction.$$$reportNull$$$0(4);
        }
        e.getPresentation().setEnabled(MarkdownActionUtil.findMarkdownTextEditor(e) != null);
        super.update(e);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseToggleStateAction.$$$reportNull$$$0(5);
        }
        Editor editor = MarkdownActionUtil.findMarkdownTextEditor(e);
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor == null || psiFile == null) {
            return false;
        }
        SelectionState lastState = null;
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            Couple<PsiElement> elements = MarkdownActionUtil.getElementsUnderCaretOrSelection(psiFile, caret);
            if (elements == null) continue;
            SelectionState state = this.getCommonState((PsiElement)elements.getFirst(), (PsiElement)elements.getSecond());
            if (lastState == null) {
                lastState = state;
                continue;
            }
            if (lastState == state) continue;
            lastState = SelectionState.INCONSISTENT;
            break;
        }
        if (lastState == SelectionState.INCONSISTENT) {
            e.getPresentation().setEnabled(false);
            return false;
        }
        e.getPresentation().setEnabled(true);
        return lastState == SelectionState.YES;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            BaseToggleStateAction.$$$reportNull$$$0(6);
        }
        Editor editor = MarkdownActionUtil.findMarkdownTextEditor(e);
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor == null || psiFile == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)psiFile.getProject(), (String)this.getTemplatePresentation().getText(), null, () -> {
            if (!psiFile.isValid()) {
                return;
            }
            Document document = editor.getDocument();
            for (Caret caret : ContainerUtil.reverse((List)editor.getCaretModel().getAllCarets())) {
                if (!state) {
                    Couple<PsiElement> elements = MarkdownActionUtil.getElementsUnderCaretOrSelection(psiFile, caret);
                    if (elements == null) continue;
                    PsiElement closestEmph = MarkdownActionUtil.getCommonParentOfType((PsiElement)elements.getFirst(), (PsiElement)elements.getSecond(), this.getTargetNodeType());
                    if (closestEmph == null) {
                        LOG.warn("Could not find enclosing element on its destruction");
                        continue;
                    }
                    TextRange range = closestEmph.getTextRange();
                    this.removeEmphFromSelection(document, caret, range);
                    continue;
                }
                this.addEmphToSelection(document, caret);
            }
            PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitDocument(document);
        }, (PsiFile[])new PsiFile[0]);
    }

    public void removeEmphFromSelection(@NotNull Document document, @NotNull Caret caret, @NotNull TextRange nodeRange) {
        CharSequence text;
        String boundString;
        if (document == null) {
            BaseToggleStateAction.$$$reportNull$$$0(7);
        }
        if (caret == null) {
            BaseToggleStateAction.$$$reportNull$$$0(8);
        }
        if (nodeRange == null) {
            BaseToggleStateAction.$$$reportNull$$$0(9);
        }
        if ((boundString = this.getExistingBoundString(text = document.getCharsSequence(), nodeRange.getStartOffset())) == null) {
            LOG.warn("Could not fetch bound string from found node");
            return;
        }
        int boundLength = boundString.length();
        if (nodeRange.getStartOffset() + boundLength == caret.getSelectionStart() && nodeRange.getEndOffset() - boundLength == caret.getSelectionEnd()) {
            document.deleteString(nodeRange.getEndOffset() - boundLength, nodeRange.getEndOffset());
            document.deleteString(nodeRange.getStartOffset(), nodeRange.getStartOffset() + boundLength);
            return;
        }
        int from = caret.getSelectionStart();
        int to = caret.getSelectionEnd();
        if (this.shouldMoveToWordBounds()) {
            while (from - boundLength > nodeRange.getStartOffset() && Character.isWhitespace(text.charAt(from - 1))) {
                --from;
            }
            while (to + boundLength < nodeRange.getEndOffset() && Character.isWhitespace(text.charAt(to))) {
                ++to;
            }
        }
        if (to + boundLength == nodeRange.getEndOffset()) {
            document.deleteString(nodeRange.getEndOffset() - boundLength, nodeRange.getEndOffset());
        } else {
            document.insertString(to, (CharSequence)boundString);
        }
        if (from - boundLength == nodeRange.getStartOffset()) {
            document.deleteString(nodeRange.getStartOffset(), nodeRange.getStartOffset() + boundLength);
        } else {
            document.insertString(from, (CharSequence)boundString);
        }
    }

    public void addEmphToSelection(@NotNull Document document, @NotNull Caret caret) {
        int from;
        if (document == null) {
            BaseToggleStateAction.$$$reportNull$$$0(10);
        }
        if (caret == null) {
            BaseToggleStateAction.$$$reportNull$$$0(11);
        }
        int to = caret.getSelectionEnd();
        CharSequence text = document.getCharsSequence();
        if (this.shouldMoveToWordBounds()) {
            for (from = caret.getSelectionStart(); from < to && Character.isWhitespace(text.charAt(from)); ++from) {
            }
            while (to > from && Character.isWhitespace(text.charAt(to - 1))) {
                --to;
            }
            if (from == to) {
                from = caret.getSelectionStart();
                to = caret.getSelectionEnd();
            }
        }
        String boundString = this.getBoundString(text, from, to);
        document.insertString(to, (CharSequence)boundString);
        document.insertString(from, (CharSequence)boundString);
        if (caret.getSelectionStart() == caret.getSelectionEnd()) {
            caret.moveCaretRelatively(boundString.length(), 0, false, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/actions/styling/BaseToggleStateAction";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/actions/styling/BaseToggleStateAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExistingBoundString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCommonState";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeEmphFromSelection";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addEmphToSelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static enum SelectionState {
        YES,
        NO,
        INCONSISTENT;

    }
}

