/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.ngram;

import com.intellij.grazie.detector.LanguageDetector;
import com.intellij.grazie.detector.model.DetectedLanguage;
import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.detector.ngram.NgramDetector;
import com.intellij.grazie.detector.ngram.impl.NgramExtractor;
import com.intellij.grazie.detector.ngram.impl.NgramFrequencies;
import com.intellij.grazie.detector.utils.StatisticsKt;
import com.intellij.grazie.detector.utils.collections.array.OptimizedFloatArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0013\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001(B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u0017J&\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00022\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J*\u0010\u001d\u001a\u00020\u00192\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u00172\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0019H\u0002J \u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000f*\u00020\u0019H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/grazie/detector/ngram/NgramDetector;", "Lcom/intellij/grazie/detector/LanguageDetector;", "", "ngramFrequencies", "Lcom/intellij/grazie/detector/ngram/impl/NgramFrequencies;", "alpha", "", "prefixFactor", "suffixFactor", "probabilityThreshold", "minimalConfidence", "ngramExtractor", "Lcom/intellij/grazie/detector/ngram/impl/NgramExtractor;", "(Lcom/intellij/grazie/detector/ngram/impl/NgramFrequencies;DDDDDLcom/intellij/grazie/detector/ngram/impl/NgramExtractor;)V", "languages", "", "Lcom/intellij/grazie/detector/model/Language;", "getLanguages", "()Ljava/util/List;", "detect", "Lcom/intellij/grazie/detector/LanguageDetector$DetectionResult;", "input", "weights", "", "detectBlock", "", "text", "initProbability", "priorMap", "makeInternalPrioMap", "langWeightingMap", "langlist", "normalizeProb", "prob", "updateLangProb", "", "ngram", "", "sortProbability", "Lcom/intellij/grazie/detector/model/DetectedLanguage;", "Companion", "language-detector"})
public final class NgramDetector
implements LanguageDetector<CharSequence> {
    @NotNull
    private final List<Language> languages;
    private final NgramFrequencies ngramFrequencies;
    private final double alpha;
    private final double prefixFactor;
    private final double suffixFactor;
    private final double probabilityThreshold;
    private final double minimalConfidence;
    private final NgramExtractor ngramExtractor;
    private static final double ALPHA_WIDTH = 0.05;
    private static final int ITERATION_LIMIT = 1000;
    private static final double CONV_THRESHOLD = 0.99999;
    private static final int BASE_FREQ = 10000;
    private static final int N_TRIAL = 7;
    private static final long DEFAULT_SEED = 41L;
    private static final Comparator<DetectedLanguage> PROBABILITY_SORTING_COMPARATOR;
    @NotNull
    private static final List<Language> supported;
    public static final Companion Companion;

    @NotNull
    public final List<Language> getLanguages() {
        return this.languages;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LanguageDetector.DetectionResult detect(@NotNull CharSequence input) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Iterable iterable = this.languages;
        CharSequence charSequence = input;
        NgramDetector ngramDetector = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Language language = (Language)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)1.0);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        return ngramDetector.detect(charSequence, StatisticsKt.normalize(MapsKt.toMap((Iterable)collection)));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final LanguageDetector.DetectionResult detect(@NotNull CharSequence input, @NotNull Map<Language, Double> weights) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(weights, (String)"weights");
        v0 = this.detectBlock(input, weights);
        var4_3 = v0 != null ? this.sortProbability(v0) : null;
        var5_4 = false;
        v1 = var4_3;
        if (v1 == null) {
            v1 = CollectionsKt.emptyList();
        }
        probabilites = v1;
        $this$maxBy$iv = probabilites;
        $i$f$maxBy = false;
        iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                it = (DetectedLanguage)maxElem$iv;
                $i$a$-maxBy-NgramDetector$detect$prob$1 = false;
                maxValue$iv = it.getProbability();
                do {
                    e$iv = iterator$iv.next();
                    it = (DetectedLanguage)e$iv;
                    $i$a$-maxBy-NgramDetector$detect$prob$1 = false;
                    v$iv = it.getProbability();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        if ((v3 = (DetectedLanguage)v2) == null) ** GOTO lbl-1000
        var5_5 = v3;
        var6_7 = false;
        var7_9 = false;
        it = var5_5;
        $i$a$-takeIf-NgramDetector$detect$prob$2 = false;
        v3 = it.getProbability() >= this.minimalConfidence != false ? var5_5 : null;
        if (v3 != null) {
            v4 = v3.getLang();
        } else lbl-1000:
        // 2 sources

        {
            v4 = null;
        }
        if ((v5 = (prob = v4)) == null) {
            v5 = Language.UNKNOWN;
        }
        return new LanguageDetector.DetectionResult(LanguageDetector.Type.Ngram, v5, CollectionsKt.toSortedSet((Iterable)probabilites));
    }

    /*
     * WARNING - void declaration
     */
    private final double[] detectBlock(CharSequence text, Map<Language, Double> weights) {
        List<String> ngrams = this.ngramExtractor.extract(text);
        if (ngrams.isEmpty()) {
            return null;
        }
        double[] prior = this.makeInternalPrioMap(weights, this.ngramFrequencies.getLanguages());
        double[] langprob = new double[this.ngramFrequencies.getLanguages().size()];
        Random rand = new Random(41L);
        int n = 0;
        int n2 = 7;
        while (n < n2) {
            void trial;
            int i;
            double[] prob = this.initProbability(prior);
            double alpha = this.alpha + rand.nextGaussian() * 0.05;
            int n3 = 0;
            int n4 = 1000;
            while (n3 < n4) {
                String randomNgram = ngrams.get(rand.nextInt(ngrams.size()));
                this.updateLangProb(prob, randomNgram, alpha);
                if (i % 5 == 0 && this.normalizeProb(prob) > 0.99999) break;
                ++i;
            }
            i = 0;
            n4 = langprob.length;
            while (i < n4) {
                void j;
                void v0 = j;
                langprob[v0] = langprob[v0] + prob[j] / (double)7;
                ++j;
            }
            ++trial;
        }
        return langprob;
    }

    /*
     * WARNING - void declaration
     */
    private final double[] initProbability(double[] priorMap) {
        double[] prob = new double[this.ngramFrequencies.getLanguages().size()];
        System.arraycopy(priorMap, 0, prob, 0, prob.length);
        int n = 0;
        int n2 = prob.length;
        while (n < n2) {
            void i;
            prob[i] = priorMap[i];
            ++i;
        }
        return prob;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean updateLangProb(double[] prob, String ngram, double alpha) {
        OptimizedFloatArray optimizedFloatArray = this.ngramFrequencies.getProbabilities(ngram);
        if (optimizedFloatArray == null) {
            return false;
        }
        OptimizedFloatArray langProbMap = optimizedFloatArray;
        double weight = alpha / (double)10000;
        if (ngram.length() > 1) {
            if (this.prefixFactor != 1.0 && ngram.charAt(0) == ' ') {
                weight *= this.prefixFactor;
            } else if (this.suffixFactor != 1.0 && ngram.charAt(ngram.length() - 1) == ' ') {
                weight *= this.suffixFactor;
            }
        }
        int n = 0;
        int n2 = prob.length;
        while (n < n2) {
            void i;
            void v1 = i;
            prob[v1] = prob[v1] * (weight + (double)langProbMap.get((int)i));
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DetectedLanguage> sortProbability(@NotNull double[] $this$sortProbability) {
        ArrayList<DetectedLanguage> list = new ArrayList<DetectedLanguage>();
        int n = 0;
        int n2 = $this$sortProbability.length;
        while (n < n2) {
            void i;
            double prob = $this$sortProbability[i];
            if (prob >= this.probabilityThreshold) {
                list.add(new DetectedLanguage(this.ngramFrequencies.getLanguage((int)i), prob));
            }
            ++i;
        }
        if (list.size() >= 2) {
            Collections.sort((List)list, PROBABILITY_SORTING_COMPARATOR);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final double normalizeProb(double[] prob) {
        double maxp = 0.0;
        double sump = ArraysKt.sum((double[])prob);
        int n = 0;
        int n2 = prob.length;
        while (n < n2) {
            void i;
            double p = prob[i] / sump;
            if (maxp < p) {
                maxp = p;
            }
            prob[i] = p;
            ++i;
        }
        return maxp;
    }

    private final double[] makeInternalPrioMap(Map<Language, Double> langWeightingMap, List<? extends Language> langlist) {
        int i;
        double[] priorMap = new double[langlist.size()];
        if (langWeightingMap.isEmpty()) {
            return priorMap;
        }
        double sump = 0.0;
        int n = 0;
        int n2 = priorMap.length;
        while (n < n2) {
            Language lang = langlist.get(i);
            if (langWeightingMap.containsKey((Object)lang)) {
                double p = ((Number)MapsKt.getValue(langWeightingMap, (Object)((Object)lang))).doubleValue();
                boolean bl = p >= 0.0;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Prior probability must be non-negative!";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                priorMap[i] = p;
                sump += p;
            }
            ++i;
        }
        if (sump == 0.0) {
            return new double[langlist.size()];
        }
        i = 0;
        n2 = priorMap.length;
        while (i < n2) {
            int n3 = i++;
            priorMap[n3] = priorMap[n3] / sump;
        }
        return priorMap;
    }

    public NgramDetector(@NotNull NgramFrequencies ngramFrequencies, double alpha, double prefixFactor, double suffixFactor, double probabilityThreshold, double minimalConfidence, @NotNull NgramExtractor ngramExtractor) {
        Intrinsics.checkParameterIsNotNull((Object)ngramFrequencies, (String)"ngramFrequencies");
        Intrinsics.checkParameterIsNotNull((Object)ngramExtractor, (String)"ngramExtractor");
        this.ngramFrequencies = ngramFrequencies;
        this.alpha = alpha;
        this.prefixFactor = prefixFactor;
        this.suffixFactor = suffixFactor;
        this.probabilityThreshold = probabilityThreshold;
        this.minimalConfidence = minimalConfidence;
        this.ngramExtractor = ngramExtractor;
        this.languages = this.ngramFrequencies.getLanguages();
        double d = this.alpha;
        boolean bl = d >= 0.0 && d <= 1.0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "alpha must be between 0 and 1, but was: " + this.alpha;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        double d2 = this.prefixFactor;
        boolean bl5 = d2 >= 0.0 && d2 <= 10.0;
        bl2 = false;
        bl3 = false;
        if (!bl5) {
            boolean bl6 = false;
            String string = "prefixFactor must be between 0 and 10, but was: " + this.prefixFactor;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        double d3 = this.suffixFactor;
        boolean bl7 = d3 >= 0.0 && d3 <= 10.0;
        bl2 = false;
        bl3 = false;
        if (!bl7) {
            boolean bl8 = false;
            String string = "suffixFactor must be between 0 and 10, but was: " + this.suffixFactor;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        double d4 = this.probabilityThreshold;
        boolean bl9 = d4 >= 0.0 && d4 <= 1.0;
        bl2 = false;
        bl3 = false;
        if (!bl9) {
            boolean bl10 = false;
            String string = "probabilityThreshold must be between 0 and 1, but was: " + this.probabilityThreshold;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        double d5 = this.minimalConfidence;
        boolean bl11 = d5 >= 0.0 && d5 <= 1.0;
        bl2 = false;
        bl3 = false;
        if (!bl11) {
            boolean bl12 = false;
            String string = "minimalConfidence must be between 0 and 1, but was: " + this.minimalConfidence;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterNotTo$iv$iv;
        Companion = new Companion(null);
        PROBABILITY_SORTING_COMPARATOR = Companion.PROBABILITY_SORTING_COMPARATOR.1.INSTANCE;
        Iterable $this$filterNot$iv = Language.Companion.getAll();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Language it = (Language)((Object)element$iv$iv);
            boolean bl = false;
            if (SetsKt.setOf((Object[])new Language[]{Language.CHINESE, Language.JAPANESE, Language.GREEK, Language.PERSIAN}).contains((Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        supported = (List)var3_3;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/grazie/detector/ngram/NgramDetector$Companion;", "", "()V", "ALPHA_WIDTH", "", "BASE_FREQ", "", "CONV_THRESHOLD", "DEFAULT_SEED", "", "ITERATION_LIMIT", "N_TRIAL", "PROBABILITY_SORTING_COMPARATOR", "Ljava/util/Comparator;", "Lcom/intellij/grazie/detector/model/DetectedLanguage;", "supported", "", "Lcom/intellij/grazie/detector/model/Language;", "getSupported", "()Ljava/util/List;", "language-detector"})
    public static final class Companion {
        @NotNull
        public final List<Language> getSupported() {
            return supported;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

