/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.ngram;

import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.detector.ngram.NgramDetector;
import com.intellij.grazie.detector.ngram.impl.NgramExtractor;
import com.intellij.grazie.detector.ngram.impl.NgramFrequencies;
import com.intellij.grazie.detector.ngram.profiles.LanguageProfile;
import com.intellij.grazie.detector.ngram.profiles.LanguageProfileReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0015\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c2\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c2\u0003\u00a2\u0006\u0002\u0010\u0018J\t\u0010\u0019\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c2\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c2\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u00c2\u0003Jv\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u00052\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u00c6\u0001\u00a2\u0006\u0002\u0010 J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0005J\t\u0010&\u001a\u00020'H\u00d6\u0001J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u000eJ\u0014\u0010*\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0+R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/grazie/detector/ngram/NgramDetectorBuilder;", "", "ngramExtractor", "Lcom/intellij/grazie/detector/ngram/impl/NgramExtractor;", "alpha", "", "seed", "", "prefixFactor", "suffixFactor", "probabilityThreshold", "minimalConfidence", "languageProfiles", "Ljava/util/HashSet;", "Lcom/intellij/grazie/detector/ngram/profiles/LanguageProfile;", "languagesAdded", "Lcom/intellij/grazie/detector/model/Language;", "(Lcom/intellij/grazie/detector/ngram/impl/NgramExtractor;DLjava/lang/Long;DDDDLjava/util/HashSet;Ljava/util/HashSet;)V", "Ljava/lang/Long;", "build", "Lcom/intellij/grazie/detector/ngram/NgramDetector;", "component1", "component2", "component3", "()Ljava/lang/Long;", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Lcom/intellij/grazie/detector/ngram/impl/NgramExtractor;DLjava/lang/Long;DDDDLjava/util/HashSet;Ljava/util/HashSet;)Lcom/intellij/grazie/detector/ngram/NgramDetectorBuilder;", "equals", "", "other", "hashCode", "", "toString", "", "withProfile", "languageProfile", "withProfiles", "", "Companion", "language-detector"})
public final class NgramDetectorBuilder {
    private final NgramExtractor ngramExtractor;
    private double alpha;
    private Long seed;
    private double prefixFactor;
    private double suffixFactor;
    private double probabilityThreshold;
    private double minimalConfidence;
    private final HashSet<LanguageProfile> languageProfiles;
    private final HashSet<Language> languagesAdded;
    private static final double ALPHA_DEFAULT = 0.5;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final NgramDetectorBuilder alpha(double alpha) {
        double d = alpha;
        boolean bl = d >= 0.0 && d <= 1.0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "alpha must be between 0 and 1, but was: " + alpha;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.alpha = alpha;
        return this;
    }

    @NotNull
    public final NgramDetectorBuilder prefixFactor(double prefixFactor) {
        this.prefixFactor = prefixFactor;
        return this;
    }

    @NotNull
    public final NgramDetectorBuilder suffixFactor(double suffixFactor) {
        this.suffixFactor = suffixFactor;
        return this;
    }

    @NotNull
    public final NgramDetectorBuilder probabilityThreshold(double probabilityThreshold) {
        this.probabilityThreshold = probabilityThreshold;
        return this;
    }

    @NotNull
    public final NgramDetectorBuilder minimalConfidence(double minimalConfidence) {
        this.minimalConfidence = minimalConfidence;
        return this;
    }

    @NotNull
    public final NgramDetectorBuilder withProfile(@NotNull LanguageProfile languageProfile) throws IllegalStateException {
        Intrinsics.checkParameterIsNotNull((Object)languageProfile, (String)"languageProfile");
        boolean bl = !this.languagesAdded.contains((Object)languageProfile.getLocale());
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "A language profile for language " + (Object)((Object)languageProfile.getLocale()) + " was added already!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Iterable $this$forEach$iv = this.ngramExtractor.getGramLengths();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl5 = false;
            boolean bl6 = languageProfile.getGramLengths().contains(it);
            boolean bl7 = false;
            boolean bl8 = false;
            if (bl6) continue;
            boolean bl9 = false;
            String string = "The NgramExtractor is set to handle " + it + "-grams but the given language profile for " + (Object)((Object)languageProfile.getLocale()) + " does not support this!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.languagesAdded.add(languageProfile.getLocale());
        this.languageProfiles.add(languageProfile);
        return this;
    }

    @NotNull
    public final NgramDetectorBuilder withProfiles(@NotNull Iterable<? extends LanguageProfile> languageProfiles) throws IllegalStateException {
        Intrinsics.checkParameterIsNotNull(languageProfiles, (String)"languageProfiles");
        Iterable<? extends LanguageProfile> $this$forEach$iv = languageProfiles;
        boolean $i$f$forEach = false;
        Iterator<? extends LanguageProfile> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            LanguageProfile element$iv;
            LanguageProfile it = element$iv = iterator.next();
            boolean bl = false;
            this.withProfile(it);
        }
        return this;
    }

    @NotNull
    public final NgramDetector build() throws IllegalStateException {
        Collection collection = this.languageProfiles;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new NgramDetector(NgramFrequencies.Companion.create((Collection<? extends LanguageProfile>)this.languageProfiles, (Collection<Integer>)this.ngramExtractor.getGramLengths()), this.alpha, this.prefixFactor, this.suffixFactor, this.probabilityThreshold, this.minimalConfidence, this.ngramExtractor);
    }

    public NgramDetectorBuilder(@NotNull NgramExtractor ngramExtractor, double alpha, @Nullable Long seed, double prefixFactor, double suffixFactor, double probabilityThreshold, double minimalConfidence, @NotNull HashSet<LanguageProfile> languageProfiles, @NotNull HashSet<Language> languagesAdded) {
        Intrinsics.checkParameterIsNotNull((Object)ngramExtractor, (String)"ngramExtractor");
        Intrinsics.checkParameterIsNotNull(languageProfiles, (String)"languageProfiles");
        Intrinsics.checkParameterIsNotNull(languagesAdded, (String)"languagesAdded");
        this.ngramExtractor = ngramExtractor;
        this.alpha = alpha;
        this.seed = seed;
        this.prefixFactor = prefixFactor;
        this.suffixFactor = suffixFactor;
        this.probabilityThreshold = probabilityThreshold;
        this.minimalConfidence = minimalConfidence;
        this.languageProfiles = languageProfiles;
        this.languagesAdded = languagesAdded;
    }

    public /* synthetic */ NgramDetectorBuilder(NgramExtractor ngramExtractor, double d, Long l, double d2, double d3, double d4, double d5, HashSet hashSet, HashSet hashSet2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.5;
        }
        if ((n & 4) != 0) {
            l = null;
        }
        if ((n & 8) != 0) {
            d2 = 1.0;
        }
        if ((n & 0x10) != 0) {
            d3 = 1.0;
        }
        if ((n & 0x20) != 0) {
            d4 = 0.1;
        }
        if ((n & 0x40) != 0) {
            d5 = 0.9999;
        }
        if ((n & 0x80) != 0) {
            hashSet = new HashSet<LanguageProfile>();
        }
        if ((n & 0x100) != 0) {
            hashSet2 = new HashSet<Language>();
        }
        this(ngramExtractor, d, l, d2, d3, d4, d5, hashSet, hashSet2);
    }

    private final NgramExtractor component1() {
        return this.ngramExtractor;
    }

    private final double component2() {
        return this.alpha;
    }

    private final Long component3() {
        return this.seed;
    }

    private final double component4() {
        return this.prefixFactor;
    }

    private final double component5() {
        return this.suffixFactor;
    }

    private final double component6() {
        return this.probabilityThreshold;
    }

    private final double component7() {
        return this.minimalConfidence;
    }

    private final HashSet<LanguageProfile> component8() {
        return this.languageProfiles;
    }

    private final HashSet<Language> component9() {
        return this.languagesAdded;
    }

    @NotNull
    public final NgramDetectorBuilder copy(@NotNull NgramExtractor ngramExtractor, double alpha, @Nullable Long seed, double prefixFactor, double suffixFactor, double probabilityThreshold, double minimalConfidence, @NotNull HashSet<LanguageProfile> languageProfiles, @NotNull HashSet<Language> languagesAdded) {
        Intrinsics.checkParameterIsNotNull((Object)ngramExtractor, (String)"ngramExtractor");
        Intrinsics.checkParameterIsNotNull(languageProfiles, (String)"languageProfiles");
        Intrinsics.checkParameterIsNotNull(languagesAdded, (String)"languagesAdded");
        return new NgramDetectorBuilder(ngramExtractor, alpha, seed, prefixFactor, suffixFactor, probabilityThreshold, minimalConfidence, languageProfiles, languagesAdded);
    }

    public static /* synthetic */ NgramDetectorBuilder copy$default(NgramDetectorBuilder ngramDetectorBuilder, NgramExtractor ngramExtractor, double d, Long l, double d2, double d3, double d4, double d5, HashSet hashSet, HashSet hashSet2, int n, Object object) {
        if ((n & 1) != 0) {
            ngramExtractor = ngramDetectorBuilder.ngramExtractor;
        }
        if ((n & 2) != 0) {
            d = ngramDetectorBuilder.alpha;
        }
        if ((n & 4) != 0) {
            l = ngramDetectorBuilder.seed;
        }
        if ((n & 8) != 0) {
            d2 = ngramDetectorBuilder.prefixFactor;
        }
        if ((n & 0x10) != 0) {
            d3 = ngramDetectorBuilder.suffixFactor;
        }
        if ((n & 0x20) != 0) {
            d4 = ngramDetectorBuilder.probabilityThreshold;
        }
        if ((n & 0x40) != 0) {
            d5 = ngramDetectorBuilder.minimalConfidence;
        }
        if ((n & 0x80) != 0) {
            hashSet = ngramDetectorBuilder.languageProfiles;
        }
        if ((n & 0x100) != 0) {
            hashSet2 = ngramDetectorBuilder.languagesAdded;
        }
        return ngramDetectorBuilder.copy(ngramExtractor, d, l, d2, d3, d4, d5, hashSet, hashSet2);
    }

    @NotNull
    public String toString() {
        return "NgramDetectorBuilder(ngramExtractor=" + this.ngramExtractor + ", alpha=" + this.alpha + ", seed=" + this.seed + ", prefixFactor=" + this.prefixFactor + ", suffixFactor=" + this.suffixFactor + ", probabilityThreshold=" + this.probabilityThreshold + ", minimalConfidence=" + this.minimalConfidence + ", languageProfiles=" + this.languageProfiles + ", languagesAdded=" + this.languagesAdded + ")";
    }

    public int hashCode() {
        NgramExtractor ngramExtractor = this.ngramExtractor;
        Long l = this.seed;
        HashSet<LanguageProfile> hashSet = this.languageProfiles;
        HashSet<Language> hashSet2 = this.languagesAdded;
        return ((((((((ngramExtractor != null ? ngramExtractor.hashCode() : 0) * 31 + Double.hashCode(this.alpha)) * 31 + (l != null ? ((Object)l).hashCode() : 0)) * 31 + Double.hashCode(this.prefixFactor)) * 31 + Double.hashCode(this.suffixFactor)) * 31 + Double.hashCode(this.probabilityThreshold)) * 31 + Double.hashCode(this.minimalConfidence)) * 31 + (hashSet != null ? ((Object)hashSet).hashCode() : 0)) * 31 + (hashSet2 != null ? ((Object)hashSet2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof NgramDetectorBuilder)) break block3;
                NgramDetectorBuilder ngramDetectorBuilder = (NgramDetectorBuilder)object;
                if (!Intrinsics.areEqual((Object)this.ngramExtractor, (Object)ngramDetectorBuilder.ngramExtractor) || Double.compare(this.alpha, ngramDetectorBuilder.alpha) != 0 || !Intrinsics.areEqual((Object)this.seed, (Object)ngramDetectorBuilder.seed) || Double.compare(this.prefixFactor, ngramDetectorBuilder.prefixFactor) != 0 || Double.compare(this.suffixFactor, ngramDetectorBuilder.suffixFactor) != 0 || Double.compare(this.probabilityThreshold, ngramDetectorBuilder.probabilityThreshold) != 0 || Double.compare(this.minimalConfidence, ngramDetectorBuilder.minimalConfidence) != 0 || !Intrinsics.areEqual(this.languageProfiles, ngramDetectorBuilder.languageProfiles) || !Intrinsics.areEqual(this.languagesAdded, ngramDetectorBuilder.languagesAdded)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/grazie/detector/ngram/NgramDetectorBuilder$Companion;", "", "()V", "ALPHA_DEFAULT", "", "create", "Lcom/intellij/grazie/detector/ngram/NgramDetectorBuilder;", "ngramExtractor", "Lcom/intellij/grazie/detector/ngram/impl/NgramExtractor;", "standard", "Lcom/intellij/grazie/detector/ngram/NgramDetector;", "language-detector"})
    public static final class Companion {
        @NotNull
        public final NgramDetector standard() {
            return new NgramDetectorBuilder(NgramExtractor.Companion.getStandard(), 0.0, null, 0.0, 0.0, 0.0, 0.0, null, null, 510, null).minimalConfidence(0.9).prefixFactor(1.5).suffixFactor(2.0).withProfiles((Iterable<? extends LanguageProfile>)LanguageProfileReader.INSTANCE.readAllBuiltIn()).build();
        }

        @NotNull
        public final NgramDetectorBuilder create(@NotNull NgramExtractor ngramExtractor) {
            Intrinsics.checkParameterIsNotNull((Object)ngramExtractor, (String)"ngramExtractor");
            return new NgramDetectorBuilder(ngramExtractor, 0.0, null, 0.0, 0.0, 0.0, 0.0, null, null, 510, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

