/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactOutputToSourceMapping;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactPathUtil;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;

public class FileBasedArtifactRootDescriptor
extends ArtifactRootDescriptor {
    private static final Logger LOG = Logger.getInstance(FileBasedArtifactRootDescriptor.class);
    private final FileCopyingHandler myCopyingHandler;

    public FileBasedArtifactRootDescriptor(@NotNull File file, @NotNull SourceFileFilter filter, int index, ArtifactBuildTarget target, @NotNull DestinationInfo destinationInfo, FileCopyingHandler copyingHandler) {
        if (file == null) {
            FileBasedArtifactRootDescriptor.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            FileBasedArtifactRootDescriptor.$$$reportNull$$$0(1);
        }
        if (destinationInfo == null) {
            FileBasedArtifactRootDescriptor.$$$reportNull$$$0(2);
        }
        super(file, FileBasedArtifactRootDescriptor.createCompositeFilter(filter, copyingHandler.createFileFilter()), index, target, destinationInfo);
        this.myCopyingHandler = copyingHandler;
    }

    @NotNull
    private static SourceFileFilter createCompositeFilter(@NotNull SourceFileFilter baseFilter, @NotNull FileFilter filter) {
        if (baseFilter == null) {
            FileBasedArtifactRootDescriptor.$$$reportNull$$$0(3);
        }
        if (filter == null) {
            FileBasedArtifactRootDescriptor.$$$reportNull$$$0(4);
        }
        if (filter.equals(FileUtilRt.ALL_FILES)) {
            SourceFileFilter sourceFileFilter = baseFilter;
            if (sourceFileFilter == null) {
                FileBasedArtifactRootDescriptor.$$$reportNull$$$0(5);
            }
            return sourceFileFilter;
        }
        return new CompositeSourceFileFilter(baseFilter, filter);
    }

    @Override
    protected String getFullPath() {
        return this.myRoot.getPath();
    }

    @Override
    public void writeConfiguration(PrintWriter out, PathRelativizerService relativizer) {
        super.writeConfiguration(out, relativizer);
        this.myCopyingHandler.writeConfiguration(out);
    }

    @Override
    public void copyFromRoot(String filePath, int rootIndex, String outputPath, CompileContext context, BuildOutputConsumer outputConsumer, ArtifactOutputToSourceMapping outSrcMapping) throws IOException, ProjectBuildException {
        String targetPath;
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        if (!FileUtil.filesEqual((File)file, (File)this.getRootFile())) {
            String relativePath = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)this.getRootFile().getPath()), (String)filePath, (char)'/');
            if (relativePath == null || relativePath.startsWith("..")) {
                throw new ProjectBuildException((Throwable)((Object)new AssertionError((Object)(filePath + " is not under " + this.getRootFile().getPath()))));
            }
            targetPath = JpsArtifactPathUtil.appendToPath(outputPath, relativePath);
        } else {
            targetPath = outputPath;
        }
        File targetFile = new File(targetPath);
        if (FileUtil.filesEqual((File)file, (File)targetFile)) {
            return;
        }
        if (outSrcMapping.getState(targetPath) == null) {
            ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
            if (logger.isEnabled()) {
                logger.logCompiledFiles(Collections.singletonList(file), "Artifacts builder", "Copying file:");
            }
            this.myCopyingHandler.copyFile(file, targetFile, context);
            outputConsumer.registerOutputFile(targetFile, Collections.singletonList(filePath));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Target path " + targetPath + " is already registered so " + filePath + " won't be copied");
        }
        outSrcMapping.appendData(targetPath, rootIndex, filePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/artifacts/instructions/FileBasedArtifactRootDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/instructions/FileBasedArtifactRootDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeFilter";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompositeSourceFileFilter
    extends SourceFileFilter {
        private final SourceFileFilter myBaseFilter;
        private final FileFilter myFilter;

        CompositeSourceFileFilter(SourceFileFilter baseFilter, FileFilter filter) {
            this.myBaseFilter = baseFilter;
            this.myFilter = filter;
        }

        @Override
        public boolean accept(@NotNull String fullFilePath) {
            if (fullFilePath == null) {
                CompositeSourceFileFilter.$$$reportNull$$$0(0);
            }
            return this.myFilter.accept(new File(fullFilePath)) && this.myBaseFilter.accept(fullFilePath);
        }

        @Override
        public boolean shouldBeCopied(@NotNull String fullFilePath, ProjectDescriptor projectDescriptor) throws IOException {
            if (fullFilePath == null) {
                CompositeSourceFileFilter.$$$reportNull$$$0(1);
            }
            return this.myBaseFilter.shouldBeCopied(fullFilePath, projectDescriptor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "fullFilePath";
            objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/instructions/FileBasedArtifactRootDescriptor$CompositeSourceFileFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldBeCopied";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

