/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.JsonElementType;
import com.intellij.json.JsonTokenType;
import com.intellij.json.psi.impl.JsonArrayImpl;
import com.intellij.json.psi.impl.JsonBooleanLiteralImpl;
import com.intellij.json.psi.impl.JsonNullLiteralImpl;
import com.intellij.json.psi.impl.JsonNumberLiteralImpl;
import com.intellij.json.psi.impl.JsonObjectImpl;
import com.intellij.json.psi.impl.JsonPropertyImpl;
import com.intellij.json.psi.impl.JsonReferenceExpressionImpl;
import com.intellij.json.psi.impl.JsonStringLiteralImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;

public interface JsonElementTypes {
    public static final IElementType ARRAY = new JsonElementType("ARRAY");
    public static final IElementType BOOLEAN_LITERAL = new JsonElementType("BOOLEAN_LITERAL");
    public static final IElementType LITERAL = new JsonElementType("LITERAL");
    public static final IElementType NULL_LITERAL = new JsonElementType("NULL_LITERAL");
    public static final IElementType NUMBER_LITERAL = new JsonElementType("NUMBER_LITERAL");
    public static final IElementType OBJECT = new JsonElementType("OBJECT");
    public static final IElementType PROPERTY = new JsonElementType("PROPERTY");
    public static final IElementType REFERENCE_EXPRESSION = new JsonElementType("REFERENCE_EXPRESSION");
    public static final IElementType STRING_LITERAL = new JsonElementType("STRING_LITERAL");
    public static final IElementType VALUE = new JsonElementType("VALUE");
    public static final IElementType BLOCK_COMMENT = new JsonTokenType("BLOCK_COMMENT");
    public static final IElementType COLON = new JsonTokenType(":");
    public static final IElementType COMMA = new JsonTokenType(",");
    public static final IElementType DOUBLE_QUOTED_STRING = new JsonTokenType("DOUBLE_QUOTED_STRING");
    public static final IElementType FALSE = new JsonTokenType("false");
    public static final IElementType IDENTIFIER = new JsonTokenType("IDENTIFIER");
    public static final IElementType LINE_COMMENT = new JsonTokenType("LINE_COMMENT");
    public static final IElementType L_BRACKET = new JsonTokenType("[");
    public static final IElementType L_CURLY = new JsonTokenType("{");
    public static final IElementType NULL = new JsonTokenType("null");
    public static final IElementType NUMBER = new JsonTokenType("NUMBER");
    public static final IElementType R_BRACKET = new JsonTokenType("]");
    public static final IElementType R_CURLY = new JsonTokenType("}");
    public static final IElementType SINGLE_QUOTED_STRING = new JsonTokenType("SINGLE_QUOTED_STRING");
    public static final IElementType TRUE = new JsonTokenType("true");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == ARRAY) {
                return new JsonArrayImpl(node);
            }
            if (type == BOOLEAN_LITERAL) {
                return new JsonBooleanLiteralImpl(node);
            }
            if (type == NULL_LITERAL) {
                return new JsonNullLiteralImpl(node);
            }
            if (type == NUMBER_LITERAL) {
                return new JsonNumberLiteralImpl(node);
            }
            if (type == OBJECT) {
                return new JsonObjectImpl(node);
            }
            if (type == PROPERTY) {
                return new JsonPropertyImpl(node);
            }
            if (type == REFERENCE_EXPRESSION) {
                return new JsonReferenceExpressionImpl(node);
            }
            if (type == STRING_LITERAL) {
                return new JsonStringLiteralImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

