/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JsonSchemaVersion {
    SCHEMA_4,
    SCHEMA_6,
    SCHEMA_7;

    private static final String ourSchemaV4Schema = "http://json-schema.org/draft-04/schema";
    private static final String ourSchemaV6Schema = "http://json-schema.org/draft-06/schema";
    private static final String ourSchemaV7Schema = "http://json-schema.org/draft-07/schema";
    private static final String ourSchemaOrgPrefix = "http://json-schema.org/";

    public String toString() {
        switch (this) {
            case SCHEMA_4: {
                return JsonBundle.message("schema.of.version", 4);
            }
            case SCHEMA_6: {
                return JsonBundle.message("schema.of.version", 6);
            }
            case SCHEMA_7: {
                return JsonBundle.message("schema.of.version", 7);
            }
        }
        throw new NotImplementedError("Unknown version: " + (Object)((Object)this));
    }

    @Nullable
    public static JsonSchemaVersion byId(@NotNull String id) {
        if (id == null) {
            JsonSchemaVersion.$$$reportNull$$$0(0);
        }
        if (id.startsWith("https://")) {
            id = "http://" + id.substring("https://".length());
        }
        switch (StringUtil.trimEnd((String)id, (char)'#')) {
            case "http://json-schema.org/draft-04/schema": {
                return SCHEMA_4;
            }
            case "http://json-schema.org/draft-06/schema": {
                return SCHEMA_6;
            }
            case "http://json-schema.org/draft-07/schema": {
                return SCHEMA_7;
            }
        }
        if (id.startsWith(ourSchemaOrgPrefix)) {
            return SCHEMA_7;
        }
        return null;
    }

    public static boolean isSchemaSchemaId(@Nullable String id) {
        return id != null && JsonSchemaVersion.byId(id) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/jsonSchema/impl/JsonSchemaVersion", "byId"));
    }
}

