/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.toolwindow;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.NonEmptyActionGroup;
import com.intellij.internal.statistic.actions.RecordStateStatisticsEventLogAction;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerKt;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.TestModeValidationRule;
import com.intellij.internal.statistic.toolwindow.StatisticsEventLogToolWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createNewSessionActionGroup", "Lcom/intellij/ide/actions/NonEmptyActionGroup;", "project", "Lcom/intellij/openapi/project/Project;", "createToolWindowContent", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "isApplicable", "", "Companion", "CreateNewSessionAction", "intellij.platform.statistics.devkit"})
final class StatisticsEventLogToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public static final Companion Companion = new Companion(null);

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)toolWindow, (String)"toolWindow");
        StatisticsEventLogToolWindowFactory.Companion.createNewTab(project, toolWindow, "FUS");
        toolWindow.setToHideOnEmptyContent(true);
        if (toolWindow instanceof ToolWindowEx) {
            NonEmptyActionGroup newSessionActionGroup = this.createNewSessionActionGroup(project);
            ((ToolWindowEx)toolWindow).setTabActions(new AnAction[]{(AnAction)newSessionActionGroup});
        }
        project.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(project){
            final /* synthetic */ Project $project;

            public void toolWindowShown(@NotNull String id, @NotNull ToolWindow toolWindow) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull((Object)toolWindow, (String)"toolWindow");
                if (Intrinsics.areEqual((Object)"Statistics Event Log", (Object)id) && toolWindow.isVisible()) {
                    ContentManager contentManager = toolWindow.getContentManager();
                    Intrinsics.checkExpressionValueIsNotNull((Object)contentManager, (String)"toolWindow.contentManager");
                    if (contentManager.getContentCount() == 0) {
                        com.intellij.internal.statistic.toolwindow.StatisticsEventLogToolWindowFactory$Companion.access$createNewTab(StatisticsEventLogToolWindowFactory.Companion, this.$project, toolWindow, "FUS");
                    }
                }
            }
            {
                this.$project = $captured_local_variable$0;
            }
        });
    }

    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return TestModeValidationRule.isTestModeEnabled();
    }

    /*
     * WARNING - void declaration
     */
    private final NonEmptyActionGroup createNewSessionActionGroup(Project project) {
        void $this$mapTo$iv$iv;
        NonEmptyActionGroup actionGroup = new NonEmptyActionGroup();
        actionGroup.setPopup(true);
        Presentation presentation = actionGroup.getTemplatePresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"actionGroup.templatePresentation");
        presentation.setIcon(AllIcons.General.Add);
        Iterable $this$map$iv = StatisticsEventLoggerKt.getEventLogProviders();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void logger;
            StatisticsEventLoggerProvider statisticsEventLoggerProvider = (StatisticsEventLoggerProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String recorder = logger.getRecorderId();
            CreateNewSessionAction createNewSessionAction = new CreateNewSessionAction(project, recorder);
            collection.add(createNewSessionAction);
        }
        List actions = (List)destination$iv$iv;
        actionGroup.addAll((Collection)actions);
        return actionGroup;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogToolWindowFactory$CreateNewSessionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "recorderId", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.statistics.devkit"})
    private static final class CreateNewSessionAction
    extends AnAction {
        private final Project project;
        private final String recorderId;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Statistics Event Log");
            if (toolWindow == null) {
                return;
            }
            ToolWindow toolWindow2 = toolWindow;
            Companion.createNewTab(this.project, toolWindow2, this.recorderId);
        }

        public CreateNewSessionAction(@NotNull Project project, @NotNull String recorderId) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
            super(recorderId);
            this.project = project;
            this.recorderId = recorderId;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogToolWindowFactory$Companion;", "", "()V", "createNewTab", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "recorderId", "", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        private final void createNewTab(Project project, ToolWindow toolWindow, String recorderId) {
            StatisticsEventLogToolWindow eventLogToolWindow = new StatisticsEventLogToolWindow(project, recorderId);
            Content content = ContentFactory.SERVICE.getInstance().createContent(eventLogToolWindow.getComponent(), recorderId, true);
            Intrinsics.checkExpressionValueIsNotNull((Object)content, (String)"ContentFactory.SERVICE.g\u2026ponent, recorderId, true)");
            Content content2 = content;
            content2.setPreferredFocusableComponent(eventLogToolWindow.getComponent());
            toolWindow.getContentManager().addContent(content2);
            RecordStateStatisticsEventLogAction.checkLogRecordingEnabled(project, recorderId);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

