/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.editorconfig.Utils;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;

public class EncodingManager
implements FileDocumentManagerListener {
    public static final String charsetKey = "charset";
    private final Project myProject;
    public static final Map<String, Charset> encodingMap;
    private boolean isApplyingSettings;

    public EncodingManager(Project project) {
        this.myProject = project;
        this.isApplyingSettings = false;
    }

    public void beforeDocumentSaving(@NotNull Document document) {
        if (document == null) {
            EncodingManager.$$$reportNull$$$0(0);
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (!this.isApplyingSettings) {
            this.applySettings(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySettings(VirtualFile file) {
        if (file == null) {
            return;
        }
        if (!Utils.isEnabled(CodeStyle.getSettings((Project)this.myProject))) {
            return;
        }
        this.isApplyingSettings = true;
        try {
            List<EditorConfig.OutPair> outPairs = SettingsProviderComponent.getInstance().getOutPairs(this.myProject, file);
            EncodingProjectManager encodingProjectManager = EncodingProjectManager.getInstance((Project)this.myProject);
            String charset = Utils.configValueForKey(outPairs, charsetKey);
            if (!charset.isEmpty()) {
                Charset newCharset = encodingMap.get(charset);
                if (newCharset != null) {
                    if (Comparing.equal((Object)newCharset, (Object)file.getCharset())) {
                        return;
                    }
                    encodingProjectManager.setEncoding(file, newCharset);
                } else {
                    Utils.invalidConfigMessage(this.myProject, charset, charsetKey, file.getCanonicalPath());
                }
            }
        }
        finally {
            this.isApplyingSettings = false;
        }
    }

    static {
        HashMap<String, Charset> map = new HashMap<String, Charset>();
        map.put("latin1", Charset.forName("ISO-8859-1"));
        map.put("utf-8", StandardCharsets.UTF_8);
        map.put("utf-16be", CharsetToolkit.UTF_16BE_CHARSET);
        map.put("utf-16le", CharsetToolkit.UTF_16LE_CHARSET);
        encodingMap = Collections.unmodifiableMap(map);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/editorconfig/configmanagement/EncodingManager", "beforeDocumentSaving"));
    }
}

