/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.annotators;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.editorconfig.language.highlighting.EditorConfigSyntaxHighlighter;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigAsteriskPattern;
import org.editorconfig.language.psi.EditorConfigCharClassExclamation;
import org.editorconfig.language.psi.EditorConfigCharClassLetter;
import org.editorconfig.language.psi.EditorConfigDoubleAsteriskPattern;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigFlatOptionKey;
import org.editorconfig.language.psi.EditorConfigFlatPattern;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigOptionValueIdentifier;
import org.editorconfig.language.psi.EditorConfigQualifiedKeyPart;
import org.editorconfig.language.psi.EditorConfigQualifiedOptionKey;
import org.editorconfig.language.psi.EditorConfigQuestionPattern;
import org.editorconfig.language.psi.EditorConfigRootDeclarationKey;
import org.editorconfig.language.psi.EditorConfigRootDeclarationValue;
import org.editorconfig.language.psi.EditorConfigVisitor;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigDeclarationDescriptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/editorconfig/language/codeinsight/annotators/EditorConfigAnnotatorVisitor;", "Lorg/editorconfig/language/psi/EditorConfigVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "checkDanglingKey", "", "option", "Lorg/editorconfig/language/psi/EditorConfigOption;", "checkEdgeDots", "edgeElement", "Lcom/intellij/psi/PsiElement;", "neighbourElement", "checkInnerDots", "key", "Lorg/editorconfig/language/psi/EditorConfigQualifiedOptionKey;", "checkLineBreaks", "special", "pattern", "visitAsteriskPattern", "Lorg/editorconfig/language/psi/EditorConfigAsteriskPattern;", "visitCharClassExclamation", "exclamation", "Lorg/editorconfig/language/psi/EditorConfigCharClassExclamation;", "visitCharClassLetter", "letter", "Lorg/editorconfig/language/psi/EditorConfigCharClassLetter;", "visitDoubleAsteriskPattern", "Lorg/editorconfig/language/psi/EditorConfigDoubleAsteriskPattern;", "visitFlatOptionKey", "flatKey", "Lorg/editorconfig/language/psi/EditorConfigFlatOptionKey;", "visitFlatPattern", "flatPattern", "Lorg/editorconfig/language/psi/EditorConfigFlatPattern;", "visitOption", "visitOptionValueIdentifier", "identifier", "Lorg/editorconfig/language/psi/EditorConfigOptionValueIdentifier;", "visitQualifiedKeyPart", "keyPart", "Lorg/editorconfig/language/psi/EditorConfigQualifiedKeyPart;", "visitQualifiedOptionKey", "visitQuestionPattern", "Lorg/editorconfig/language/psi/EditorConfigQuestionPattern;", "visitRootDeclarationKey", "Lorg/editorconfig/language/psi/EditorConfigRootDeclarationKey;", "visitRootDeclarationValue", "value", "Lorg/editorconfig/language/psi/EditorConfigRootDeclarationValue;", "intellij.editorconfig"})
public final class EditorConfigAnnotatorVisitor
extends EditorConfigVisitor {
    private final AnnotationHolder holder;

    @Override
    public void visitQualifiedOptionKey(@NotNull EditorConfigQualifiedOptionKey key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        PsiElement psiElement = key.getFirstChild();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"key.firstChild");
        PsiElement psiElement2 = key.getFirstChild();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"key.firstChild");
        this.checkEdgeDots(psiElement, psiElement2.getNextSibling());
        PsiElement psiElement3 = key.getLastChild();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"key.lastChild");
        PsiElement psiElement4 = key.getLastChild();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"key.lastChild");
        this.checkEdgeDots(psiElement3, psiElement4.getPrevSibling());
        this.checkInnerDots(key);
    }

    private final void checkInnerDots(EditorConfigQualifiedOptionKey key) {
        PsiElement firstDot = null;
        PsiElement lastDot = null;
        JBIterable jBIterable = SyntaxTraverser.psiTraverser().children((Object)key);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"SyntaxTraverser.psiTraverser().children(key)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            PsiElement psiElement = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"it");
            ASTNode aSTNode = psiElement.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)EditorConfigElementTypes.DOT)) {
                if (firstDot == null) {
                    firstDot = it;
                }
                lastDot = it;
                continue;
            }
            if (Intrinsics.areEqual((Object)firstDot, (Object)lastDot) ^ true) {
                TextRange range;
                String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.multiple-dots");
                PsiElement psiElement2 = firstDot;
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                TextRange textRange = psiElement2.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"firstDot!!.textRange");
                int start = textRange.getStartOffset();
                PsiElement psiElement3 = lastDot;
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                TextRange textRange2 = psiElement3.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"lastDot!!.textRange");
                int end = textRange2.getEndOffset();
                Intrinsics.checkExpressionValueIsNotNull((Object)TextRange.create((int)start, (int)end), (String)"TextRange.create(start, end)");
                this.holder.newAnnotation(HighlightSeverity.ERROR, message2).range(range).create();
                firstDot = null;
                lastDot = null;
                continue;
            }
            firstDot = null;
            lastDot = null;
        }
    }

    private final void checkEdgeDots(PsiElement edgeElement, PsiElement neighbourElement) {
        ASTNode aSTNode = edgeElement.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"edgeElement.node");
        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)EditorConfigElementTypes.DOT) ^ true) {
            return;
        }
        PsiElement psiElement = neighbourElement;
        if (Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)EditorConfigElementTypes.DOT)) {
            return;
        }
        String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.key.dangling-dot");
        this.holder.newAnnotation(HighlightSeverity.ERROR, message2).range(edgeElement).create();
    }

    @Override
    public void visitOption(@NotNull EditorConfigOption option) {
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        this.checkDanglingKey(option);
        this.checkLineBreaks(option);
    }

    private final void checkLineBreaks(EditorConfigOption option) {
        if (!option.textContains('\n')) {
            return;
        }
        String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.option.suspicious.line.break");
        this.holder.newAnnotation(HighlightSeverity.ERROR, message2).range((PsiElement)option).create();
    }

    private final void checkDanglingKey(EditorConfigOption option) {
        if (option.getAnyValue() != null) {
            return;
        }
        String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.dangling.key");
        this.holder.newAnnotation(HighlightSeverity.ERROR, message2).range((PsiElement)option).create();
    }

    @Override
    public void visitFlatOptionKey(@NotNull EditorConfigFlatOptionKey flatKey) {
        Intrinsics.checkParameterIsNotNull((Object)flatKey, (String)"flatKey");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)flatKey).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_KEY()).create();
    }

    @Override
    public void visitQualifiedKeyPart(@NotNull EditorConfigQualifiedKeyPart keyPart) {
        Intrinsics.checkParameterIsNotNull((Object)keyPart, (String)"keyPart");
        EditorConfigDescriptor descriptor = keyPart.getDescriptor(false);
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)keyPart).textAttributes(descriptor instanceof EditorConfigDeclarationDescriptor ? EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_KEY() : EditorConfigSyntaxHighlighter.INSTANCE.getKEY_DESCRIPTION()).create();
    }

    @Override
    public void visitOptionValueIdentifier(@NotNull EditorConfigOptionValueIdentifier identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)identifier).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_VALUE()).create();
    }

    @Override
    public void visitFlatPattern(@NotNull EditorConfigFlatPattern flatPattern) {
        Intrinsics.checkParameterIsNotNull((Object)flatPattern, (String)"flatPattern");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)flatPattern).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPATTERN()).create();
        if (!flatPattern.textContains('\\')) {
            return;
        }
        String text = flatPattern.getText();
        int offset = flatPattern.getTextOffset();
        for (int index = 0; index < text.length(); ++index) {
            if (text.charAt(index) != '\\') continue;
            TextRange range = new TextRange(offset + index, offset + index + 2);
            if (StringsKt.contains$default((CharSequence)" \r\n\t\\#;!?*[]{}", (char)text.charAt(++index), (boolean)false, (int)2, null)) {
                this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getVALID_CHAR_ESCAPE()).create();
                continue;
            }
            String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.illegal.char.escape");
            this.holder.newAnnotation(HighlightSeverity.INFORMATION, message2).range(range).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getINVALID_CHAR_ESCAPE()).create();
        }
    }

    @Override
    public void visitAsteriskPattern(@NotNull EditorConfigAsteriskPattern pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        this.special(pattern);
    }

    @Override
    public void visitDoubleAsteriskPattern(@NotNull EditorConfigDoubleAsteriskPattern pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        this.special(pattern);
    }

    private final void special(PsiElement pattern) {
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(pattern).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getSPECIAL_SYMBOL()).create();
    }

    @Override
    public void visitCharClassExclamation(@NotNull EditorConfigCharClassExclamation exclamation) {
        Intrinsics.checkParameterIsNotNull((Object)exclamation, (String)"exclamation");
        this.special(exclamation);
    }

    @Override
    public void visitQuestionPattern(@NotNull EditorConfigQuestionPattern pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        this.special(pattern);
    }

    @Override
    public void visitCharClassLetter(@NotNull EditorConfigCharClassLetter letter) {
        Intrinsics.checkParameterIsNotNull((Object)letter, (String)"letter");
        if (!letter.isEscape()) {
            this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)letter).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPATTERN()).create();
        } else if (letter.isValidEscape()) {
            this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)letter).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getVALID_CHAR_ESCAPE()).create();
        } else {
            this.holder.newAnnotation(HighlightSeverity.INFORMATION, EditorConfigBundle.INSTANCE.get("annotator.error.illegal.char.escape")).range((PsiElement)letter).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getINVALID_CHAR_ESCAPE()).create();
        }
    }

    @Override
    public void visitRootDeclarationKey(@NotNull EditorConfigRootDeclarationKey key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)key).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_KEY()).create();
    }

    @Override
    public void visitRootDeclarationValue(@NotNull EditorConfigRootDeclarationValue value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)value).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_VALUE()).create();
    }

    public EditorConfigAnnotatorVisitor(@NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        this.holder = holder;
    }
}

