/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.testng;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGXmlSuiteHelper {
    public static File writeSuite(Map<String, Map<String, List<String>>> map, Map<String, String> testParams, String name, String rootPath, Logger logger) {
        XmlSuite xmlSuite = new XmlSuite();
        xmlSuite.setParameters(testParams);
        XmlTest xmlTest = new XmlTest(xmlSuite);
        xmlTest.setName(name);
        ArrayList<XmlClass> xmlClasses = new ArrayList<XmlClass>();
        int idx = 0;
        for (String className : map.keySet()) {
            XmlClass xmlClass = new XmlClass(className, idx++, false);
            Map<String, List<String>> collection = map.get(className);
            if (collection != null) {
                ArrayList<XmlInclude> includedMethods = new ArrayList<XmlInclude>();
                int mIdx = 0;
                for (String methodName : collection.keySet()) {
                    ArrayList<Integer> includes = new ArrayList<Integer>();
                    for (String include : collection.get(methodName)) {
                        try {
                            includes.add(Integer.parseInt(include));
                        }
                        catch (NumberFormatException e) {
                            logger.log(e);
                        }
                    }
                    includedMethods.add(new XmlInclude(methodName, includes, mIdx++));
                }
                xmlClass.setIncludedMethods(includedMethods);
            }
            xmlClasses.add(xmlClass);
        }
        xmlTest.setXmlClasses(xmlClasses);
        File xmlFile = new File(rootPath, "temp-testng-customsuite.xml");
        String toXml = xmlSuite.toXml();
        TestNGXmlSuiteHelper.writeToFile(logger, xmlFile, toXml);
        return xmlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(Logger logger, File xmlFile, String content) {
        try {
            FileOutputStream stream = new FileOutputStream(xmlFile, false);
            try {
                byte[] text = content.getBytes("UTF-8");
                ((OutputStream)stream).write(text, 0, text.length);
            }
            finally {
                ((OutputStream)stream).close();
            }
        }
        catch (IOException e) {
            logger.log(e);
        }
    }

    public static interface Logger {
        public static final Logger DEAF = new Logger(){

            public void log(Throwable e) {
            }
        };

        public void log(Throwable var1);
    }
}

