/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class CommandLineWrapper {
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static void main(String[] args) throws Exception {
        try {
            Class.forName("java.lang.Module");
            System.err.println("`CommandLineWrapper` is ill-suited for launching apps on Java 9+.\nIf the run configuration uses \"classpath file\", please change it to \"@argfile\".\nOtherwise, please contact support.");
            System.exit(1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        File file = new File(args[0]);
        AppData appData = args[0].endsWith(".jar") ? CommandLineWrapper.loadMainClassFromClasspathJar(file, args) : CommandLineWrapper.loadMainClassWithCustomLoader(file, args);
        List properties = appData.properties;
        for (int i = 0; i < properties.size(); ++i) {
            String property = (String)properties.get(i);
            if (!property.startsWith("-D")) continue;
            int p = property.indexOf(61);
            if (p > 0) {
                System.setProperty(property.substring(2, p), property.substring(p + 1));
                continue;
            }
            System.setProperty(property.substring(2), "");
        }
        Method main = appData.mainClass.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = CommandLineWrapper.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        main.setAccessible(true);
        main.invoke(null, new Object[]{appData.args});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AppData loadMainClassFromClasspathJar(File jarFile, String[] args) throws Exception {
        String[] mainArgs;
        List properties = Collections.EMPTY_LIST;
        JarInputStream inputStream = new JarInputStream(new FileInputStream(jarFile));
        try {
            String programParameters;
            String vmOptions;
            Manifest manifest = inputStream.getManifest();
            String string = vmOptions = manifest != null ? manifest.getMainAttributes().getValue("VM-Options") : null;
            if (vmOptions != null) {
                properties = CommandLineWrapper.splitBySpaces(vmOptions);
            }
            String string2 = programParameters = manifest != null ? manifest.getMainAttributes().getValue("Program-Parameters") : null;
            if (programParameters == null) {
                mainArgs = new String[args.length - 2];
                System.arraycopy(args, 2, mainArgs, 0, mainArgs.length);
            } else {
                List list = CommandLineWrapper.splitBySpaces(programParameters);
                mainArgs = list.toArray(new String[0]);
            }
        }
        finally {
            inputStream.close();
            jarFile.deleteOnExit();
        }
        return new AppData(properties, Class.forName(args[1]), mainArgs);
    }

    private static List splitBySpaces(String parameterString) {
        parameterString = parameterString.trim();
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer token = new StringBuffer(128);
        boolean inQuotes = false;
        boolean escapedQuote = false;
        boolean nonEmpty = false;
        for (int i = 0; i < parameterString.length(); ++i) {
            char ch = parameterString.charAt(i);
            if (ch == '\"') {
                if (!escapedQuote) {
                    inQuotes = !inQuotes;
                    nonEmpty = true;
                    continue;
                }
                escapedQuote = false;
            } else if (Character.isWhitespace(ch)) {
                if (!inQuotes) {
                    if (token.length() <= 0 && !nonEmpty) continue;
                    params.add(token.toString());
                    token.setLength(0);
                    nonEmpty = false;
                    continue;
                }
            } else if (ch == '\\' && i < parameterString.length() - 1 && parameterString.charAt(i + 1) == '\"') {
                escapedQuote = true;
                continue;
            }
            token.append(ch);
        }
        if (token.length() > 0 || nonEmpty) {
            params.add(token.toString());
        }
        return params;
    }

    private static AppData loadMainClassWithCustomLoader(File classpathFile, String[] args) throws Exception {
        String[] mainArgs;
        ArrayList<URL> classpathUrls = new ArrayList<URL>();
        StringBuffer classpathString = new StringBuffer();
        List pathElements = CommandLineWrapper.readLinesAndDeleteFile(classpathFile);
        for (int i = 0; i < pathElements.size(); ++i) {
            String pathElement = (String)pathElements.get(i);
            classpathUrls.add(CommandLineWrapper.toUrl(new File(pathElement)));
            if (classpathString.length() > 0) {
                classpathString.append(File.pathSeparator);
            }
            classpathString.append(pathElement);
        }
        System.setProperty("java.class.path", classpathString.toString());
        int startArgsIdx = 2;
        List properties = Collections.EMPTY_LIST;
        if (args.length > startArgsIdx && "@vm_params".equals(args[startArgsIdx - 1])) {
            properties = CommandLineWrapper.readLinesAndDeleteFile(new File(args[startArgsIdx]));
            startArgsIdx += 2;
        }
        if (args.length > startArgsIdx && "@app_params".equals(args[startArgsIdx - 1])) {
            List lines = CommandLineWrapper.readLinesAndDeleteFile(new File(args[startArgsIdx]));
            mainArgs = lines.toArray(new String[0]);
            startArgsIdx += 2;
        } else {
            mainArgs = new String[args.length - startArgsIdx];
            System.arraycopy(args, startArgsIdx, mainArgs, 0, mainArgs.length);
        }
        String mainClassName = args[startArgsIdx - 1];
        ClassLoader loader = new URLClassLoader(classpathUrls.toArray(new URL[0]), null);
        String systemLoaderName = System.getProperty("java.system.class.loader");
        if (systemLoaderName != null) {
            try {
                loader = (ClassLoader)Class.forName(systemLoaderName).getConstructor(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = CommandLineWrapper.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).newInstance(loader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Class<?> mainClass = loader.loadClass(mainClassName);
        Thread.currentThread().setContextClassLoader(loader);
        return new AppData(properties, mainClass, mainArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List readLinesAndDeleteFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        finally {
            reader.close();
            file.delete();
        }
    }

    private static URL toUrl(File classpathElement) throws MalformedURLException {
        URL url;
        try {
            url = classpathElement.toURI().toURL();
        }
        catch (NoSuchMethodError e) {
            url = classpathElement.toURL();
        }
        url = new URL("file", url.getHost(), url.getPort(), url.getFile());
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class AppData {
        private final List properties;
        private final Class mainClass;
        private final String[] args;

        private AppData(List properties, Class mainClass, String[] args) {
            this.properties = properties;
            this.mainClass = mainClass;
            this.args = args;
        }
    }
}

