/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.openapi.project.Project;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/ant/AntSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ant"})
public final class AntSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "build.ant.state";
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        AntConfiguration antConfiguration = AntConfiguration.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)antConfiguration), (String)"AntConfiguration.getInstance(project)");
        List<AntBuildFileBase> buildFiles = antConfiguration.getBuildFileList();
        if (buildFiles.isEmpty()) {
            return SetsKt.emptySet();
        }
        boolean bl = false;
        Set usages = new LinkedHashSet();
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasAntProjects", (boolean)true));
        Iterator<AntBuildFileBase> iterator = buildFiles.iterator();
        while (iterator.hasNext()) {
            AntBuildFileBase each;
            AntBuildFileBase antBuildFileBase = each = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)antBuildFileBase, (String)"each");
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"isRunInBackground", (boolean)antBuildFileBase.isRunInBackground()));
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"isColoredOutputMessages", (boolean)each.isColoredOutputMessages()));
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"isViewClosedWhenNoErrors", (boolean)each.isViewClosedWhenNoErrors()));
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"isCollapseFinishedTargets", (boolean)each.isCollapseFinishedTargets()));
        }
        return usages;
    }
}

