/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ProjectIndexableFilesFilter;
import com.intellij.util.indexing.ValueContainer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/completion/ml/common/TextReferencesFeature;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "getName", "intellij.statsCollector"})
public final class TextReferencesFeature
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "references";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)contextFeatures, (String)"contextFeatures");
        if (element.getPsiElement() == null || !StringUtil.isJavaIdentifier((String)element.getLookupString())) {
            boolean bl = false;
            return new LinkedHashMap();
        }
        Project project = location.getProject();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (fileBasedIndex == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        }
        FileBasedIndexImpl index = (FileBasedIndexImpl)fileBasedIndex;
        ProjectIndexableFilesFilter projectIndexableFilesFilter = index.projectIndexableFiles(project);
        if (projectIndexableFilesFilter == null) {
            boolean bl = false;
            return new LinkedHashMap();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)projectIndexableFilesFilter, (String)"index.projectIndexableFi\u2026 ?: return mutableMapOf()");
        ProjectIndexableFilesFilter filter = projectIndexableFilesFilter;
        AtomicInteger referencingFiles = new AtomicInteger(0);
        index.ensureUpToDate(IdIndex.NAME, project, GlobalSearchScope.allScope((Project)project));
        index.getIndex(IdIndex.NAME).getData((Object)new IdIndexEntry(element.getLookupString(), true)).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Integer>(filter, referencingFiles){
            final /* synthetic */ ProjectIndexableFilesFilter $filter;
            final /* synthetic */ AtomicInteger $referencingFiles;

            public final boolean perform(int fileId, Integer value) {
                if ((value & 1) != 0 && this.$filter.containsFileId(fileId)) {
                    this.$referencingFiles.incrementAndGet();
                }
                return true;
            }
            {
                this.$filter = projectIndexableFilesFilter;
                this.$referencingFiles = atomicInteger;
            }
        });
        return MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"file_count", (Object)MLFeatureValue.Companion.float(referencingFiles.get()))});
    }
}

