/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.jetbrains.annotations.Nullable;

public class PathUtils {
    @Nullable
    public static File convertToFile(URI uri) {
        if (uri == null) {
            return null;
        }
        String path = uri.getPath();
        if (path == null) {
            return null;
        }
        return new File(PathUtils.toURI(path));
    }

    public static URI toURI(String localPath) {
        try {
            String p = FileUtilRt.toSystemIndependentName((String)localPath);
            StringBuilder buf = new StringBuilder(p.length() + 3);
            if (!p.startsWith("/")) {
                buf.append("///");
            } else if (!p.startsWith("//")) {
                buf.append("//");
            }
            buf.append(p);
            return new URI("file", null, buf.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }
}

