/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import org.jetbrains.annotations.NotNull;

public class CharArrayCharSequence
implements CharSequence {
    protected final char[] myChars;
    protected final int myStart;
    protected final int myEnd;

    public CharArrayCharSequence(@NotNull char[] chars) {
        if (chars == null) {
            CharArrayCharSequence.$$$reportNull$$$0(0);
        }
        this(chars, 0, chars.length);
    }

    public CharArrayCharSequence(@NotNull char[] chars, int start, int end) {
        if (chars == null) {
            CharArrayCharSequence.$$$reportNull$$$0(1);
        }
        if (start < 0 || end > chars.length || start > end) {
            throw new IndexOutOfBoundsException("chars.length:" + chars.length + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    public char[] getBackendArray() {
        return this.myChars;
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index) {
        return this.myChars[index + this.myStart];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? this : new CharArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        return new String(this.myChars, this.myStart, this.myEnd - this.myStart);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "org/jetbrains/jps/incremental/CharArrayCharSequence", "<init>"));
    }
}

