/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.CharBuffer;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.CharArrayCharSequence;

public abstract class JpsFileObject
extends SimpleJavaFileObject {
    private static final JavaFileObject.Kind[] ourAvailableKinds = JavaFileObject.Kind.values();
    private final JavaFileManager.Location myLocation;

    public JpsFileObject(URI uri, JavaFileObject.Kind kind, @Nullable JavaFileManager.Location location) {
        super(uri, kind);
        this.myLocation = location;
    }

    @Nullable
    public JavaFileManager.Location getLocation() {
        return this.myLocation;
    }

    protected static JavaFileObject.Kind findKind(String name) {
        for (JavaFileObject.Kind kind : ourAvailableKinds) {
            if (kind == JavaFileObject.Kind.OTHER || !name.endsWith(kind.extension)) continue;
            return kind;
        }
        return JavaFileObject.Kind.OTHER;
    }

    @Nullable
    protected abstract String inferBinaryName(Iterable<? extends File> var1, boolean var2);

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        CharBuffer buffer;
        CharSequence content = this.getCharContent(ignoreEncodingErrors);
        if (content == null) {
            throw new UnsupportedOperationException();
        }
        if (content instanceof CharArrayCharSequence) {
            CharArrayCharSequence _content = (CharArrayCharSequence)content;
            return new CharArrayReader(_content.getBackendArray(), _content.getStart(), _content.length());
        }
        if (content instanceof CharBuffer && (buffer = (CharBuffer)content).hasArray()) {
            return new CharArrayReader(buffer.array(), buffer.arrayOffset(), buffer.length());
        }
        return new StringReader(content.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    protected static CharSequence loadCharContent(@NotNull File file, @Nullable String encoding) throws IOException {
        int count;
        int n;
        if (file == null) {
            JpsFileObject.$$$reportNull$$$0(0);
        }
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
        char[] chars = new char[(int)stream.getChannel().size()];
        for (count = 0; count < chars.length && (n = ((Reader)reader).read(chars, count, chars.length - count)) > 0; count += n) {
        }
        CharArrayCharSequence charArrayCharSequence = new CharArrayCharSequence(chars, 0, count);
        ((Reader)reader).close();
        CharArrayCharSequence charArrayCharSequence2 = charArrayCharSequence;
        if (charArrayCharSequence2 == null) {
            JpsFileObject.$$$reportNull$$$0(1);
        }
        return charArrayCharSequence2;
        {
            catch (Throwable throwable) {
                ((Reader)reader).close();
                throw throwable;
            }
        }
        finally {
            stream.close();
        }
    }

    public int hashCode() {
        return this.toUri().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof JpsFileObject && this.toUri().equals(((JpsFileObject)obj).toUri());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/javac/JpsFileObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/javac/JpsFileObject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCharContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadCharContent";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

