/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.OutputWrapper;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.JavaVersion;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.process.internal.JvmOptions;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressListener;
import org.jetbrains.plugins.gradle.service.project.DistributionFactoryExt;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.tooling.internal.init.Init;
import org.jetbrains.plugins.gradle.tooling.loader.rt.MarkerRt;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleExecutionHelper {
    private static final Logger LOG = Logger.getInstance(GradleExecutionHelper.class);
    private static final Set<String> REPORTED_JAVA11_ISSUE = ContainerUtil.newConcurrentSet();

    @NotNull
    public <T> ModelBuilder<T> getModelBuilder(@NotNull Class<T> modelType, @NotNull ExternalSystemTaskId id, @Nullable GradleExecutionSettings settings, @NotNull ProjectConnection connection, @NotNull ExternalSystemTaskNotificationListener listener) {
        if (modelType == null) {
            GradleExecutionHelper.$$$reportNull$$$0(0);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(3);
        }
        ModelBuilder result = connection.model(modelType);
        if (settings != null) {
            GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings, listener, connection);
        }
        ModelBuilder modelBuilder = result;
        if (modelBuilder == null) {
            GradleExecutionHelper.$$$reportNull$$$0(4);
        }
        return modelBuilder;
    }

    @NotNull
    public BuildLauncher getBuildLauncher(@NotNull ExternalSystemTaskId id, @NotNull ProjectConnection connection, @Nullable GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(5);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(6);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(7);
        }
        BuildLauncher result = connection.newBuild();
        if (settings != null) {
            GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings, listener, connection);
        }
        BuildLauncher buildLauncher = result;
        if (buildLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(8);
        }
        return buildLauncher;
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(ProjectResolverContext projectResolverContext) {
        return GradleExecutionHelper.getBuildEnvironment(projectResolverContext.getConnection(), projectResolverContext.getExternalSystemTaskId(), projectResolverContext.getListener(), projectResolverContext.getCancellationTokenSource());
    }

    public static void prepare(@NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull ProjectConnection connection) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(9);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(11);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(12);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(13);
        }
        GradleExecutionHelper.prepare(operation, id, settings, listener, connection, (OutputStream)new OutputWrapper(listener, id, true), (OutputStream)new OutputWrapper(listener, id, false));
    }

    public static void prepare(@NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull ProjectConnection connection, @NotNull OutputStream standardOutput, @NotNull OutputStream standardError) {
        BuildIdentifier buildIdentifier;
        Application application;
        ArrayList<String> filteredArgs;
        String gradleVersion;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(14);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(15);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(16);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(17);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(18);
        }
        if (standardOutput == null) {
            GradleExecutionHelper.$$$reportNull$$$0(19);
        }
        if (standardError == null) {
            GradleExecutionHelper.$$$reportNull$$$0(20);
        }
        List<String> jvmArgs = settings.getJvmArguments();
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, id, listener, null);
        String string = gradleVersion = buildEnvironment != null ? buildEnvironment.getGradle().getGradleVersion() : null;
        if (!jvmArgs.isEmpty()) {
            List<String> merged;
            if (buildEnvironment != null) {
                BuildIdentifier buildIdentifier2 = GradleExecutionHelper.getBuildIdentifier(buildEnvironment);
                List buildJvmArguments = buildIdentifier2 == null || "buildSrc".equals(buildIdentifier2.getRootDir().getName()) ? ContainerUtil.emptyList() : buildEnvironment.getJava().getJvmArguments();
                merged = GradleExecutionHelper.mergeJvmArgs(settings.getServiceDirectory(), buildJvmArguments, jvmArgs);
            } else {
                merged = jvmArgs;
            }
            filteredArgs = ContainerUtil.mapNotNull((Collection)merged, s -> StringUtil.isEmpty((String)s) ? null : s);
            operation.setJvmArguments(ArrayUtilRt.toStringArray((Collection)filteredArgs));
        }
        if (settings.isOfflineWork()) {
            settings.withArgument("--offline");
        }
        if ((application = ApplicationManager.getApplication()) != null && application.isUnitTestMode() && !settings.getArguments().contains("--quiet") && !settings.getArguments().contains("--debug")) {
            settings.withArgument("--info");
        }
        filteredArgs = new ArrayList<String>();
        if (!settings.getArguments().isEmpty()) {
            String loggableArgs = StringUtil.join(GradleExecutionHelper.obfuscatePasswordParameters(settings.getArguments()), (String)" ");
            LOG.info("Passing command-line args to Gradle Tooling API: " + loggableArgs);
            filteredArgs.addAll(ContainerUtil.mapNotNull((Collection)settings.getArguments(), s -> StringUtil.isEmpty((String)s) ? null : s));
            GradleExecutionHelper.replaceTestCommandOptionWithInitScript(filteredArgs);
        }
        filteredArgs.add("-Didea.active=true");
        filteredArgs.add("-Didea.version=" + GradleExecutionHelper.getIdeaVersion());
        operation.withArguments(ArrayUtilRt.toStringArray(filteredArgs));
        GradleExecutionHelper.setupEnvironment(operation, settings, gradleVersion, id, listener);
        String javaHome = settings.getJavaHome();
        if (javaHome != null && new File(javaHome).isDirectory()) {
            operation.setJavaHome(new File(javaHome));
        }
        String buildRootDir = buildEnvironment == null ? null : ((buildIdentifier = GradleExecutionHelper.getBuildIdentifier(buildEnvironment)) == null ? null : buildIdentifier.getRootDir().getPath());
        GradleProgressListener gradleProgressListener = new GradleProgressListener(listener, id, buildRootDir);
        operation.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
        operation.addProgressListener((ProgressListener)gradleProgressListener, new OperationType[]{OperationType.TASK, OperationType.TEST});
        operation.setStandardOutput(standardOutput);
        operation.setStandardError(standardError);
        InputStream inputStream = (InputStream)settings.getUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY);
        if (inputStream != null) {
            operation.setStandardInput(inputStream);
        }
    }

    @Nullable
    private static BuildIdentifier getBuildIdentifier(@NotNull BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            GradleExecutionHelper.$$$reportNull$$$0(21);
        }
        try {
            return buildEnvironment.getBuildIdentifier();
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            return null;
        }
    }

    private static void setupEnvironment(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings, @Nullable String gradleVersion, ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener listener) {
        boolean isEnvironmentCustomizationSupported;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(22);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(23);
        }
        boolean bl = isEnvironmentCustomizationSupported = gradleVersion != null && GradleVersion.version((String)gradleVersion).getBaseVersion().compareTo(GradleVersion.version((String)"3.5")) >= 0;
        if (!isEnvironmentCustomizationSupported) {
            if (!settings.isPassParentEnvs() || !settings.getEnv().isEmpty()) {
                listener.onTaskOutput(taskId, String.format("The version of Gradle you are using%s does not support the environment variables customization feature. Support for this is available in Gradle 3.5 and all later versions.\n", gradleVersion == null ? "" : " (" + gradleVersion + ")"), false);
            }
            return;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withEnvironment(settings.getEnv());
        commandLine.withParentEnvironmentType(settings.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        Map effectiveEnvironment = commandLine.getEffectiveEnvironment();
        operation.setEnvironmentVariables(effectiveEnvironment);
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings, @NotNull Function<? super ProjectConnection, ? extends T> f) {
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(24);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(25);
        }
        return this.execute(projectPath, settings, null, null, null, f);
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings, @Nullable ExternalSystemTaskId taskId, @Nullable ExternalSystemTaskNotificationListener listener, @Nullable CancellationTokenSource cancellationTokenSource, @NotNull Function<? super ProjectConnection, ? extends T> f) {
        File projectPathFile;
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(26);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(27);
        }
        String projectDir = (projectPathFile = new File(projectPath)).isFile() && projectPath.endsWith("gradle") && projectPathFile.getParent() != null ? projectPathFile.getParent() : projectPath;
        String userDir = null;
        if (!GradleEnvironment.ADJUST_USER_DIR) {
            try {
                userDir = System.getProperty("user.dir");
                if (userDir != null) {
                    System.setProperty("user.dir", projectDir);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ProjectConnection connection = GradleExecutionHelper.getConnection(projectDir, settings);
        try {
            GradleExecutionHelper.workaroundJavaVersionIssueIfNeeded(connection, taskId, listener, cancellationTokenSource);
            Object object = f.fun((Object)connection);
            return (T)object;
        }
        catch (ExternalSystemException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.warn("Gradle execution error", e);
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
            ExternalSystemException externalSystemException = new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause), e, new String[0]);
            externalSystemException.initCause(e);
            throw externalSystemException;
        }
        finally {
            if (userDir != null) {
                System.setProperty("user.dir", userDir);
            }
            try {
                connection.close();
            }
            catch (Throwable e) {
                LOG.warn("Gradle connection close error", e);
            }
        }
    }

    public void ensureInstalledWrapper(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull CancellationToken cancellationToken) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(28);
        }
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(29);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(30);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(31);
        }
        if (cancellationToken == null) {
            GradleExecutionHelper.$$$reportNull$$$0(32);
        }
        if (!settings.getDistributionType().isWrapped()) {
            return;
        }
        if (settings.getDistributionType() == DistributionType.DEFAULT_WRAPPED && GradleUtil.findDefaultWrapperPropertiesFile(projectPath) != null) {
            return;
        }
        long ttlInMs = settings.getRemoteProcessIdleTtlInMs();
        ProjectConnection connection = GradleExecutionHelper.getConnection(projectPath, settings);
        try {
            settings.setRemoteProcessIdleTtlInMs(100L);
            try {
                File wrapperFilesLocation = FileUtil.createTempDirectory((String)"wrap", (String)"loc");
                String fileName = "gradle-wrapper";
                File jarFile = new File(wrapperFilesLocation, "gradle-wrapper.jar");
                File scriptFile = new File(wrapperFilesLocation, "gradlew");
                File pathToProperties = new File(wrapperFilesLocation, "path.tmp");
                Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtil.delete((File)wrapperFilesLocation), "GradleExecutionHelper cleanup"));
                String[] lines = new String[]{"", "gradle.projectsEvaluated { gr ->", "  def wrapper = gr.rootProject.tasks[\"wrapper\"]", "  if (wrapper != null) {", "    if (wrapper.jarFile.exists()) {", "      wrapper.jarFile = new File('" + StringUtil.escapeBackSlashes((String)jarFile.getCanonicalPath()) + "')", "      wrapper.scriptFile = new File('" + StringUtil.escapeBackSlashes((String)scriptFile.getCanonicalPath()) + "')", "    }", "    wrapper.doLast {", "      new File('" + StringUtil.escapeBackSlashes((String)pathToProperties.getCanonicalPath()) + "').write wrapper.propertiesFile.getCanonicalPath()", "    }", "  }", "}", ""};
                File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator()), "wrapper_init");
                settings.withArguments(new String[]{"--init-script", tempFile.getAbsolutePath()});
                BuildLauncher launcher = this.getBuildLauncher(id, connection, settings, listener);
                launcher.withCancellationToken(cancellationToken);
                launcher.forTasks(new String[]{"wrapper"});
                launcher.run();
                settings.setWrapperPropertyFile(FileUtil.loadFile((File)pathToProperties));
            }
            catch (IOException e) {
                LOG.warn("Can't update wrapper", (Throwable)e);
            }
        }
        catch (Throwable e) {
            LOG.warn("Can't update wrapper", e);
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
            ExternalSystemException externalSystemException = new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause));
            externalSystemException.initCause(e);
            throw externalSystemException;
        }
        finally {
            settings.setRemoteProcessIdleTtlInMs(ttlInMs);
            try {
                connection.close();
            }
            catch (Throwable e) {}
        }
    }

    @ApiStatus.Experimental
    static List<String> mergeJvmArgs(String serviceDirectory, List<String> jvmArgs, List<String> jvmArgsFromIdeSettings) {
        File gradleUserHomeDir = serviceDirectory != null ? new File(serviceDirectory) : new BuildLayoutParameters().getGradleUserHomeDir();
        LOG.debug("Gradle home: " + gradleUserHomeDir);
        NativeServices.initialize((File)gradleUserHomeDir);
        JvmOptions jvmOptions = new JvmOptions(null);
        List<String> mergedJvmArgs = GradleExecutionHelper.mergeJvmArgs(jvmArgs, jvmArgsFromIdeSettings);
        jvmOptions.setAllJvmArgs(mergedJvmArgs);
        return jvmOptions.getAllJvmArgs();
    }

    @ApiStatus.Experimental
    static List<String> mergeJvmArgs(List<String> jvmArgs, List<String> jvmArgsFromIdeSettings) {
        MultiMap argumentsMap = MultiMap.createLinkedSet();
        String lastKey = null;
        for (String jvmArg : ContainerUtil.concat(jvmArgs, jvmArgsFromIdeSettings)) {
            if (jvmArg.startsWith("-")) {
                argumentsMap.putValue((Object)jvmArg, (Object)"");
                lastKey = jvmArg;
                continue;
            }
            if (lastKey != null) {
                argumentsMap.putValue((Object)lastKey, (Object)jvmArg);
                lastKey = null;
                continue;
            }
            argumentsMap.putValue((Object)jvmArg, (Object)"");
        }
        LinkedHashMap<Object, Object> mergedKeys = new LinkedHashMap<Object, Object>();
        LinkedHashSet argKeySet = new LinkedHashSet(argumentsMap.keySet());
        for (String argKey : argKeySet) {
            Collection values = argumentsMap.getModifiable((Object)argKey);
            if (values.size() == 1 && ((String)values.iterator().next()).isEmpty()) {
                Couple<String> couple = GradleExecutionHelper.splitArg(argKey);
                mergedKeys.put(couple.first, couple.second);
                continue;
            }
            mergedKeys.put(argKey, "");
            LinkedHashMap<Object, Object> mergedArgs = new LinkedHashMap<Object, Object>();
            for (String jvmArg : values) {
                if (jvmArg.isEmpty()) continue;
                Couple<String> couple = GradleExecutionHelper.splitArg(jvmArg);
                mergedArgs.put(couple.first, couple.second);
            }
            values.clear();
            mergedArgs.forEach((key, value) -> values.add(key + value));
        }
        SmartList mergedArgs = new SmartList();
        mergedKeys.forEach((arg_0, arg_1) -> GradleExecutionHelper.lambda$mergeJvmArgs$4((List)mergedArgs, arg_0, arg_1));
        argKeySet.stream().filter(arg_0 -> GradleExecutionHelper.lambda$mergeJvmArgs$5((List)mergedArgs, arg_0)).forEach(arg_0 -> ((MultiMap)argumentsMap).remove(arg_0));
        argumentsMap.remove((Object)"--add-opens");
        SmartList result = new SmartList();
        argumentsMap.keySet().forEach(arg_0 -> GradleExecutionHelper.lambda$mergeJvmArgs$7(argumentsMap, (List)result, arg_0));
        return result;
    }

    private static Couple<String> splitArg(String arg) {
        int i2 = arg.indexOf(61);
        return i2 <= 0 ? Couple.of((Object)arg, (Object)"") : Couple.of((Object)arg.substring(0, i2), (Object)arg.substring(i2));
    }

    @NotNull
    private static ProjectConnection getConnection(@NotNull String projectPath, @Nullable GradleExecutionSettings settings) throws IllegalStateException {
        Application app;
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(33);
        }
        File projectDir = new File(projectPath);
        GradleConnector connector = GradleConnector.newConnector();
        int ttl = -1;
        if (settings != null) {
            File serviceDirectory = settings.getServiceDirectory() == null ? null : new File(settings.getServiceDirectory());
            File gradleHome = settings.getGradleHome() == null ? null : new File(settings.getGradleHome());
            switch (settings.getDistributionType()) {
                case LOCAL: {
                    if (gradleHome == null) break;
                    connector.useInstallation(gradleHome);
                    break;
                }
                case WRAPPED: {
                    if (settings.getWrapperPropertyFile() == null) break;
                    DistributionFactoryExt.setWrappedDistribution(connector, settings.getWrapperPropertyFile(), serviceDirectory, projectDir);
                }
            }
            if (serviceDirectory != null) {
                connector.useGradleUserHomeDir(serviceDirectory);
            }
            if (settings.isVerboseProcessing() && connector instanceof DefaultGradleConnector) {
                ((DefaultGradleConnector)connector).setVerboseLogging(true);
            }
            ttl = (int)settings.getRemoteProcessIdleTtlInMs();
        }
        int n = ttl = (app = ApplicationManager.getApplication()) != null && app.isUnitTestMode() ? 10000 : ttl;
        if (ttl > 0 && connector instanceof DefaultGradleConnector) {
            ((DefaultGradleConnector)connector).daemonMaxIdleTime(ttl, TimeUnit.MILLISECONDS);
        }
        connector.forProjectDirectory(projectDir);
        ProjectConnection connection = connector.connect();
        if (connection == null) {
            throw new IllegalStateException(String.format("Can't create connection to the target project via gradle tooling api. Project path: '%s'", projectPath));
        }
        ProjectConnection projectConnection = connection;
        if (projectConnection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(34);
        }
        return projectConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static File generateInitScript(boolean isBuildSrcProject, @NotNull Set<Class<?>> toolingExtensionClasses) {
        if (toolingExtensionClasses == null) {
            GradleExecutionHelper.$$$reportNull$$$0(35);
        }
        InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/init.gradle");
        try {
            if (stream == null) {
                LOG.warn("Can't get init script template");
                File file = null;
                return file;
            }
            String toolingExtensionsJarPaths = GradleExecutionHelper.getToolingExtensionsJarPaths(toolingExtensionClasses);
            String script = FileUtil.loadTextAndClose((InputStream)stream).replaceFirst(Pattern.quote("${EXTENSIONS_JARS_PATH}"), toolingExtensionsJarPaths);
            if (isBuildSrcProject) {
                String buildSrcDefaultInitScript = GradleExecutionHelper.getBuildSrcDefaultInitScript();
                if (buildSrcDefaultInitScript == null) {
                    File file = null;
                    return file;
                }
                script = script + buildSrcDefaultInitScript;
            }
            File file = GradleExecutionHelper.writeToFileGradleInitScript(script, "ijinit");
            return file;
        }
        catch (Exception e) {
            LOG.warn("Can't generate IJ gradle init script", (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    public static File writeToFileGradleInitScript(@NotNull String content, @NotNull String filePrefix) throws IOException {
        if (content == null) {
            GradleExecutionHelper.$$$reportNull$$$0(36);
        }
        if (filePrefix == null) {
            GradleExecutionHelper.$$$reportNull$$$0(37);
        }
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        int contentLength = contentBytes.length;
        return FileUtil.findSequentFile((File)new File(FileUtil.getTempDirectory()), (String)filePrefix, (String)"gradle", file -> {
            try {
                if (!file.exists()) {
                    FileUtil.writeToFile((File)file, (byte[])contentBytes, (boolean)false);
                    file.deleteOnExit();
                    return true;
                }
                if ((long)contentLength != file.length()) {
                    return false;
                }
                return content.equals(FileUtil.loadFile((File)file, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException iOException) {
                return false;
            }
        });
    }

    @Nullable
    public static String getBuildSrcDefaultInitScript() {
        InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/buildSrcInit.gradle");
        try {
            if (stream == null) {
                String string = null;
                return string;
            }
            String string = FileUtil.loadTextAndClose((InputStream)stream);
            return string;
        }
        catch (Exception e) {
            LOG.warn("Can't use IJ gradle init script", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    @Nullable
    public static GradleVersion getGradleVersion(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener, @Nullable CancellationTokenSource cancellationTokenSource) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(38);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(39);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(40);
        }
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, taskId, listener, cancellationTokenSource);
        GradleVersion gradleVersion = null;
        if (buildEnvironment != null) {
            gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        }
        return gradleVersion;
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener, @Nullable CancellationTokenSource cancellationTokenSource) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(41);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(42);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(43);
        }
        BuildEnvironment buildEnvironment = null;
        try {
            ModelBuilder modelBuilder = connection.model(BuildEnvironment.class);
            if (cancellationTokenSource != null) {
                modelBuilder.withCancellationToken(cancellationTokenSource.token());
            }
            GradleProgressListener gradleProgressListener = new GradleProgressListener(listener, taskId);
            modelBuilder.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
            modelBuilder.addProgressListener((ProgressListener)gradleProgressListener);
            modelBuilder.setStandardOutput((OutputStream)new OutputWrapper(listener, taskId, true));
            modelBuilder.setStandardError((OutputStream)new OutputWrapper(listener, taskId, false));
            buildEnvironment = (BuildEnvironment)modelBuilder.get();
            if (LOG.isDebugEnabled()) {
                try {
                    LOG.debug("Gradle version: " + buildEnvironment.getGradle().getGradleVersion());
                    LOG.debug("Gradle java home: " + buildEnvironment.getJava().getJavaHome());
                    LOG.debug("Gradle jvm arguments: " + buildEnvironment.getJava().getJvmArguments());
                }
                catch (Throwable t) {
                    LOG.debug(t);
                }
            }
        }
        catch (Throwable t) {
            LOG.debug(t);
        }
        return buildEnvironment;
    }

    private static void replaceTestCommandOptionWithInitScript(@NotNull List<String> args) {
        if (args == null) {
            GradleExecutionHelper.$$$reportNull$$$0(44);
        }
        LinkedHashSet<String> testIncludePatterns = new LinkedHashSet<String>();
        Iterator<String> it = args.iterator();
        while (it.hasNext()) {
            String next = it.next();
            if (!"--tests".equals(next)) continue;
            it.remove();
            if (!it.hasNext()) continue;
            testIncludePatterns.add(it.next());
            it.remove();
        }
        if (!testIncludePatterns.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append('[');
            Iterator iterator = testIncludePatterns.iterator();
            while (iterator.hasNext()) {
                String pattern = (String)iterator.next();
                String groovyPattern = GradleExecutionHelper.toGroovyString(pattern);
                buf.append('\'').append(groovyPattern).append('\'');
                if (!iterator.hasNext()) continue;
                buf.append(',');
            }
            buf.append(']');
            String path = GradleExecutionHelper.renderInitScript(buf.toString());
            if (path != null) {
                ContainerUtil.addAll(args, (Object[])new String[]{"--init-script", path});
            }
        }
    }

    @NotNull
    public static String toGroovyString(@NotNull String string) {
        if (string == null) {
            GradleExecutionHelper.$$$reportNull$$$0(45);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char ch : string.toCharArray()) {
            if (ch == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (ch == '\'') {
                stringBuilder.append("\\'");
                continue;
            }
            if (ch == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            stringBuilder.append(ch);
        }
        String string2 = stringBuilder.toString();
        if (string2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(46);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String renderInitScript(@NotNull String testArgs) {
        if (testArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(47);
        }
        InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/testFilterInit.gradle");
        try {
            if (stream == null) {
                LOG.error("Can't get test filter init script template");
                String string = null;
                return string;
            }
            String script = FileUtil.loadTextAndClose((InputStream)stream).replaceFirst(Pattern.quote("${TEST_NAME_INCLUDES}"), Matcher.quoteReplacement(testArgs));
            File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(script, "ijtestinit");
            String string = tempFile.getAbsolutePath();
            return string;
        }
        catch (Exception e) {
            LOG.warn("Can't generate IJ gradle test filter init script", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    @NotNull
    public static String getToolingExtensionsJarPaths(@NotNull Set<Class<?>> toolingExtensionClasses) {
        if (toolingExtensionClasses == null) {
            GradleExecutionHelper.$$$reportNull$$$0(48);
        }
        Set jarPaths = ContainerUtil.map2SetNotNull(toolingExtensionClasses, aClass -> {
            String path = PathManager.getJarPathForClass((Class)aClass);
            if (path != null) {
                if (FileUtilRt.getNameWithoutExtension((String)path).equals("gradle-api-" + GradleVersion.current().getBaseVersion())) {
                    LOG.warn("The gradle api jar shouldn't be added to the gradle daemon classpath: {" + aClass + "," + path + "}");
                    return null;
                }
                return PathUtil.getCanonicalPath((String)path);
            }
            return null;
        });
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        Iterator it = jarPaths.iterator();
        while (it.hasNext()) {
            String jarPath = (String)it.next();
            buf.append('\"').append(jarPath).append('\"');
            if (!it.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        String string = buf.toString();
        if (string == null) {
            GradleExecutionHelper.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    static List<String> obfuscatePasswordParameters(@NotNull List<String> commandLineArguments) {
        if (commandLineArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(50);
        }
        ArrayList<String> replaced = new ArrayList<String>(commandLineArguments.size());
        String PASSWORD_PARAMETER_IDENTIFIER = ".password=";
        for (String option : commandLineArguments) {
            int index = option.indexOf(".password=");
            if (index == -1) {
                replaced.add(option);
                continue;
            }
            replaced.add(option.substring(0, index + ".password=".length()) + "*********");
        }
        ArrayList<String> arrayList = replaced;
        if (arrayList == null) {
            GradleExecutionHelper.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    private static String getIdeaVersion() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        return appInfo.getMajorVersion() + "." + appInfo.getMinorVersion();
    }

    private static void workaroundJavaVersionIssueIfNeeded(@NotNull ProjectConnection connection, @Nullable ExternalSystemTaskId taskId, @Nullable ExternalSystemTaskNotificationListener listener, @Nullable CancellationTokenSource cancellationTokenSource) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(52);
        }
        String buildRoot = null;
        if (Registry.is((String)"gradle.java11.issue.workaround", (boolean)true) && taskId != null && listener != null && JavaVersion.current().feature > 8) {
            try {
                String gradleVersion;
                BuildEnvironment environment = GradleExecutionHelper.getBuildEnvironment(connection, taskId, listener, cancellationTokenSource);
                if (environment != null) {
                    try {
                        buildRoot = environment.getBuildIdentifier().getRootDir().getPath();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String string = gradleVersion = environment != null ? environment.getGradle().getGradleVersion() : null;
                if (gradleVersion == null || GradleVersion.version((String)gradleVersion).getBaseVersion().compareTo(GradleVersion.version((String)"4.7")) < 0) {
                    Object conn = ReflectionUtil.getField(connection.getClass(), (Object)connection, null, (String)"connection");
                    Object actionExecutor = ReflectionUtil.getField(Objects.requireNonNull(conn).getClass(), (Object)conn, null, (String)"actionExecutor");
                    Object actionExecutorDelegate = ReflectionUtil.getField(Objects.requireNonNull(actionExecutor).getClass(), (Object)actionExecutor, null, (String)"delegate");
                    Object delegateActionExecutor = ReflectionUtil.getField(Objects.requireNonNull(actionExecutorDelegate).getClass(), (Object)actionExecutorDelegate, null, (String)"actionExecutor");
                    Object delegateActionExecutorDelegate = ReflectionUtil.getField(Objects.requireNonNull(delegateActionExecutor).getClass(), (Object)delegateActionExecutor, null, (String)"delegate");
                    Field distributionField = ReflectionUtil.getDeclaredField(Objects.requireNonNull(delegateActionExecutorDelegate).getClass(), (String)"distribution");
                    Objects.requireNonNull(distributionField).set(delegateActionExecutorDelegate, new DistributionWrapper((Distribution)distributionField.get(delegateActionExecutorDelegate)));
                }
            }
            catch (Throwable t) {
                String buildId = taskId.getIdeProjectId() + StringUtil.notNullize(buildRoot);
                if (REPORTED_JAVA11_ISSUE.add(buildId)) {
                    LOG.error(t);
                }
                LOG.debug(t);
            }
        }
    }

    private static /* synthetic */ void lambda$mergeJvmArgs$7(MultiMap argumentsMap, List result, String key) {
        argumentsMap.get((Object)key).forEach(val -> {
            result.add(key);
            if (StringUtil.isNotEmpty((String)val)) {
                result.add(val);
            }
        });
    }

    private static /* synthetic */ boolean lambda$mergeJvmArgs$5(List mergedArgs, String argKey) {
        return !mergedArgs.contains(argKey);
    }

    private static /* synthetic */ void lambda$mergeJvmArgs$4(List mergedArgs, String s1, String s2) {
        mergedArgs.add(s1 + s2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 34: 
            case 46: 
            case 49: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 34: 
            case 46: 
            case 49: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelType";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 6: 
            case 13: 
            case 18: 
            case 38: 
            case 41: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 17: 
            case 31: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 8: 
            case 34: 
            case 46: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 9: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 11: 
            case 16: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardOutput";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardError";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildEnvironment";
                break;
            }
            case 24: 
            case 26: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationToken";
                break;
            }
            case 35: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolingExtensionClasses";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePrefix";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testArgs";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildLauncher";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "toGroovyString";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolingExtensionsJarPaths";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "obfuscatePasswordParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModelBuilder";
                break;
            }
            case 4: 
            case 8: 
            case 34: 
            case 46: 
            case 49: 
            case 51: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBuildLauncher";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBuildIdentifier";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setupEnvironment";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "ensureInstalledWrapper";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getConnection";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "generateInitScript";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "writeToFileGradleInitScript";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getGradleVersion";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getBuildEnvironment";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "replaceTestCommandOptionWithInitScript";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "toGroovyString";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "renderInitScript";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getToolingExtensionsJarPaths";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "obfuscatePasswordParameters";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "workaroundJavaVersionIssueIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 34: 
            case 46: 
            case 49: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DistributionWrapper
    implements Distribution {
        private final Distribution myDistribution;
        private final File myRtJarFile;

        private DistributionWrapper(Distribution distribution) {
            this.myDistribution = distribution;
            this.myRtJarFile = new File(Objects.requireNonNull(PathUtil.getCanonicalPath((String)PathManager.getJarPathForClass(MarkerRt.class))));
        }

        public String getDisplayName() {
            return this.myDistribution.getDisplayName();
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory factory, InternalBuildProgressListener listener, File file, BuildCancellationToken token) {
            ClassPath classpath = this.myDistribution.getToolingImplementationClasspath(factory, listener, file, token);
            return DefaultClassPath.of((File[])new File[]{this.myRtJarFile}).plus(classpath);
        }
    }
}

