/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.open;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.open.GradleOpenProjectProvider;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0001H\u0007\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\"\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0001\u001a*\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u001a\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0018"}, d2={"canLinkAndRefreshGradleProject", "", "projectFilePath", "", "project", "Lcom/intellij/openapi/project/Project;", "showValidationDialog", "canOpenGradleProject", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "linkAndRefreshGradleProject", "", "openGradleProject", "projectFile", "projectToClose", "forceOpenInNewFrame", "setupGradleSettings", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "projectDirectory", "projectSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "validateGradleProject", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.gradle.common"})
@JvmName(name="GradleProjectImportUtil")
public final class GradleProjectImportUtil {
    public static final boolean canOpenGradleProject(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return new GradleOpenProjectProvider().canOpenProject(file);
    }

    @Nullable
    public static final Project openGradleProject(@NotNull VirtualFile projectFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Intrinsics.checkParameterIsNotNull((Object)projectFile, (String)"projectFile");
        return new GradleOpenProjectProvider().openProject(projectFile, projectToClose, forceOpenInNewFrame);
    }

    @ApiStatus.Experimental
    @JvmOverloads
    public static final boolean canLinkAndRefreshGradleProject(@NotNull String projectFilePath, @NotNull Project project, boolean showValidationDialog) {
        Intrinsics.checkParameterIsNotNull((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ValidationInfo validationInfo = GradleProjectImportUtil.validateGradleProject(projectFilePath, project);
        if (validationInfo == null) {
            return true;
        }
        ValidationInfo validationInfo2 = validationInfo;
        if (showValidationDialog) {
            String title = ExternalSystemBundle.message((String)"error.project.import.error.title", (Object[])new Object[0]);
            boolean bl = validationInfo2.warning;
            if (bl) {
                Messages.showWarningDialog((Project)project, (String)validationInfo2.message, (String)title);
            } else {
                Messages.showErrorDialog((Project)project, (String)validationInfo2.message, (String)title);
            }
        }
        return false;
    }

    public static /* synthetic */ boolean canLinkAndRefreshGradleProject$default(String string, Project project, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return GradleProjectImportUtil.canLinkAndRefreshGradleProject(string, project, bl);
    }

    @ApiStatus.Experimental
    @JvmOverloads
    public static final boolean canLinkAndRefreshGradleProject(@NotNull String projectFilePath, @NotNull Project project) {
        return GradleProjectImportUtil.canLinkAndRefreshGradleProject$default(projectFilePath, project, false, 4, null);
    }

    public static final void linkAndRefreshGradleProject(@NotNull String projectFilePath, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile projectFile = localFileSystem.refreshAndFindFileByPath(projectFilePath);
        if (projectFile == null) {
            String shortPath = FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)projectFilePath), (boolean)false);
            throw (Throwable)new IllegalArgumentException(ExternalSystemBundle.message((String)"error.project.does.not.exist", (Object[])new Object[]{"Gradle", shortPath}));
        }
        new GradleOpenProjectProvider().linkToExistingProject(projectFile, project);
    }

    public static final void setupGradleSettings(@NotNull GradleProjectSettings settings, @NotNull String projectDirectory, @NotNull Project project, @Nullable Sdk projectSdk2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)settings), (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        new GradleOpenProjectProvider().setupGradleSettings(settings, projectDirectory, project, projectSdk2);
    }

    public static /* synthetic */ void setupGradleSettings$default(GradleProjectSettings gradleProjectSettings, String string, Project project, Sdk sdk, int n, Object object) {
        if ((n & 8) != 0) {
            sdk = null;
        }
        GradleProjectImportUtil.setupGradleSettings(gradleProjectSettings, string, project, sdk);
    }

    private static final ValidationInfo validateGradleProject(String projectFilePath, Project project) {
        VirtualFile projectDirectory;
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractExternalSystemSettings, (String)"ExternalSystemApiUtil.ge\u2026radleConstants.SYSTEM_ID)");
        AbstractExternalSystemSettings systemSettings = abstractExternalSystemSettings;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile projectFile = localFileSystem.refreshAndFindFileByPath(projectFilePath);
        if (projectFile == null) {
            String shortPath = FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)projectFilePath), (boolean)false);
            return new ValidationInfo(ExternalSystemBundle.message((String)"error.project.does.not.exist", (Object[])new Object[]{"Gradle", shortPath}));
        }
        VirtualFile virtualFile = projectDirectory = projectFile.isDirectory() ? projectFile : projectFile.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"projectDirectory");
        ExternalProjectSettings projectSettings = systemSettings.getLinkedProjectSettings(virtualFile.getPath());
        if (projectSettings != null) {
            return new ValidationInfo(ExternalSystemBundle.message((String)"error.project.already.registered", (Object[])new Object[0]));
        }
        return null;
    }
}

