/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.GradleProperty;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.data.GradleExtensionsDataService;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleExtensionsSettings {
    private static final Logger LOG = Logger.getInstance(GradleExtensionsSettings.class);
    private final Settings myState = new Settings();

    public GradleExtensionsSettings(Project project) {
        ExternalSystemApiUtil.subscribe((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemSettingsListener)new GradleSettingsListenerAdapter(){

            public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                if (linkedProjectPaths == null) {
                    1.$$$reportNull$$$0(0);
                }
                GradleExtensionsSettings.this.myState.remove(linkedProjectPaths);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPaths", "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$1", "onProjectsUnlinked"));
            }
        });
    }

    @NotNull
    public static Settings getInstance(@NotNull Project project) {
        if (project == null) {
            GradleExtensionsSettings.$$$reportNull$$$0(0);
        }
        Settings settings = ((GradleExtensionsSettings)ServiceManager.getService((Project)project, GradleExtensionsSettings.class)).myState;
        if (settings == null) {
            GradleExtensionsSettings.$$$reportNull$$$0(1);
        }
        return settings;
    }

    public static void load(Project project) {
        Collection projectsData = ProjectDataManager.getInstance().getExternalProjectsData(project, GradleConstants.SYSTEM_ID);
        for (ExternalProjectInfo projectInfo : projectsData) {
            DataNode projectDataNode = projectInfo.getExternalProjectStructure();
            if (projectDataNode == null) continue;
            String projectPath = projectInfo.getExternalProjectPath();
            try {
                SmartList nodes = new SmartList();
                for (DataNode moduleNode : ExternalSystemApiUtil.findAll((DataNode)projectDataNode, (Key)ProjectKeys.MODULE)) {
                    ContainerUtil.addIfNotNull((Collection)nodes, (Object)ExternalSystemApiUtil.find((DataNode)moduleNode, GradleExtensionsDataService.KEY));
                }
                GradleExtensionsSettings.getInstance(project).add(projectPath, (Collection<DataNode<GradleExtensions>>)nodes);
            }
            catch (ClassCastException e) {
                LOG.debug((Throwable)e);
                ExternalProjectsManager.getInstance((Project)project).getExternalProjectsWatcher().markDirty(projectPath);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GradleConfiguration {
        public String name;
        public boolean visible = true;
        public boolean scriptClasspath;
        public String description;
    }

    public static class GradleTask
    implements TypeAware {
        public String name;
        public String typeFqn = "org.gradle.api.DefaultTask";
        @Nullable
        public String description;

        @Override
        public String getTypeFqn() {
            return this.typeFqn;
        }
    }

    public static class GradleProp
    implements TypeAware {
        public String name;
        public String typeFqn = "java.lang.String";
        @Nullable
        public String value;

        @Override
        public String getTypeFqn() {
            return this.typeFqn;
        }
    }

    public static class GradleConvention
    implements TypeAware {
        public String name;
        public String typeFqn = "Object";

        @Override
        public String getTypeFqn() {
            return this.typeFqn;
        }
    }

    public static class GradleExtension
    implements TypeAware {
        public String name;
        public String rootTypeFqn = "Object";

        @Override
        public String getTypeFqn() {
            return this.rootTypeFqn;
        }
    }

    public static interface TypeAware {
        public String getTypeFqn();
    }

    public static class GradleExtensionsData {
        private GradleProject myGradleProject;
        public String parent;
        @NotNull
        public final Map<String, GradleExtension> extensions = new HashMap<String, GradleExtension>();
        @NotNull
        public final List<GradleConvention> conventions = new SmartList();
        @NotNull
        public final Map<String, GradleProp> properties = new HashMap<String, GradleProp>();
        @NotNull
        public final Map<String, GradleTask> tasksMap = new LinkedHashMap<String, GradleTask>();
        @Deprecated
        public List<GradleTask> tasks = Collections.emptyList();
        @NotNull
        public final Map<String, GradleConfiguration> configurations = new HashMap<String, GradleConfiguration>();
        @NotNull
        public final Map<String, GradleConfiguration> buildScriptConfigurations = new HashMap<String, GradleConfiguration>();

        @Nullable
        public GradleExtensionsData getParent() {
            if (this.myGradleProject == null) {
                return null;
            }
            return this.myGradleProject.extensions.get(this.parent);
        }

        @Nullable
        public GradleProp findProperty(@Nullable String name) {
            return GradleExtensionsData.findProperty(this, name);
        }

        @NotNull
        public Collection<GradleProp> findAllProperties() {
            return GradleExtensionsData.findAllProperties(this, new HashMap<String, GradleProp>());
        }

        @NotNull
        private static Collection<GradleProp> findAllProperties(@NotNull GradleExtensionsData extensionsData, @NotNull Map<String, GradleProp> result) {
            if (extensionsData == null) {
                GradleExtensionsData.$$$reportNull$$$0(0);
            }
            if (result == null) {
                GradleExtensionsData.$$$reportNull$$$0(1);
            }
            for (GradleProp property : extensionsData.properties.values()) {
                result.putIfAbsent(property.name, property);
            }
            if (extensionsData.getParent() != null) {
                GradleExtensionsData.findAllProperties(extensionsData.getParent(), result);
            }
            Collection<GradleProp> collection = result.values();
            if (collection == null) {
                GradleExtensionsData.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @Nullable
        private static GradleProp findProperty(@NotNull GradleExtensionsData extensionsData, String propName) {
            GradleExtensionsData parentData;
            GradleProp prop;
            if (extensionsData == null) {
                GradleExtensionsData.$$$reportNull$$$0(3);
            }
            if ((prop = extensionsData.properties.get(propName)) != null) {
                return prop;
            }
            if (extensionsData.parent != null && extensionsData.myGradleProject != null && (parentData = extensionsData.myGradleProject.extensions.get(extensionsData.parent)) != null) {
                return GradleExtensionsData.findProperty(parentData, propName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensionsData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findAllProperties";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findAllProperties";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findProperty";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class GradleProject {
        public Map<String, GradleExtensionsData> extensions = new HashMap<String, GradleExtensionsData>();

        GradleProject() {
        }
    }

    public static class Settings {
        public Map<String, GradleProject> projects = new HashMap<String, GradleProject>();

        public void add(@NotNull String rootPath, @NotNull Collection<DataNode<GradleExtensions>> extensionsData) {
            if (rootPath == null) {
                Settings.$$$reportNull$$$0(0);
            }
            if (extensionsData == null) {
                Settings.$$$reportNull$$$0(1);
            }
            HashMap<String, GradleExtensions> extensionMap = new HashMap<String, GradleExtensions>();
            for (DataNode<GradleExtensions> node : extensionsData) {
                DataNode parent = node.getParent();
                if (parent == null || !(parent.getData() instanceof ModuleData)) continue;
                String gradlePath = GradleProjectResolverUtil.getGradlePath((ModuleData)parent.getData());
                extensionMap.put(gradlePath, (GradleExtensions)node.getData());
            }
            this.add(rootPath, extensionMap);
        }

        public void add(@NotNull String rootPath, @NotNull Map<String, GradleExtensions> extensions) {
            if (rootPath == null) {
                Settings.$$$reportNull$$$0(2);
            }
            if (extensions == null) {
                Settings.$$$reportNull$$$0(3);
            }
            GradleProject gradleProject = new GradleProject();
            for (Map.Entry<String, GradleExtensions> entry : extensions.entrySet()) {
                GradleExtensionsData extensionsData = new GradleExtensionsData();
                GradleExtensions gradleExtensions = entry.getValue();
                extensionsData.parent = gradleExtensions.getParentProjectPath();
                for (org.jetbrains.plugins.gradle.model.GradleExtension extension : gradleExtensions.getExtensions()) {
                    GradleExtension gradleExtension = new GradleExtension();
                    gradleExtension.name = extension.getName();
                    gradleExtension.rootTypeFqn = extension.getTypeFqn();
                    extensionsData.extensions.put(extension.getName(), gradleExtension);
                }
                for (org.jetbrains.plugins.gradle.model.GradleConvention convention : gradleExtensions.getConventions()) {
                    GradleConvention gradleConvention = new GradleConvention();
                    gradleConvention.name = convention.getName();
                    gradleConvention.typeFqn = convention.getTypeFqn();
                    extensionsData.conventions.add(gradleConvention);
                }
                for (GradleProperty property : gradleExtensions.getGradleProperties()) {
                    GradleProp gradleProp = new GradleProp();
                    gradleProp.name = property.getName();
                    gradleProp.typeFqn = property.getTypeFqn();
                    extensionsData.properties.put(gradleProp.name, gradleProp);
                }
                for (ExternalTask task : gradleExtensions.getTasks()) {
                    GradleTask gradleTask = new GradleTask();
                    gradleTask.name = task.getName();
                    String type = task.getType();
                    if (type != null) {
                        gradleTask.typeFqn = type;
                    }
                    StringBuilder description = new StringBuilder();
                    if (task.getDescription() != null) {
                        description.append(task.getDescription());
                        if (task.getGroup() != null) {
                            description.append("<p>");
                        }
                    }
                    if (task.getGroup() != null) {
                        description.append("<i>Task group: ").append(task.getGroup()).append("<i>");
                    }
                    gradleTask.description = description.toString();
                    extensionsData.tasksMap.put(gradleTask.name, gradleTask);
                }
                extensionsData.tasks = new SmartList(extensionsData.tasksMap.values());
                for (org.jetbrains.plugins.gradle.model.GradleConfiguration configuration : gradleExtensions.getConfigurations()) {
                    GradleConfiguration gradleConfiguration = new GradleConfiguration();
                    gradleConfiguration.name = configuration.getName();
                    gradleConfiguration.description = configuration.getDescription();
                    gradleConfiguration.visible = configuration.isVisible();
                    gradleConfiguration.scriptClasspath = configuration.isScriptClasspathConfiguration();
                    if (gradleConfiguration.scriptClasspath) {
                        extensionsData.buildScriptConfigurations.put(configuration.getName(), gradleConfiguration);
                        continue;
                    }
                    extensionsData.configurations.put(configuration.getName(), gradleConfiguration);
                }
                gradleProject.extensions.put(entry.getKey(), extensionsData);
                extensionsData.myGradleProject = gradleProject;
            }
            HashMap<String, GradleProject> projects2 = new HashMap<String, GradleProject>(this.projects);
            projects2.put(rootPath, gradleProject);
            this.projects = projects2;
        }

        public void remove(Set<String> rootPaths) {
            HashMap<String, GradleProject> projects2 = new HashMap<String, GradleProject>(this.projects);
            for (String path : rootPaths) {
                projects2.remove(path);
            }
            this.projects = projects2;
        }

        @Nullable
        public GradleExtensionsData getExtensionsFor(@Nullable Module module) {
            if (module == null) {
                return null;
            }
            return this.getExtensionsFor(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module), GradleProjectResolverUtil.getGradlePath(module));
        }

        @Nullable
        public GradleExtensionsData getExtensionsFor(@Nullable String rootProjectPath, @Nullable String gradlePath) {
            if (rootProjectPath == null || gradlePath == null) {
                return null;
            }
            GradleProject gradleProject = this.projects.get(rootProjectPath);
            if (gradleProject == null) {
                return null;
            }
            return gradleProject.extensions.get(gradlePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extensionsData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extensions";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$Settings";
            objectArray[2] = "add";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

