/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.util.io.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.Environment;
import org.jetbrains.plugins.gradle.util.GradleProperties;
import org.jetbrains.plugins.gradle.util.GradlePropertiesImpl;
import org.jetbrains.plugins.gradle.util.GradlePropertiesUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\b\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"GRADLE_CACHE_DIR_NAME", "", "GRADLE_JAVA_HOME_PROPERTY", "PROPERTIES_FILE_NAME", "getGradleHomePropertiesPath", "getGradleProjectPropertiesPath", "externalProjectPath", "getGradleProperties", "Lorg/jetbrains/plugins/gradle/util/GradleProperties;", "getPossiblePropertiesFiles", "", "loadGradleProperties", "propertiesPath", "loadProperties", "Ljava/util/Properties;", "mergeGradleProperties", "most", "other", "intellij.gradle.common"})
@JvmName(name="GradlePropertiesUtil")
public final class GradlePropertiesUtil {
    @NotNull
    public static final String GRADLE_CACHE_DIR_NAME = ".gradle";
    @NotNull
    public static final String PROPERTIES_FILE_NAME = "gradle.properties";
    @NotNull
    public static final String GRADLE_JAVA_HOME_PROPERTY = "org.gradle.java.home";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GradleProperties getGradleProperties(@NotNull String externalProjectPath) {
        Intrinsics.checkParameterIsNotNull((Object)externalProjectPath, (String)"externalProjectPath");
        Sequence $this$reduce$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)GradlePropertiesUtil.getPossiblePropertiesFiles(externalProjectPath)), (Function1)getGradleProperties.1.INSTANCE);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p2;
            GradleProperties gradleProperties = (GradleProperties)iterator$iv.next();
            GradleProperties p1 = (GradleProperties)accumulator$iv;
            boolean bl = false;
            accumulator$iv = GradlePropertiesUtil.mergeGradleProperties(p1, (GradleProperties)p2);
        }
        return (GradleProperties)accumulator$iv;
    }

    private static final List<String> getPossiblePropertiesFiles(String externalProjectPath) {
        return CollectionsKt.listOfNotNull((Object[])new String[]{GradlePropertiesUtil.getGradleHomePropertiesPath(), GradlePropertiesUtil.getGradleProjectPropertiesPath(externalProjectPath)});
    }

    private static final String getGradleHomePropertiesPath() {
        String gradleUserHome = Environment.Companion.getEnvVariable("GRADLE_USER_HOME");
        if (gradleUserHome != null) {
            String string = FileUtil.join((String[])new String[]{gradleUserHome, PROPERTIES_FILE_NAME});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.join(gradleUser\u2026me, PROPERTIES_FILE_NAME)");
            return string;
        }
        String userHome = Environment.Companion.getUserHome();
        String string = FileUtil.join((String[])new String[]{userHome, GRADLE_CACHE_DIR_NAME, PROPERTIES_FILE_NAME});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.join(userHome, \u2026ME, PROPERTIES_FILE_NAME)");
        return string;
    }

    private static final String getGradleProjectPropertiesPath(String externalProjectPath) {
        String string = FileUtil.join((String[])new String[]{externalProjectPath, PROPERTIES_FILE_NAME});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.join(externalPr\u2026th, PROPERTIES_FILE_NAME)");
        return string;
    }

    private static final GradleProperties loadGradleProperties(String propertiesPath) {
        Properties properties = GradlePropertiesUtil.loadProperties(propertiesPath);
        if (properties == null) {
            return GradleProperties.EMPTY.INSTANCE;
        }
        Properties properties2 = properties;
        String javaHome = properties2.getProperty(GRADLE_JAVA_HOME_PROPERTY);
        return new GradlePropertiesImpl(javaHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Properties loadProperties(String propertiesPath) {
        File propertiesFile = new File(propertiesPath);
        if (!propertiesFile.isFile()) {
            return null;
        }
        if (!propertiesFile.exists()) {
            return null;
        }
        Properties properties = new Properties();
        Object object = propertiesFile;
        boolean bl = false;
        object = new FileInputStream((File)object);
        bl = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)object;
            boolean bl2 = false;
            properties.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return properties;
    }

    private static final GradleProperties mergeGradleProperties(GradleProperties most, GradleProperties other) {
        GradleProperties gradleProperties;
        if (most instanceof GradleProperties.EMPTY) {
            gradleProperties = other;
        } else if (other instanceof GradleProperties.EMPTY) {
            gradleProperties = most;
        } else {
            String string = most.getJavaHome();
            if (string == null) {
                string = other.getJavaHome();
            }
            gradleProperties = new GradlePropertiesImpl(string);
        }
        return gradleProperties;
    }

    public static final /* synthetic */ GradleProperties access$loadGradleProperties(String propertiesPath) {
        return GradlePropertiesUtil.loadGradleProperties(propertiesPath);
    }
}

