/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.source;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Reader;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Writer;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class CatalogArchetypeDataSource
extends AbstractLogEnabled
implements ArchetypeDataSource {
    public static final String ARCHETYPE_CATALOG_PROPERTY = "file";
    public static final String ARCHETYPE_CATALOG_FILENAME = "archetype-catalog.xml";
    private ArchetypeCatalogXpp3Reader catalogReader = new ArchetypeCatalogXpp3Reader();
    private ArchetypeCatalogXpp3Writer catalogWriter = new ArchetypeCatalogXpp3Writer();
    public static final File USER_HOME = new File(System.getProperty("user.home"));
    public static final File MAVEN_CONFIGURATION = new File(USER_HOME, ".m2");
    public static final File DEFAULT_ARCHETYPE_CATALOG = new File(MAVEN_CONFIGURATION, "archetype-catalog.xml");

    public List getArchetypes(Properties properties) throws ArchetypeDataSourceException {
        String s = properties.getProperty(ARCHETYPE_CATALOG_PROPERTY);
        s = StringUtils.replace((String)s, (String)"${user.home}", (String)System.getProperty("user.home"));
        this.getLogger().debug("Using catalog " + s);
        File catalogFile = new File(s);
        if (catalogFile.exists()) {
            try {
                ArchetypeCatalog catalog = this.readCatalog(new FileReader(catalogFile));
                return this.createArchetypeMap(catalog);
            }
            catch (FileNotFoundException e) {
                throw new ArchetypeDataSourceException("The specific archetype catalog does not exist.", e);
            }
        }
        return new ArrayList();
    }

    public void updateCatalog(Properties properties, Archetype archetype) throws ArchetypeDataSourceException {
        ArchetypeCatalog catalog;
        String s = properties.getProperty(ARCHETYPE_CATALOG_PROPERTY);
        s = StringUtils.replace((String)s, (String)"${user.home}", (String)System.getProperty("user.home"));
        this.getLogger().debug("Using catalog " + s);
        File catalogFile = new File(s);
        if (catalogFile.exists()) {
            try {
                this.getLogger().debug("Reading the catalog " + catalogFile);
                catalog = this.readCatalog(new FileReader(catalogFile));
            }
            catch (FileNotFoundException ex) {
                this.getLogger().debug("Catalog file don't exist");
                catalog = new ArchetypeCatalog();
            }
        } else {
            this.getLogger().debug("Catalog file don't exist");
            catalog = new ArchetypeCatalog();
        }
        Iterator archetypes = catalog.getArchetypes().iterator();
        boolean found = false;
        Archetype newArchetype = archetype;
        while (!found && archetypes.hasNext()) {
            Archetype a = (Archetype)archetypes.next();
            if (!a.getGroupId().equals(archetype.getGroupId()) || !a.getArtifactId().equals(archetype.getArtifactId())) continue;
            newArchetype = a;
            found = true;
        }
        if (!found) {
            catalog.addArchetype(newArchetype);
        }
        newArchetype.setVersion(archetype.getVersion());
        newArchetype.setRepository(archetype.getRepository());
        newArchetype.setDescription(archetype.getDescription());
        newArchetype.setProperties(archetype.getProperties());
        newArchetype.setGoals(archetype.getGoals());
        this.writeLocalCatalog(catalog, catalogFile);
    }

    protected void writeLocalCatalog(ArchetypeCatalog catalog, File catalogFile) throws ArchetypeDataSourceException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(catalogFile);
            this.catalogWriter.write(writer, catalog);
        }
        catch (IOException e) {
            try {
                throw new ArchetypeDataSourceException("Error writing archetype catalog.", e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    protected List createArchetypeMap(ArchetypeCatalog archetypeCatalog) throws ArchetypeDataSourceException {
        ArrayList<Archetype> archetypes = new ArrayList<Archetype>();
        Iterator i = archetypeCatalog.getArchetypes().iterator();
        while (i.hasNext()) {
            Archetype archetype = (Archetype)i.next();
            archetypes.add(archetype);
        }
        return archetypes;
    }

    protected ArchetypeCatalog readCatalog(Reader reader) throws ArchetypeDataSourceException {
        try {
            ArchetypeCatalog archetypeCatalog = this.catalogReader.read(reader);
            return archetypeCatalog;
        }
        catch (IOException e) {
            throw new ArchetypeDataSourceException("Error reading archetype catalog.", e);
        }
        catch (XmlPullParserException e) {
            throw new ArchetypeDataSourceException("Error parsing archetype catalog.", e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    public ArchetypeCatalog getArchetypeCatalog(Properties properties) throws ArchetypeDataSourceException {
        String s = properties.getProperty(ARCHETYPE_CATALOG_PROPERTY);
        File catalogFile = new File(s = StringUtils.replace((String)s, (String)"${user.home}", (String)System.getProperty("user.home")));
        if (catalogFile.exists() && catalogFile.isDirectory()) {
            catalogFile = new File(catalogFile, ARCHETYPE_CATALOG_FILENAME);
        }
        this.getLogger().debug("Using catalog " + catalogFile);
        if (catalogFile.exists()) {
            try {
                return this.readCatalog(new FileReader(catalogFile));
            }
            catch (FileNotFoundException e) {
                throw new ArchetypeDataSourceException("The specific archetype catalog does not exist.", e);
            }
        }
        return new ArchetypeCatalog();
    }
}

