/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.maven.compiler.MavenResourceFileProcessor;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourceRootDescriptor;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTarget;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTargetType;

public class MavenResourcesBuilder
extends TargetBuilder<MavenResourceRootDescriptor, MavenResourcesTarget> {
    private static final Logger LOG = Logger.getInstance(MavenResourcesBuilder.class);
    public static final String BUILDER_NAME = "Maven Resources Compiler";

    public MavenResourcesBuilder() {
        super(Arrays.asList(MavenResourcesTargetType.PRODUCTION, MavenResourcesTargetType.TEST));
    }

    public void build(final @NotNull MavenResourcesTarget target, @NotNull DirtyFilesHolder<MavenResourceRootDescriptor, MavenResourcesTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(3);
        }
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        MavenProjectConfiguration projectConfig = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
        if (projectConfig == null) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, "Maven project configuration required for module '" + target.getModule().getName() + "' isn't available. Compilation of Maven projects is supported only if external build is started from an IDE."));
            throw new StopBuildException();
        }
        MavenModuleResourceConfiguration config = target.getModuleResourcesConfiguration(dataPaths);
        if (config == null) {
            return;
        }
        final HashMap files = new HashMap();
        holder.processDirtyFiles((FileProcessor)new FileProcessor<MavenResourceRootDescriptor, MavenResourcesTarget>(){

            public boolean apply(MavenResourcesTarget t, File file, MavenResourceRootDescriptor rd) throws IOException {
                assert (target == t);
                ArrayList<File> fileList = (ArrayList<File>)files.get((Object)rd);
                if (fileList == null) {
                    fileList = new ArrayList<File>();
                    files.put(rd, fileList);
                }
                fileList.add(file);
                return true;
            }
        });
        MavenResourceRootDescriptor[] roots = files.keySet().toArray(new MavenResourceRootDescriptor[0]);
        Arrays.sort(roots, (r1, r2) -> {
            int res = r1.getIndexInPom() - r2.getIndexInPom();
            if (r1.isOverwrite()) {
                assert (r2.isOverwrite());
                return res;
            }
            if (r1.getConfiguration().isFiltered && !r2.getConfiguration().isFiltered) {
                return 1;
            }
            if (!r1.getConfiguration().isFiltered && r2.getConfiguration().isFiltered) {
                return -1;
            }
            if (!r1.getConfiguration().isFiltered) {
                res = -res;
            }
            return res;
        });
        MavenResourceFileProcessor fileProcessor = new MavenResourceFileProcessor(projectConfig, target.getModule().getProject(), config);
        context.processMessage((BuildMessage)new ProgressMessage("Copying resources... [" + target.getModule().getName() + "]"));
        for (MavenResourceRootDescriptor rd : roots) {
            for (File file : (List)files.get((Object)rd)) {
                String relPath = FileUtil.getRelativePath((File)rd.getRootFile(), (File)file);
                if (relPath == null) continue;
                String outputDirectory = target.isTests() ? config.testOutputDirectory : config.outputDirectory;
                File outputDir = MavenResourcesTarget.getOutputDir(target.getModuleOutputDir(), rd.getConfiguration(), outputDirectory);
                if (outputDir == null) continue;
                File outputFile = new File(outputDir, relPath);
                String sourcePath = file.getPath();
                try {
                    fileProcessor.copyFile(file, outputFile, rd.getConfiguration(), context, FileUtilRt.ALL_FILES);
                    outputConsumer.registerOutputFile(outputFile, Collections.singleton(sourcePath));
                }
                catch (UnsupportedEncodingException e) {
                    context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.INFO, "Resource was not copied: " + e.getMessage(), sourcePath));
                }
                catch (IOException e) {
                    context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, "Failed to copy '" + sourcePath + "' to '" + outputFile.getAbsolutePath() + "': " + e.getMessage()));
                    LOG.info((Throwable)e);
                }
                if (!context.getCancelStatus().isCanceled()) continue;
                return;
            }
        }
        context.checkCanceled();
        context.processMessage((BuildMessage)new ProgressMessage(""));
    }

    @NotNull
    public String getPresentableName() {
        return BUILDER_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "outputConsumer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/maven/compiler/MavenResourcesBuilder";
        objectArray[2] = "build";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

