/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.resources.ResourcesBuilder;
import org.jetbrains.jps.incremental.resources.StandardResourceBuilderEnabler;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.JpsMavenModuleExtension;
import org.jetbrains.jps.maven.model.impl.JpsMavenModuleExtensionImpl;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsMavenExtensionServiceImpl
extends JpsMavenExtensionService {
    private static final Logger LOG = Logger.getInstance(JpsMavenExtensionServiceImpl.class);
    private static final JpsElementChildRole<JpsSimpleElement<Boolean>> PRODUCTION_ON_TEST_ROLE = JpsElementChildRoleBase.create((String)"maven production on test");
    private final Map<File, MavenProjectConfiguration> myLoadedConfigs = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
    private final Map<File, Boolean> myConfigFileExists = ConcurrentFactoryMap.createMap(key -> key.exists());

    public JpsMavenExtensionServiceImpl() {
        ResourcesBuilder.registerEnabler((StandardResourceBuilderEnabler)new StandardResourceBuilderEnabler(){

            public boolean isResourceProcessingEnabled(JpsModule module) {
                return JpsMavenExtensionServiceImpl.this.getExtension(module) == null;
            }
        });
    }

    @Override
    @Nullable
    public JpsMavenModuleExtension getExtension(@NotNull JpsModule module) {
        if (module == null) {
            JpsMavenExtensionServiceImpl.$$$reportNull$$$0(0);
        }
        return (JpsMavenModuleExtension)module.getContainer().getChild(JpsMavenModuleExtensionImpl.ROLE);
    }

    @Override
    @NotNull
    public JpsMavenModuleExtension getOrCreateExtension(@NotNull JpsModule module) {
        JpsMavenModuleExtension extension;
        if (module == null) {
            JpsMavenExtensionServiceImpl.$$$reportNull$$$0(1);
        }
        if ((extension = (JpsMavenModuleExtension)module.getContainer().getChild(JpsMavenModuleExtensionImpl.ROLE)) == null) {
            extension = new JpsMavenModuleExtensionImpl();
            module.getContainer().setChild(JpsMavenModuleExtensionImpl.ROLE, (JpsElement)extension);
        }
        JpsMavenModuleExtension jpsMavenModuleExtension = extension;
        if (jpsMavenModuleExtension == null) {
            JpsMavenExtensionServiceImpl.$$$reportNull$$$0(2);
        }
        return jpsMavenModuleExtension;
    }

    @Override
    public void setProductionOnTestDependency(@NotNull JpsDependencyElement dependency, boolean value) {
        if (dependency == null) {
            JpsMavenExtensionServiceImpl.$$$reportNull$$$0(3);
        }
        if (value) {
            dependency.getContainer().setChild(PRODUCTION_ON_TEST_ROLE, (JpsElement)JpsElementFactory.getInstance().createSimpleElement((Object)true));
        } else {
            dependency.getContainer().removeChild(PRODUCTION_ON_TEST_ROLE);
        }
    }

    @Override
    public boolean isProductionOnTestDependency(@NotNull JpsDependencyElement dependency) {
        JpsSimpleElement child;
        if (dependency == null) {
            JpsMavenExtensionServiceImpl.$$$reportNull$$$0(4);
        }
        return (child = (JpsSimpleElement)dependency.getContainer().getChild(PRODUCTION_ON_TEST_ROLE)) != null && (Boolean)child.getData() != false;
    }

    @Override
    public boolean hasMavenProjectConfiguration(@NotNull BuildDataPaths paths) {
        if (paths == null) {
            JpsMavenExtensionServiceImpl.$$$reportNull$$$0(5);
        }
        return this.myConfigFileExists.get(new File(paths.getDataStorageRoot(), "maven/configuration.xml"));
    }

    @Override
    public MavenProjectConfiguration getMavenProjectConfiguration(BuildDataPaths paths) {
        if (!this.hasMavenProjectConfiguration(paths)) {
            return null;
        }
        File dataStorageRoot = paths.getDataStorageRoot();
        return this.getMavenProjectConfiguration(dataStorageRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MavenProjectConfiguration getMavenProjectConfiguration(@NotNull File dataStorageRoot) {
        MavenProjectConfiguration config;
        if (dataStorageRoot == null) {
            JpsMavenExtensionServiceImpl.$$$reportNull$$$0(6);
        }
        File configFile = new File(dataStorageRoot, "maven/configuration.xml");
        Map<File, MavenProjectConfiguration> map = this.myLoadedConfigs;
        synchronized (map) {
            config = this.myLoadedConfigs.get(configFile);
            if (config == null) {
                config = new MavenProjectConfiguration();
                try {
                    XmlSerializer.deserializeInto((Object)config, (Element)JDOMUtil.load((File)configFile));
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
                this.myLoadedConfigs.put(configFile, config);
            }
        }
        MavenProjectConfiguration mavenProjectConfiguration = config;
        if (mavenProjectConfiguration == null) {
            JpsMavenExtensionServiceImpl.$$$reportNull$$$0(7);
        }
        return mavenProjectConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/maven/model/impl/JpsMavenExtensionServiceImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStorageRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/maven/model/impl/JpsMavenExtensionServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateExtension";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenProjectConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateExtension";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProductionOnTestDependency";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isProductionOnTestDependency";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasMavenProjectConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMavenProjectConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

