/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeAssocTable<T> {
    private final Map<CharSequence, T> myExtensionMappings;
    private final Map<CharSequence, T> myExactFileNameMappings;
    private final Map<CharSequence, T> myExactFileNameAnyCaseMappings;
    private final List<Pair<FileNameMatcher, T>> myMatchingMappings;

    private FileTypeAssocTable(@NotNull Map<? extends CharSequence, ? extends T> extensionMappings, @NotNull Map<? extends CharSequence, ? extends T> exactFileNameMappings, @NotNull Map<? extends CharSequence, T> exactFileNameAnyCaseMappings, @NotNull List<? extends Pair<FileNameMatcher, T>> matchingMappings) {
        if (extensionMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(0);
        }
        if (exactFileNameMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(1);
        }
        if (exactFileNameAnyCaseMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(2);
        }
        if (matchingMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(3);
        }
        this.myExtensionMappings = new THashMap(Math.max(10, extensionMappings.size()), 0.5f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_INSENSITIVE);
        this.myExtensionMappings.putAll(extensionMappings);
        this.myExactFileNameMappings = new THashMap(Math.max(10, exactFileNameMappings.size()), 0.5f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_SENSITIVE);
        this.myExactFileNameMappings.putAll(exactFileNameMappings);
        this.myExactFileNameAnyCaseMappings = new THashMap(Math.max(10, exactFileNameAnyCaseMappings.size()), 0.5f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_INSENSITIVE);
        this.myExactFileNameAnyCaseMappings.putAll(exactFileNameAnyCaseMappings);
        this.myMatchingMappings = new ArrayList<Pair<FileNameMatcher, T>>(matchingMappings);
    }

    public FileTypeAssocTable() {
        this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
    }

    boolean isAssociatedWith(@NotNull T type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(4);
        }
        if (matcher == null) {
            FileTypeAssocTable.$$$reportNull$$$0(5);
        }
        if (matcher instanceof ExtensionFileNameMatcher || matcher instanceof ExactFileNameMatcher) {
            return this.findAssociatedFileType(matcher) == type;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst()) || type != mapping.getSecond()) continue;
            return true;
        }
        return false;
    }

    public void addAssociation(@NotNull FileNameMatcher matcher, @NotNull T type) {
        if (matcher == null) {
            FileTypeAssocTable.$$$reportNull$$$0(6);
        }
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(7);
        }
        if (matcher instanceof ExtensionFileNameMatcher) {
            this.myExtensionMappings.put(((ExtensionFileNameMatcher)matcher).getExtension(), type);
        } else if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            Map<CharSequence, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            mapToUse.put(exactFileNameMatcher.getFileName(), type);
        } else {
            this.myMatchingMappings.add(Pair.create((Object)matcher, type));
        }
    }

    boolean removeAssociation(@NotNull FileNameMatcher matcher, @NotNull T type) {
        if (matcher == null) {
            FileTypeAssocTable.$$$reportNull$$$0(8);
        }
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(9);
        }
        if (matcher instanceof ExtensionFileNameMatcher) {
            String extension = ((ExtensionFileNameMatcher)matcher).getExtension();
            if (this.myExtensionMappings.get(extension) == type) {
                this.myExtensionMappings.remove(extension);
                return true;
            }
            return false;
        }
        if (matcher instanceof ExactFileNameMatcher) {
            Map<CharSequence, T> mapToUse;
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            String fileName = exactFileNameMatcher.getFileName();
            Map<CharSequence, T> map = mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            if (mapToUse.get(fileName) == type) {
                mapToUse.remove(fileName);
                return true;
            }
            return false;
        }
        return this.myMatchingMappings.removeIf(assoc -> matcher.equals(assoc.getFirst()));
    }

    boolean removeAllAssociations(@NotNull T type) {
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(10);
        }
        boolean changed = this.removeAssociationsFromMap(this.myExtensionMappings, type, false);
        changed = this.removeAssociationsFromMap(this.myExactFileNameAnyCaseMappings, type, changed);
        changed = this.removeAssociationsFromMap(this.myExactFileNameMappings, type, changed);
        return this.myMatchingMappings.removeIf(assoc -> assoc.getSecond() == type);
    }

    private boolean removeAssociationsFromMap(@NotNull Map<CharSequence, T> extensionMappings, @NotNull T type, boolean changed) {
        if (extensionMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(11);
        }
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(12);
        }
        return extensionMappings.entrySet().removeIf(entry -> entry.getValue() == type) || changed;
    }

    @Nullable
    public T findAssociatedFileType(@NotNull @NonNls CharSequence fileName) {
        T t;
        if (fileName == null) {
            FileTypeAssocTable.$$$reportNull$$$0(13);
        }
        if (!this.myExactFileNameMappings.isEmpty() && (t = this.myExactFileNameMappings.get(fileName)) != null) {
            return t;
        }
        if (!this.myExactFileNameAnyCaseMappings.isEmpty() && (t = this.myExactFileNameAnyCaseMappings.get(fileName)) != null) {
            return t;
        }
        for (int i = 0; i < this.myMatchingMappings.size(); ++i) {
            Pair<FileNameMatcher, T> mapping = this.myMatchingMappings.get(i);
            if (!((FileNameMatcher)mapping.getFirst()).acceptsCharSequence(fileName)) continue;
            return (T)mapping.getSecond();
        }
        return this.findByExtension(FileUtilRt.getExtension((CharSequence)fileName));
    }

    @Nullable
    T findAssociatedFileType(@NotNull FileNameMatcher matcher) {
        if (matcher == null) {
            FileTypeAssocTable.$$$reportNull$$$0(14);
        }
        if (matcher instanceof ExtensionFileNameMatcher) {
            return this.findByExtension(((ExtensionFileNameMatcher)matcher).getExtension());
        }
        if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            Map<CharSequence, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            return mapToUse.get(exactFileNameMatcher.getFileName());
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst())) continue;
            return (T)mapping.getSecond();
        }
        return null;
    }

    T findByExtension(@NotNull CharSequence extension) {
        if (extension == null) {
            FileTypeAssocTable.$$$reportNull$$$0(15);
        }
        return this.myExtensionMappings.get(extension);
    }

    @Deprecated
    String @NotNull [] getAssociatedExtensions(@NotNull T type) {
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(16);
        }
        ArrayList<String> exts = new ArrayList<String>();
        for (Map.Entry<CharSequence, T> entry : this.myExtensionMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            exts.add(entry.getKey().toString());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(exts);
        if (stringArray == null) {
            FileTypeAssocTable.$$$reportNull$$$0(17);
        }
        return stringArray;
    }

    @NotNull
    public FileTypeAssocTable<T> copy() {
        return new FileTypeAssocTable<T>(this.myExtensionMappings, this.myExactFileNameMappings, this.myExactFileNameAnyCaseMappings, this.myMatchingMappings);
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull T type) {
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(18);
        }
        ArrayList<FileNameMatcher> result = new ArrayList<FileNameMatcher>();
        for (Pair<FileNameMatcher, T> pair : this.myMatchingMappings) {
            if (pair.getSecond() != type) continue;
            result.add((FileNameMatcher)pair.getFirst());
        }
        for (Map.Entry entry : this.myExactFileNameMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExactFileNameMatcher(((CharSequence)entry.getKey()).toString(), false));
        }
        for (Map.Entry entry : this.myExactFileNameAnyCaseMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExactFileNameMatcher(((CharSequence)entry.getKey()).toString(), true));
        }
        for (Map.Entry entry : this.myExtensionMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExtensionFileNameMatcher(((CharSequence)entry.getKey()).toString()));
        }
        ArrayList<FileNameMatcher> arrayList = result;
        if (arrayList == null) {
            FileTypeAssocTable.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    boolean hasAssociationsFor(@NotNull T fileType) {
        if (fileType == null) {
            FileTypeAssocTable.$$$reportNull$$$0(20);
        }
        if (this.myExtensionMappings.containsValue(fileType) || this.myExactFileNameMappings.containsValue(fileType) || this.myExactFileNameAnyCaseMappings.containsValue(fileType)) {
            return true;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (mapping.getSecond() != fileType) continue;
            return true;
        }
        return false;
    }

    @NotNull
    Map<FileNameMatcher, T> getRemovedMappings(@NotNull FileTypeAssocTable<T> newTable, @NotNull Collection<? extends T> keys) {
        if (newTable == null) {
            FileTypeAssocTable.$$$reportNull$$$0(21);
        }
        if (keys == null) {
            FileTypeAssocTable.$$$reportNull$$$0(22);
        }
        HashMap<FileNameMatcher, T> map = new HashMap<FileNameMatcher, T>();
        for (T key : keys) {
            List<FileNameMatcher> associations = this.getAssociations(key);
            associations.removeAll(newTable.getAssociations(key));
            for (FileNameMatcher matcher : associations) {
                map.put(matcher, key);
            }
        }
        HashMap<FileNameMatcher, T> hashMap = map;
        if (hashMap == null) {
            FileTypeAssocTable.$$$reportNull$$$0(23);
        }
        return hashMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTypeAssocTable that = (FileTypeAssocTable)o;
        return this.myExtensionMappings.equals(that.myExtensionMappings) && this.myMatchingMappings.equals(that.myMatchingMappings) && this.myExactFileNameMappings.equals(that.myExactFileNameMappings) && this.myExactFileNameAnyCaseMappings.equals(that.myExactFileNameAnyCaseMappings);
    }

    public int hashCode() {
        int result = this.myExtensionMappings.hashCode();
        result = 31 * result + this.myMatchingMappings.hashCode();
        result = 31 * result + this.myExactFileNameMappings.hashCode();
        result = 31 * result + this.myExactFileNameAnyCaseMappings.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 19: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 19: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionMappings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exactFileNameMappings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exactFileNameAnyCaseMappings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingMappings";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTable";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedExtensions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociations";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemovedMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAssociatedWith";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAssociation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeAllAssociations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociationsFromMap";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findAssociatedFileType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findByExtension";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedExtensions";
                break;
            }
            case 17: 
            case 19: 
            case 23: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAssociations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasAssociationsFor";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRemovedMappings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 19: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

