/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaSdkUtil {
    @NotNull
    public static List<File> getJdkClassesRoots(@NotNull File home, boolean isJre) {
        File classesDir;
        Object toolsJar;
        File[] jarDirs;
        if (home == null) {
            JavaSdkUtil.$$$reportNull$$$0(0);
        }
        if (SystemInfo.isMac && !home.getName().startsWith("mockJDK")) {
            File libEndorsedDir;
            File libExtDir;
            File classesDir2;
            File libDir;
            File openJdkRtJar = new File(home, "jre/lib/rt.jar");
            if (openJdkRtJar.isFile()) {
                libDir = new File(home, "lib");
                classesDir2 = openJdkRtJar.getParentFile();
                libExtDir = new File(openJdkRtJar.getParentFile(), "ext");
                libEndorsedDir = new File(libDir, "endorsed");
                jarDirs = new File[]{libEndorsedDir, libDir, classesDir2, libExtDir};
            } else {
                libDir = new File(home, "lib");
                classesDir2 = new File(home, "../Classes");
                libExtDir = new File(libDir, "ext");
                libEndorsedDir = new File(libDir, "endorsed");
                jarDirs = new File[]{libEndorsedDir, libDir, classesDir2, libExtDir};
            }
        } else if (new File(home, "lib/jrt-fs.jar").exists()) {
            jarDirs = ArrayUtilRt.EMPTY_FILE_ARRAY;
        } else {
            File libDir = new File(home, isJre ? "lib" : "jre/lib");
            File libExtDir = new File(libDir, "ext");
            File libEndorsedDir = new File(libDir, "endorsed");
            jarDirs = new File[]{libEndorsedDir, libDir, libExtDir};
        }
        FileFilter jarFileFilter = FileFilters.filesWithExtension((String)"jar");
        THashSet pathFilter = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        ArrayList<File> rootFiles = new ArrayList<File>();
        if (Registry.is((String)"project.structure.add.tools.jar.to.new.jdk", (boolean)false) && ((File)(toolsJar = new File(home, "lib/tools.jar"))).isFile()) {
            rootFiles.add((File)toolsJar);
        }
        for (File jarDir : jarDirs) {
            File[] jarFiles;
            if (jarDir == null || !jarDir.isDirectory()) continue;
            File[] fileArray = jarFiles = JavaSdkUtil.listFiles(jarDir, jarFileFilter);
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                String canonicalPath;
                File jarFile = fileArray[i];
                String jarFileName = jarFile.getName();
                if (jarFileName.equals("alt-rt.jar") || jarFileName.equals("alt-string.jar") || (canonicalPath = JavaSdkUtil.getCanonicalPath(jarFile)) == null || !pathFilter.add(canonicalPath)) continue;
                rootFiles.add(jarFile);
            }
        }
        ArrayList ibmJdkLookupDirs = ContainerUtil.newArrayList((Object[])new File[]{new File(home, isJre ? "bin" : "jre/bin")});
        ContainerUtil.addAll((Collection)ibmJdkLookupDirs, (Object[])JavaSdkUtil.listFiles(new File(home, isJre ? "lib" : "jre/lib"), FileUtilRt.ALL_DIRECTORIES));
        for (File candidate : ibmJdkLookupDirs) {
            File[] vmJarDirs;
            for (File dir : vmJarDirs = JavaSdkUtil.listFiles(new File(candidate, "default"), f -> f.getName().startsWith("jclSC") && f.isDirectory())) {
                File vmJar = new File(dir, "vm.jar");
                if (!vmJar.isFile()) continue;
                rootFiles.add(vmJar);
            }
        }
        File classesZip = new File(home, "lib/classes.zip");
        if (classesZip.isFile()) {
            rootFiles.add(classesZip);
        }
        if (rootFiles.isEmpty() && (classesDir = new File(home, "classes")).isDirectory()) {
            rootFiles.add(classesDir);
        }
        ArrayList<File> arrayList = rootFiles;
        if (arrayList == null) {
            JavaSdkUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static File[] listFiles(File dir, FileFilter filter) {
        return (File[])ObjectUtils.notNull((Object)dir.listFiles(filter), (Object)ArrayUtilRt.EMPTY_FILE_ARRAY);
    }

    @Nullable
    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/java/impl/JavaSdkUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/java/impl/JavaSdkUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkClassesRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJdkClassesRoots";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

