/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.execution.CommandLineUtil;
import com.intellij.externalSystem.JavaModuleData;
import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.tooling.model.idea.IdeaJavaLanguageSettings;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingConfig;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingModel;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.data.AnnotationProcessingData;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class JavaGradleProjectResolver
extends AbstractProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(JavaGradleProjectResolver.class);

    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        if (gradleProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(0);
        }
        if (ideProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(1);
        }
        String compileOutputPath = this.getCompileOutputPath();
        IdeaJavaLanguageSettings languageSettings = gradleProject.getJavaLanguageSettings();
        LanguageLevel languageLevel = JavaGradleProjectResolver.getLanguageLevel(languageSettings, false);
        String targetBytecodeVersion = JavaGradleProjectResolver.getTargetBytecodeVersion(languageSettings);
        JavaSdkVersion jdkVersion = JavaProjectData.resolveSdkVersion((String)gradleProject.getJdkName());
        JavaProjectData javaProjectData = new JavaProjectData(GradleConstants.SYSTEM_ID, compileOutputPath, jdkVersion, languageLevel, targetBytecodeVersion);
        ideProject.createChild(JavaProjectData.KEY, (Object)javaProjectData);
        this.nextResolver.populateProjectExtraModels(gradleProject, ideProject);
    }

    @NotNull
    private String getCompileOutputPath() {
        String projectDirPath = this.resolverCtx.getProjectPath();
        String string = projectDirPath + "/build/classes";
        if (string == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(3);
        }
        if (ideModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(4);
        }
        this.populateBuildScriptClasspathData(gradleModule, ideModule);
        this.populateAnnotationProcessorData(gradleModule, ideModule);
        this.populateDependenciesGraphData(gradleModule, ideModule);
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    private void populateAnnotationProcessorData(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        AnnotationProcessingModel apModel;
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(5);
        }
        if (ideModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(6);
        }
        if ((apModel = (AnnotationProcessingModel)this.resolverCtx.getExtraProject(gradleModule, AnnotationProcessingModel.class)) == null) {
            return;
        }
        if (!this.resolverCtx.isResolveModulePerSourceSet()) {
            AnnotationProcessingData apData = JavaGradleProjectResolver.getMergedAnnotationProcessingData(apModel);
            DataNode dataNode = ideModule.createChild(AnnotationProcessingData.KEY, (Object)apData);
            JavaGradleProjectResolver.populateAnnotationProcessingOutput((DataNode<AnnotationProcessingData>)dataNode, apModel);
        } else {
            Collection all = ExternalSystemApiUtil.findAll(ideModule, (Key)GradleSourceSetData.KEY);
            for (DataNode node : all) {
                AnnotationProcessingData apData = JavaGradleProjectResolver.getAnnotationProcessingData(apModel, ((GradleSourceSetData)node.getData()).getModuleName());
                if (apData == null) continue;
                DataNode dataNode = node.createChild(AnnotationProcessingData.KEY, (Object)apData);
                JavaGradleProjectResolver.populateAnnotationProcessorOutput((DataNode<AnnotationProcessingData>)dataNode, apModel, ((GradleSourceSetData)node.getData()).getModuleName());
            }
        }
    }

    private static void populateAnnotationProcessorOutput(@NotNull DataNode<AnnotationProcessingData> parent, @NotNull AnnotationProcessingModel apModel, @NotNull String sourceSetName) {
        AnnotationProcessingConfig config;
        if (parent == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(7);
        }
        if (apModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(8);
        }
        if (sourceSetName == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(9);
        }
        if ((config = apModel.bySourceSetName(sourceSetName)) != null && config.getProcessorOutput() != null) {
            parent.createChild(AnnotationProcessingData.OUTPUT_KEY, (Object)new AnnotationProcessingData.AnnotationProcessorOutput(config.getProcessorOutput(), config.isTestSources()));
        }
    }

    private static void populateAnnotationProcessingOutput(@NotNull DataNode<AnnotationProcessingData> parent, @NotNull AnnotationProcessingModel apModel) {
        if (parent == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(10);
        }
        if (apModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(11);
        }
        for (AnnotationProcessingConfig config : apModel.allConfigs().values()) {
            if (config.getProcessorOutput() == null) continue;
            parent.createChild(AnnotationProcessingData.OUTPUT_KEY, (Object)new AnnotationProcessingData.AnnotationProcessorOutput(config.getProcessorOutput(), config.isTestSources()));
        }
    }

    @NotNull
    private static AnnotationProcessingData getMergedAnnotationProcessingData(@NotNull AnnotationProcessingModel apModel) {
        if (apModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(12);
        }
        LinkedHashSet<String> mergedAnnotationProcessorPath = new LinkedHashSet<String>();
        for (AnnotationProcessingConfig config : apModel.allConfigs().values()) {
            mergedAnnotationProcessorPath.addAll(config.getAnnotationProcessorPath());
        }
        ArrayList<String> apArguments = new ArrayList<String>();
        AnnotationProcessingConfig mainConfig = apModel.bySourceSetName("main");
        if (mainConfig != null) {
            apArguments.addAll(mainConfig.getAnnotationProcessorArguments());
        }
        AnnotationProcessingData annotationProcessingData = AnnotationProcessingData.create(mergedAnnotationProcessorPath, apArguments);
        if (annotationProcessingData == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(13);
        }
        return annotationProcessingData;
    }

    @Nullable
    private static AnnotationProcessingData getAnnotationProcessingData(@NotNull AnnotationProcessingModel apModel, @NotNull String sourceSetName) {
        AnnotationProcessingConfig config;
        if (apModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(14);
        }
        if (sourceSetName == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(15);
        }
        if ((config = apModel.bySourceSetName(sourceSetName)) == null) {
            return null;
        }
        return AnnotationProcessingData.create(config.getAnnotationProcessorPath(), config.getAnnotationProcessorArguments());
    }

    private void populateBuildScriptClasspathData(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        BuildScriptClasspathModel buildScriptClasspathModel;
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(16);
        }
        if (ideModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(17);
        }
        List classpathEntries = (buildScriptClasspathModel = (BuildScriptClasspathModel)this.resolverCtx.getExtraProject(gradleModule, BuildScriptClasspathModel.class)) != null ? ContainerUtil.map((Collection)buildScriptClasspathModel.getClasspath(), model -> BuildScriptClasspathData.ClasspathEntry.create((Set)model.getClasses(), (Set)model.getSources(), (Set)model.getJavadoc())) : ContainerUtil.emptyList();
        BuildScriptClasspathData buildScriptClasspathData = new BuildScriptClasspathData(GradleConstants.SYSTEM_ID, classpathEntries);
        buildScriptClasspathData.setGradleHomeDir(buildScriptClasspathModel != null ? buildScriptClasspathModel.getGradleHomeDir() : null);
        ideModule.createChild(BuildScriptClasspathData.KEY, (Object)buildScriptClasspathData);
    }

    private void populateDependenciesGraphData(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ProjectDependencies projectDependencies;
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(18);
        }
        if (ideModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(19);
        }
        if ((projectDependencies = (ProjectDependencies)this.resolverCtx.getExtraProject(gradleModule, ProjectDependencies.class)) != null) {
            ideModule.createChild(ProjectKeys.DEPENDENCIES_GRAPH, (Object)projectDependencies);
        }
    }

    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @NotNull Consumer<String> initScriptConsumer, @NotNull Map<String, String> parameters) {
        String testExecutionExpected;
        if (taskNames == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(20);
        }
        if (initScriptConsumer == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(21);
        }
        if (parameters == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(22);
        }
        if (Boolean.valueOf(testExecutionExpected = parameters.get("TEST_EXECUTION_EXPECTED")).booleanValue()) {
            try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/org/jetbrains/plugins/gradle/java/addTestListener.groovy");){
                String addTestListenerScript = StreamUtil.readText((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                initScriptConsumer.consume((Object)addTestListenerScript);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        String jvmParametersSetup = parameters.get("JVM_PARAMETERS_SETUP");
        this.enhanceTaskProcessing(taskNames, jvmParametersSetup, initScriptConsumer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadTestEventListenerDefinition() {
        try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/org/jetbrains/plugins/gradle/IJTestLogger.groovy");){
            String string = StreamUtil.readText((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return "";
        }
    }

    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull Consumer<String> initScriptConsumer) {
        if (taskNames == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(23);
        }
        if (initScriptConsumer == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(24);
        }
        if (!StringUtil.isEmpty((String)jvmParametersSetup)) {
            LOG.assertTrue(!jvmParametersSetup.contains("-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address="), (Object)"Please use org.jetbrains.plugins.gradle.service.debugger.GradleJvmDebuggerBackend to setup debugger");
            String names = "[" + JavaGradleProjectResolver.toStringListLiteral(taskNames, ", ") + "]";
            List argv = ParametersListUtil.parse((String)jvmParametersSetup);
            if (SystemInfo.isWindows) {
                argv = ContainerUtil.map((Collection)argv, s -> CommandLineUtil.escapeParameterOnWindows((String)s, (boolean)false));
            }
            String jvmArgs = JavaGradleProjectResolver.toStringListLiteral(argv, " << ");
            String[] lines = new String[]{"gradle.taskGraph.beforeTask { Task task ->", "    if (task instanceof JavaForkOptions && (" + names + ".contains(task.name) || " + names + ".contains(task.path))) {", "        def jvmArgs = task.jvmArgs.findAll{!it?.startsWith('-agentlib:jdwp') && !it?.startsWith('-Xrunjdwp')}", "        jvmArgs << " + jvmArgs, "        task.jvmArgs = jvmArgs", "    }", "}"};
            String script = StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator());
            initScriptConsumer.consume((Object)script);
        }
        String testEventListenerDefinition = this.loadTestEventListenerDefinition();
        initScriptConsumer.consume((Object)testEventListenerDefinition);
    }

    @NotNull
    private static String toStringListLiteral(@NotNull List<String> strings, @NotNull String separator) {
        if (strings == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(25);
        }
        if (separator == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(26);
        }
        List quotedStrings = ContainerUtil.map(strings, s -> JavaGradleProjectResolver.toStringLiteral(s));
        String string = StringUtil.join((Collection)quotedStrings, (String)separator);
        if (string == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private static String toStringLiteral(@NotNull String s) {
        if (s == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(28);
        }
        String string = StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeStringCharacters((String)s));
        if (string == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        Set set = ContainerUtil.set((Object[])new Class[]{AnnotationProcessingModel.class, ProjectDependencies.class});
        if (set == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(30);
        }
        return set;
    }

    @Nullable
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        DataNode moduleNode;
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(31);
        }
        if (projectDataNode == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(32);
        }
        if ((moduleNode = super.createModule(gradleModule, projectDataNode)) == null) {
            return null;
        }
        ExternalProject externalProject = (ExternalProject)this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject == null) {
            return moduleNode;
        }
        if (this.resolverCtx.isResolveModulePerSourceSet()) {
            Map<ExternalSourceSet, DataNode<GradleSourceSetData>> sourceSets = this.findSourceSets(gradleModule, externalProject, (DataNode<ModuleData>)moduleNode);
            for (Map.Entry<ExternalSourceSet, DataNode<GradleSourceSetData>> entry : sourceSets.entrySet()) {
                JavaModuleData moduleData = JavaGradleProjectResolver.createSourceSetModuleData(gradleModule, entry.getKey());
                entry.getValue().createChild(JavaModuleData.KEY, (Object)moduleData);
            }
        }
        JavaModuleData moduleData = JavaGradleProjectResolver.createMainModuleData(gradleModule, externalProject);
        moduleNode.createChild(JavaModuleData.KEY, (Object)moduleData);
        return moduleNode;
    }

    @NotNull
    private static JavaModuleData createMainModuleData(@NotNull IdeaModule ideaModule, @NotNull ExternalProject externalProject) {
        String targetBytecodeVersion;
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(33);
        }
        if (externalProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(34);
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        LanguageLevel languageLevel = JavaGradleProjectResolver.getLanguageLevel(externalProject, false);
        if (languageLevel == null) {
            languageLevel = JavaGradleProjectResolver.getLanguageLevel(javaLanguageSettings, false);
        }
        if ((targetBytecodeVersion = externalProject.getTargetCompatibility()) == null) {
            targetBytecodeVersion = JavaGradleProjectResolver.getTargetBytecodeVersion(javaLanguageSettings);
        }
        return new JavaModuleData(GradleConstants.SYSTEM_ID, languageLevel, targetBytecodeVersion);
    }

    @NotNull
    private static JavaModuleData createSourceSetModuleData(@NotNull IdeaModule ideaModule, @NotNull ExternalSourceSet sourceSet) {
        String targetBytecodeVersion;
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(35);
        }
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(36);
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        LanguageLevel languageLevel = JavaGradleProjectResolver.getLanguageLevel(sourceSet);
        if (languageLevel == null) {
            languageLevel = JavaGradleProjectResolver.getLanguageLevel(javaLanguageSettings, sourceSet.isPreview());
        }
        if ((targetBytecodeVersion = sourceSet.getTargetCompatibility()) == null) {
            targetBytecodeVersion = JavaGradleProjectResolver.getTargetBytecodeVersion(javaLanguageSettings);
        }
        return new JavaModuleData(GradleConstants.SYSTEM_ID, languageLevel, targetBytecodeVersion);
    }

    @NotNull
    private Map<ExternalSourceSet, DataNode<GradleSourceSetData>> findSourceSets(@NotNull IdeaModule ideaModule, @NotNull ExternalProject externalProject, @NotNull DataNode<ModuleData> moduleNode) {
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(37);
        }
        if (externalProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(38);
        }
        if (moduleNode == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(39);
        }
        Collection sourceSetNodes = ExternalSystemApiUtil.getChildren(moduleNode, (Key)GradleSourceSetData.KEY);
        LinkedHashMap<String, DataNode> sourceSetIndex = new LinkedHashMap<String, DataNode>();
        for (DataNode sourceSetNode : sourceSetNodes) {
            sourceSetIndex.put(((GradleSourceSetData)sourceSetNode.getData()).getId(), sourceSetNode);
        }
        LinkedHashMap<ExternalSourceSet, DataNode<GradleSourceSetData>> result = new LinkedHashMap<ExternalSourceSet, DataNode<GradleSourceSetData>>();
        for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
            String moduleId = GradleProjectResolverUtil.getModuleId((ProjectResolverContext)this.resolverCtx, (IdeaModule)ideaModule, (ExternalSourceSet)sourceSet);
            DataNode sourceSetNode = (DataNode)sourceSetIndex.get(moduleId);
            if (sourceSetNode == null) continue;
            result.put(sourceSet, (DataNode<GradleSourceSetData>)sourceSetNode);
        }
        LinkedHashMap<ExternalSourceSet, DataNode<GradleSourceSetData>> linkedHashMap = result;
        if (linkedHashMap == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(40);
        }
        return linkedHashMap;
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@NotNull ExternalSourceSet sourceSet) {
        String sourceCompatibility;
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(41);
        }
        if ((sourceCompatibility = sourceSet.getSourceCompatibility()) == null) {
            return null;
        }
        return JavaGradleProjectResolver.parseLanguageLevel(sourceCompatibility, sourceSet.isPreview());
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@NotNull ExternalProject externalProject, boolean isPreview) {
        String sourceCompatibility;
        if (externalProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(42);
        }
        if ((sourceCompatibility = externalProject.getSourceCompatibility()) == null) {
            return null;
        }
        return JavaGradleProjectResolver.parseLanguageLevel(sourceCompatibility, isPreview);
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@Nullable IdeaJavaLanguageSettings languageSettings, boolean isPreview) {
        if (languageSettings == null) {
            return null;
        }
        JavaVersion languageLevel = languageSettings.getLanguageLevel();
        if (languageLevel == null) {
            return null;
        }
        return JavaGradleProjectResolver.parseLanguageLevel(languageLevel.toString(), isPreview);
    }

    @Nullable
    private static LanguageLevel parseLanguageLevel(@NotNull String languageLevelString, boolean isPreview) {
        LanguageLevel languageLevel;
        if (languageLevelString == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(43);
        }
        if ((languageLevel = LanguageLevel.parse((String)languageLevelString)) == null) {
            return null;
        }
        return JavaGradleProjectResolver.setPreview(languageLevel, isPreview);
    }

    @NotNull
    private static LanguageLevel setPreview(@NotNull LanguageLevel languageLevel, boolean isPreview) {
        if (languageLevel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(44);
        }
        if (languageLevel.isPreview() == isPreview) {
            LanguageLevel languageLevel2 = languageLevel;
            if (languageLevel2 == null) {
                JavaGradleProjectResolver.$$$reportNull$$$0(45);
            }
            return languageLevel2;
        }
        com.intellij.util.lang.JavaVersion javaVersion = languageLevel.toJavaVersion();
        LanguageLevel languageLevel3 = Arrays.stream(LanguageLevel.values()).filter(it -> it.isPreview() == isPreview).filter(it -> it.toJavaVersion().equals((Object)javaVersion)).findFirst().orElse(languageLevel);
        if (languageLevel3 == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(46);
        }
        return languageLevel3;
    }

    @Nullable
    private static String getTargetBytecodeVersion(@Nullable IdeaJavaLanguageSettings languageSettings) {
        if (languageSettings == null) {
            return null;
        }
        JavaVersion targetByteCodeVersion = languageSettings.getTargetBytecodeVersion();
        if (targetByteCodeVersion == null) {
            return null;
        }
        return targetByteCodeVersion.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 13: 
            case 27: 
            case 29: 
            case 30: 
            case 40: 
            case 45: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 13: 
            case 27: 
            case 29: 
            case 30: 
            case 40: 
            case 45: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 2: 
            case 13: 
            case 27: 
            case 29: 
            case 30: 
            case 40: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/JavaGradleProjectResolver";
                break;
            }
            case 3: 
            case 5: 
            case 16: 
            case 18: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apModel";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetName";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScriptConsumer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaModule";
                break;
            }
            case 34: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProject";
                break;
            }
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNode";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevelString";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/JavaGradleProjectResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompileOutputPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedAnnotationProcessingData";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringListLiteral";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringLiteral";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceSets";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "setPreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "populateProjectExtraModels";
                break;
            }
            case 2: 
            case 13: 
            case 27: 
            case 29: 
            case 30: 
            case 40: 
            case 45: 
            case 46: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleExtraModels";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "populateAnnotationProcessorData";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "populateAnnotationProcessorOutput";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "populateAnnotationProcessingOutput";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMergedAnnotationProcessingData";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationProcessingData";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "populateBuildScriptClasspathData";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "populateDependenciesGraphData";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "enhanceTaskProcessing";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "toStringListLiteral";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteral";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createMainModuleData";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createSourceSetModuleData";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findSourceSets";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "parseLanguageLevel";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setPreview";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 13: 
            case 27: 
            case 29: 
            case 30: 
            case 40: 
            case 45: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

