/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.SaveSessionBaseKt;
import com.intellij.configurationStore.StateGetter;
import com.intellij.configurationStore.StorageBaseEx;
import com.intellij.configurationStore.XmlElementStorageKt;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.JdomKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B?\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0001\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010\u0014\u001a\u0004\u0018\u00018\u00002\b\u0010\u0015\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/configurationStore/StateGetterImpl;", "S", "", "T", "Lcom/intellij/configurationStore/StateGetter;", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "componentName", "", "storageData", "stateClass", "Ljava/lang/Class;", "storage", "Lcom/intellij/configurationStore/StorageBaseEx;", "(Lcom/intellij/openapi/components/PersistentStateComponent;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;Lcom/intellij/configurationStore/StorageBaseEx;)V", "serializedState", "Lorg/jdom/Element;", "Ljava/lang/Object;", "archiveState", "()Ljava/lang/Object;", "getState", "mergeInto", "(Ljava/lang/Object;)Ljava/lang/Object;", "intellij.platform.configurationStore.impl"})
final class StateGetterImpl<S, T>
implements StateGetter<S> {
    private Element serializedState;
    private final PersistentStateComponent<S> component;
    private final String componentName;
    private final T storageData;
    private final Class<S> stateClass;
    private final StorageBaseEx<T> storage;

    @Override
    @Nullable
    public S getState(@Nullable S mergeInto) {
        ComponentStoreImplKt.getLOG().assertTrue(this.serializedState == null);
        this.serializedState = this.storage.getSerializedState(this.storageData, this.component, this.componentName, false);
        return (S)this.storage.deserializeState(this.serializedState, this.stateClass, mergeInto);
    }

    @Override
    @Nullable
    public S archiveState() {
        Element serializedStateAfterLoad;
        Object stateAfterLoad;
        block10: {
            Object object;
            StringBuilder stringBuilder;
            Logger logger;
            block12: {
                block11: {
                    Element it;
                    boolean bl;
                    boolean bl2;
                    Element element;
                    Object object2;
                    Object object3;
                    if (this.serializedState == null) {
                        return null;
                    }
                    try {
                        object3 = this.component.getState();
                    }
                    catch (ProcessCanceledException e) {
                        throw (Throwable)e;
                    }
                    catch (Throwable e) {
                        PluginException.logPluginError((Logger)ComponentStoreImplKt.getLOG(), (String)"Cannot get state after load", (Throwable)e, this.component.getClass());
                        object3 = null;
                    }
                    stateAfterLoad = object3;
                    if (stateAfterLoad == null) {
                        object2 = this.serializedState;
                    } else {
                        Element element2 = SaveSessionBaseKt.serializeState(stateAfterLoad);
                        element = element2 != null ? XmlElementStorageKt.normalizeRootName(element2) : null;
                        bl2 = false;
                        bl = false;
                        it = element;
                        boolean bl3 = false;
                        object2 = JdomKt.isEmpty((Element)it) ? null : it;
                    }
                    serializedStateAfterLoad = object2;
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    if (!application.isUnitTestMode() || !(Intrinsics.areEqual((Object)this.serializedState, (Object)serializedStateAfterLoad) ^ true) || serializedStateAfterLoad != null && JDOMUtil.areElementsEqual((Element)this.serializedState, (Element)serializedStateAfterLoad)) break block10;
                    logger = ComponentStoreImplKt.getLOG();
                    StringBuilder stringBuilder2 = new StringBuilder().append(this.componentName).append(" (from ").append(this.component.getClass().getName()).append(") state changed after load. \nOld: ");
                    Element element3 = this.serializedState;
                    if (element3 == null) {
                        Intrinsics.throwNpe();
                    }
                    stringBuilder = stringBuilder2.append(JDOMUtil.writeElement((Element)element3)).append("\n\nNew: ");
                    object = serializedStateAfterLoad;
                    if (object == null) break block11;
                    element = object;
                    StringBuilder stringBuilder3 = stringBuilder;
                    Logger logger2 = logger;
                    bl2 = false;
                    bl = false;
                    it = element;
                    boolean bl4 = false;
                    String string = JDOMUtil.writeElement((Element)it);
                    logger = logger2;
                    stringBuilder = stringBuilder3;
                    object = string;
                    if (object != null) break block12;
                }
                object = "null";
            }
            logger.debug(stringBuilder.append((String)object).append('\n').toString());
        }
        this.storage.archiveState(this.storageData, this.componentName, serializedStateAfterLoad);
        return (S)stateAfterLoad;
    }

    public StateGetterImpl(@NotNull PersistentStateComponent<S> component, @NotNull String componentName, @NotNull T storageData, @NotNull Class<S> stateClass, @NotNull StorageBaseEx<T> storage2) {
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull(storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull(stateClass, (String)"stateClass");
        Intrinsics.checkParameterIsNotNull(storage2, (String)"storage");
        this.component = component;
        this.componentName = componentName;
        this.storageData = storageData;
        this.stateClass = stateClass;
        this.storage = storage2;
    }
}

