/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.font.LineMetrics;
import sun.font.FontLineMetrics;

public final class CoreMetrics {
    public final float ascent;
    public final float descent;
    public final float leading;
    public final float height;
    public final int baselineIndex;
    public final float[] baselineOffsets;
    public final float strikethroughOffset;
    public final float strikethroughThickness;
    public final float underlineOffset;
    public final float underlineThickness;
    public final float ssOffset;
    public final float italicAngle;

    public CoreMetrics(float f, float f2, float f3, float f4, int n, float[] fArray, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.ascent = f;
        this.descent = f2;
        this.leading = f3;
        this.height = f4;
        this.baselineIndex = n;
        this.baselineOffsets = fArray;
        this.strikethroughOffset = f5;
        this.strikethroughThickness = f6;
        this.underlineOffset = f7;
        this.underlineThickness = f8;
        this.ssOffset = f9;
        this.italicAngle = f10;
    }

    public static CoreMetrics get(LineMetrics lineMetrics) {
        return ((FontLineMetrics)lineMetrics).cm;
    }

    public final int hashCode() {
        return Float.floatToIntBits(this.ascent + this.ssOffset);
    }

    public final boolean equals(Object object) {
        try {
            return this.equals((CoreMetrics)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public final boolean equals(CoreMetrics coreMetrics) {
        if (coreMetrics != null) {
            if (this == coreMetrics) {
                return true;
            }
            return this.ascent == coreMetrics.ascent && this.descent == coreMetrics.descent && this.leading == coreMetrics.leading && this.baselineIndex == coreMetrics.baselineIndex && this.baselineOffsets[0] == coreMetrics.baselineOffsets[0] && this.baselineOffsets[1] == coreMetrics.baselineOffsets[1] && this.baselineOffsets[2] == coreMetrics.baselineOffsets[2] && this.strikethroughOffset == coreMetrics.strikethroughOffset && this.strikethroughThickness == coreMetrics.strikethroughThickness && this.underlineOffset == coreMetrics.underlineOffset && this.underlineThickness == coreMetrics.underlineThickness && this.ssOffset == coreMetrics.ssOffset && this.italicAngle == coreMetrics.italicAngle;
        }
        return false;
    }

    public final float effectiveBaselineOffset(float[] fArray) {
        switch (this.baselineIndex) {
            case -1: {
                return fArray[4] + this.ascent;
            }
            case -2: {
                return fArray[3] - this.descent;
            }
        }
        return fArray[this.baselineIndex];
    }
}

