/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.DuplicateProjectException;
import org.apache.maven.InternalErrorException;
import org.apache.maven.Maven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.ProjectCycleException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.graph.GraphBuilder;
import org.apache.maven.internal.aether.DefaultRepositorySystemSessionFactory;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.LifecycleStarter;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.Result;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.repository.LocalRepositoryNotAccessibleException;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.util.repository.ChainedWorkspaceReader;

@Component(role=Maven.class)
public class DefaultMaven
implements Maven {
    @Requirement
    private Logger logger;
    @Requirement
    protected ProjectBuilder projectBuilder;
    @Requirement
    private LifecycleStarter lifecycleStarter;
    @Requirement
    protected PlexusContainer container;
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private SessionScope sessionScope;
    @Requirement
    private DefaultRepositorySystemSessionFactory repositorySessionFactory;
    @Requirement(hint="graphBuilder")
    private GraphBuilder graphBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MavenExecutionResult execute(MavenExecutionRequest request) {
        MavenExecutionResult result;
        try {
            result = this.doExecute(request);
        }
        catch (OutOfMemoryError e) {
            result = this.addExceptionToResult(new DefaultMavenExecutionResult(), e);
        }
        catch (RuntimeException e) {
            result = e.getCause() instanceof ProjectCycleException ? this.addExceptionToResult(new DefaultMavenExecutionResult(), e.getCause()) : this.addExceptionToResult(new DefaultMavenExecutionResult(), new InternalErrorException("Internal error: " + e, e));
        }
        finally {
            this.legacySupport.setSession(null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenExecutionResult doExecute(MavenExecutionRequest request) {
        request.setStartTime(new Date());
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        try {
            this.validateLocalRepository(request);
        }
        catch (LocalRepositoryNotAccessibleException e) {
            return this.addExceptionToResult(result, e);
        }
        this.sessionScope.enter();
        try {
            DefaultRepositorySystemSession repoSession = (DefaultRepositorySystemSession)this.newRepositorySession(request);
            MavenSession session = new MavenSession(this.container, (RepositorySystemSession)repoSession, request, result);
            this.sessionScope.seed(MavenSession.class, session);
            this.legacySupport.setSession(session);
            MavenExecutionResult mavenExecutionResult = this.doExecute(request, session, result, repoSession);
            return mavenExecutionResult;
        }
        finally {
            this.sessionScope.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenExecutionResult doExecute(MavenExecutionRequest request, MavenSession session, MavenExecutionResult result, DefaultRepositorySystemSession repoSession) {
        WorkspaceReader reactorWorkspace;
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(Collections.emptyList())) {
                listener.afterSessionStart(session);
            }
        }
        catch (MavenExecutionException e) {
            return this.addExceptionToResult(result, e);
        }
        this.eventCatapult.fire(ExecutionEvent.Type.ProjectDiscoveryStarted, session, null);
        Result<? extends ProjectDependencyGraph> graphResult = this.buildGraph(session, result);
        if (graphResult.hasErrors()) {
            return this.addExceptionToResult(result, ((ModelProblem)graphResult.getProblems().iterator().next()).getException());
        }
        try {
            session.setProjectMap(this.getProjectMap(session.getProjects()));
        }
        catch (DuplicateProjectException e) {
            return this.addExceptionToResult(result, e);
        }
        try {
            reactorWorkspace = (WorkspaceReader)this.container.lookup(WorkspaceReader.class, "reactor");
        }
        catch (ComponentLookupException e) {
            return this.addExceptionToResult(result, e);
        }
        repoSession.setWorkspaceReader(ChainedWorkspaceReader.newInstance((WorkspaceReader)reactorWorkspace, (WorkspaceReader)repoSession.getWorkspaceReader()));
        repoSession.setReadOnly();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(session.getProjects())) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                listener.afterProjectsRead(session);
            }
        }
        catch (MavenExecutionException e) {
            MavenExecutionResult listener = this.addExceptionToResult(result, e);
            return listener;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        graphResult = this.buildGraph(session, result);
        if (graphResult.hasErrors()) {
            return this.addExceptionToResult(result, ((ModelProblem)graphResult.getProblems().iterator().next()).getException());
        }
        try {
            MavenExecutionResult e;
            if (result.hasExceptions()) {
                e = result;
                return e;
            }
            result.setTopologicallySortedProjects(session.getProjects());
            result.setProject(session.getTopLevelProject());
            this.validatePrerequisitesForNonMavenPluginProjects(session.getProjects());
            this.lifecycleStarter.execute(session);
            this.validateActivatedProfiles(session.getProjects(), request.getActiveProfiles());
            if (session.getResult().hasExceptions()) {
                e = this.addExceptionToResult(result, session.getResult().getExceptions().get(0));
                return e;
            }
        }
        finally {
            try {
                this.afterSessionEnd(session.getProjects(), session);
            }
            catch (MavenExecutionException e) {
                return this.addExceptionToResult(result, e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterSessionEnd(Collection<MavenProject> projects, MavenSession session) throws MavenExecutionException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(projects)) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                listener.afterSessionEnd(session);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public RepositorySystemSession newRepositorySession(MavenExecutionRequest request) {
        return this.repositorySessionFactory.newRepositorySession(request);
    }

    private void validateLocalRepository(MavenExecutionRequest request) throws LocalRepositoryNotAccessibleException {
        File localRepoDir = request.getLocalRepositoryPath();
        this.logger.debug("Using local repository at " + localRepoDir);
        localRepoDir.mkdirs();
        if (!localRepoDir.isDirectory()) {
            throw new LocalRepositoryNotAccessibleException("Could not create local repository at " + localRepoDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                lifecycleListeners.addAll(this.container.lookupList(AbstractMavenLifecycleParticipant.class));
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Failed to lookup lifecycle participants: " + e.getMessage());
            }
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                try {
                    lifecycleListeners.addAll(this.container.lookupList(AbstractMavenLifecycleParticipant.class));
                }
                catch (ComponentLookupException e) {
                    this.logger.warn("Failed to lookup lifecycle participants: " + e.getMessage());
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    private MavenExecutionResult addExceptionToResult(MavenExecutionResult result, Throwable e) {
        if (!result.getExceptions().contains(e)) {
            result.addException(e);
        }
        return result;
    }

    private void validatePrerequisitesForNonMavenPluginProjects(List<MavenProject> projects) {
        for (MavenProject mavenProject : projects) {
            Prerequisites prerequisites;
            if ("maven-plugin".equals(mavenProject.getPackaging()) || (prerequisites = mavenProject.getPrerequisites()) == null || prerequisites.getMaven() == null) continue;
            this.logger.warn("The project " + mavenProject.getId() + " uses prerequisites" + " which is only intended for maven-plugin projects " + "but not for non maven-plugin projects. " + "For such purposes you should use the maven-enforcer-plugin. " + "See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
        }
    }

    private void validateActivatedProfiles(List<MavenProject> projects, List<String> activeProfileIds) {
        LinkedHashSet<String> notActivatedProfileIds = new LinkedHashSet<String>(activeProfileIds);
        for (MavenProject project : projects) {
            for (List<String> profileIds : project.getInjectedProfileIds().values()) {
                notActivatedProfileIds.removeAll(profileIds);
            }
        }
        for (String notActivatedProfileId : notActivatedProfileIds) {
            this.logger.warn("The requested profile \"" + notActivatedProfileId + "\" could not be activated because it does not exist.");
        }
    }

    private Map<String, MavenProject> getProjectMap(Collection<MavenProject> projects) throws DuplicateProjectException {
        LinkedHashMap<String, MavenProject> index = new LinkedHashMap<String, MavenProject>();
        LinkedHashMap<String, List<File>> collisions = new LinkedHashMap<String, List<File>>();
        for (MavenProject project : projects) {
            String projectId = ArtifactUtils.key((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion());
            MavenProject collision = (MavenProject)index.get(projectId);
            if (collision == null) {
                index.put(projectId, project);
                continue;
            }
            ArrayList<File> pomFiles = (ArrayList<File>)collisions.get(projectId);
            if (pomFiles == null) {
                pomFiles = new ArrayList<File>(Arrays.asList(collision.getFile(), project.getFile()));
                collisions.put(projectId, pomFiles);
                continue;
            }
            pomFiles.add(project.getFile());
        }
        if (!collisions.isEmpty()) {
            throw new DuplicateProjectException("Two or more projects in the reactor have the same identifier, please make sure that <groupId>:<artifactId>:<version> is unique for each project: " + collisions, collisions);
        }
        return index;
    }

    private Result<? extends ProjectDependencyGraph> buildGraph(MavenSession session, MavenExecutionResult result) {
        Result<? extends ProjectDependencyGraph> graphResult = this.graphBuilder.build(session);
        for (ModelProblem problem : graphResult.getProblems()) {
            if (problem.getSeverity() == ModelProblem.Severity.WARNING) {
                this.logger.warn(problem.toString());
                continue;
            }
            this.logger.error(problem.toString());
        }
        if (!graphResult.hasErrors()) {
            ProjectDependencyGraph projectDependencyGraph = (ProjectDependencyGraph)graphResult.get();
            session.setProjects(projectDependencyGraph.getSortedProjects());
            session.setAllProjects(projectDependencyGraph.getAllProjects());
            session.setProjectDependencyGraph(projectDependencyGraph);
        }
        return graphResult;
    }

    @Deprecated
    protected Logger getLogger() {
        return this.logger;
    }
}

