/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.diagnostic;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.device.attribute.AttributeDefinition;
import onl.netfishers.netshot.diagnostic.DiagnosticBinaryResult;
import onl.netfishers.netshot.diagnostic.DiagnosticLongTextResult;
import onl.netfishers.netshot.diagnostic.DiagnosticNumericResult;
import onl.netfishers.netshot.diagnostic.DiagnosticResult;
import onl.netfishers.netshot.diagnostic.DiagnosticTextResult;
import onl.netfishers.netshot.diagnostic.JavaScriptDiagnostic;
import onl.netfishers.netshot.diagnostic.SimpleDiagnostic;
import org.hibernate.annotations.NaturalId;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, include=JsonTypeInfo.As.PROPERTY, property="type")
public abstract class Diagnostic {
    private static final Set<Class<? extends Diagnostic>> DIAGNOSTIC_CLASSES = new HashSet<Class<? extends Diagnostic>>();
    private long id;
    private String name;
    private DeviceGroup targetGroup;
    protected boolean enabled = false;
    protected AttributeDefinition.AttributeType resultType;
    List<DiagnosticResult> results = new ArrayList<DiagnosticResult>();

    public static final Set<Class<? extends Diagnostic>> getDiagnosticClasses() {
        return DIAGNOSTIC_CLASSES;
    }

    protected Diagnostic() {
    }

    public Diagnostic(String name, boolean enabled, DeviceGroup targetGroup, AttributeDefinition.AttributeType resultType) {
        this.name = name;
        this.enabled = enabled;
        this.targetGroup = targetGroup;
        this.resultType = resultType;
    }

    @Id
    @GeneratedValue
    @XmlElement
    public long getId() {
        return this.id;
    }

    @NaturalId(mutable=true)
    @XmlElement
    public String getName() {
        return this.name;
    }

    @XmlElement
    public AttributeDefinition.AttributeType getResultType() {
        return this.resultType;
    }

    @ManyToOne
    @XmlElement
    public DeviceGroup getTargetGroup() {
        return this.targetGroup;
    }

    @XmlElement
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResultType(AttributeDefinition.AttributeType resultType) {
        this.resultType = resultType;
    }

    public void setTargetGroup(DeviceGroup targetGroup) {
        this.targetGroup = targetGroup;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="diagnostic", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    public List<DiagnosticResult> getResults() {
        return this.results;
    }

    public void setResults(List<DiagnosticResult> results) {
        this.results = results;
    }

    @Transient
    public void addResultToDevice(Device device, String value) {
        switch (this.resultType) {
            case LONGTEXT: {
                device.addDiagnosticResult(new DiagnosticLongTextResult(device, this, value));
                break;
            }
            case TEXT: {
                device.addDiagnosticResult(new DiagnosticTextResult(device, this, value));
                break;
            }
            case NUMERIC: {
                device.addDiagnosticResult(new DiagnosticNumericResult(device, this, value));
                break;
            }
            case BINARY: {
                device.addDiagnosticResult(new DiagnosticBinaryResult(device, this, value));
                break;
            }
        }
    }

    @Transient
    public abstract Object getJsObject(Device var1, ScriptEngine var2, ScriptContext var3) throws ScriptException;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Diagnostic)) {
            return false;
        }
        Diagnostic other = (Diagnostic)obj;
        return this.id == other.id;
    }

    static {
        DIAGNOSTIC_CLASSES.add(SimpleDiagnostic.class);
        DIAGNOSTIC_CLASSES.add(JavaScriptDiagnostic.class);
    }
}

