/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.diagnostic;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Date;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.diagnostic.Diagnostic;
import onl.netfishers.netshot.diagnostic.DiagnosticBinaryResult;
import onl.netfishers.netshot.diagnostic.DiagnosticLongTextResult;
import onl.netfishers.netshot.diagnostic.DiagnosticNumericResult;
import onl.netfishers.netshot.diagnostic.DiagnosticTextResult;
import org.hibernate.annotations.FilterDef;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.CHAR)
@DiscriminatorValue(value="A")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DiagnosticNumericResult.class, name="NUMERIC"), @JsonSubTypes.Type(value=DiagnosticTextResult.class, name="TEXT"), @JsonSubTypes.Type(value=DiagnosticLongTextResult.class, name="LONGTEXT"), @JsonSubTypes.Type(value=DiagnosticBinaryResult.class, name="BINARY")})
@FilterDef(name="lightAttributesOnly", defaultCondition="type <> 'T'")
public abstract class DiagnosticResult {
    protected long id;
    private Date creationDate = new Date();
    private Date lastCheckDate = new Date();
    private Diagnostic diagnostic;
    private Device device;

    protected DiagnosticResult() {
    }

    public DiagnosticResult(Device device, Diagnostic diagnostic) {
        this.device = device;
        this.diagnostic = diagnostic;
    }

    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public void setDiagnostic(Diagnostic diagnostic) {
        this.diagnostic = diagnostic;
    }

    @XmlElement
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @XmlElement
    public Date getLastCheckDate() {
        return this.lastCheckDate;
    }

    public void setLastCheckDate(Date lastCheckDate) {
        this.lastCheckDate = lastCheckDate;
    }

    @ManyToOne
    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    @Transient
    public abstract String getAsText();

    @Transient
    public abstract Object getData();

    @Transient
    @XmlElement
    public String getDiagnosticName() {
        return this.getDiagnostic().getName();
    }
}

