/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.TaskManager;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DynamicDeviceGroup;
import onl.netfishers.netshot.device.script.CliScript;
import onl.netfishers.netshot.device.script.RunDiagnosticCliScript;
import onl.netfishers.netshot.work.DebugLog;
import onl.netfishers.netshot.work.Task;
import onl.netfishers.netshot.work.tasks.CheckComplianceTask;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class RunDiagnosticsTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(RunDiagnosticsTask.class);
    private static Set<Long> runningDiagnostics = ConcurrentHashMap.newKeySet();
    private Device device;
    private boolean dontCheckCompliance = false;

    public static boolean checkRunningDiagnostic(Long deviceId) {
        return runningDiagnostics.add(deviceId);
    }

    public static void clearRunningDiagnostic(Long deviceId) {
        runningDiagnostics.remove(deviceId);
    }

    protected RunDiagnosticsTask() {
    }

    public RunDiagnosticsTask(Device device, String comments, String author, boolean dontCheckCompliance) {
        super(comments, device.getLastConfig() == null ? device.getMgmtAddress().getIp() : device.getName(), author);
        this.device = device;
        this.dontCheckCompliance = dontCheckCompliance;
    }

    @Override
    public void prepare() {
        Hibernate.initialize(this.device);
        Hibernate.initialize(this.device.getDiagnosticResults());
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Device diagnostics";
    }

    @ManyToOne(fetch=FetchType.LAZY)
    protected Device getDevice() {
        return this.device;
    }

    @XmlElement
    @Transient
    protected long getDeviceId() {
        return this.device.getId();
    }

    protected void setDevice(Device device) {
        this.device = device;
    }

    public boolean isDontCheckCompliance() {
        return this.dontCheckCompliance;
    }

    public void setDontCheckCompliance(boolean dontCheckCompliance) {
        this.dontCheckCompliance = dontCheckCompliance;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RunDiagnosticsTask task = (RunDiagnosticsTask)super.clone();
        task.setDevice(this.device);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("Starting diagnostic task for device {}.", (Object)this.device.getId());
        this.trace(String.format("Run diagnostic task for device %s (%s).", this.device.getName(), this.device.getMgmtAddress().getIp()));
        boolean locked = false;
        CliScript cliScript = null;
        Session session = Database.getSession();
        try {
            session.beginTransaction();
            session.refresh(this.device);
            if (this.device.getStatus() != Device.Status.INPRODUCTION) {
                logger.trace("Device not INPRODUCTION, stopping the diagnostic task.");
                this.warn("The device is not enabled (not in production).");
                this.status = Task.Status.FAILURE;
                return;
            }
            locked = RunDiagnosticsTask.checkRunningDiagnostic(this.device.getId());
            if (!locked) {
                logger.trace("A Diagnostic task already ongoing for this device, cancelling.");
                this.warn("A diagnostic task is already running for this device, cancelling this task.");
                this.status = Task.Status.CANCELLED;
                return;
            }
            List diagnostics = session.createQuery("select distinct dg from Device d left join d.ownerGroups g left join g.diagnostics dg where d = :device and dg.enabled = :enabled").setEntity("device", (Object)this.device).setBoolean("enabled", true).list();
            if (diagnostics.size() > 0) {
                cliScript = new RunDiagnosticCliScript(diagnostics, this.debugEnabled);
                cliScript.connectRun(session, this.device);
                this.log.append(cliScript.getPlainJsLog());
                session.update(this.device);
                session.getTransaction().commit();
            }
            this.status = Task.Status.SUCCESS;
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            logger.error("Error while executing the diagnostics.", e);
            this.error("Error while executing the diagnostics: " + e.getMessage());
            if (cliScript != null) {
                this.log.append(cliScript.getPlainJsLog());
            }
            this.status = Task.Status.FAILURE;
            return;
        }
        finally {
            try {
                if (this.debugEnabled) {
                    this.debugLog = new DebugLog(cliScript.getPlainCliLog());
                }
            }
            catch (Exception e1) {
                logger.error("Error while saving the debug logs.", e1);
            }
            session.close();
            if (locked) {
                RunDiagnosticsTask.clearRunningDiagnostic(this.device.getId());
            }
        }
        logger.debug("Request to refresh all the groups for the device after the diagnostics.");
        DynamicDeviceGroup.refreshAllGroups(this.device);
        if (!this.dontCheckCompliance) {
            try {
                CheckComplianceTask checkTask = new CheckComplianceTask(this.device, "Check compliance after device diagnostics.", "Auto");
                TaskManager.addTask(checkTask);
            }
            catch (Exception e) {
                logger.error("Error while registering the new task.", e);
            }
        }
    }

    @Override
    @Transient
    public JobKey getIdentity() {
        return new JobKey(String.format("Task_%d", this.getId()), String.format("RunDevice_%d", this.getDevice().getId()));
    }
}

