/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.TaskManager;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.work.Task;
import onl.netfishers.netshot.work.tasks.RunDiagnosticsTask;
import org.hibernate.Hibernate;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class RunGroupDiagnosticsTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(RunGroupDiagnosticsTask.class);
    private DeviceGroup deviceGroup;
    private boolean dontCheckCompliance = false;

    public RunGroupDiagnosticsTask() {
    }

    public RunGroupDiagnosticsTask(DeviceGroup group, String comments, String author, boolean dontCheckCompliance) {
        super(comments, group.getName(), author);
        this.deviceGroup = group;
        this.dontCheckCompliance = dontCheckCompliance;
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Group diagnostics";
    }

    @Override
    public void prepare() {
        Hibernate.initialize(this.getDeviceGroup());
        Hibernate.initialize(this.getDeviceGroup().getCachedDevices());
    }

    @Override
    public void run() {
        logger.debug("Starting diagnostics task for group {}.", (Object)this.getDeviceGroup().getId());
        Set<Device> devices = this.getDeviceGroup().getCachedDevices();
        logger.debug("{} devices in the group.", (Object)devices.size());
        String comment = String.format("Started due to group %s diagnotics", this.getDeviceGroup().getName());
        for (Device device : devices) {
            this.info(String.format("Scheduling diagnostics task for device %s.", device.getName()));
            RunDiagnosticsTask task = new RunDiagnosticsTask(device, comment, this.author, this.dontCheckCompliance);
            try {
                TaskManager.addTask(task);
            }
            catch (Exception e) {
                logger.error("Error while scheduling the individual diagnostics task.", e);
                this.error("Error while scheduling the task.");
            }
        }
        logger.debug("Everything went fine.");
        this.status = Task.Status.SUCCESS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public DeviceGroup getDeviceGroup() {
        return this.deviceGroup;
    }

    public void setDeviceGroup(DeviceGroup deviceGroup) {
        this.deviceGroup = deviceGroup;
    }

    public boolean isDontCheckCompliance() {
        return this.dontCheckCompliance;
    }

    public void setDontCheckCompliance(boolean dontCheckCompliance) {
        this.dontCheckCompliance = dontCheckCompliance;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RunGroupDiagnosticsTask task = (RunGroupDiagnosticsTask)super.clone();
        task.setDeviceGroup(this.deviceGroup);
        return task;
    }

    @Override
    @Transient
    public JobKey getIdentity() {
        return new JobKey(String.format("Task_%d", this.getId()), String.format("RunGroupDiagnosticsTask_%d", this.getDeviceGroup().getId()));
    }
}

