/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.Collection;
import java.util.HashMap;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.type.Type;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.logging.Logger;

public class FilterDefBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, FilterDefBinder.class.getName());

    public static void bind(AnnotationBindingContext bindingContext) {
        Collection annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.FILTER_DEF);
        for (AnnotationInstance filterDef : annotations) {
            FilterDefBinder.bind(bindingContext.getMetadataImplementor(), filterDef);
        }
        annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.FILTER_DEFS);
        for (AnnotationInstance filterDefs : annotations) {
            AnnotationInstance[] filterDefAnnotations;
            for (AnnotationInstance filterDef : filterDefAnnotations = JandexHelper.getValue(filterDefs, "value", AnnotationInstance[].class)) {
                FilterDefBinder.bind(bindingContext.getMetadataImplementor(), filterDef);
            }
        }
    }

    private static void bind(MetadataImplementor metadata, AnnotationInstance filterDef) {
        String name = JandexHelper.getValue(filterDef, "name", String.class);
        HashMap<String, Type> prms = new HashMap<String, Type>();
        for (AnnotationInstance prm : JandexHelper.getValue(filterDef, "parameters", AnnotationInstance[].class)) {
            prms.put(JandexHelper.getValue(prm, "name", String.class), metadata.getTypeResolver().heuristicType(JandexHelper.getValue(prm, "type", String.class)));
        }
        metadata.addFilterDefinition(new FilterDefinition(name, JandexHelper.getValue(filterDef, "defaultCondition", String.class), prms));
        LOG.debugf("Binding filter definition: %s", (Object)name);
    }

    private FilterDefBinder() {
    }
}

