/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf) / dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => dvec4(1.0lf, 1.0lf, 1.0lf, 1.0lf)
 * (dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf) / dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => dvec4(-0.4848484848484849lf, -0.11278195488721804lf, -0.26424870466321243lf, 0.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf) / dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), dvec4(1.0lf, 1.0lf, 1.0lf, 1.0lf)) <= 2e-05lf ? 1 : -1] array0;
  double[distance((dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf) / dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), dvec4(-0.4848484848484849lf, -0.11278195488721804lf, -0.26424870466321243lf, 0.0lf)) <= 5.635824700292227e-06lf ? 1 : -1] array1;
  gl_Position = vec4(array0.length() + array1.length());
}
