/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.util.NodeList;
import groovy.util.NodePrinter;
import groovy.xml.QName;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;

public class Node
implements Serializable {
    private static final long serialVersionUID = 4121134753270542643L;
    private Node parent;
    private Object name;
    private Map attributes;
    private Object value;

    public Node(Node parent, Object name) {
        this(parent, name, Collections.EMPTY_MAP, Collections.EMPTY_LIST);
    }

    public Node(Node parent, Object name, Object value) {
        this(parent, name, Collections.EMPTY_MAP, value);
    }

    public Node(Node parent, Object name, Map attributes) {
        this(parent, name, attributes, Collections.EMPTY_LIST);
    }

    public Node(Node parent, Object name, Map attributes, Object value) {
        this.parent = parent;
        this.name = name;
        this.attributes = attributes;
        this.value = value;
        if (parent != null) {
            List parentList;
            Object parentValue = parent.value();
            if (parentValue instanceof List) {
                parentList = (List)parentValue;
            } else {
                parentList = new NodeList();
                parentList.add(parentValue);
                parent.setValue(parentList);
            }
            parentList.add(this);
        }
    }

    public String text() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value instanceof Collection) {
            Collection coll = (Collection)this.value;
            String previousText = null;
            StringBuffer buffer = null;
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Object child = iter.next();
                if (!(child instanceof String)) continue;
                String childText = (String)child;
                if (previousText == null) {
                    previousText = childText;
                    continue;
                }
                if (buffer == null) {
                    buffer = new StringBuffer();
                    buffer.append(previousText);
                }
                buffer.append(childText);
            }
            if (buffer != null) {
                return buffer.toString();
            }
            if (previousText != null) {
                return previousText;
            }
        }
        return "";
    }

    public Iterator iterator() {
        return this.children().iterator();
    }

    public List children() {
        if (this.value == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.value instanceof List) {
            return (List)this.value;
        }
        return Collections.singletonList(this.value);
    }

    public Map attributes() {
        return this.attributes;
    }

    public Object attribute(Object key) {
        return this.attributes != null ? this.attributes.get(key) : null;
    }

    public Object name() {
        return this.name;
    }

    public Object value() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Node parent() {
        return this.parent;
    }

    public Object get(String key) {
        if (key != null && key.charAt(0) == '@') {
            String attributeName = key.substring(1);
            return this.attributes().get(attributeName);
        }
        if ("..".equals(key)) {
            return this.parent();
        }
        if ("*".equals(key)) {
            return this.children();
        }
        if ("**".equals(key)) {
            return this.depthFirst();
        }
        NodeList answer = new NodeList();
        Iterator iter = this.children().iterator();
        while (iter.hasNext()) {
            Node childNode;
            Object childNodeName;
            Object child = iter.next();
            if (!(child instanceof Node) || (childNodeName = (childNode = (Node)child).name()) == null || !childNodeName.equals(key)) continue;
            answer.add(childNode);
        }
        return answer;
    }

    public NodeList getAt(QName name) {
        NodeList answer = new NodeList();
        Iterator iter = this.children().iterator();
        while (iter.hasNext()) {
            Node childNode;
            Object childNodeName;
            Object child = iter.next();
            if (!(child instanceof Node) || (childNodeName = (childNode = (Node)child).name()) == null || !childNodeName.equals(name)) continue;
            answer.add(childNode);
        }
        return answer;
    }

    public List depthFirst() {
        NodeList answer = new NodeList();
        answer.add(this);
        answer.addAll(this.depthFirstRest());
        return answer;
    }

    private List depthFirstRest() {
        NodeList answer = new NodeList();
        Iterator iter = InvokerHelper.asIterator(this.value);
        while (iter.hasNext()) {
            Object child = iter.next();
            if (!(child instanceof Node)) continue;
            Node childNode = (Node)child;
            List children = childNode.depthFirstRest();
            answer.add(childNode);
            answer.addAll(children);
        }
        return answer;
    }

    public List breadthFirst() {
        NodeList answer = new NodeList();
        answer.add(this);
        answer.addAll(this.breadthFirstRest());
        return answer;
    }

    private List breadthFirstRest() {
        NodeList answer = new NodeList();
        List nextLevelChildren = this.getDirectChildren();
        while (!nextLevelChildren.isEmpty()) {
            NodeList working = new NodeList((Collection)nextLevelChildren);
            nextLevelChildren = new NodeList();
            Iterator iter = working.iterator();
            while (iter.hasNext()) {
                Node childNode = (Node)iter.next();
                answer.add(childNode);
                List children = childNode.getDirectChildren();
                nextLevelChildren.addAll(children);
            }
        }
        return answer;
    }

    private List getDirectChildren() {
        NodeList answer = new NodeList();
        Iterator iter = InvokerHelper.asIterator(this.value);
        while (iter.hasNext()) {
            Object child = iter.next();
            if (!(child instanceof Node)) continue;
            Node childNode = (Node)child;
            answer.add(childNode);
        }
        return answer;
    }

    public String toString() {
        return this.name + "[attributes=" + this.attributes + "; value=" + this.value + "]";
    }

    public void print(PrintWriter out) {
        new NodePrinter(out).print(this);
    }
}

