/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;

public class AggregateProjectMergeRule
extends RelOptRule {
    public static final AggregateProjectMergeRule INSTANCE = new AggregateProjectMergeRule(Aggregate.class, Project.class, RelFactories.LOGICAL_BUILDER);

    public AggregateProjectMergeRule(Class<? extends Aggregate> aggregateClass, Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory) {
        super(AggregateProjectMergeRule.operand(aggregateClass, AggregateProjectMergeRule.operand(projectClass, AggregateProjectMergeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project;
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelNode x = AggregateProjectMergeRule.apply(call, aggregate, project = (Project)call.rel(1));
        if (x != null) {
            call.transformTo(x);
        }
    }

    public static RelNode apply(RelOptRuleCall call, Aggregate aggregate, Project project) {
        TreeSet<Integer> interestingFields = new TreeSet<Integer>();
        interestingFields.addAll(aggregate.getGroupSet().asList());
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            interestingFields.addAll(aggregateCall.getArgList());
            if (aggregateCall.filterArg >= 0) {
                interestingFields.add(aggregateCall.filterArg);
            }
            interestingFields.addAll(RelCollations.ordinals(aggregateCall.collation));
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        Iterator iterator = interestingFields.iterator();
        while (iterator.hasNext()) {
            int source = (Integer)iterator.next();
            RexNode rex = project.getProjects().get(source);
            if (!(rex instanceof RexInputRef)) {
                return null;
            }
            map.put(source, ((RexInputRef)rex).getIndex());
        }
        ImmutableBitSet immutableBitSet = aggregate.getGroupSet().permute(map);
        ImmutableList newGroupingSets = null;
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            newGroupingSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute(aggregate.getGroupSets(), map));
        }
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        int sourceCount = aggregate.getInput().getRowType().getFieldCount();
        int targetCount = project.getInput().getRowType().getFieldCount();
        Mappings.TargetMapping targetMapping = Mappings.target(map, sourceCount, targetCount);
        for (AggregateCall aggregateCall3 : aggregate.getAggCallList()) {
            aggCalls.add((Object)aggregateCall3.transform(targetMapping));
        }
        Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet(), project.getInput(), aggregate.indicator, immutableBitSet, (List<ImmutableBitSet>)newGroupingSets, (List<AggregateCall>)aggCalls.build());
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newAggregate);
        List newKeys = Lists.transform(aggregate.getGroupSet().asList(), map::get);
        if (!newKeys.equals(immutableBitSet.asList())) {
            int newKey;
            ArrayList<Integer> posList = new ArrayList<Integer>();
            Iterator iterator2 = newKeys.iterator();
            while (iterator2.hasNext()) {
                newKey = (Integer)iterator2.next();
                posList.add(immutableBitSet.indexOf(newKey));
            }
            if (aggregate.indicator) {
                iterator2 = newKeys.iterator();
                while (iterator2.hasNext()) {
                    newKey = (Integer)iterator2.next();
                    posList.add(aggregate.getGroupCount() + immutableBitSet.indexOf(newKey));
                }
            }
            for (int i = newAggregate.getGroupCount() + newAggregate.getIndicatorCount(); i < newAggregate.getRowType().getFieldCount(); ++i) {
                posList.add(i);
            }
            relBuilder.project((Iterable<? extends RexNode>)relBuilder.fields((List<? extends Number>)posList));
        }
        return relBuilder.build();
    }
}

