/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.common.EnumFieldValue;
import org.apache.solr.common.SolrException;
import org.apache.solr.legacy.LegacyFieldType;
import org.apache.solr.legacy.LegacyIntField;
import org.apache.solr.legacy.LegacyNumericRangeQuery;
import org.apache.solr.legacy.LegacyNumericType;
import org.apache.solr.legacy.LegacyNumericUtils;
import org.apache.solr.schema.AbstractEnumField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class EnumField
extends AbstractEnumField {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final int DEFAULT_PRECISION_STEP = Integer.MAX_VALUE;

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return UninvertingReader.Type.SORTED_SET_INTEGER;
        }
        return UninvertingReader.Type.LEGACY_INTEGER;
    }

    @Override
    protected Query getSpecializedRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        boolean matchOnly;
        Integer minValue = this.enumMapping.stringValueToIntValue(min);
        Integer maxValue = this.enumMapping.stringValueToIntValue(max);
        if (field.multiValued() && field.hasDocValues() && !field.indexed()) {
            return super.getSpecializedRangeQuery(parser, field, minValue.toString(), maxValue.toString(), minInclusive, maxInclusive);
        }
        ConstantScoreQuery query = null;
        boolean bl = matchOnly = field.hasDocValues() && !field.indexed();
        if (matchOnly) {
            long lowerValue = Long.MIN_VALUE;
            long upperValue = Long.MAX_VALUE;
            if (minValue != null) {
                lowerValue = minValue.longValue();
                if (!minInclusive) {
                    ++lowerValue;
                }
            }
            if (maxValue != null) {
                upperValue = maxValue.longValue();
                if (!maxInclusive) {
                    --upperValue;
                }
            }
            query = new ConstantScoreQuery(NumericDocValuesField.newSlowRangeQuery((String)field.getName(), (long)lowerValue, (long)upperValue));
        } else {
            query = LegacyNumericRangeQuery.newIntRange(field.getName(), Integer.MAX_VALUE, min == null ? null : minValue, max == null ? null : maxValue, minInclusive, maxInclusive);
        }
        return query;
    }

    @Override
    public void readableToIndexed(CharSequence val, BytesRefBuilder result) {
        String s = val.toString();
        if (s == null) {
            return;
        }
        Integer intValue = this.enumMapping.stringValueToIntValue(s);
        LegacyNumericUtils.intToPrefixCoded(intValue, 0, result);
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        if (indexedForm == null) {
            return null;
        }
        BytesRef bytesRef = new BytesRef((CharSequence)indexedForm);
        Integer intValue = LegacyNumericUtils.prefixCodedToInt(bytesRef);
        return this.enumMapping.intValueToStringValue(intValue);
    }

    @Override
    public CharsRef indexedToReadable(BytesRef input, CharsRefBuilder output) {
        Integer intValue = LegacyNumericUtils.prefixCodedToInt(input);
        String stringValue = this.enumMapping.intValueToStringValue(intValue);
        output.grow(stringValue.length());
        output.setLength(stringValue.length());
        stringValue.getChars(0, output.length(), output.chars(), 0);
        return output.get();
    }

    public EnumFieldValue toObject(SchemaField sf, BytesRef term) {
        Integer intValue = LegacyNumericUtils.prefixCodedToInt(term);
        String stringValue = this.enumMapping.intValueToStringValue(intValue);
        return new EnumFieldValue(intValue, stringValue);
    }

    @Override
    public String storedToIndexed(IndexableField f) {
        Number val = f.numericValue();
        if (val == null) {
            return null;
        }
        BytesRefBuilder bytes = new BytesRefBuilder();
        LegacyNumericUtils.intToPrefixCoded(val.intValue(), 0, bytes);
        return bytes.get().utf8ToString();
    }

    @Override
    public IndexableField createField(SchemaField field, Object value) {
        boolean indexed = field.indexed();
        boolean stored = field.stored();
        boolean docValues = field.hasDocValues();
        if (!(indexed || stored || docValues)) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: " + field);
            }
            return null;
        }
        Integer intValue = this.enumMapping.stringValueToIntValue(value.toString());
        if (intValue == null || intValue.equals(AbstractEnumField.EnumMapping.DEFAULT_VALUE)) {
            String exceptionMessage = String.format(Locale.ENGLISH, "Unknown value for enum field: %s, value: %s", field.getName(), value.toString());
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, exceptionMessage);
        }
        LegacyFieldType newType = new LegacyFieldType();
        newType.setTokenized(field.isTokenized());
        newType.setStored(field.stored());
        newType.setOmitNorms(field.omitNorms());
        newType.setIndexOptions(field.indexOptions());
        newType.setStoreTermVectors(field.storeTermVector());
        newType.setStoreTermVectorOffsets(field.storeTermOffsets());
        newType.setStoreTermVectorPositions(field.storeTermPositions());
        newType.setStoreTermVectorPayloads(field.storeTermPayloads());
        newType.setNumericType(LegacyNumericType.INT);
        newType.setNumericPrecisionStep(Integer.MAX_VALUE);
        return new LegacyIntField(field.getName(), (int)intValue, newType);
    }

    @Override
    public List<IndexableField> createFields(SchemaField sf, Object value) {
        if (sf.hasDocValues()) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            IndexableField field = this.createField(sf, value);
            fields.add(field);
            if (sf.multiValued()) {
                BytesRefBuilder bytes = new BytesRefBuilder();
                this.readableToIndexed(this.enumMapping.stringValueToIntValue(value.toString()).toString(), bytes);
                fields.add((IndexableField)new SortedSetDocValuesField(sf.getName(), bytes.toBytesRef()));
            } else {
                long bits = field.numericValue().intValue();
                fields.add((IndexableField)new NumericDocValuesField(sf.getName(), bits));
            }
            return fields;
        }
        return Collections.singletonList(this.createField(sf, value));
    }
}

