/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.solr.common.SpecProvider;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.AuthorizationResponse;
import org.apache.solr.security.AutorizationEditOperation;
import org.apache.solr.security.ConfigEditablePlugin;
import org.apache.solr.security.Permission;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedAuthorizationPlugin
implements AuthorizationPlugin,
ConfigEditablePlugin,
SpecProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, Set<String>> usersVsRoles = new HashMap<String, Set<String>>();
    private final Map<String, WildCardSupportMap> mapping = new HashMap<String, WildCardSupportMap>();
    private final List<Permission> permissions = new ArrayList<Permission>();
    private static final Map<String, AutorizationEditOperation> ops = Collections.unmodifiableMap(Arrays.asList(AutorizationEditOperation.values()).stream().collect(Collectors.toMap(AutorizationEditOperation::getOperationName, Function.identity())));

    @Override
    public AuthorizationResponse authorize(AuthorizationContext context) {
        List<AuthorizationContext.CollectionRequest> collectionRequests = context.getCollectionRequests();
        log.debug("Attempting to authorize request to [{}] of type: [{}], associated with collections [{}]", new Object[]{context.getResource(), context.getRequestType(), collectionRequests});
        if (context.getRequestType() == AuthorizationContext.RequestType.ADMIN) {
            log.debug("Authorizing an ADMIN request, checking admin permissions");
            MatchStatus flag = this.checkCollPerm(this.mapping.get(null), context);
            return flag.rsp;
        }
        for (AuthorizationContext.CollectionRequest collreq : collectionRequests) {
            log.debug("Authorizing collection-aware request, checking perms applicable to specific collection [{}]", (Object)collreq.collectionName);
            MatchStatus flag = this.checkCollPerm(this.mapping.get(collreq.collectionName), context);
            if (flag == MatchStatus.NO_PERMISSIONS_FOUND) continue;
            return flag.rsp;
        }
        log.debug("Authorizing collection-aware request, checking perms applicable to all (*) collections");
        Object flag = this.checkCollPerm(this.mapping.get("*"), context);
        return ((MatchStatus)((Object)flag)).rsp;
    }

    private MatchStatus checkCollPerm(Map<String, List<Permission>> pathVsPerms, AuthorizationContext context) {
        String path;
        MatchStatus flag;
        if (pathVsPerms == null) {
            return MatchStatus.NO_PERMISSIONS_FOUND;
        }
        if (log.isTraceEnabled()) {
            log.trace("Following perms are associated with collection");
            for (String pathKey : pathVsPerms.keySet()) {
                List<Permission> permsAssociatedWithPath = pathVsPerms.get(pathKey);
                log.trace("Path: [{}], Perms: [{}]", (Object)pathKey, permsAssociatedWithPath);
            }
        }
        if ((flag = this.checkPathPerm(pathVsPerms.get(path = context.getResource()), context)) != MatchStatus.NO_PERMISSIONS_FOUND) {
            return flag;
        }
        return this.checkPathPerm(pathVsPerms.get(null), context);
    }

    private MatchStatus checkPathPerm(List<Permission> permissions, AuthorizationContext context) {
        if (permissions == null || permissions.isEmpty()) {
            return MatchStatus.NO_PERMISSIONS_FOUND;
        }
        Principal principal = context.getUserPrincipal();
        log.trace("Following perms are associated with this collection and path: [{}]", permissions);
        Permission governingPermission = this.findFirstGoverningPermission(permissions, context);
        if (governingPermission == null) {
            log.debug("No perms configured for the resource {} . So allowed to access", (Object)context.getResource());
            return MatchStatus.NO_PERMISSIONS_FOUND;
        }
        log.debug("Found perm [{}] to govern resource [{}]", (Object)governingPermission, (Object)context.getResource());
        return this.determineIfPermissionPermitsPrincipal(principal, governingPermission);
    }

    private Permission findFirstGoverningPermission(List<Permission> permissions, AuthorizationContext context) {
        for (int i = 0; i < permissions.size(); ++i) {
            Permission permission = permissions.get(i);
            if (!this.permissionAppliesToRequest(permission, context)) continue;
            return permission;
        }
        return null;
    }

    private boolean permissionAppliesToRequest(Permission permission, AuthorizationContext context) {
        log.trace("Testing whether permission [{}] applies to request [{}]", (Object)permission, (Object)context.getResource());
        if (PermissionNameProvider.values.containsKey(permission.name)) {
            return this.predefinedPermissionAppliesToRequest(permission, context);
        }
        return this.customPermissionAppliesToRequest(permission, context);
    }

    private boolean predefinedPermissionAppliesToRequest(Permission predefinedPermission, AuthorizationContext context) {
        log.trace("Permission [{}] is a predefined perm", (Object)predefinedPermission);
        if (predefinedPermission.wellknownName == PermissionNameProvider.Name.ALL) {
            log.trace("'ALL' perm applies to all requests; perm applies.");
            return true;
        }
        if (!(context.getHandler() instanceof PermissionNameProvider)) {
            log.trace("Request handler [{}] is not a PermissionNameProvider, perm doesnt apply", context.getHandler());
            return false;
        }
        PermissionNameProvider handler = (PermissionNameProvider)context.getHandler();
        PermissionNameProvider.Name permissionName = handler.getPermissionName(context);
        boolean applies = permissionName != null && predefinedPermission.name.equals(permissionName.name);
        log.trace("Request handler [{}] is associated with predefined perm [{}]? {}", new Object[]{handler, predefinedPermission.name, applies});
        return applies;
    }

    private boolean customPermissionAppliesToRequest(Permission customPermission, AuthorizationContext context) {
        log.trace("Permission [{}] is a custom permission", (Object)customPermission);
        if (customPermission.method != null && !customPermission.method.contains(context.getHttpMethod())) {
            log.trace("Custom permission requires method [{}] but request had method [{}]; permission doesn't apply", customPermission.method, (Object)context.getHttpMethod());
            return false;
        }
        if (customPermission.params != null) {
            for (Map.Entry<String, Function<String[], Boolean>> e : customPermission.params.entrySet()) {
                String[] paramVal = context.getParams().getParams(e.getKey());
                if (e.getValue().apply(paramVal).booleanValue()) continue;
                log.trace("Request has param [{}] which is incompatible with custom perm [{}]; perm doesnt apply", (Object)e.getKey(), (Object)customPermission);
                return false;
            }
        }
        log.trace("Perm [{}] matches method and params for request; permission applies", (Object)customPermission);
        return true;
    }

    private MatchStatus determineIfPermissionPermitsPrincipal(Principal principal, Permission governingPermission) {
        if (governingPermission.role == null) {
            log.debug("Governing permission [{}] has no role; permitting access", (Object)governingPermission);
            return MatchStatus.PERMITTED;
        }
        if (principal == null) {
            log.debug("Governing permission [{}] has role, but request principal cannot be identified; forbidding access", (Object)governingPermission);
            return MatchStatus.USER_REQUIRED;
        }
        if (governingPermission.role.contains("*")) {
            log.debug("Governing permission [{}] allows all roles; permitting access", (Object)governingPermission);
            return MatchStatus.PERMITTED;
        }
        Set<String> userRoles = this.usersVsRoles.get(principal.getName());
        for (String role : governingPermission.role) {
            if (userRoles == null || !userRoles.contains(role)) continue;
            log.debug("Governing permission [{}] allows access to role [{}]; permitting access", (Object)governingPermission, (Object)role);
            return MatchStatus.PERMITTED;
        }
        log.info("This resource is configured to have a permission {}, The principal {} does not have the right role ", (Object)governingPermission, (Object)principal);
        return MatchStatus.FORBIDDEN;
    }

    public boolean doesUserHavePermission(String user, PermissionNameProvider.Name permission) {
        Set<String> roles = this.usersVsRoles.get(user);
        if (roles != null) {
            for (String role : roles) {
                Object permissions;
                if (this.mapping.get(null) == null || (permissions = this.mapping.get(null).get(null)) == null) continue;
                Iterator iterator = permissions.iterator();
                while (iterator.hasNext()) {
                    Permission p = (Permission)iterator.next();
                    if (!permission.equals((Object)p.wellknownName) || !p.role.contains(role)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void init(Map<String, Object> initInfo) {
        this.mapping.put(null, new WildCardSupportMap());
        Map<String, Object> map = SecurityConfHandler.getMapValue(initInfo, "user-role");
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> o;
            Map.Entry<String, Object> e = o = iterator.next();
            String roleName = e.getKey();
            this.usersVsRoles.put(roleName, Permission.readValueAsSet(map, roleName));
        }
        List perms = SecurityConfHandler.getListValue(initInfo, "permissions");
        for (Map o : perms) {
            Permission p;
            try {
                p = Permission.load(o);
            }
            catch (Exception exp) {
                log.error("Invalid permission ", (Throwable)exp);
                continue;
            }
            this.permissions.add(p);
            this.add2Mapping(p);
        }
    }

    private void add2Mapping(Permission permission) {
        for (String c : permission.collections) {
            WildCardSupportMap m = this.mapping.get(c);
            if (m == null) {
                m = new WildCardSupportMap();
                this.mapping.put(c, m);
            }
            for (String path : permission.path) {
                ArrayList<Permission> perms = m.get(path);
                if (perms == null) {
                    perms = new ArrayList<Permission>();
                    m.put(path, (List<Permission>)perms);
                }
                perms.add(permission);
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Map<String, Object> edit(Map<String, Object> latestConf, List<CommandOperation> commands) {
        for (CommandOperation op : commands) {
            AutorizationEditOperation operation = ops.get(op.name);
            if (operation == null) {
                op.unknownOperation();
                return null;
            }
            if ((latestConf = operation.edit(latestConf, op)) != null) continue;
            return null;
        }
        return latestConf;
    }

    public ValidatingJsonMap getSpec() {
        return Utils.getSpec((String)"cluster.security.RuleBasedAuthorization").getSpec();
    }

    static enum MatchStatus {
        USER_REQUIRED(AuthorizationResponse.PROMPT),
        NO_PERMISSIONS_FOUND(AuthorizationResponse.OK),
        PERMITTED(AuthorizationResponse.OK),
        FORBIDDEN(AuthorizationResponse.FORBIDDEN);

        final AuthorizationResponse rsp;

        private MatchStatus(AuthorizationResponse rsp) {
            this.rsp = rsp;
        }
    }

    private static class WildCardSupportMap
    extends HashMap<String, List<Permission>> {
        final Set<String> wildcardPrefixes = new HashSet<String>();

        private WildCardSupportMap() {
        }

        @Override
        public List<Permission> put(String key, List<Permission> value) {
            if (key != null && key.endsWith("/*")) {
                key = key.substring(0, key.length() - 2);
                this.wildcardPrefixes.add(key);
            }
            return super.put(key, value);
        }

        @Override
        public List<Permission> get(Object key) {
            ArrayList result = (ArrayList)super.get(key);
            if (key == null || result != null) {
                return result;
            }
            if (!this.wildcardPrefixes.isEmpty()) {
                for (String s : this.wildcardPrefixes) {
                    List l;
                    if (!key.toString().startsWith(s) || (l = (List)super.get(s)) == null) continue;
                    result = result == null ? new ArrayList() : new ArrayList(result);
                    result.addAll(l);
                }
            }
            return result;
        }
    }
}

