/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute.constraint;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.carrot2.shaded.guava.common.base.Throwables;
import org.carrot2.shaded.guava.common.collect.Lists;
import org.carrot2.util.attribute.constraint.Constraint;
import org.carrot2.util.attribute.constraint.IsConstraint;

public class ConstraintFactory {
    public static List<Constraint> createConstraints(Annotation ... annotations) {
        ArrayList constraints = Lists.newArrayList();
        for (Annotation annotation : annotations) {
            if (!ConstraintFactory.isConstraintAnnotation(annotation.annotationType())) continue;
            constraints.add(ConstraintFactory.createImplementation(annotation));
        }
        return constraints;
    }

    static boolean isConstraintAnnotation(Class<? extends Annotation> ann) {
        return ann.isAnnotationPresent(IsConstraint.class);
    }

    static Constraint createImplementation(Annotation ann) {
        Constraint instance;
        IsConstraint constraintAnnotation = ann.annotationType().getAnnotation(IsConstraint.class);
        Class<?> implClass = constraintAnnotation.implementation();
        if (!Constraint.class.isAssignableFrom(implClass)) {
            throw new IllegalArgumentException("Implementation class " + implClass.getClass().getName() + " must implement " + Constraint.class.getName());
        }
        try {
            instance = (Constraint)implClass.newInstance();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        instance.populate(ann);
        return instance;
    }
}

