/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;

public class RrdDbPool {
    public static final int INITIAL_CAPACITY = 200;
    private final AtomicInteger usage = new AtomicInteger(0);
    private final ReentrantLock countLock = new ReentrantLock();
    private final Condition full = this.countLock.newCondition();
    private int maxCapacity = 200;
    private final ConcurrentMap<URI, RrdEntry> pool = new ConcurrentHashMap<URI, RrdEntry>(200);
    private final RrdBackendFactory defaultFactory = RrdBackendFactory.getDefaultFactory();

    public static RrdDbPool getInstance() {
        return RrdDbPoolSingletonHolder.instance;
    }

    public int getOpenFileCount() {
        return this.usage.get();
    }

    public URI[] getOpenUri() {
        HashSet files = new HashSet();
        files.addAll(this.pool.keySet());
        return files.toArray(new URI[files.size()]);
    }

    public String[] getOpenFiles() {
        HashSet<String> files = new HashSet<String>();
        for (RrdEntry i : this.pool.values()) {
            files.add(i.rrdDb.getPath());
        }
        return files.toArray(new String[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private RrdEntry getEntry(URI uri, boolean cancreate) throws InterruptedException {
        ref = null;
        try {
            do {
                if ((ref = (RrdEntry)this.pool.get(uri)) == null) {
                    try {
                        this.countLock.lockInterruptibly();
                        while (ref == null && this.usage.get() >= this.maxCapacity && cancreate) {
                            this.full.await();
                            ref = (RrdEntry)this.pool.get(uri);
                        }
                        if (ref != null || !cancreate || (ref = this.pool.putIfAbsent(uri, new RrdEntry(true, uri))) != null) ** GOTO lbl24
                        ref = new RrdEntry(false, uri);
                        this.usage.incrementAndGet();
                    }
                    finally {
                        this.countLock.unlock();
                    }
                } else {
                    if (!ref.placeholder) {
                        if (this.pool.replace(uri, ref, new RrdEntry(true, uri))) continue;
                        ref = new RrdEntry(true, uri);
                        continue;
                    }
                    ref.inuse.await();
                }
lbl24:
                // 5 sources

            } while (ref != null && ref.placeholder);
            return ref;
        }
        catch (InterruptedException | RuntimeException e) {
            this.passNext(ACTION.SWAP, ref);
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    private void passNext(ACTION a, RrdEntry e) {
        if (e == null) {
            return;
        }
        RrdEntry o = null;
        switch (a) {
            case SWAP: {
                o = this.pool.put(e.uri, e);
                break;
            }
            case DROP: {
                o = (RrdEntry)this.pool.remove(e.uri);
                if (this.usage.decrementAndGet() >= this.maxCapacity) break;
                try {
                    this.countLock.lockInterruptibly();
                    this.full.signalAll();
                    this.countLock.unlock();
                    break;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (o != null) {
            o.inuse.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void release(RrdDb rrdDb) throws IOException {
        if (rrdDb == null) {
            return;
        }
        URI dburi = rrdDb.getUri();
        RrdEntry ref = null;
        try {
            ref = this.getEntry(dburi, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("release interrupted for " + rrdDb, e);
        }
        if (ref == null) {
            return;
        }
        if (ref.count <= 0) {
            this.passNext(ACTION.DROP, ref);
            throw new IllegalStateException("Could not release [" + rrdDb.getPath() + "], the file was never requested");
        }
        if (--ref.count == 0) {
            if (ref.rrdDb == null) {
                this.passNext(ACTION.DROP, ref);
                throw new IllegalStateException("Could not release [" + rrdDb.getPath() + "], pool corruption");
            }
            try {
                ref.rrdDb.internalClose();
            }
            finally {
                this.passNext(ACTION.DROP, ref);
                ref.waitempty.countDown();
            }
        } else {
            this.passNext(ACTION.SWAP, ref);
        }
    }

    @Deprecated
    public RrdDb requestRrdDb(String path) throws IOException {
        return this.requestRrdDb(this.defaultFactory.getUri(path), this.defaultFactory);
    }

    @Deprecated
    public RrdDb requestRrdDb(URI uri) throws IOException {
        RrdBackendFactory factory = RrdBackendFactory.findFactory(uri);
        return this.requestRrdDb(uri, factory);
    }

    RrdDb requestRrdDb(URI uri, RrdBackendFactory factory) throws IOException {
        uri = factory.getCanonicalUri(uri);
        RrdEntry ref = null;
        try {
            ref = this.getEntry(uri, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("request interrupted for " + uri, e);
        }
        if (ref.count == 0) {
            try {
                ref.rrdDb = RrdDb.getBuilder().setPath(factory.getPath(uri)).setBackendFactory(factory).setPool(this).build();
            }
            catch (IOException | RuntimeException e) {
                this.passNext(ACTION.DROP, ref);
                throw e;
            }
        }
        ++ref.count;
        this.passNext(ACTION.SWAP, ref);
        return ref.rrdDb;
    }

    private RrdEntry waitEmpty(URI uri) throws IOException, InterruptedException {
        RrdEntry ref = this.getEntry(uri, true);
        try {
            while (ref.count != 0) {
                this.passNext(ACTION.SWAP, ref);
                ref.waitempty.await();
                ref = this.getEntry(uri, true);
            }
            return ref;
        }
        catch (InterruptedException e) {
            this.passNext(ACTION.SWAP, ref);
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    private RrdEntry requestEmpty(URI uri) throws InterruptedException, IOException {
        RrdEntry ref = this.waitEmpty(uri);
        ref.count = 1;
        return ref;
    }

    @Deprecated
    public RrdDb requestRrdDb(RrdDef rrdDef) throws IOException {
        return this.requestRrdDb(rrdDef, RrdBackendFactory.findFactory(rrdDef.getUri()));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RrdDb requestRrdDb(RrdDef rrdDef, RrdBackendFactory backend) throws IOException {
        RrdDb rrdDb;
        block6: {
            RrdEntry ref = null;
            try {
                URI uri = backend.getCanonicalUri(rrdDef.getUri());
                ref = this.requestEmpty(uri);
                rrdDb = ref.rrdDb = RrdDb.getBuilder().setRrdDef(rrdDef).setBackendFactory(backend).setPool(this).build();
                if (ref == null) break block6;
            }
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("request interrupted for new rrdDef " + rrdDef.getPath(), e);
                    catch (RuntimeException e2) {
                        this.passNext(ACTION.DROP, ref);
                        ref = null;
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    if (ref != null) {
                        this.passNext(ACTION.SWAP, ref);
                    }
                    throw throwable;
                }
            }
            this.passNext(ACTION.SWAP, ref);
        }
        return rrdDb;
    }

    @Deprecated
    public RrdDb requestRrdDb(String path, String sourcePath) throws IOException {
        URI uri = RrdBackendFactory.getDefaultFactory().getUri(path);
        RrdBackendFactory backend = RrdBackendFactory.getDefaultFactory();
        return this.requestRrdDb(RrdDb.getBuilder().setExternalPath(sourcePath), uri, backend);
    }

    @Deprecated
    public RrdDb requestRrdDb(URI uri, String sourcePath) throws IOException {
        RrdBackendFactory backend = RrdBackendFactory.getDefaultFactory();
        return this.requestRrdDb(RrdDb.getBuilder().setExternalPath(sourcePath), uri, backend);
    }

    private RrdDb requestRrdDb(RrdDb.Builder builder, URI uri, RrdBackendFactory backend) throws IOException {
        RrdEntry ref = null;
        uri = backend.getCanonicalUri(uri);
        try {
            ref = this.requestEmpty(uri);
            RrdDb rrdDb = ref.rrdDb = builder.setPath(uri).setBackendFactory(backend).setPool(this).build();
            return rrdDb;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("request interrupted for new rrd " + uri, e);
        }
        catch (RuntimeException e) {
            this.passNext(ACTION.DROP, ref);
            ref = null;
            throw e;
        }
        finally {
            if (ref != null) {
                this.passNext(ACTION.SWAP, ref);
            }
        }
    }

    RrdDb requestRrdDb(URI uri, RrdBackendFactory backend, DataImporter importer) throws IOException {
        return this.requestRrdDb(RrdDb.getBuilder().setImporter(importer), uri, backend);
    }

    public void setCapacity(int newCapacity) {
        int oldUsage = this.usage.getAndSet(this.maxCapacity);
        try {
            if (oldUsage != 0) {
                throw new RuntimeException("Can only be done on a empty pool");
            }
        }
        finally {
            this.usage.set(oldUsage);
        }
        this.maxCapacity = newCapacity;
    }

    public int getCapacity() {
        return this.maxCapacity;
    }

    public int getOpenCount(RrdDb rrdDb) throws IOException {
        return this.getOpenCount(rrdDb.getUri());
    }

    public int getOpenCount(String path) throws IOException {
        return this.getOpenCount(this.defaultFactory.getUri(path));
    }

    public int getOpenCount(URI uri) throws IOException {
        RrdEntry ref = null;
        try {
            ref = this.getEntry(uri, false);
            if (ref == null) {
                int n = 0;
                return n;
            }
            int n = ref.count;
            return n;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("getOpenCount interrupted", e);
        }
        finally {
            if (ref != null) {
                this.passNext(ACTION.SWAP, ref);
            }
        }
    }

    private static enum ACTION {
        SWAP,
        DROP;

    }

    private static class RrdEntry {
        RrdDb rrdDb = null;
        int count = 0;
        final CountDownLatch waitempty;
        final CountDownLatch inuse;
        final boolean placeholder;
        final URI uri;

        RrdEntry(boolean placeholder, URI canonicalPath) {
            this.placeholder = placeholder;
            this.uri = canonicalPath;
            if (placeholder) {
                this.inuse = new CountDownLatch(1);
                this.waitempty = null;
            } else {
                this.inuse = null;
                this.waitempty = new CountDownLatch(1);
            }
        }

        public String toString() {
            if (this.placeholder) {
                return "RrdEntry [inuse=" + this.inuse.getCount() + ", uri=" + this.uri + "]";
            }
            return "RrdEntry [rrdDb=" + this.rrdDb + ", count=" + this.count + ", uri=" + this.uri + "]";
        }
    }

    private static class RrdDbPoolSingletonHolder {
        static final RrdDbPool instance = new RrdDbPool();

        private RrdDbPoolSingletonHolder() {
        }
    }
}

