/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.util.DateMathParser;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrDeletionPolicy
extends IndexDeletionPolicy
implements NamedListInitializedPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String maxCommitAge = null;
    private int maxCommitsToKeep = 1;
    private int maxOptimizedCommitsToKeep = 0;

    @Override
    public void init(NamedList args) {
        boolean keepOptimizedOnly;
        String keepOptimizedOnlyString = (String)args.get("keepOptimizedOnly");
        String maxCommitsToKeepString = (String)args.get("maxCommitsToKeep");
        String maxOptimizedCommitsToKeepString = (String)args.get("maxOptimizedCommitsToKeep");
        String maxCommitAgeString = (String)args.get("maxCommitAge");
        if (maxCommitsToKeepString != null && maxCommitsToKeepString.trim().length() > 0) {
            this.maxCommitsToKeep = Integer.parseInt(maxCommitsToKeepString);
        }
        if (maxCommitAgeString != null && maxCommitAgeString.trim().length() > 0) {
            this.maxCommitAge = "-" + maxCommitAgeString;
        }
        if (maxOptimizedCommitsToKeepString != null && maxOptimizedCommitsToKeepString.trim().length() > 0) {
            this.maxOptimizedCommitsToKeep = Integer.parseInt(maxOptimizedCommitsToKeepString);
        }
        if (keepOptimizedOnlyString != null && keepOptimizedOnlyString.trim().length() > 0 && (keepOptimizedOnly = Boolean.parseBoolean(keepOptimizedOnlyString))) {
            this.maxOptimizedCommitsToKeep = Math.max(this.maxOptimizedCommitsToKeep, this.maxCommitsToKeep);
            this.maxCommitsToKeep = 0;
        }
    }

    public void onInit(List<? extends IndexCommit> commits) throws IOException {
        if (commits.isEmpty()) {
            return;
        }
        log.debug("SolrDeletionPolicy.onInit: commits: {}", (Object)new CommitsLoggingDebug(commits));
        this.updateCommits(commits);
    }

    public void onCommit(List<? extends IndexCommit> commits) throws IOException {
        log.debug("SolrDeletionPolicy.onCommit: commits: {}", (Object)new CommitsLoggingDebug(commits));
        this.updateCommits(commits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCommits(List<? extends IndexCommit> commits) {
        SolrDeletionPolicy solrDeletionPolicy = this;
        synchronized (solrDeletionPolicy) {
            long maxCommitAgeTimeStamp = -1L;
            IndexCommit newest = commits.get(commits.size() - 1);
            log.debug("newest commit generation = " + newest.getGeneration());
            int singleSegKept = newest.getSegmentCount() == 1 ? 1 : 0;
            int totalKept = 1;
            for (int i = commits.size() - 2; i >= 0; --i) {
                IndexCommit commit = commits.get(i);
                try {
                    if (this.maxCommitAge != null) {
                        if (maxCommitAgeTimeStamp == -1L) {
                            DateMathParser dmp = new DateMathParser(DateMathParser.UTC);
                            maxCommitAgeTimeStamp = dmp.parseMath(this.maxCommitAge).getTime();
                        }
                        if (IndexDeletionPolicyWrapper.getCommitTimestamp(commit) < maxCommitAgeTimeStamp) {
                            commit.delete();
                            continue;
                        }
                    }
                }
                catch (Exception e) {
                    log.warn("Exception while checking commit point's age for deletion", (Throwable)e);
                }
                if (singleSegKept < this.maxOptimizedCommitsToKeep && commit.getSegmentCount() == 1) {
                    ++totalKept;
                    ++singleSegKept;
                    continue;
                }
                if (totalKept < this.maxCommitsToKeep) {
                    ++totalKept;
                    continue;
                }
                commit.delete();
            }
        }
    }

    private String getId(IndexCommit commit) {
        StringBuilder sb = new StringBuilder();
        Directory dir = commit.getDirectory();
        if (dir instanceof FSDirectory) {
            FSDirectory fsd = (FSDirectory)dir;
            File fdir = fsd.getDirectory().toFile();
            sb.append(fdir.getPath());
        } else {
            sb.append(dir);
        }
        sb.append('/');
        sb.append(commit.getGeneration());
        return sb.toString();
    }

    public String getMaxCommitAge() {
        return this.maxCommitAge;
    }

    public int getMaxCommitsToKeep() {
        return this.maxCommitsToKeep;
    }

    public int getMaxOptimizedCommitsToKeep() {
        return this.maxOptimizedCommitsToKeep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxCommitsToKeep(int maxCommitsToKeep) {
        SolrDeletionPolicy solrDeletionPolicy = this;
        synchronized (solrDeletionPolicy) {
            this.maxCommitsToKeep = maxCommitsToKeep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxOptimizedCommitsToKeep(int maxOptimizedCommitsToKeep) {
        SolrDeletionPolicy solrDeletionPolicy = this;
        synchronized (solrDeletionPolicy) {
            this.maxOptimizedCommitsToKeep = maxOptimizedCommitsToKeep;
        }
    }

    private static class CommitsLoggingDebug
    extends CommitsLoggingInfo {
        public CommitsLoggingDebug(List<? extends IndexCommit> commits) {
            super(commits);
        }

        @Override
        protected void appendDetails(StringBuilder sb, IndexCommit c) {
            super.appendDetails(sb, c);
            try {
                sb.append(",filenames=");
                sb.append(c.getFileNames());
            }
            catch (IOException e) {
                sb.append(e);
            }
        }
    }

    private static class CommitsLoggingInfo {
        private List<? extends IndexCommit> commits;

        public CommitsLoggingInfo(List<? extends IndexCommit> commits) {
            this.commits = commits;
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("num=").append(this.commits.size());
            for (IndexCommit indexCommit : this.commits) {
                sb.append("\n\tcommit{");
                this.appendDetails(sb, indexCommit);
                sb.append("}");
            }
            return sb.toString();
        }

        protected void appendDetails(StringBuilder sb, IndexCommit c) {
            Directory dir = c.getDirectory();
            if (dir instanceof FSDirectory) {
                FSDirectory fsd = (FSDirectory)dir;
                sb.append("dir=").append(fsd.getDirectory());
            } else {
                sb.append("dir=").append(dir);
            }
            sb.append(",segFN=").append(c.getSegmentsFileName());
            sb.append(",generation=").append(c.getGeneration());
        }
    }
}

