/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.Map;
import java.util.Optional;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetParser;
import org.apache.solr.search.facet.FacetRequest;

class FacetFieldParser
extends FacetParser<FacetField> {
    public FacetFieldParser(FacetParser parent, String key) {
        super(parent, key);
        this.facet = new FacetField();
    }

    @Override
    public FacetField parse(Object arg) throws SyntaxError {
        this.parseCommonParams(arg);
        if (arg instanceof String) {
            ((FacetField)this.facet).field = (String)arg;
        } else if (arg instanceof Map) {
            Map m = (Map)arg;
            ((FacetField)this.facet).field = this.getField(m);
            ((FacetField)this.facet).offset = this.getLong(m, "offset", ((FacetField)this.facet).offset);
            ((FacetField)this.facet).limit = this.getLong(m, "limit", ((FacetField)this.facet).limit);
            ((FacetField)this.facet).overrequest = (int)this.getLong(m, "overrequest", ((FacetField)this.facet).overrequest);
            ((FacetField)this.facet).overrefine = (int)this.getLong(m, "overrefine", ((FacetField)this.facet).overrefine);
            if (((FacetField)this.facet).limit == 0L) {
                ((FacetField)this.facet).offset = 0L;
            }
            ((FacetField)this.facet).mincount = this.getLong(m, "mincount", ((FacetField)this.facet).mincount);
            ((FacetField)this.facet).missing = this.getBoolean(m, "missing", ((FacetField)this.facet).missing);
            ((FacetField)this.facet).numBuckets = this.getBoolean(m, "numBuckets", ((FacetField)this.facet).numBuckets);
            ((FacetField)this.facet).prefix = this.getString(m, "prefix", ((FacetField)this.facet).prefix);
            ((FacetField)this.facet).allBuckets = this.getBoolean(m, "allBuckets", ((FacetField)this.facet).allBuckets);
            ((FacetField)this.facet).method = FacetField.FacetMethod.fromString(this.getString(m, "method", null));
            ((FacetField)this.facet).cacheDf = (int)this.getLong(m, "cacheDf", ((FacetField)this.facet).cacheDf);
            ((FacetField)this.facet).refine = FacetRequest.RefineMethod.fromObj(m.get("refine"));
            ((FacetField)this.facet).perSeg = this.getBooleanOrNull(m, "perSeg");
            Object o = m.get("facet");
            this.parseSubs(o);
            ((FacetField)this.facet).sort = FacetFieldParser.parseAndValidateSort((FacetField)this.facet, m, "sort");
            ((FacetField)this.facet).prelim_sort = FacetFieldParser.parseAndValidateSort((FacetField)this.facet, m, "prelim_sort");
        } else if (arg != null) {
            throw this.err("Expected string/map for facet field, received " + arg.getClass().getSimpleName() + "=" + arg);
        }
        if (null == ((FacetField)this.facet).sort) {
            ((FacetField)this.facet).sort = FacetRequest.FacetSort.COUNT_DESC;
        }
        return (FacetField)this.facet;
    }

    private static FacetRequest.FacetSort parseAndValidateSort(FacetField facet, Map<String, Object> args, String sortParam) {
        boolean isValidSort;
        Object sort = args.get(sortParam);
        if (sort == null) {
            return null;
        }
        FacetRequest.FacetSort facetSort = null;
        if (sort instanceof String) {
            String sortStr = (String)sort;
            facetSort = sortStr.endsWith(" asc") ? new FacetRequest.FacetSort(sortStr.substring(0, sortStr.length() - " asc".length()), FacetRequest.SortDirection.asc) : (sortStr.endsWith(" desc") ? new FacetRequest.FacetSort(sortStr.substring(0, sortStr.length() - " desc".length()), FacetRequest.SortDirection.desc) : new FacetRequest.FacetSort(sortStr, "index".equals(sortStr) ? FacetRequest.SortDirection.asc : FacetRequest.SortDirection.desc));
        } else if (sort instanceof Map) {
            Optional optional = ((Map)sort).entrySet().stream().findFirst();
            if (optional.isPresent()) {
                Map.Entry entry = (Map.Entry)optional.get();
                facetSort = new FacetRequest.FacetSort((String)entry.getKey(), FacetRequest.SortDirection.fromObj(entry.getValue()));
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected string/map for '" + sortParam + "', received " + sort.getClass().getSimpleName() + "=" + sort);
        }
        Map facetStats = facet.facetStats;
        boolean bl = isValidSort = facetSort == null || "index".equals(facetSort.sortVariable) || "count".equals(facetSort.sortVariable) || facetStats != null && facetStats.containsKey(facetSort.sortVariable);
        if (!isValidSort) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid " + sortParam + " option '" + sort + "' for field '" + facet.field + "'");
        }
        return facetSort;
    }
}

