/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import au.com.trgtd.tr.appl.Constants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import org.openide.util.NbBundle;
import tr.extract.Extract;
import tr.extract.ExtractAction;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateScheduled;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.thought.Thought;

public class ExtractProjectDetail {
    private static final Logger LOG = Logger.getLogger("tr.extract");
    private static final DateFormat DFN = Constants.DATE_FORMAT_FIXED;
    private static final DateFormat DFT = Constants.DATE_TIME_FORMAT_FIXED;
    private static final String TEXT_NONE = NbBundle.getMessage(ExtractAction.class, (String)"none");
    private static int index;
    private static boolean doneAll;
    private static boolean doneValue;
    private static boolean subDoneAll;
    private static boolean subDoneValue;
    private static boolean topTopicAll;
    private static String topTopicValue;
    private static boolean actions;

    public static void process(File xmlfile, Project project, String done) {
        index = 0;
        doneAll = done.equals("all");
        doneValue = done.equals("done");
        try {
            Writer out = ExtractProjectDetail.initialise(xmlfile);
            ExtractProjectDetail.process(out, project);
            ExtractProjectDetail.finalise(out);
        }
        catch (Exception ex) {
            LOG.severe("Extracting data failed: " + ex.getMessage());
        }
    }

    private static Writer initialise(File xmlfile) throws Exception {
        if (xmlfile.exists()) {
            xmlfile.delete();
        }
        FileOutputStream fout = new FileOutputStream(xmlfile);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        out.write("<data>\r\n");
        return out;
    }

    private static void finalise(Writer out) throws Exception {
        out.write("</data>\r\n");
        out.flush();
        out.close();
    }

    private static void process(Writer out, Project project) throws Exception {
        LOG.info("Extracting projects ... ");
        ExtractProjectDetail.extractProject(project, out, 0);
        LOG.info("Extracting projects ... done");
    }

    private static boolean filtered(Project project) {
        return !doneAll && doneValue != project.isDone();
    }

    private static boolean filtered(Action action) {
        return !doneAll && doneValue != action.isDone();
    }

    public static void extractProject(Project project, Writer out, int level) throws Exception {
        if (ExtractProjectDetail.filtered(project)) {
            return;
        }
        Thought thought = project.getThought();
        out.write("<item>\r\n");
        out.write("<index>" + index++ + "</index>\r\n");
        out.write("<type>P</type>\r\n");
        out.write("<indent>" + level + "</indent>\r\n");
        out.write("<check>" + (project.isDone() ? "\u2611" : "\u2610") + "</check>\r\n");
        out.write("<descr>" + ExtractProjectDetail.escape(project.getDescription()) + "</descr>\r\n");
        out.write("<start-date>" + (project.getStartDate() == null ? "" : DFN.format(project.getStartDate())) + "</start-date>\r\n");
        out.write("<due-date>" + (project.getDueDate() == null ? "" : DFN.format(project.getDueDate())) + "</due-date>\r\n");
        out.write("<priority>" + ExtractProjectDetail.getPriority(project.getPriority()) + "</priority>\r\n");
        out.write("<notes>" + ExtractProjectDetail.escape(project.getNotes().trim()) + "</notes>\r\n");
        out.write("<done>" + project.isDone() + "</done>\r\n");
        out.write("<done-date>" + (project.getDoneDate() == null ? "" : DFN.format(project.getDoneDate())) + "</done-date>\r\n");
        out.write("<topic>" + project.getTopic().getName() + "</topic>\r\n");
        out.write("<created>" + DFN.format(project.getCreated()) + "</created>\r\n");
        out.write("<purpose>" + ExtractProjectDetail.escape(project.getPurpose()) + "</purpose>\r\n");
        out.write("<success>" + ExtractProjectDetail.escape(project.getVision()) + "</success>\r\n");
        out.write("<brainstorming>" + ExtractProjectDetail.escape(project.getBrainstorming()) + "</brainstorming>\r\n");
        out.write("<organising>" + ExtractProjectDetail.escape(project.getOrganising()) + "</organising>\r\n");
        out.write("<thought>" + (thought == null ? "" : ExtractProjectDetail.escape(thought.getDescription())) + "</thought>\r\n");
        out.write("</item>\r\n");
        for (Item item : project.getChildren()) {
            if (item instanceof Action) {
                ExtractProjectDetail.extractAction((Action)item, out, level + 1);
                continue;
            }
            if (!(item instanceof Project)) continue;
            ExtractProjectDetail.extractProject((Project)item, out, level + 1);
        }
    }

    public static void extractAction(Action action, Writer out, int level) throws Exception {
        if (ExtractProjectDetail.filtered(action)) {
            return;
        }
        Thought thought = action.getThought();
        out.write("<item>\r\n");
        out.write("<index>" + index++ + "</index>\r\n");
        out.write("<type>A</type>\r\n");
        out.write("<indent>" + level + "</indent>\r\n");
        out.write("<check>" + (action.isDone() ? "\u2611" : "\u2610") + "</check>\r\n");
        out.write("<descr>" + ExtractProjectDetail.escape(action.getDescription()) + "</descr>\r\n");
        out.write("<state>" + ExtractProjectDetail.getState(action) + "</state>\r\n");
        out.write("<notes>" + ExtractProjectDetail.escape(action.getNotes().trim()) + "</notes>\r\n");
        out.write("<done>" + action.isDone() + "</done>\r\n");
        out.write("<created>" + DFN.format(action.getCreated()) + "</created>\r\n");
        out.write("<thought>" + (thought == null ? "" : ExtractProjectDetail.escape(action.getThought().getDescription())) + "</thought>\r\n");
        out.write("<success>" + ExtractProjectDetail.escape(action.getSuccess()) + "</success>\r\n");
        out.write("<topic>" + ExtractProjectDetail.escape(action.getTopic().getName()) + "</topic>\r\n");
        String contextName = action.getContext().getName().trim();
        if (!contextName.startsWith("@")) {
            contextName = "@" + contextName;
        }
        out.write("<context>" + ExtractProjectDetail.escape(contextName) + "</context>\r\n");
        Value time = action.getTime();
        if (time == null) {
            out.write("<time>" + TEXT_NONE + "</time>\r\n");
        } else {
            out.write("<time>" + ExtractProjectDetail.escape(time.getName()) + "</time>\r\n");
        }
        Value energy = action.getEnergy();
        if (energy == null) {
            out.write("<energy>" + TEXT_NONE + "</energy>\r\n");
        } else {
            out.write("<energy>" + ExtractProjectDetail.escape(energy.getName()) + "</energy>\r\n");
        }
        Value priority = action.getPriority();
        if (priority == null) {
            out.write("<priority>" + TEXT_NONE + "</priority>\r\n");
        } else {
            out.write("<priority>" + ExtractProjectDetail.escape(priority.getName()) + "</priority>\r\n");
        }
        Date actionDate = action.getActionDate();
        if (action.isStateScheduled()) {
            out.write("<action-date>" + (actionDate == null ? "" : DFT.format(actionDate)) + "</action-date>\r\n");
        } else {
            out.write("<action-date>" + (actionDate == null ? "" : DFN.format(actionDate)) + "</action-date>\r\n");
        }
        out.write("<due-date>" + (action.getDueDate() == null ? "" : DFN.format(action.getDueDate())) + "</due-date>\r\n");
        out.write("<done_date>" + (action.getDoneDate() == null ? "" : DFN.format(action.getDoneDate())) + "</done_date>\r\n");
        out.write("</item>\r\n");
    }

    private static synchronized String getState(Action a) {
        StringBuffer sb = new StringBuffer();
        if (a.isStateASAP()) {
            sb.append("\u2605");
            sb.append(a.getDueDate() == null ? "" : " " + NbBundle.getMessage(ExtractProjectDetail.class, (String)"Due") + ": " + DFN.format(a.getDueDate()));
        } else if (a.isStateDelegated()) {
            ActionStateDelegated s = (ActionStateDelegated)a.getState();
            sb.append("\u261e");
            sb.append(s.getTo() == null ? "" : " " + ExtractProjectDetail.escape(s.getTo()));
            sb.append(s.getDate() == null ? "" : " " + NbBundle.getMessage(ExtractProjectDetail.class, (String)"Followup_Abbrev") + ": " + DFN.format(s.getDate()));
            sb.append(a.getDueDate() == null ? "" : " " + NbBundle.getMessage(ExtractProjectDetail.class, (String)"Due") + ": " + DFN.format(a.getDueDate()));
        } else if (a.isStateScheduled()) {
            ActionStateScheduled s = (ActionStateScheduled)a.getState();
            sb.append(s.getRecurrence() == null ? "\u2637" : "\u27f3");
            Date d = s.getDate();
            if (d != null) {
                sb.append(" ");
                sb.append(ExtractProjectDetail.hasTime(d) ? DFT.format(s.getDate()) : DFN.format(s.getDate()));
            }
            if (s.getDurationHours() > 0 || s.getDurationMinutes() > 0) {
                sb.append(" ");
                if (s.getDurationHours() > 0) {
                    sb.append(s.getDurationHours() + "h");
                }
                if (s.getDurationMinutes() > 0) {
                    sb.append(s.getDurationMinutes() + "m");
                }
            }
        } else if (a.isStateInactive()) {
            sb.append("\u2606");
            sb.append(a.getStartDate() == null ? "" : " " + NbBundle.getMessage(ExtractProjectDetail.class, (String)"Start") + ": " + DFN.format(a.getStartDate()));
            sb.append(a.getDueDate() == null ? "" : " " + NbBundle.getMessage(ExtractProjectDetail.class, (String)"Due") + ": " + DFN.format(a.getDueDate()));
        }
        return sb.length() == 0 ? "" : sb.toString();
    }

    private static boolean hasTime(Date date) {
        if (date == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(10) > 0 || calendar.get(12) > 0 || calendar.get(13) > 0;
    }

    private static String getPriority(Value priority) {
        return priority == null ? "" : "\u2690" + ExtractProjectDetail.escape(priority.getName());
    }

    private static String escape(String string) {
        return Extract.FormatType.XML.escape(string);
    }
}

