/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import java.util.HashMap;
import java.util.Map;
import org.traccar.database.IdentityManager;
import org.traccar.database.MaintenancesManager;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.model.Event;
import org.traccar.model.Maintenance;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class MaintenanceEventHandler
extends BaseEventHandler {
    private final IdentityManager identityManager;
    private final MaintenancesManager maintenancesManager;

    public MaintenanceEventHandler(IdentityManager identityManager, MaintenancesManager maintenancesManager) {
        this.identityManager = identityManager;
        this.maintenancesManager = maintenancesManager;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        if (this.identityManager.getById(position.getDeviceId()) == null || !this.identityManager.isLatestPosition(position)) {
            return null;
        }
        Position lastPosition = this.identityManager.getLastPosition(position.getDeviceId());
        if (lastPosition == null) {
            return null;
        }
        HashMap<Event, Position> events = new HashMap<Event, Position>();
        for (long maintenanceId : this.maintenancesManager.getAllDeviceItems(position.getDeviceId())) {
            Maintenance maintenance = (Maintenance)this.maintenancesManager.getById(maintenanceId);
            if (maintenance.getPeriod() == 0.0) continue;
            double oldValue = lastPosition.getDouble(maintenance.getType());
            double newValue = position.getDouble(maintenance.getType());
            if (oldValue == 0.0 || newValue == 0.0 || (long)((oldValue - maintenance.getStart()) / maintenance.getPeriod()) >= (long)((newValue - maintenance.getStart()) / maintenance.getPeriod())) continue;
            Event event = new Event("maintenance", position.getDeviceId(), position.getId());
            event.setMaintenanceId(maintenanceId);
            event.set(maintenance.getType(), newValue);
            events.put(event, position);
        }
        return events;
    }
}

