(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/text/zlib#compress__%
    (lambda (_data113905_ _level113906_)
      (if (u8vector? _data113905_)
          (std/text/zlib#compress-bytes _data113905_ _level113906_)
          (if (string? _data113905_)
              (std/text/zlib#compress-bytes
               (std/text/utf8#string->utf8__0 _data113905_)
               _level113906_)
              (if (input-port? _data113905_)
                  (std/text/zlib#compress-port _data113905_ _level113906_)
                  (error '"Bad input source" _data113905_))))))
  (define std/text/zlib#compress__0
    (lambda (_data113911_)
      (let ((_level113913_ std/text/_zlib#Z_DEFAULT_COMPRESSION))
        (std/text/zlib#compress__% _data113911_ _level113913_))))
  (define std/text/zlib#compress
    (lambda _g113918_
      (let ((_g113917_ (length _g113918_)))
        (cond ((##fx= _g113917_ 1) (apply std/text/zlib#compress__0 _g113918_))
              ((##fx= _g113917_ 2) (apply std/text/zlib#compress__% _g113918_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/zlib#compress
                _g113918_))))))
  (define std/text/zlib#compress-bytes
    (lambda (_data113896_ _level113897_)
      (let* ((_buf113899_
              (make-u8vector
               (std/text/_zlib#compressBound (u8vector-length _data113896_))))
             (_res113901_
              (std/text/_zlib#compress2
               _buf113899_
               _data113896_
               _level113897_)))
        (if (##fxnegative? _res113901_)
            (std/error#raise-io-error 'compress '"zlib error" _res113901_)
            (begin (u8vector-shrink! _buf113899_ _res113901_) _buf113899_)))))
  (define std/text/zlib#compress-port
    (lambda (_inp113893_ _level113894_)
      (std/text/zlib#deflate-port
       _inp113893_
       _level113894_
       std/text/_zlib#deflateInit)))
  (define std/text/zlib#compress-gz__%
    (lambda (_data113880_ _level113881_)
      (if (u8vector? _data113880_)
          (std/text/zlib#compress-gz-bytes _data113880_ _level113881_)
          (if (string? _data113880_)
              (std/text/zlib#compress-gz-bytes
               (std/text/utf8#string->utf8__0 _data113880_)
               _level113881_)
              (if (input-port? _data113880_)
                  (std/text/zlib#compress-gz-port _data113880_ _level113881_)
                  (error '"Bad input source" _data113880_))))))
  (define std/text/zlib#compress-gz__0
    (lambda (_data113886_)
      (let ((_level113888_ std/text/_zlib#Z_DEFAULT_COMPRESSION))
        (std/text/zlib#compress-gz__% _data113886_ _level113888_))))
  (define std/text/zlib#compress-gz
    (lambda _g113920_
      (let ((_g113919_ (length _g113920_)))
        (cond ((##fx= _g113919_ 1)
               (apply std/text/zlib#compress-gz__0 _g113920_))
              ((##fx= _g113919_ 2)
               (apply std/text/zlib#compress-gz__% _g113920_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/zlib#compress-gz
                _g113920_))))))
  (define std/text/zlib#compress-gz-bytes
    (lambda (_data113868_ _level113869_)
      (let* ((_zs113871_ (std/text/_zlib#make_z_stream))
             (_res113873_
              (std/text/_zlib#deflateInit_gz _zs113871_ _level113869_)))
        (if (eq? _res113873_ std/text/_zlib#Z_OK)
            '#!void
            (std/error#raise-io-error
             'compress
             '"zlib stream initialization error"
             _res113873_))
        (with-unwind-protect
         (lambda () (std/text/zlib#compress-gz-data _zs113871_ _data113868_))
         (lambda () (std/text/_zlib#deflateEnd _zs113871_))))))
  (define std/text/zlib#compress-gz-data
    (lambda (_zs113860_ _data113861_)
      (let* ((_buf113863_
              (make-u8vector
               (std/text/_zlib#deflateBound
                _zs113860_
                (u8vector-length _data113861_))))
             (_res113865_
              (std/text/_zlib#deflate
               _zs113860_
               _buf113863_
               _data113861_
               '0
               std/text/_zlib#Z_FINISH)))
        (if (eq? _res113865_ std/text/_zlib#Z_STREAM_END)
            '#!void
            (std/error#raise-io-error
             'compress-gz
             '"incomplete deflate"
             (std/text/_zlib#z_stream_msg _zs113860_)
             _res113865_))
        (u8vector-shrink!
         _buf113863_
         (std/text/_zlib#z_stream_total_out _zs113860_))
        _buf113863_)))
  (define std/text/zlib#compress-gz-port
    (lambda (_inp113857_ _level113858_)
      (std/text/zlib#deflate-port
       _inp113857_
       _level113858_
       std/text/_zlib#deflateInit_gz)))
  (define std/text/zlib#deflate-port
    (lambda (_inp113845_ _level113846_ _init-e113847_)
      (let* ((_zs113849_ (std/text/_zlib#make_z_stream))
             (_res113851_ (_init-e113847_ _zs113849_ _level113846_)))
        (if (eq? _res113851_ std/text/_zlib#Z_OK)
            '#!void
            (std/error#raise-io-error
             'compress
             '"zlib stream initialization error"
             _res113851_))
        (with-unwind-protect
         (lambda () (std/text/zlib#do-deflate-port _zs113849_ _inp113845_))
         (lambda () (std/text/_zlib#deflateEnd _zs113849_))))))
  (define std/text/zlib#do-deflate-port
    (lambda (_zs113803_ _inp113804_)
      (letrec* ((_buflen113806_ '1024)
                (_fini113807_
                 (lambda (_r113843_) (append-u8vectors (reverse _r113843_))))
                (_deflate-next113808_
                 (lambda (_ibuf113820_ _r113821_ _flush113822_)
                   (let _lp113824_ ((_obuf113826_
                                     (make-u8vector _buflen113806_))
                                    (_start113827_ '0)
                                    (_r113828_ _r113821_))
                     (let* ((_icount113830_
                             (std/text/_zlib#z_stream_total_in _zs113803_))
                            (_ocount113832_
                             (std/text/_zlib#z_stream_total_out _zs113803_))
                            (_res113834_
                             (std/text/_zlib#deflate
                              _zs113803_
                              _obuf113826_
                              _ibuf113820_
                              _start113827_
                              _flush113822_))
                            (_ocount113836_
                             (##fx- (std/text/_zlib#z_stream_total_out
                                     _zs113803_)
                                    _ocount113832_)))
                       (if (eq? _res113834_ std/text/_zlib#Z_OK)
                           (let ((_acount113839_
                                  (std/text/_zlib#z_stream_avail_out
                                   _zs113803_)))
                             (if (##fxzero? _acount113839_)
                                 (let ((_icount113841_
                                        (##fx- (std/text/_zlib#z_stream_total_in
                                                _zs113803_)
                                               _icount113830_)))
                                   (u8vector-shrink!
                                    _obuf113826_
                                    _ocount113836_)
                                   (_lp113824_
                                    (make-u8vector _buflen113806_)
                                    (##fx+ _start113827_ _icount113841_)
                                    (cons _obuf113826_ _r113828_)))
                                 (if (##fx> _ocount113836_ '0)
                                     (begin
                                       (u8vector-shrink!
                                        _obuf113826_
                                        _ocount113836_)
                                       (cons _obuf113826_ _r113828_))
                                     _r113828_)))
                           (if (eq? _res113834_ std/text/_zlib#Z_STREAM_END)
                               (if (##fx> _ocount113836_ '0)
                                   (begin
                                     (u8vector-shrink!
                                      _obuf113826_
                                      _ocount113836_)
                                     (cons _obuf113826_ _r113828_))
                                   _r113828_)
                               (std/error#raise-io-error
                                'deflate-port
                                '"deflate: zlib error"
                                (std/text/_zlib#z_stream_msg _zs113803_)
                                _res113834_))))))))
        (let ((_ibuf113810_ (make-u8vector _buflen113806_)))
          (let _lp113812_ ((_r113814_ '()))
            (let ((_rd113816_
                   (read-subu8vector
                    _ibuf113810_
                    '0
                    _buflen113806_
                    _inp113804_)))
              (if (##fxzero? _rd113816_)
                  (_fini113807_
                   (_deflate-next113808_
                    '#f
                    _r113814_
                    std/text/_zlib#Z_FINISH))
                  (if (##fx< _rd113816_ _buflen113806_)
                      (begin
                        (u8vector-shrink! _ibuf113810_ _rd113816_)
                        (_fini113807_
                         (_deflate-next113808_
                          _ibuf113810_
                          _r113814_
                          std/text/_zlib#Z_FINISH)))
                      (let ((_r113818_
                             (_deflate-next113808_
                              _ibuf113810_
                              _r113814_
                              std/text/_zlib#Z_NO_FLUSH)))
                        (_lp113812_ _r113818_))))))))))
  (define std/text/zlib#uncompress
    (lambda (_data113801_)
      (if (u8vector? _data113801_)
          (std/text/zlib#uncompress-bytes _data113801_)
          (if (input-port? _data113801_)
              (std/text/zlib#uncompress-port _data113801_)
              (error '"Bad input source" _data113801_)))))
  (define std/text/zlib#uncompress-bytes
    (lambda (_data113799_)
      (std/text/zlib#do-inflate _data113799_ std/text/zlib#uncompress-data)))
  (define std/text/zlib#do-inflate
    (lambda (_data113788_ _inflate-e113789_)
      (let* ((_zs113791_ (std/text/_zlib#make_z_stream))
             (_res113793_ (std/text/_zlib#inflateInit _zs113791_)))
        (if (eq? _res113793_ std/text/_zlib#Z_OK)
            '#!void
            (std/error#raise-io-error
             'uncompress
             '"zlib stream initialization error"
             _res113793_))
        (with-unwind-protect
         (lambda () (_inflate-e113789_ _zs113791_ _data113788_))
         (lambda () (std/text/_zlib#inflateEnd _zs113791_))))))
  (define std/text/zlib#uncompress-data
    (lambda (_zs113765_ _data113766_)
      (letrec* ((_buflen113768_ '1024))
        (let _lp113770_ ((_start113772_ '0) (_r113773_ '()))
          (let* ((_buf113775_ (make-u8vector _buflen113768_))
                 (_icount113777_ (std/text/_zlib#z_stream_total_in _zs113765_))
                 (_ocount113779_
                  (std/text/_zlib#z_stream_total_out _zs113765_))
                 (_res113781_
                  (std/text/_zlib#inflate
                   _zs113765_
                   _buf113775_
                   _data113766_
                   _start113772_))
                 (_ocount113783_
                  (##fx- (std/text/_zlib#z_stream_total_out _zs113765_)
                         _ocount113779_)))
            (if (eq? _res113781_ std/text/_zlib#Z_OK)
                (let ((_icount113786_
                       (##fx- (std/text/_zlib#z_stream_total_in _zs113765_)
                              _icount113777_)))
                  (u8vector-shrink! _buf113775_ _ocount113783_)
                  (_lp113770_
                   (##fx+ _start113772_ _icount113786_)
                   (cons _buf113775_ _r113773_)))
                (if (eq? _res113781_ std/text/_zlib#Z_STREAM_END)
                    (begin
                      (u8vector-shrink! _buf113775_ _ocount113783_)
                      (append-u8vectors
                       (reverse (cons _buf113775_ _r113773_))))
                    (std/error#raise-io-error
                     'uncompress
                     '"zlib error"
                     (std/text/_zlib#z_stream_msg _zs113765_)
                     _res113781_))))))))
  (define std/text/zlib#uncompress-port
    (lambda (_inp113763_)
      (std/text/zlib#do-inflate _inp113763_ std/text/zlib#do-inflate-port)))
  (define std/text/zlib#do-inflate-port
    (lambda (_zs113723_ _inp113724_)
      (letrec* ((_buflen113726_ '1024)
                (_fini113727_
                 (lambda (_r113761_) (append-u8vectors (reverse _r113761_))))
                (_inflate-next113728_
                 (lambda (_ibuf113738_ _r113739_)
                   (let _lp113741_ ((_obuf113743_
                                     (make-u8vector _buflen113726_))
                                    (_start113744_ '0)
                                    (_r113745_ _r113739_))
                     (let* ((_icount113747_
                             (std/text/_zlib#z_stream_total_in _zs113723_))
                            (_ocount113749_
                             (std/text/_zlib#z_stream_total_out _zs113723_))
                            (_res113751_
                             (std/text/_zlib#inflate
                              _zs113723_
                              _obuf113743_
                              _ibuf113738_
                              _start113744_))
                            (_ocount113753_
                             (##fx- (std/text/_zlib#z_stream_total_out
                                     _zs113723_)
                                    _ocount113749_)))
                       (if (eq? _res113751_ std/text/_zlib#Z_OK)
                           (let* ((_icount113756_
                                   (##fx- (std/text/_zlib#z_stream_total_in
                                           _zs113723_)
                                          _icount113747_))
                                  (_start113758_
                                   (##fx+ _start113744_ _icount113756_)))
                             (u8vector-shrink! _obuf113743_ _ocount113753_)
                             (if (##fx< _start113758_ _buflen113726_)
                                 (_lp113741_
                                  (make-u8vector _buflen113726_)
                                  _start113758_
                                  (cons _obuf113743_ _r113745_))
                                 (cons _obuf113743_ _r113745_)))
                           (if (eq? _res113751_ std/text/_zlib#Z_STREAM_END)
                               (begin
                                 (u8vector-shrink! _obuf113743_ _ocount113753_)
                                 (cons _obuf113743_ _r113745_))
                               (std/error#raise-io-error
                                'inflate-port
                                '"zlib error"
                                (std/text/_zlib#z_stream_msg _zs113723_)
                                _res113751_))))))))
        (let ((_ibuf113730_ (make-u8vector _buflen113726_)))
          (let _lp113732_ ((_r113734_ '()))
            (let ((_rd113736_
                   (read-subu8vector
                    _ibuf113730_
                    '0
                    _buflen113726_
                    _inp113724_)))
              (if (##fxzero? _rd113736_)
                  (_fini113727_ _r113734_)
                  (if (##fx< _rd113736_ _buflen113726_)
                      (begin
                        (u8vector-shrink! _ibuf113730_ _rd113736_)
                        (_fini113727_
                         (_inflate-next113728_ _ibuf113730_ _r113734_)))
                      (_lp113732_
                       (_inflate-next113728_ _ibuf113730_ _r113734_)))))))))))
