# Copyright 2012 Tom Hayward <tom@tomh.us>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


FIPS_STATES = {
    "Alaska":                    2,
    "Alabama":                   1,
    "Arkansas":                  5,
    "Arizona":                   4,
    "California":                6,
    "Colorado":                  8,
    "Connecticut":               9,
    "District of Columbia":      11,
    "Delaware":                  10,
    "Florida":                   12,
    "Georgia":                   13,
    "Guam":                      66,
    "Hawaii":                    15,
    "Iowa":                      19,
    "Idaho":                     16,
    "Illinois":                  17,
    "Indiana":                   18,
    "Kansas":                    20,
    "Kentucky":                  21,
    "Louisiana":                 22,
    "Massachusetts":             25,
    "Maryland":                  24,
    "Maine":                     23,
    "Michigan":                  26,
    "Minnesota":                 27,
    "Missouri":                  29,
    "Mississippi":               28,
    "Montana":                   30,
    "North Carolina":            37,
    "North Dakota":              38,
    "Nebraska":                  31,
    "New Hampshire":             33,
    "New Jersey":                34,
    "New Mexico":                35,
    "Nevada":                    32,
    "New York":                  36,
    "Ohio":                      39,
    "Oklahoma":                  40,
    "Oregon":                    41,
    "Pennsylvania":              42,
    "Puerto Rico":               72,
    "Rhode Island":              44,
    "South Carolina":            45,
    "South Dakota":              46,
    "Tennessee":                 47,
    "Texas":                     48,
    "Utah":                      49,
    "Virginia":                  51,
    "Virgin Islands":            78,
    "Vermont":                   50,
    "Washington":                53,
    "Wisconsin":                 55,
    "West Virginia":             54,
    "Wyoming":                   56,
    "Alberta":                   "CA01",
    "British Columbia":          "CA02",
    "Manitoba":                  "CA03",
    "New Brunswick":             "CA04",
    "Newfoundland and Labrador": "CA05",
    "Northwest Territories":     "CA13",
    "Nova Scotia":               "CA07",
    "Nunavut":                   "CA14",
    "Ontario":                   "CA08",
    "Prince Edward Island":      "CA09",
    "Quebec":                    "CA10",
    "Saskatchewan":              "CA11",
    "Yukon":                     "CA12",
}

FIPS_COUNTIES = {
  1:  {'--All--': '%',
       'Autauga County, AL': '001',
       'Baldwin County, AL': '003',
       'Barbour County, AL': '005',
       'Bibb County, AL': '007',
       'Blount County, AL': '009',
       'Bullock County, AL': '011',
       'Butler County, AL': '013',
       'Calhoun County, AL': '015',
       'Chambers County, AL': '017',
       'Cherokee County, AL': '019',
       'Chilton County, AL': '021',
       'Choctaw County, AL': '023',
       'Clarke County, AL': '025',
       'Clay County, AL': '027',
       'Cleburne County, AL': '029',
       'Coffee County, AL': '031',
       'Colbert County, AL': '033',
       'Conecuh County, AL': '035',
       'Coosa County, AL': '037',
       'Covington County, AL': '039',
       'Crenshaw County, AL': '041',
       'Cullman County, AL': '043',
       'Dale County, AL': '045',
       'Dallas County, AL': '047',
       'DeKalb County, AL': '049',
       'Elmore County, AL': '051',
       'Escambia County, AL': '053',
       'Etowah County, AL': '055',
       'Fayette County, AL': '057',
       'Franklin County, AL': '059',
       'Geneva County, AL': '061',
       'Greene County, AL': '063',
       'Hale County, AL': '065',
       'Henry County, AL': '067',
       'Houston County, AL': '069',
       'Jackson County, AL': '071',
       'Jefferson County, AL': '073',
       'Lamar County, AL': '075',
       'Lauderdale County, AL': '077',
       'Lawrence County, AL': '079',
       'Lee County, AL': '081',
       'Limestone County, AL': '083',
       'Lowndes County, AL': '085',
       'Macon County, AL': '087',
       'Madison County, AL': '089',
       'Marengo County, AL': '091',
       'Marion County, AL': '093',
       'Marshall County, AL': '095',
       'Mobile County, AL': '097',
       'Monroe County, AL': '099',
       'Montgomery County, AL': '101',
       'Morgan County, AL': '103',
       'Perry County, AL': '105',
       'Pickens County, AL': '107',
       'Pike County, AL': '109',
       'Randolph County, AL': '111',
       'Russell County, AL': '113',
       'Shelby County, AL': '117',
       'St. Clair County, AL': '115',
       'Sumter County, AL': '119',
       'Talladega County, AL': '121',
       'Tallapoosa County, AL': '123',
       'Tuscaloosa County, AL': '125',
       'Walker County, AL': '127',
       'Washington County, AL': '129',
       'Wilcox County, AL': '131',
       'Winston County, AL': '133'},
  2:  {'--All--': '%',
       'Aleutians East Borough, AK': '013',
       'Aleutians West Census Area, AK': '016',
       'Anchorage Borough/municipality, AK': '020',
       'Bethel Census Area, AK': '050',
       'Bristol Bay Borough, AK': '060',
       'Denali Borough, AK': '068',
       'Dillingham Census Area, AK': '070',
       'Fairbanks North Star Borough, AK': '090',
       'Haines Borough, AK': '100',
       'Juneau Borough/city, AK': '110',
       'Kenai Peninsula Borough, AK': '122',
       'Ketchikan Gateway Borough, AK': '130',
       'Kodiak Island Borough, AK': '150',
       'Lake and Peninsula Borough, AK': '164',
       'Matanuska-Susitna Borough, AK': '170',
       'Nome Census Area, AK': '180',
       'North Slope Borough, AK': '185',
       'Northwest Arctic Borough, AK': '188',
       'Prince of Wales-Outer Ketchikan Census Area, AK': '201',
       'Sitka Borough/city, AK': '220',
       'Skagway-Hoonah-Angoon Census Area, AK': '232',
       'Southeast Fairbanks Census Area, AK': '240',
       'Valdez-Cordova Census Area, AK': '261',
       'Wade Hampton Census Area, AK': '270',
       'Wrangell-Petersburg Census Area, AK': '280',
       'Yakutat Borough, AK': '282',
       'Yukon-Koyukuk Census Area, AK': '290'},
  4:  {'--All--': '%',
       'Apache County, AZ': '001',
       'Cochise County, AZ': '003',
       'Coconino County, AZ': '005',
       'Gila County, AZ': '007',
       'Graham County, AZ': '009',
       'Greenlee County, AZ': '011',
       'La Paz County, AZ': '012',
       'Maricopa County, AZ': '013',
       'Mohave County, AZ': '015',
       'Navajo County, AZ': '017',
       'Pima County, AZ': '019',
       'Pinal County, AZ': '021',
       'Santa Cruz County, AZ': '023',
       'Yavapai County, AZ': '025',
       'Yuma County, AZ': '027'},
  5:  {'--All--': '%',
       'Arkansas County, AR': '001',
       'Ashley County, AR': '003',
       'Baxter County, AR': '005',
       'Benton County, AR': '007',
       'Boone County, AR': '009',
       'Bradley County, AR': '011',
       'Calhoun County, AR': '013',
       'Carroll County, AR': '015',
       'Chicot County, AR': '017',
       'Clark County, AR': '019',
       'Clay County, AR': '021',
       'Cleburne County, AR': '023',
       'Cleveland County, AR': '025',
       'Columbia County, AR': '027',
       'Conway County, AR': '029',
       'Craighead County, AR': '031',
       'Crawford County, AR': '033',
       'Crittenden County, AR': '035',
       'Cross County, AR': '037',
       'Dallas County, AR': '039',
       'Desha County, AR': '041',
       'Drew County, AR': '043',
       'Faulkner County, AR': '045',
       'Franklin County, AR': '047',
       'Fulton County, AR': '049',
       'Garland County, AR': '051',
       'Grant County, AR': '053',
       'Greene County, AR': '055',
       'Hempstead County, AR': '057',
       'Hot Spring County, AR': '059',
       'Howard County, AR': '061',
       'Independence County, AR': '063',
       'Izard County, AR': '065',
       'Jackson County, AR': '067',
       'Jefferson County, AR': '069',
       'Johnson County, AR': '071',
       'Lafayette County, AR': '073',
       'Lawrence County, AR': '075',
       'Lee County, AR': '077',
       'Lincoln County, AR': '079',
       'Little River County, AR': '081',
       'Logan County, AR': '083',
       'Lonoke County, AR': '085',
       'Madison County, AR': '087',
       'Marion County, AR': '089',
       'Miller County, AR': '091',
       'Mississippi County, AR': '093',
       'Monroe County, AR': '095',
       'Montgomery County, AR': '097',
       'Nevada County, AR': '099',
       'Newton County, AR': '101',
       'Ouachita County, AR': '103',
       'Perry County, AR': '105',
       'Phillips County, AR': '107',
       'Pike County, AR': '109',
       'Poinsett County, AR': '111',
       'Polk County, AR': '113',
       'Pope County, AR': '115',
       'Prairie County, AR': '117',
       'Pulaski County, AR': '119',
       'Randolph County, AR': '121',
       'Saline County, AR': '125',
       'Scott County, AR': '127',
       'Searcy County, AR': '129',
       'Sebastian County, AR': '131',
       'Sevier County, AR': '133',
       'Sharp County, AR': '135',
       'St. Francis County, AR': '123',
       'Stone County, AR': '137',
       'Union County, AR': '139',
       'Van Buren County, AR': '141',
       'Washington County, AR': '143',
       'White County, AR': '145',
       'Woodruff County, AR': '147',
       'Yell County, AR': '149'},
  6:  {'--All--': '%',
       'Alameda County, CA': '001',
       'Alpine County, CA': '003',
       'Amador County, CA': '005',
       'Butte County, CA': '007',
       'Calaveras County, CA': '009',
       'Colusa County, CA': '011',
       'Contra Costa County, CA': '013',
       'Del Norte County, CA': '015',
       'El Dorado County, CA': '017',
       'Fresno County, CA': '019',
       'Glenn County, CA': '021',
       'Humboldt County, CA': '023',
       'Imperial County, CA': '025',
       'Inyo County, CA': '027',
       'Kern County, CA': '029',
       'Kings County, CA': '031',
       'Lake County, CA': '033',
       'Lassen County, CA': '035',
       'Los Angeles County, CA': '037',
       'Madera County, CA': '039',
       'Marin County, CA': '041',
       'Mariposa County, CA': '043',
       'Mendocino County, CA': '045',
       'Merced County, CA': '047',
       'Modoc County, CA': '049',
       'Mono County, CA': '051',
       'Monterey County, CA': '053',
       'Napa County, CA': '055',
       'Nevada County, CA': '057',
       'Orange County, CA': '059',
       'Placer County, CA': '061',
       'Plumas County, CA': '063',
       'Riverside County, CA': '065',
       'Sacramento County, CA': '067',
       'San Benito County, CA': '069',
       'San Bernardino County, CA': '071',
       'San Diego County, CA': '073',
       'San Francisco County/city, CA': '075',
       'San Joaquin County, CA': '077',
       'San Luis Obispo County, CA': '079',
       'San Mateo County, CA': '081',
       'Santa Barbara County, CA': '083',
       'Santa Clara County, CA': '085',
       'Santa Cruz County, CA': '087',
       'Shasta County, CA': '089',
       'Sierra County, CA': '091',
       'Siskiyou County, CA': '093',
       'Solano County, CA': '095',
       'Sonoma County, CA': '097',
       'Stanislaus County, CA': '099',
       'Sutter County, CA': '101',
       'Tehama County, CA': '103',
       'Trinity County, CA': '105',
       'Tulare County, CA': '107',
       'Tuolumne County, CA': '109',
       'Ventura County, CA': '111',
       'Yolo County, CA': '113',
       'Yuba County, CA': '115'},
  8:  {'--All--': '%',
       'Adams County, CO': '001',
       'Alamosa County, CO': '003',
       'Arapahoe County, CO': '005',
       'Archuleta County, CO': '007',
       'Baca County, CO': '009',
       'Bent County, CO': '011',
       'Boulder County, CO': '013',
       'Broomfield County/city, CO': '014',
       'Chaffee County, CO': '015',
       'Cheyenne County, CO': '017',
       'Clear Creek County, CO': '019',
       'Conejos County, CO': '021',
       'Costilla County, CO': '023',
       'Crowley County, CO': '025',
       'Custer County, CO': '027',
       'Delta County, CO': '029',
       'Denver County/city, CO': '031',
       'Dolores County, CO': '033',
       'Douglas County, CO': '035',
       'Eagle County, CO': '037',
       'El Paso County, CO': '041',
       'Elbert County, CO': '039',
       'Fremont County, CO': '043',
       'Garfield County, CO': '045',
       'Gilpin County, CO': '047',
       'Grand County, CO': '049',
       'Gunnison County, CO': '051',
       'Hinsdale County, CO': '053',
       'Huerfano County, CO': '055',
       'Jackson County, CO': '057',
       'Jefferson County, CO': '059',
       'Kiowa County, CO': '061',
       'Kit Carson County, CO': '063',
       'La Plata County, CO': '067',
       'Lake County, CO': '065',
       'Larimer County, CO': '069',
       'Las Animas County, CO': '071',
       'Lincoln County, CO': '073',
       'Logan County, CO': '075',
       'Mesa County, CO': '077',
       'Mineral County, CO': '079',
       'Moffat County, CO': '081',
       'Montezuma County, CO': '083',
       'Montrose County, CO': '085',
       'Morgan County, CO': '087',
       'Otero County, CO': '089',
       'Ouray County, CO': '091',
       'Park County, CO': '093',
       'Phillips County, CO': '095',
       'Pitkin County, CO': '097',
       'Prowers County, CO': '099',
       'Pueblo County, CO': '101',
       'Rio Blanco County, CO': '103',
       'Rio Grande County, CO': '105',
       'Routt County, CO': '107',
       'Saguache County, CO': '109',
       'San Juan County, CO': '111',
       'San Miguel County, CO': '113',
       'Sedgwick County, CO': '115',
       'Summit County, CO': '117',
       'Teller County, CO': '119',
       'Washington County, CO': '121',
       'Weld County, CO': '123',
       'Yuma County, CO': '125'},
  9:  {'--All--': '%',
       'Fairfield County, CT': '001',
       'Hartford County, CT': '003',
       'Litchfield County, CT': '005',
       'Middlesex County, CT': '007',
       'New Haven County, CT': '009',
       'New London County, CT': '011',
       'Tolland County, CT': '013',
       'Windham County, CT': '015'},
  10:  {'--All--': '%',
        'Kent County, DE': '001',
        'New Castle County, DE': '003',
        'Sussex County, DE': '005'},
  11:  {'--All--': '%', 'District of Columbia': '001'},
  12:  {'--All--': '%',
        'Alachua County, FL': '001',
        'Baker County, FL': '003',
        'Bay County, FL': '005',
        'Bradford County, FL': '007',
        'Brevard County, FL': '009',
        'Broward County, FL': '011',
        'Calhoun County, FL': '013',
        'Charlotte County, FL': '015',
        'Citrus County, FL': '017',
        'Clay County, FL': '019',
        'Collier County, FL': '021',
        'Columbia County, FL': '023',
        'DeSoto County, FL': '027',
        'Dixie County, FL': '029',
        'Duval County, FL': '031',
        'Escambia County, FL': '033',
        'Flagler County, FL': '035',
        'Franklin County, FL': '037',
        'Gadsden County, FL': '039',
        'Gilchrist County, FL': '041',
        'Glades County, FL': '043',
        'Gulf County, FL': '045',
        'Hamilton County, FL': '047',
        'Hardee County, FL': '049',
        'Hendry County, FL': '051',
        'Hernando County, FL': '053',
        'Highlands County, FL': '055',
        'Hillsborough County, FL': '057',
        'Holmes County, FL': '059',
        'Indian River County, FL': '061',
        'Jackson County, FL': '063',
        'Jefferson County, FL': '065',
        'Lafayette County, FL': '067',
        'Lake County, FL': '069',
        'Lee County, FL': '071',
        'Leon County, FL': '073',
        'Levy County, FL': '075',
        'Liberty County, FL': '077',
        'Madison County, FL': '079',
        'Manatee County, FL': '081',
        'Marion County, FL': '083',
        'Martin County, FL': '085',
        'Miami-Dade County, FL': '086',
        'Monroe County, FL': '087',
        'Nassau County, FL': '089',
        'Okaloosa County, FL': '091',
        'Okeechobee County, FL': '093',
        'Orange County, FL': '095',
        'Osceola County, FL': '097',
        'Palm Beach County, FL': '099',
        'Pasco County, FL': '101',
        'Pinellas County, FL': '103',
        'Polk County, FL': '105',
        'Putnam County, FL': '107',
        'Santa Rosa County, FL': '113',
        'Sarasota County, FL': '115',
        'Seminole County, FL': '117',
        'St. Johns County, FL': '109',
        'St. Lucie County, FL': '111',
        'Sumter County, FL': '119',
        'Suwannee County, FL': '121',
        'Taylor County, FL': '123',
        'Union County, FL': '125',
        'Volusia County, FL': '127',
        'Wakulla County, FL': '129',
        'Walton County, FL': '131',
        'Washington County, FL': '133'},
  13:  {'--All--': '%',
        'Appling County, GA': '001',
        'Atkinson County, GA': '003',
        'Bacon County, GA': '005',
        'Baker County, GA': '007',
        'Baldwin County, GA': '009',
        'Banks County, GA': '011',
        'Barrow County, GA': '013',
        'Bartow County, GA': '015',
        'Ben Hill County, GA': '017',
        'Berrien County, GA': '019',
        'Bibb County, GA': '021',
        'Bleckley County, GA': '023',
        'Brantley County, GA': '025',
        'Brooks County, GA': '027',
        'Bryan County, GA': '029',
        'Bulloch County, GA': '031',
        'Burke County, GA': '033',
        'Butts County, GA': '035',
        'Calhoun County, GA': '037',
        'Camden County, GA': '039',
        'Candler County, GA': '043',
        'Carroll County, GA': '045',
        'Catoosa County, GA': '047',
        'Charlton County, GA': '049',
        'Chatham County, GA': '051',
        'Chattahoochee County, GA': '053',
        'Chattooga County, GA': '055',
        'Cherokee County, GA': '057',
        'Clarke County, GA': '059',
        'Clay County, GA': '061',
        'Clayton County, GA': '063',
        'Clinch County, GA': '065',
        'Cobb County, GA': '067',
        'Coffee County, GA': '069',
        'Colquitt County, GA': '071',
        'Columbia County, GA': '073',
        'Cook County, GA': '075',
        'Coweta County, GA': '077',
        'Crawford County, GA': '079',
        'Crisp County, GA': '081',
        'Dade County, GA': '083',
        'Dawson County, GA': '085',
        'DeKalb County, GA': '089',
        'Decatur County, GA': '087',
        'Dodge County, GA': '091',
        'Dooly County, GA': '093',
        'Dougherty County, GA': '095',
        'Douglas County, GA': '097',
        'Early County, GA': '099',
        'Echols County, GA': '101',
        'Effingham County, GA': '103',
        'Elbert County, GA': '105',
        'Emanuel County, GA': '107',
        'Evans County, GA': '109',
        'Fannin County, GA': '111',
        'Fayette County, GA': '113',
        'Floyd County, GA': '115',
        'Forsyth County, GA': '117',
        'Franklin County, GA': '119',
        'Fulton County, GA': '121',
        'Gilmer County, GA': '123',
        'Glascock County, GA': '125',
        'Glynn County, GA': '127',
        'Gordon County, GA': '129',
        'Grady County, GA': '131',
        'Greene County, GA': '133',
        'Gwinnett County, GA': '135',
        'Habersham County, GA': '137',
        'Hall County, GA': '139',
        'Hancock County, GA': '141',
        'Haralson County, GA': '143',
        'Harris County, GA': '145',
        'Hart County, GA': '147',
        'Heard County, GA': '149',
        'Henry County, GA': '151',
        'Houston County, GA': '153',
        'Irwin County, GA': '155',
        'Jackson County, GA': '157',
        'Jasper County, GA': '159',
        'Jeff Davis County, GA': '161',
        'Jefferson County, GA': '163',
        'Jenkins County, GA': '165',
        'Johnson County, GA': '167',
        'Jones County, GA': '169',
        'Lamar County, GA': '171',
        'Lanier County, GA': '173',
        'Laurens County, GA': '175',
        'Lee County, GA': '177',
        'Liberty County, GA': '179',
        'Lincoln County, GA': '181',
        'Long County, GA': '183',
        'Lowndes County, GA': '185',
        'Lumpkin County, GA': '187',
        'Macon County, GA': '193',
        'Madison County, GA': '195',
        'Marion County, GA': '197',
        'McDuffie County, GA': '189',
        'McIntosh County, GA': '191',
        'Meriwether County, GA': '199',
        'Miller County, GA': '201',
        'Mitchell County, GA': '205',
        'Monroe County, GA': '207',
        'Montgomery County, GA': '209',
        'Morgan County, GA': '211',
        'Murray County, GA': '213',
        'Muscogee County, GA': '215',
        'Newton County, GA': '217',
        'Oconee County, GA': '219',
        'Oglethorpe County, GA': '221',
        'Paulding County, GA': '223',
        'Peach County, GA': '225',
        'Pickens County, GA': '227',
        'Pierce County, GA': '229',
        'Pike County, GA': '231',
        'Polk County, GA': '233',
        'Pulaski County, GA': '235',
        'Putnam County, GA': '237',
        'Quitman County, GA': '239',
        'Rabun County, GA': '241',
        'Randolph County, GA': '243',
        'Richmond County, GA': '245',
        'Rockdale County, GA': '247',
        'Schley County, GA': '249',
        'Screven County, GA': '251',
        'Seminole County, GA': '253',
        'Spalding County, GA': '255',
        'Stephens County, GA': '257',
        'Stewart County, GA': '259',
        'Sumter County, GA': '261',
        'Talbot County, GA': '263',
        'Taliaferro County, GA': '265',
        'Tattnall County, GA': '267',
        'Taylor County, GA': '269',
        'Telfair County, GA': '271',
        'Terrell County, GA': '273',
        'Thomas County, GA': '275',
        'Tift County, GA': '277',
        'Toombs County, GA': '279',
        'Towns County, GA': '281',
        'Treutlen County, GA': '283',
        'Troup County, GA': '285',
        'Turner County, GA': '287',
        'Twiggs County, GA': '289',
        'Union County, GA': '291',
        'Upson County, GA': '293',
        'Walker County, GA': '295',
        'Walton County, GA': '297',
        'Ware County, GA': '299',
        'Warren County, GA': '301',
        'Washington County, GA': '303',
        'Wayne County, GA': '305',
        'Webster County, GA': '307',
        'Wheeler County, GA': '309',
        'White County, GA': '311',
        'Whitfield County, GA': '313',
        'Wilcox County, GA': '315',
        'Wilkes County, GA': '317',
        'Wilkinson County, GA': '319',
        'Worth County, GA': '321'},
  15:  {'--All--': '%',
        'Hawaii County, HI': '001',
        'Honolulu County/city, HI': '003',
        'Kauai County, HI': '007',
        'Maui County, HI': '009'},
  16:  {'--All--': '%',
        'Ada County, ID': '001',
        'Adams County, ID': '003',
        'Bannock County, ID': '005',
        'Bear Lake County, ID': '007',
        'Benewah County, ID': '009',
        'Bingham County, ID': '011',
        'Blaine County, ID': '013',
        'Boise County, ID': '015',
        'Bonner County, ID': '017',
        'Bonneville County, ID': '019',
        'Boundary County, ID': '021',
        'Butte County, ID': '023',
        'Camas County, ID': '025',
        'Canyon County, ID': '027',
        'Caribou County, ID': '029',
        'Cassia County, ID': '031',
        'Clark County, ID': '033',
        'Clearwater County, ID': '035',
        'Custer County, ID': '037',
        'Elmore County, ID': '039',
        'Franklin County, ID': '041',
        'Fremont County, ID': '043',
        'Gem County, ID': '045',
        'Gooding County, ID': '047',
        'Idaho County, ID': '049',
        'Jefferson County, ID': '051',
        'Jerome County, ID': '053',
        'Kootenai County, ID': '055',
        'Latah County, ID': '057',
        'Lemhi County, ID': '059',
        'Lewis County, ID': '061',
        'Lincoln County, ID': '063',
        'Madison County, ID': '065',
        'Minidoka County, ID': '067',
        'Nez Perce County, ID': '069',
        'Oneida County, ID': '071',
        'Owyhee County, ID': '073',
        'Payette County, ID': '075',
        'Power County, ID': '077',
        'Shoshone County, ID': '079',
        'Teton County, ID': '081',
        'Twin Falls County, ID': '083',
        'Valley County, ID': '085',
        'Washington County, ID': '087'},
  17:  {'--All--': '%',
        'Adams County, IL': '001',
        'Alexander County, IL': '003',
        'Bond County, IL': '005',
        'Boone County, IL': '007',
        'Brown County, IL': '009',
        'Bureau County, IL': '011',
        'Calhoun County, IL': '013',
        'Carroll County, IL': '015',
        'Cass County, IL': '017',
        'Champaign County, IL': '019',
        'Christian County, IL': '021',
        'Clark County, IL': '023',
        'Clay County, IL': '025',
        'Clinton County, IL': '027',
        'Coles County, IL': '029',
        'Cook County, IL': '031',
        'Crawford County, IL': '033',
        'Cumberland County, IL': '035',
        'De Witt County, IL': '039',
        'DeKalb County, IL': '037',
        'Douglas County, IL': '041',
        'DuPage County, IL': '043',
        'Edgar County, IL': '045',
        'Edwards County, IL': '047',
        'Effingham County, IL': '049',
        'Fayette County, IL': '051',
        'Ford County, IL': '053',
        'Franklin County, IL': '055',
        'Fulton County, IL': '057',
        'Gallatin County, IL': '059',
        'Greene County, IL': '061',
        'Grundy County, IL': '063',
        'Hamilton County, IL': '065',
        'Hancock County, IL': '067',
        'Hardin County, IL': '069',
        'Henderson County, IL': '071',
        'Henry County, IL': '073',
        'Iroquois County, IL': '075',
        'Jackson County, IL': '077',
        'Jasper County, IL': '079',
        'Jefferson County, IL': '081',
        'Jersey County, IL': '083',
        'Jo Daviess County, IL': '085',
        'Johnson County, IL': '087',
        'Kane County, IL': '089',
        'Kankakee County, IL': '091',
        'Kendall County, IL': '093',
        'Knox County, IL': '095',
        'La Salle County, IL': '099',
        'Lake County, IL': '097',
        'Lawrence County, IL': '101',
        'Lee County, IL': '103',
        'Livingston County, IL': '105',
        'Logan County, IL': '107',
        'Macon County, IL': '115',
        'Macoupin County, IL': '117',
        'Madison County, IL': '119',
        'Marion County, IL': '121',
        'Marshall County, IL': '123',
        'Mason County, IL': '125',
        'Massac County, IL': '127',
        'McDonough County, IL': '109',
        'McHenry County, IL': '111',
        'McLean County, IL': '113',
        'Menard County, IL': '129',
        'Mercer County, IL': '131',
        'Monroe County, IL': '133',
        'Montgomery County, IL': '135',
        'Morgan County, IL': '137',
        'Moultrie County, IL': '139',
        'Ogle County, IL': '141',
        'Peoria County, IL': '143',
        'Perry County, IL': '145',
        'Piatt County, IL': '147',
        'Pike County, IL': '149',
        'Pope County, IL': '151',
        'Pulaski County, IL': '153',
        'Putnam County, IL': '155',
        'Randolph County, IL': '157',
        'Richland County, IL': '159',
        'Rock Island County, IL': '161',
        'Saline County, IL': '165',
        'Sangamon County, IL': '167',
        'Schuyler County, IL': '169',
        'Scott County, IL': '171',
        'Shelby County, IL': '173',
        'St. Clair County, IL': '163',
        'Stark County, IL': '175',
        'Stephenson County, IL': '177',
        'Tazewell County, IL': '179',
        'Union County, IL': '181',
        'Vermilion County, IL': '183',
        'Wabash County, IL': '185',
        'Warren County, IL': '187',
        'Washington County, IL': '189',
        'Wayne County, IL': '191',
        'White County, IL': '193',
        'Whiteside County, IL': '195',
        'Will County, IL': '197',
        'Williamson County, IL': '199',
        'Winnebago County, IL': '201',
        'Woodford County, IL': '203'},
  18:  {'--All--': '%',
        'Adams County, IN': '001',
        'Allen County, IN': '003',
        'Bartholomew County, IN': '005',
        'Benton County, IN': '007',
        'Blackford County, IN': '009',
        'Boone County, IN': '011',
        'Brown County, IN': '013',
        'Carroll County, IN': '015',
        'Cass County, IN': '017',
        'Clark County, IN': '019',
        'Clay County, IN': '021',
        'Clinton County, IN': '023',
        'Crawford County, IN': '025',
        'Daviess County, IN': '027',
        'DeKalb County, IN': '033',
        'Dearborn County, IN': '029',
        'Decatur County, IN': '031',
        'Delaware County, IN': '035',
        'Dubois County, IN': '037',
        'Elkhart County, IN': '039',
        'Fayette County, IN': '041',
        'Floyd County, IN': '043',
        'Fountain County, IN': '045',
        'Franklin County, IN': '047',
        'Fulton County, IN': '049',
        'Gibson County, IN': '051',
        'Grant County, IN': '053',
        'Greene County, IN': '055',
        'Hamilton County, IN': '057',
        'Hancock County, IN': '059',
        'Harrison County, IN': '061',
        'Hendricks County, IN': '063',
        'Henry County, IN': '065',
        'Howard County, IN': '067',
        'Huntington County, IN': '069',
        'Jackson County, IN': '071',
        'Jasper County, IN': '073',
        'Jay County, IN': '075',
        'Jefferson County, IN': '077',
        'Jennings County, IN': '079',
        'Johnson County, IN': '081',
        'Knox County, IN': '083',
        'Kosciusko County, IN': '085',
        'LaGrange County, IN': '087',
        'LaPorte County, IN': '091',
        'Lake County, IN': '089',
        'Lawrence County, IN': '093',
        'Madison County, IN': '095',
        'Marion County, IN': '097',
        'Marshall County, IN': '099',
        'Martin County, IN': '101',
        'Miami County, IN': '103',
        'Monroe County, IN': '105',
        'Montgomery County, IN': '107',
        'Morgan County, IN': '109',
        'Newton County, IN': '111',
        'Noble County, IN': '113',
        'Ohio County, IN': '115',
        'Orange County, IN': '117',
        'Owen County, IN': '119',
        'Parke County, IN': '121',
        'Perry County, IN': '123',
        'Pike County, IN': '125',
        'Porter County, IN': '127',
        'Posey County, IN': '129',
        'Pulaski County, IN': '131',
        'Putnam County, IN': '133',
        'Randolph County, IN': '135',
        'Ripley County, IN': '137',
        'Rush County, IN': '139',
        'Scott County, IN': '143',
        'Shelby County, IN': '145',
        'Spencer County, IN': '147',
        'St. Joseph County, IN': '141',
        'Starke County, IN': '149',
        'Steuben County, IN': '151',
        'Sullivan County, IN': '153',
        'Switzerland County, IN': '155',
        'Tippecanoe County, IN': '157',
        'Tipton County, IN': '159',
        'Union County, IN': '161',
        'Vanderburgh County, IN': '163',
        'Vermillion County, IN': '165',
        'Vigo County, IN': '167',
        'Wabash County, IN': '169',
        'Warren County, IN': '171',
        'Warrick County, IN': '173',
        'Washington County, IN': '175',
        'Wayne County, IN': '177',
        'Wells County, IN': '179',
        'White County, IN': '181',
        'Whitley County, IN': '183'},
  19:  {'--All--': '%',
        'Adair County, IA': '001',
        'Adams County, IA': '003',
        'Allamakee County, IA': '005',
        'Appanoose County, IA': '007',
        'Audubon County, IA': '009',
        'Benton County, IA': '011',
        'Black Hawk County, IA': '013',
        'Boone County, IA': '015',
        'Bremer County, IA': '017',
        'Buchanan County, IA': '019',
        'Buena Vista County, IA': '021',
        'Butler County, IA': '023',
        'Calhoun County, IA': '025',
        'Carroll County, IA': '027',
        'Cass County, IA': '029',
        'Cedar County, IA': '031',
        'Cerro Gordo County, IA': '033',
        'Cherokee County, IA': '035',
        'Chickasaw County, IA': '037',
        'Clarke County, IA': '039',
        'Clay County, IA': '041',
        'Clayton County, IA': '043',
        'Clinton County, IA': '045',
        'Crawford County, IA': '047',
        'Dallas County, IA': '049',
        'Davis County, IA': '051',
        'Decatur County, IA': '053',
        'Delaware County, IA': '055',
        'Des Moines County, IA': '057',
        'Dickinson County, IA': '059',
        'Dubuque County, IA': '061',
        'Emmet County, IA': '063',
        'Fayette County, IA': '065',
        'Floyd County, IA': '067',
        'Franklin County, IA': '069',
        'Fremont County, IA': '071',
        'Greene County, IA': '073',
        'Grundy County, IA': '075',
        'Guthrie County, IA': '077',
        'Hamilton County, IA': '079',
        'Hancock County, IA': '081',
        'Hardin County, IA': '083',
        'Harrison County, IA': '085',
        'Henry County, IA': '087',
        'Howard County, IA': '089',
        'Humboldt County, IA': '091',
        'Ida County, IA': '093',
        'Iowa County, IA': '095',
        'Jackson County, IA': '097',
        'Jasper County, IA': '099',
        'Jefferson County, IA': '101',
        'Johnson County, IA': '103',
        'Jones County, IA': '105',
        'Keokuk County, IA': '107',
        'Kossuth County, IA': '109',
        'Lee County, IA': '111',
        'Linn County, IA': '113',
        'Louisa County, IA': '115',
        'Lucas County, IA': '117',
        'Lyon County, IA': '119',
        'Madison County, IA': '121',
        'Mahaska County, IA': '123',
        'Marion County, IA': '125',
        'Marshall County, IA': '127',
        'Mills County, IA': '129',
        'Mitchell County, IA': '131',
        'Monona County, IA': '133',
        'Monroe County, IA': '135',
        'Montgomery County, IA': '137',
        'Muscatine County, IA': '139',
        "O'Brien County, IA": '141',
        'Osceola County, IA': '143',
        'Page County, IA': '145',
        'Palo Alto County, IA': '147',
        'Plymouth County, IA': '149',
        'Pocahontas County, IA': '151',
        'Polk County, IA': '153',
        'Pottawattamie County, IA': '155',
        'Poweshiek County, IA': '157',
        'Ringgold County, IA': '159',
        'Sac County, IA': '161',
        'Scott County, IA': '163',
        'Shelby County, IA': '165',
        'Sioux County, IA': '167',
        'Story County, IA': '169',
        'Tama County, IA': '171',
        'Taylor County, IA': '173',
        'Union County, IA': '175',
        'Van Buren County, IA': '177',
        'Wapello County, IA': '179',
        'Warren County, IA': '181',
        'Washington County, IA': '183',
        'Wayne County, IA': '185',
        'Webster County, IA': '187',
        'Winnebago County, IA': '189',
        'Winneshiek County, IA': '191',
        'Woodbury County, IA': '193',
        'Worth County, IA': '195',
        'Wright County, IA': '197'},
  20:  {'--All--': '%',
        'Allen County, KS': '001',
        'Anderson County, KS': '003',
        'Atchison County, KS': '005',
        'Barber County, KS': '007',
        'Barton County, KS': '009',
        'Bourbon County, KS': '011',
        'Brown County, KS': '013',
        'Butler County, KS': '015',
        'Chase County, KS': '017',
        'Chautauqua County, KS': '019',
        'Cherokee County, KS': '021',
        'Cheyenne County, KS': '023',
        'Clark County, KS': '025',
        'Clay County, KS': '027',
        'Cloud County, KS': '029',
        'Coffey County, KS': '031',
        'Comanche County, KS': '033',
        'Cowley County, KS': '035',
        'Crawford County, KS': '037',
        'Decatur County, KS': '039',
        'Dickinson County, KS': '041',
        'Doniphan County, KS': '043',
        'Douglas County, KS': '045',
        'Edwards County, KS': '047',
        'Elk County, KS': '049',
        'Ellis County, KS': '051',
        'Ellsworth County, KS': '053',
        'Finney County, KS': '055',
        'Ford County, KS': '057',
        'Franklin County, KS': '059',
        'Geary County, KS': '061',
        'Gove County, KS': '063',
        'Graham County, KS': '065',
        'Grant County, KS': '067',
        'Gray County, KS': '069',
        'Greeley County, KS': '071',
        'Greenwood County, KS': '073',
        'Hamilton County, KS': '075',
        'Harper County, KS': '077',
        'Harvey County, KS': '079',
        'Haskell County, KS': '081',
        'Hodgeman County, KS': '083',
        'Jackson County, KS': '085',
        'Jefferson County, KS': '087',
        'Jewell County, KS': '089',
        'Johnson County, KS': '091',
        'Kearny County, KS': '093',
        'Kingman County, KS': '095',
        'Kiowa County, KS': '097',
        'Labette County, KS': '099',
        'Lane County, KS': '101',
        'Leavenworth County, KS': '103',
        'Lincoln County, KS': '105',
        'Linn County, KS': '107',
        'Logan County, KS': '109',
        'Lyon County, KS': '111',
        'Marion County, KS': '115',
        'Marshall County, KS': '117',
        'McPherson County, KS': '113',
        'Meade County, KS': '119',
        'Miami County, KS': '121',
        'Mitchell County, KS': '123',
        'Montgomery County, KS': '125',
        'Morris County, KS': '127',
        'Morton County, KS': '129',
        'Nemaha County, KS': '131',
        'Neosho County, KS': '133',
        'Ness County, KS': '135',
        'Norton County, KS': '137',
        'Osage County, KS': '139',
        'Osborne County, KS': '141',
        'Ottawa County, KS': '143',
        'Pawnee County, KS': '145',
        'Phillips County, KS': '147',
        'Pottawatomie County, KS': '149',
        'Pratt County, KS': '151',
        'Rawlins County, KS': '153',
        'Reno County, KS': '155',
        'Republic County, KS': '157',
        'Rice County, KS': '159',
        'Riley County, KS': '161',
        'Rooks County, KS': '163',
        'Rush County, KS': '165',
        'Russell County, KS': '167',
        'Saline County, KS': '169',
        'Scott County, KS': '171',
        'Sedgwick County, KS': '173',
        'Seward County, KS': '175',
        'Shawnee County, KS': '177',
        'Sheridan County, KS': '179',
        'Sherman County, KS': '181',
        'Smith County, KS': '183',
        'Stafford County, KS': '185',
        'Stanton County, KS': '187',
        'Stevens County, KS': '189',
        'Sumner County, KS': '191',
        'Thomas County, KS': '193',
        'Trego County, KS': '195',
        'Wabaunsee County, KS': '197',
        'Wallace County, KS': '199',
        'Washington County, KS': '201',
        'Wichita County, KS': '203',
        'Wilson County, KS': '205',
        'Woodson County, KS': '207',
        'Wyandotte County, KS': '209'},
  21:  {'--All--': '%',
        'Adair County, KY': '001',
        'Allen County, KY': '003',
        'Anderson County, KY': '005',
        'Ballard County, KY': '007',
        'Barren County, KY': '009',
        'Bath County, KY': '011',
        'Bell County, KY': '013',
        'Boone County, KY': '015',
        'Bourbon County, KY': '017',
        'Boyd County, KY': '019',
        'Boyle County, KY': '021',
        'Bracken County, KY': '023',
        'Breathitt County, KY': '025',
        'Breckinridge County, KY': '027',
        'Bullitt County, KY': '029',
        'Butler County, KY': '031',
        'Caldwell County, KY': '033',
        'Calloway County, KY': '035',
        'Campbell County, KY': '037',
        'Carlisle County, KY': '039',
        'Carroll County, KY': '041',
        'Carter County, KY': '043',
        'Casey County, KY': '045',
        'Christian County, KY': '047',
        'Clark County, KY': '049',
        'Clay County, KY': '051',
        'Clinton County, KY': '053',
        'Crittenden County, KY': '055',
        'Cumberland County, KY': '057',
        'Daviess County, KY': '059',
        'Edmonson County, KY': '061',
        'Elliott County, KY': '063',
        'Estill County, KY': '065',
        'Fayette County, KY': '067',
        'Fleming County, KY': '069',
        'Floyd County, KY': '071',
        'Franklin County, KY': '073',
        'Fulton County, KY': '075',
        'Gallatin County, KY': '077',
        'Garrard County, KY': '079',
        'Grant County, KY': '081',
        'Graves County, KY': '083',
        'Grayson County, KY': '085',
        'Green County, KY': '087',
        'Greenup County, KY': '089',
        'Hancock County, KY': '091',
        'Hardin County, KY': '093',
        'Harlan County, KY': '095',
        'Harrison County, KY': '097',
        'Hart County, KY': '099',
        'Henderson County, KY': '101',
        'Henry County, KY': '103',
        'Hickman County, KY': '105',
        'Hopkins County, KY': '107',
        'Jackson County, KY': '109',
        'Jefferson County, KY': '111',
        'Jessamine County, KY': '113',
        'Johnson County, KY': '115',
        'Kenton County, KY': '117',
        'Knott County, KY': '119',
        'Knox County, KY': '121',
        'Larue County, KY': '123',
        'Laurel County, KY': '125',
        'Lawrence County, KY': '127',
        'Lee County, KY': '129',
        'Leslie County, KY': '131',
        'Letcher County, KY': '133',
        'Lewis County, KY': '135',
        'Lincoln County, KY': '137',
        'Livingston County, KY': '139',
        'Logan County, KY': '141',
        'Lyon County, KY': '143',
        'Madison County, KY': '151',
        'Magoffin County, KY': '153',
        'Marion County, KY': '155',
        'Marshall County, KY': '157',
        'Martin County, KY': '159',
        'Mason County, KY': '161',
        'McCracken County, KY': '145',
        'McCreary County, KY': '147',
        'McLean County, KY': '149',
        'Meade County, KY': '163',
        'Menifee County, KY': '165',
        'Mercer County, KY': '167',
        'Metcalfe County, KY': '169',
        'Monroe County, KY': '171',
        'Montgomery County, KY': '173',
        'Morgan County, KY': '175',
        'Muhlenberg County, KY': '177',
        'Nelson County, KY': '179',
        'Nicholas County, KY': '181',
        'Ohio County, KY': '183',
        'Oldham County, KY': '185',
        'Owen County, KY': '187',
        'Owsley County, KY': '189',
        'Pendleton County, KY': '191',
        'Perry County, KY': '193',
        'Pike County, KY': '195',
        'Powell County, KY': '197',
        'Pulaski County, KY': '199',
        'Robertson County, KY': '201',
        'Rockcastle County, KY': '203',
        'Rowan County, KY': '205',
        'Russell County, KY': '207',
        'Scott County, KY': '209',
        'Shelby County, KY': '211',
        'Simpson County, KY': '213',
        'Spencer County, KY': '215',
        'Taylor County, KY': '217',
        'Todd County, KY': '219',
        'Trigg County, KY': '221',
        'Trimble County, KY': '223',
        'Union County, KY': '225',
        'Warren County, KY': '227',
        'Washington County, KY': '229',
        'Wayne County, KY': '231',
        'Webster County, KY': '233',
        'Whitley County, KY': '235',
        'Wolfe County, KY': '237',
        'Woodford County, KY': '239'},
  22:  {'--All--': '%',
        'Acadia Parish, LA': '001',
        'Allen Parish, LA': '003',
        'Ascension Parish, LA': '005',
        'Assumption Parish, LA': '007',
        'Avoyelles Parish, LA': '009',
        'Beauregard Parish, LA': '011',
        'Bienville Parish, LA': '013',
        'Bossier Parish, LA': '015',
        'Caddo Parish, LA': '017',
        'Calcasieu Parish, LA': '019',
        'Caldwell Parish, LA': '021',
        'Cameron Parish, LA': '023',
        'Catahoula Parish, LA': '025',
        'Claiborne Parish, LA': '027',
        'Concordia Parish, LA': '029',
        'De Soto Parish, LA': '031',
        'East Baton Rouge Parish, LA': '033',
        'East Carroll Parish, LA': '035',
        'East Feliciana Parish, LA': '037',
        'Evangeline Parish, LA': '039',
        'Franklin Parish, LA': '041',
        'Grant Parish, LA': '043',
        'Iberia Parish, LA': '045',
        'Iberville Parish, LA': '047',
        'Jackson Parish, LA': '049',
        'Jefferson Davis Parish, LA': '053',
        'Jefferson Parish, LA': '051',
        'La Salle Parish, LA': '059',
        'Lafayette Parish, LA': '055',
        'Lafourche Parish, LA': '057',
        'Lincoln Parish, LA': '061',
        'Livingston Parish, LA': '063',
        'Madison Parish, LA': '065',
        'Morehouse Parish, LA': '067',
        'Natchitoches Parish, LA': '069',
        'Orleans Parish, LA': '071',
        'Ouachita Parish, LA': '073',
        'Plaquemines Parish, LA': '075',
        'Pointe Coupee Parish, LA': '077',
        'Rapides Parish, LA': '079',
        'Red River Parish, LA': '081',
        'Richland Parish, LA': '083',
        'Sabine Parish, LA': '085',
        'St. Bernard Parish, LA': '087',
        'St. Charles Parish, LA': '089',
        'St. Helena Parish, LA': '091',
        'St. James Parish, LA': '093',
        'St. John the Baptist Parish, LA': '095',
        'St. Landry Parish, LA': '097',
        'St. Martin Parish, LA': '099',
        'St. Mary Parish, LA': '101',
        'St. Tammany Parish, LA': '103',
        'Tangipahoa Parish, LA': '105',
        'Tensas Parish, LA': '107',
        'Terrebonne Parish, LA': '109',
        'Union Parish, LA': '111',
        'Vermilion Parish, LA': '113',
        'Vernon Parish, LA': '115',
        'Washington Parish, LA': '117',
        'Webster Parish, LA': '119',
        'West Baton Rouge Parish, LA': '121',
        'West Carroll Parish, LA': '123',
        'West Feliciana Parish, LA': '125',
        'Winn Parish, LA': '127'},
  23:  {'--All--': '%',
        'Androscoggin County, ME': '001',
        'Aroostook County, ME': '003',
        'Cumberland County, ME': '005',
        'Franklin County, ME': '007',
        'Hancock County, ME': '009',
        'Kennebec County, ME': '011',
        'Knox County, ME': '013',
        'Lincoln County, ME': '015',
        'Oxford County, ME': '017',
        'Penobscot County, ME': '019',
        'Piscataquis County, ME': '021',
        'Sagadahoc County, ME': '023',
        'Somerset County, ME': '025',
        'Waldo County, ME': '027',
        'Washington County, ME': '029',
        'York County, ME': '031'},
  24:  {'--All--': '%',
        'Allegany County, MD': '001',
        'Anne Arundel County, MD': '003',
        'Baltimore County, MD': '005',
        'Baltimore city, MD': '510',
        'Calvert County, MD': '009',
        'Caroline County, MD': '011',
        'Carroll County, MD': '013',
        'Cecil County, MD': '015',
        'Charles County, MD': '017',
        'Dorchester County, MD': '019',
        'Frederick County, MD': '021',
        'Garrett County, MD': '023',
        'Harford County, MD': '025',
        'Howard County, MD': '027',
        'Kent County, MD': '029',
        'Montgomery County, MD': '031',
        "Prince George's County, MD": '033',
        "Queen Anne's County, MD": '035',
        'Somerset County, MD': '039',
        "St. Mary's County, MD": '037',
        'Talbot County, MD': '041',
        'Washington County, MD': '043',
        'Wicomico County, MD': '045',
        'Worcester County, MD': '047'},
  25:  {'--All--': '%',
        'Barnstable County, MA': '001',
        'Berkshire County, MA': '003',
        'Bristol County, MA': '005',
        'Dukes County, MA': '007',
        'Essex County, MA': '009',
        'Franklin County, MA': '011',
        'Hampden County, MA': '013',
        'Hampshire County, MA': '015',
        'Middlesex County, MA': '017',
        'Nantucket County/town, MA': '019',
        'Norfolk County, MA': '021',
        'Plymouth County, MA': '023',
        'Suffolk County, MA': '025',
        'Worcester County, MA': '027'},
  26:  {'--All--': '%',
        'Alcona County, MI': '001',
        'Alger County, MI': '003',
        'Allegan County, MI': '005',
        'Alpena County, MI': '007',
        'Antrim County, MI': '009',
        'Arenac County, MI': '011',
        'Baraga County, MI': '013',
        'Barry County, MI': '015',
        'Bay County, MI': '017',
        'Benzie County, MI': '019',
        'Berrien County, MI': '021',
        'Branch County, MI': '023',
        'Calhoun County, MI': '025',
        'Cass County, MI': '027',
        'Charlevoix County, MI': '029',
        'Cheboygan County, MI': '031',
        'Chippewa County, MI': '033',
        'Clare County, MI': '035',
        'Clinton County, MI': '037',
        'Crawford County, MI': '039',
        'Delta County, MI': '041',
        'Dickinson County, MI': '043',
        'Eaton County, MI': '045',
        'Emmet County, MI': '047',
        'Genesee County, MI': '049',
        'Gladwin County, MI': '051',
        'Gogebic County, MI': '053',
        'Grand Traverse County, MI': '055',
        'Gratiot County, MI': '057',
        'Hillsdale County, MI': '059',
        'Houghton County, MI': '061',
        'Huron County, MI': '063',
        'Ingham County, MI': '065',
        'Ionia County, MI': '067',
        'Iosco County, MI': '069',
        'Iron County, MI': '071',
        'Isabella County, MI': '073',
        'Jackson County, MI': '075',
        'Kalamazoo County, MI': '077',
        'Kalkaska County, MI': '079',
        'Kent County, MI': '081',
        'Keweenaw County, MI': '083',
        'Lake County, MI': '085',
        'Lapeer County, MI': '087',
        'Leelanau County, MI': '089',
        'Lenawee County, MI': '091',
        'Livingston County, MI': '093',
        'Luce County, MI': '095',
        'Mackinac County, MI': '097',
        'Macomb County, MI': '099',
        'Manistee County, MI': '101',
        'Marquette County, MI': '103',
        'Mason County, MI': '105',
        'Mecosta County, MI': '107',
        'Menominee County, MI': '109',
        'Midland County, MI': '111',
        'Missaukee County, MI': '113',
        'Monroe County, MI': '115',
        'Montcalm County, MI': '117',
        'Montmorency County, MI': '119',
        'Muskegon County, MI': '121',
        'Newaygo County, MI': '123',
        'Oakland County, MI': '125',
        'Oceana County, MI': '127',
        'Ogemaw County, MI': '129',
        'Ontonagon County, MI': '131',
        'Osceola County, MI': '133',
        'Oscoda County, MI': '135',
        'Otsego County, MI': '137',
        'Ottawa County, MI': '139',
        'Presque Isle County, MI': '141',
        'Roscommon County, MI': '143',
        'Saginaw County, MI': '145',
        'Sanilac County, MI': '151',
        'Schoolcraft County, MI': '153',
        'Shiawassee County, MI': '155',
        'St. Clair County, MI': '147',
        'St. Joseph County, MI': '149',
        'Tuscola County, MI': '157',
        'Van Buren County, MI': '159',
        'Washtenaw County, MI': '161',
        'Wayne County, MI': '163',
        'Wexford County, MI': '165'},
  27:  {'--All--': '%',
        'Aitkin County, MN': '001',
        'Anoka County, MN': '003',
        'Becker County, MN': '005',
        'Beltrami County, MN': '007',
        'Benton County, MN': '009',
        'Big Stone County, MN': '011',
        'Blue Earth County, MN': '013',
        'Brown County, MN': '015',
        'Carlton County, MN': '017',
        'Carver County, MN': '019',
        'Cass County, MN': '021',
        'Chippewa County, MN': '023',
        'Chisago County, MN': '025',
        'Clay County, MN': '027',
        'Clearwater County, MN': '029',
        'Cook County, MN': '031',
        'Cottonwood County, MN': '033',
        'Crow Wing County, MN': '035',
        'Dakota County, MN': '037',
        'Dodge County, MN': '039',
        'Douglas County, MN': '041',
        'Faribault County, MN': '043',
        'Fillmore County, MN': '045',
        'Freeborn County, MN': '047',
        'Goodhue County, MN': '049',
        'Grant County, MN': '051',
        'Hennepin County, MN': '053',
        'Houston County, MN': '055',
        'Hubbard County, MN': '057',
        'Isanti County, MN': '059',
        'Itasca County, MN': '061',
        'Jackson County, MN': '063',
        'Kanabec County, MN': '065',
        'Kandiyohi County, MN': '067',
        'Kittson County, MN': '069',
        'Koochiching County, MN': '071',
        'Lac qui Parle County, MN': '073',
        'Lake County, MN': '075',
        'Lake of the Woods County, MN': '077',
        'Le Sueur County, MN': '079',
        'Lincoln County, MN': '081',
        'Lyon County, MN': '083',
        'Mahnomen County, MN': '087',
        'Marshall County, MN': '089',
        'Martin County, MN': '091',
        'McLeod County, MN': '085',
        'Meeker County, MN': '093',
        'Mille Lacs County, MN': '095',
        'Morrison County, MN': '097',
        'Mower County, MN': '099',
        'Murray County, MN': '101',
        'Nicollet County, MN': '103',
        'Nobles County, MN': '105',
        'Norman County, MN': '107',
        'Olmsted County, MN': '109',
        'Otter Tail County, MN': '111',
        'Pennington County, MN': '113',
        'Pine County, MN': '115',
        'Pipestone County, MN': '117',
        'Polk County, MN': '119',
        'Pope County, MN': '121',
        'Ramsey County, MN': '123',
        'Red Lake County, MN': '125',
        'Redwood County, MN': '127',
        'Renville County, MN': '129',
        'Rice County, MN': '131',
        'Rock County, MN': '133',
        'Roseau County, MN': '135',
        'Scott County, MN': '139',
        'Sherburne County, MN': '141',
        'Sibley County, MN': '143',
        'St. Louis County, MN': '137',
        'Stearns County, MN': '145',
        'Steele County, MN': '147',
        'Stevens County, MN': '149',
        'Swift County, MN': '151',
        'Todd County, MN': '153',
        'Traverse County, MN': '155',
        'Wabasha County, MN': '157',
        'Wadena County, MN': '159',
        'Waseca County, MN': '161',
        'Washington County, MN': '163',
        'Watonwan County, MN': '165',
        'Wilkin County, MN': '167',
        'Winona County, MN': '169',
        'Wright County, MN': '171',
        'Yellow Medicine County, MN': '173'},
  28:  {'--All--': '%',
        'Adams County, MS': '001',
        'Alcorn County, MS': '003',
        'Amite County, MS': '005',
        'Attala County, MS': '007',
        'Benton County, MS': '009',
        'Bolivar County, MS': '011',
        'Calhoun County, MS': '013',
        'Carroll County, MS': '015',
        'Chickasaw County, MS': '017',
        'Choctaw County, MS': '019',
        'Claiborne County, MS': '021',
        'Clarke County, MS': '023',
        'Clay County, MS': '025',
        'Coahoma County, MS': '027',
        'Copiah County, MS': '029',
        'Covington County, MS': '031',
        'DeSoto County, MS': '033',
        'Forrest County, MS': '035',
        'Franklin County, MS': '037',
        'George County, MS': '039',
        'Greene County, MS': '041',
        'Grenada County, MS': '043',
        'Hancock County, MS': '045',
        'Harrison County, MS': '047',
        'Hinds County, MS': '049',
        'Holmes County, MS': '051',
        'Humphreys County, MS': '053',
        'Issaquena County, MS': '055',
        'Itawamba County, MS': '057',
        'Jackson County, MS': '059',
        'Jasper County, MS': '061',
        'Jefferson County, MS': '063',
        'Jefferson Davis County, MS': '065',
        'Jones County, MS': '067',
        'Kemper County, MS': '069',
        'Lafayette County, MS': '071',
        'Lamar County, MS': '073',
        'Lauderdale County, MS': '075',
        'Lawrence County, MS': '077',
        'Leake County, MS': '079',
        'Lee County, MS': '081',
        'Leflore County, MS': '083',
        'Lincoln County, MS': '085',
        'Lowndes County, MS': '087',
        'Madison County, MS': '089',
        'Marion County, MS': '091',
        'Marshall County, MS': '093',
        'Monroe County, MS': '095',
        'Montgomery County, MS': '097',
        'Neshoba County, MS': '099',
        'Newton County, MS': '101',
        'Noxubee County, MS': '103',
        'Oktibbeha County, MS': '105',
        'Panola County, MS': '107',
        'Pearl River County, MS': '109',
        'Perry County, MS': '111',
        'Pike County, MS': '113',
        'Pontotoc County, MS': '115',
        'Prentiss County, MS': '117',
        'Quitman County, MS': '119',
        'Rankin County, MS': '121',
        'Scott County, MS': '123',
        'Sharkey County, MS': '125',
        'Simpson County, MS': '127',
        'Smith County, MS': '129',
        'Stone County, MS': '131',
        'Sunflower County, MS': '133',
        'Tallahatchie County, MS': '135',
        'Tate County, MS': '137',
        'Tippah County, MS': '139',
        'Tishomingo County, MS': '141',
        'Tunica County, MS': '143',
        'Union County, MS': '145',
        'Walthall County, MS': '147',
        'Warren County, MS': '149',
        'Washington County, MS': '151',
        'Wayne County, MS': '153',
        'Webster County, MS': '155',
        'Wilkinson County, MS': '157',
        'Winston County, MS': '159',
        'Yalobusha County, MS': '161',
        'Yazoo County, MS': '163'},
  29:  {'--All--': '%',
        'Adair County, MO': '001',
        'Andrew County, MO': '003',
        'Atchison County, MO': '005',
        'Audrain County, MO': '007',
        'Barry County, MO': '009',
        'Barton County, MO': '011',
        'Bates County, MO': '013',
        'Benton County, MO': '015',
        'Bollinger County, MO': '017',
        'Boone County, MO': '019',
        'Buchanan County, MO': '021',
        'Butler County, MO': '023',
        'Caldwell County, MO': '025',
        'Callaway County, MO': '027',
        'Camden County, MO': '029',
        'Cape Girardeau County, MO': '031',
        'Carroll County, MO': '033',
        'Carter County, MO': '035',
        'Cass County, MO': '037',
        'Cedar County, MO': '039',
        'Chariton County, MO': '041',
        'Christian County, MO': '043',
        'Clark County, MO': '045',
        'Clay County, MO': '047',
        'Clinton County, MO': '049',
        'Cole County, MO': '051',
        'Cooper County, MO': '053',
        'Crawford County, MO': '055',
        'Dade County, MO': '057',
        'Dallas County, MO': '059',
        'Daviess County, MO': '061',
        'DeKalb County, MO': '063',
        'Dent County, MO': '065',
        'Douglas County, MO': '067',
        'Dunklin County, MO': '069',
        'Franklin County, MO': '071',
        'Gasconade County, MO': '073',
        'Gentry County, MO': '075',
        'Greene County, MO': '077',
        'Grundy County, MO': '079',
        'Harrison County, MO': '081',
        'Henry County, MO': '083',
        'Hickory County, MO': '085',
        'Holt County, MO': '087',
        'Howard County, MO': '089',
        'Howell County, MO': '091',
        'Iron County, MO': '093',
        'Jackson County, MO': '095',
        'Jasper County, MO': '097',
        'Jefferson County, MO': '099',
        'Johnson County, MO': '101',
        'Knox County, MO': '103',
        'Laclede County, MO': '105',
        'Lafayette County, MO': '107',
        'Lawrence County, MO': '109',
        'Lewis County, MO': '111',
        'Lincoln County, MO': '113',
        'Linn County, MO': '115',
        'Livingston County, MO': '117',
        'Macon County, MO': '121',
        'Madison County, MO': '123',
        'Maries County, MO': '125',
        'Marion County, MO': '127',
        'McDonald County, MO': '119',
        'Mercer County, MO': '129',
        'Miller County, MO': '131',
        'Mississippi County, MO': '133',
        'Moniteau County, MO': '135',
        'Monroe County, MO': '137',
        'Montgomery County, MO': '139',
        'Morgan County, MO': '141',
        'New Madrid County, MO': '143',
        'Newton County, MO': '145',
        'Nodaway County, MO': '147',
        'Oregon County, MO': '149',
        'Osage County, MO': '151',
        'Ozark County, MO': '153',
        'Pemiscot County, MO': '155',
        'Perry County, MO': '157',
        'Pettis County, MO': '159',
        'Phelps County, MO': '161',
        'Pike County, MO': '163',
        'Platte County, MO': '165',
        'Polk County, MO': '167',
        'Pulaski County, MO': '169',
        'Putnam County, MO': '171',
        'Ralls County, MO': '173',
        'Randolph County, MO': '175',
        'Ray County, MO': '177',
        'Reynolds County, MO': '179',
        'Ripley County, MO': '181',
        'Saline County, MO': '195',
        'Schuyler County, MO': '197',
        'Scotland County, MO': '199',
        'Scott County, MO': '201',
        'Shannon County, MO': '203',
        'Shelby County, MO': '205',
        'St. Charles County, MO': '183',
        'St. Clair County, MO': '185',
        'St. Francois County, MO': '187',
        'St. Louis County, MO': '189',
        'St. Louis city, MO': '510',
        'Ste. Genevieve County, MO': '186',
        'Stoddard County, MO': '207',
        'Stone County, MO': '209',
        'Sullivan County, MO': '211',
        'Taney County, MO': '213',
        'Texas County, MO': '215',
        'Vernon County, MO': '217',
        'Warren County, MO': '219',
        'Washington County, MO': '221',
        'Wayne County, MO': '223',
        'Webster County, MO': '225',
        'Worth County, MO': '227',
        'Wright County, MO': '229'},
  30:  {'--All--': '%',
        'Beaverhead County, MT': '001',
        'Big Horn County, MT': '003',
        'Blaine County, MT': '005',
        'Broadwater County, MT': '007',
        'Carbon County, MT': '009',
        'Carter County, MT': '011',
        'Cascade County, MT': '013',
        'Chouteau County, MT': '015',
        'Custer County, MT': '017',
        'Daniels County, MT': '019',
        'Dawson County, MT': '021',
        'Deer Lodge County, MT': '023',
        'Fallon County, MT': '025',
        'Fergus County, MT': '027',
        'Flathead County, MT': '029',
        'Gallatin County, MT': '031',
        'Garfield County, MT': '033',
        'Glacier County, MT': '035',
        'Golden Valley County, MT': '037',
        'Granite County, MT': '039',
        'Hill County, MT': '041',
        'Jefferson County, MT': '043',
        'Judith Basin County, MT': '045',
        'Lake County, MT': '047',
        'Lewis and Clark County, MT': '049',
        'Liberty County, MT': '051',
        'Lincoln County, MT': '053',
        'Madison County, MT': '057',
        'McCone County, MT': '055',
        'Meagher County, MT': '059',
        'Mineral County, MT': '061',
        'Missoula County, MT': '063',
        'Musselshell County, MT': '065',
        'Park County, MT': '067',
        'Petroleum County, MT': '069',
        'Phillips County, MT': '071',
        'Pondera County, MT': '073',
        'Powder River County, MT': '075',
        'Powell County, MT': '077',
        'Prairie County, MT': '079',
        'Ravalli County, MT': '081',
        'Richland County, MT': '083',
        'Roosevelt County, MT': '085',
        'Rosebud County, MT': '087',
        'Sanders County, MT': '089',
        'Sheridan County, MT': '091',
        'Silver Bow County, MT': '093',
        'Stillwater County, MT': '095',
        'Sweet Grass County, MT': '097',
        'Teton County, MT': '099',
        'Toole County, MT': '101',
        'Treasure County, MT': '103',
        'Valley County, MT': '105',
        'Wheatland County, MT': '107',
        'Wibaux County, MT': '109',
        'Yellowstone County, MT': '111'},
  31:  {'--All--': '%',
        'Adams County, NE': '001',
        'Antelope County, NE': '003',
        'Arthur County, NE': '005',
        'Banner County, NE': '007',
        'Blaine County, NE': '009',
        'Boone County, NE': '011',
        'Box Butte County, NE': '013',
        'Boyd County, NE': '015',
        'Brown County, NE': '017',
        'Buffalo County, NE': '019',
        'Burt County, NE': '021',
        'Butler County, NE': '023',
        'Cass County, NE': '025',
        'Cedar County, NE': '027',
        'Chase County, NE': '029',
        'Cherry County, NE': '031',
        'Cheyenne County, NE': '033',
        'Clay County, NE': '035',
        'Colfax County, NE': '037',
        'Cuming County, NE': '039',
        'Custer County, NE': '041',
        'Dakota County, NE': '043',
        'Dawes County, NE': '045',
        'Dawson County, NE': '047',
        'Deuel County, NE': '049',
        'Dixon County, NE': '051',
        'Dodge County, NE': '053',
        'Douglas County, NE': '055',
        'Dundy County, NE': '057',
        'Fillmore County, NE': '059',
        'Franklin County, NE': '061',
        'Frontier County, NE': '063',
        'Furnas County, NE': '065',
        'Gage County, NE': '067',
        'Garden County, NE': '069',
        'Garfield County, NE': '071',
        'Gosper County, NE': '073',
        'Grant County, NE': '075',
        'Greeley County, NE': '077',
        'Hall County, NE': '079',
        'Hamilton County, NE': '081',
        'Harlan County, NE': '083',
        'Hayes County, NE': '085',
        'Hitchcock County, NE': '087',
        'Holt County, NE': '089',
        'Hooker County, NE': '091',
        'Howard County, NE': '093',
        'Jefferson County, NE': '095',
        'Johnson County, NE': '097',
        'Kearney County, NE': '099',
        'Keith County, NE': '101',
        'Keya Paha County, NE': '103',
        'Kimball County, NE': '105',
        'Knox County, NE': '107',
        'Lancaster County, NE': '109',
        'Lincoln County, NE': '111',
        'Logan County, NE': '113',
        'Loup County, NE': '115',
        'Madison County, NE': '119',
        'McPherson County, NE': '117',
        'Merrick County, NE': '121',
        'Morrill County, NE': '123',
        'Nance County, NE': '125',
        'Nemaha County, NE': '127',
        'Nuckolls County, NE': '129',
        'Otoe County, NE': '131',
        'Pawnee County, NE': '133',
        'Perkins County, NE': '135',
        'Phelps County, NE': '137',
        'Pierce County, NE': '139',
        'Platte County, NE': '141',
        'Polk County, NE': '143',
        'Red Willow County, NE': '145',
        'Richardson County, NE': '147',
        'Rock County, NE': '149',
        'Saline County, NE': '151',
        'Sarpy County, NE': '153',
        'Saunders County, NE': '155',
        'Scotts Bluff County, NE': '157',
        'Seward County, NE': '159',
        'Sheridan County, NE': '161',
        'Sherman County, NE': '163',
        'Sioux County, NE': '165',
        'Stanton County, NE': '167',
        'Thayer County, NE': '169',
        'Thomas County, NE': '171',
        'Thurston County, NE': '173',
        'Valley County, NE': '175',
        'Washington County, NE': '177',
        'Wayne County, NE': '179',
        'Webster County, NE': '181',
        'Wheeler County, NE': '183',
        'York County, NE': '185'},
  32:  {'--All--': '%',
        'Carson City, NV': '510',
        'Churchill County, NV': '001',
        'Clark County, NV': '003',
        'Douglas County, NV': '005',
        'Elko County, NV': '007',
        'Esmeralda County, NV': '009',
        'Eureka County, NV': '011',
        'Humboldt County, NV': '013',
        'Lander County, NV': '015',
        'Lincoln County, NV': '017',
        'Lyon County, NV': '019',
        'Mineral County, NV': '021',
        'Nye County, NV': '023',
        'Pershing County, NV': '027',
        'Storey County, NV': '029',
        'Washoe County, NV': '031',
        'White Pine County, NV': '033'},
  33:  {'--All--': '%',
        'Belknap County, NH': '001',
        'Carroll County, NH': '003',
        'Cheshire County, NH': '005',
        'Coos County, NH': '007',
        'Grafton County, NH': '009',
        'Hillsborough County, NH': '011',
        'Merrimack County, NH': '013',
        'Rockingham County, NH': '015',
        'Strafford County, NH': '017',
        'Sullivan County, NH': '019'},
  34:  {'--All--': '%',
        'Atlantic County, NJ': '001',
        'Bergen County, NJ': '003',
        'Burlington County, NJ': '005',
        'Camden County, NJ': '007',
        'Cape May County, NJ': '009',
        'Cumberland County, NJ': '011',
        'Essex County, NJ': '013',
        'Gloucester County, NJ': '015',
        'Hudson County, NJ': '017',
        'Hunterdon County, NJ': '019',
        'Mercer County, NJ': '021',
        'Middlesex County, NJ': '023',
        'Monmouth County, NJ': '025',
        'Morris County, NJ': '027',
        'Ocean County, NJ': '029',
        'Passaic County, NJ': '031',
        'Salem County, NJ': '033',
        'Somerset County, NJ': '035',
        'Sussex County, NJ': '037',
        'Union County, NJ': '039',
        'Warren County, NJ': '041'},
  35:  {'--All--': '%',
        'Bernalillo County, NM': '001',
        'Catron County, NM': '003',
        'Chaves County, NM': '005',
        'Cibola County, NM': '006',
        'Colfax County, NM': '007',
        'Curry County, NM': '009',
        'DeBaca County, NM': '011',
        'Dona Ana County, NM': '013',
        'Eddy County, NM': '015',
        'Grant County, NM': '017',
        'Guadalupe County, NM': '019',
        'Harding County, NM': '021',
        'Hidalgo County, NM': '023',
        'Lea County, NM': '025',
        'Lincoln County, NM': '027',
        'Los Alamos County, NM': '028',
        'Luna County, NM': '029',
        'McKinley County, NM': '031',
        'Mora County, NM': '033',
        'Otero County, NM': '035',
        'Quay County, NM': '037',
        'Rio Arriba County, NM': '039',
        'Roosevelt County, NM': '041',
        'San Juan County, NM': '045',
        'San Miguel County, NM': '047',
        'Sandoval County, NM': '043',
        'Santa Fe County, NM': '049',
        'Sierra County, NM': '051',
        'Socorro County, NM': '053',
        'Taos County, NM': '055',
        'Torrance County, NM': '057',
        'Union County, NM': '059',
        'Valencia County, NM': '061'},
  36:  {'--All--': '%',
        'Albany County, NY': '001',
        'Allegany County, NY': '003',
        'Bronx County, NY': '005',
        'Broome County, NY': '007',
        'Cattaraugus County, NY': '009',
        'Cayuga County, NY': '011',
        'Chautauqua County, NY': '013',
        'Chemung County, NY': '015',
        'Chenango County, NY': '017',
        'Clinton County, NY': '019',
        'Columbia County, NY': '021',
        'Cortland County, NY': '023',
        'Delaware County, NY': '025',
        'Dutchess County, NY': '027',
        'Erie County, NY': '029',
        'Essex County, NY': '031',
        'Franklin County, NY': '033',
        'Fulton County, NY': '035',
        'Genesee County, NY': '037',
        'Greene County, NY': '039',
        'Hamilton County, NY': '041',
        'Herkimer County, NY': '043',
        'Jefferson County, NY': '045',
        'Kings County, NY': '047',
        'Lewis County, NY': '049',
        'Livingston County, NY': '051',
        'Madison County, NY': '053',
        'Monroe County, NY': '055',
        'Montgomery County, NY': '057',
        'Nassau County, NY': '059',
        'New York County, NY': '061',
        'Niagara County, NY': '063',
        'Oneida County, NY': '065',
        'Onondaga County, NY': '067',
        'Ontario County, NY': '069',
        'Orange County, NY': '071',
        'Orleans County, NY': '073',
        'Oswego County, NY': '075',
        'Otsego County, NY': '077',
        'Putnam County, NY': '079',
        'Queens County, NY': '081',
        'Rensselaer County, NY': '083',
        'Richmond County, NY': '085',
        'Rockland County, NY': '087',
        'Saratoga County, NY': '091',
        'Schenectady County, NY': '093',
        'Schoharie County, NY': '095',
        'Schuyler County, NY': '097',
        'Seneca County, NY': '099',
        'St. Lawrence County, NY': '089',
        'Steuben County, NY': '101',
        'Suffolk County, NY': '103',
        'Sullivan County, NY': '105',
        'Tioga County, NY': '107',
        'Tompkins County, NY': '109',
        'Ulster County, NY': '111',
        'Warren County, NY': '113',
        'Washington County, NY': '115',
        'Wayne County, NY': '117',
        'Westchester County, NY': '119',
        'Wyoming County, NY': '121',
        'Yates County, NY': '123'},
  37:  {'--All--': '%',
        'Alamance County, NC': '001',
        'Alexander County, NC': '003',
        'Alleghany County, NC': '005',
        'Anson County, NC': '007',
        'Ashe County, NC': '009',
        'Avery County, NC': '011',
        'Beaufort County, NC': '013',
        'Bertie County, NC': '015',
        'Bladen County, NC': '017',
        'Brunswick County, NC': '019',
        'Buncombe County, NC': '021',
        'Burke County, NC': '023',
        'Cabarrus County, NC': '025',
        'Caldwell County, NC': '027',
        'Camden County, NC': '029',
        'Carteret County, NC': '031',
        'Caswell County, NC': '033',
        'Catawba County, NC': '035',
        'Chatham County, NC': '037',
        'Cherokee County, NC': '039',
        'Chowan County, NC': '041',
        'Clay County, NC': '043',
        'Cleveland County, NC': '045',
        'Columbus County, NC': '047',
        'Craven County, NC': '049',
        'Cumberland County, NC': '051',
        'Currituck County, NC': '053',
        'Dare County, NC': '055',
        'Davidson County, NC': '057',
        'Davie County, NC': '059',
        'Duplin County, NC': '061',
        'Durham County, NC': '063',
        'Edgecombe County, NC': '065',
        'Forsyth County, NC': '067',
        'Franklin County, NC': '069',
        'Gaston County, NC': '071',
        'Gates County, NC': '073',
        'Graham County, NC': '075',
        'Granville County, NC': '077',
        'Greene County, NC': '079',
        'Guilford County, NC': '081',
        'Halifax County, NC': '083',
        'Harnett County, NC': '085',
        'Haywood County, NC': '087',
        'Henderson County, NC': '089',
        'Hertford County, NC': '091',
        'Hoke County, NC': '093',
        'Hyde County, NC': '095',
        'Iredell County, NC': '097',
        'Jackson County, NC': '099',
        'Johnston County, NC': '101',
        'Jones County, NC': '103',
        'Lee County, NC': '105',
        'Lenoir County, NC': '107',
        'Lincoln County, NC': '109',
        'Macon County, NC': '113',
        'Madison County, NC': '115',
        'Martin County, NC': '117',
        'McDowell County, NC': '111',
        'Mecklenburg County, NC': '119',
        'Mitchell County, NC': '121',
        'Montgomery County, NC': '123',
        'Moore County, NC': '125',
        'Nash County, NC': '127',
        'New Hanover County, NC': '129',
        'Northampton County, NC': '131',
        'Onslow County, NC': '133',
        'Orange County, NC': '135',
        'Pamlico County, NC': '137',
        'Pasquotank County, NC': '139',
        'Pender County, NC': '141',
        'Perquimans County, NC': '143',
        'Person County, NC': '145',
        'Pitt County, NC': '147',
        'Polk County, NC': '149',
        'Randolph County, NC': '151',
        'Richmond County, NC': '153',
        'Robeson County, NC': '155',
        'Rockingham County, NC': '157',
        'Rowan County, NC': '159',
        'Rutherford County, NC': '161',
        'Sampson County, NC': '163',
        'Scotland County, NC': '165',
        'Stanly County, NC': '167',
        'Stokes County, NC': '169',
        'Surry County, NC': '171',
        'Swain County, NC': '173',
        'Transylvania County, NC': '175',
        'Tyrrell County, NC': '177',
        'Union County, NC': '179',
        'Vance County, NC': '181',
        'Wake County, NC': '183',
        'Warren County, NC': '185',
        'Washington County, NC': '187',
        'Watauga County, NC': '189',
        'Wayne County, NC': '191',
        'Wilkes County, NC': '193',
        'Wilson County, NC': '195',
        'Yadkin County, NC': '197',
        'Yancey County, NC': '199'},
  38:  {'--All--': '%',
        'Adams County, ND': '001',
        'Barnes County, ND': '003',
        'Benson County, ND': '005',
        'Billings County, ND': '007',
        'Bottineau County, ND': '009',
        'Bowman County, ND': '011',
        'Burke County, ND': '013',
        'Burleigh County, ND': '015',
        'Cass County, ND': '017',
        'Cavalier County, ND': '019',
        'Dickey County, ND': '021',
        'Divide County, ND': '023',
        'Dunn County, ND': '025',
        'Eddy County, ND': '027',
        'Emmons County, ND': '029',
        'Foster County, ND': '031',
        'Golden Valley County, ND': '033',
        'Grand Forks County, ND': '035',
        'Grant County, ND': '037',
        'Griggs County, ND': '039',
        'Hettinger County, ND': '041',
        'Kidder County, ND': '043',
        'LaMoure County, ND': '045',
        'Logan County, ND': '047',
        'McHenry County, ND': '049',
        'McIntosh County, ND': '051',
        'McKenzie County, ND': '053',
        'McLean County, ND': '055',
        'Mercer County, ND': '057',
        'Morton County, ND': '059',
        'Mountrail County, ND': '061',
        'Nelson County, ND': '063',
        'Oliver County, ND': '065',
        'Pembina County, ND': '067',
        'Pierce County, ND': '069',
        'Ramsey County, ND': '071',
        'Ransom County, ND': '073',
        'Renville County, ND': '075',
        'Richland County, ND': '077',
        'Rolette County, ND': '079',
        'Sargent County, ND': '081',
        'Sheridan County, ND': '083',
        'Sioux County, ND': '085',
        'Slope County, ND': '087',
        'Stark County, ND': '089',
        'Steele County, ND': '091',
        'Stutsman County, ND': '093',
        'Towner County, ND': '095',
        'Traill County, ND': '097',
        'Walsh County, ND': '099',
        'Ward County, ND': '101',
        'Wells County, ND': '103',
        'Williams County, ND': '105'},
  39:  {'--All--': '%',
        'Adams County, OH': '001',
        'Allen County, OH': '003',
        'Ashland County, OH': '005',
        'Ashtabula County, OH': '007',
        'Athens County, OH': '009',
        'Auglaize County, OH': '011',
        'Belmont County, OH': '013',
        'Brown County, OH': '015',
        'Butler County, OH': '017',
        'Carroll County, OH': '019',
        'Champaign County, OH': '021',
        'Clark County, OH': '023',
        'Clermont County, OH': '025',
        'Clinton County, OH': '027',
        'Columbiana County, OH': '029',
        'Coshocton County, OH': '031',
        'Crawford County, OH': '033',
        'Cuyahoga County, OH': '035',
        'Darke County, OH': '037',
        'Defiance County, OH': '039',
        'Delaware County, OH': '041',
        'Erie County, OH': '043',
        'Fairfield County, OH': '045',
        'Fayette County, OH': '047',
        'Franklin County, OH': '049',
        'Fulton County, OH': '051',
        'Gallia County, OH': '053',
        'Geauga County, OH': '055',
        'Greene County, OH': '057',
        'Guernsey County, OH': '059',
        'Hamilton County, OH': '061',
        'Hancock County, OH': '063',
        'Hardin County, OH': '065',
        'Harrison County, OH': '067',
        'Henry County, OH': '069',
        'Highland County, OH': '071',
        'Hocking County, OH': '073',
        'Holmes County, OH': '075',
        'Huron County, OH': '077',
        'Jackson County, OH': '079',
        'Jefferson County, OH': '081',
        'Knox County, OH': '083',
        'Lake County, OH': '085',
        'Lawrence County, OH': '087',
        'Licking County, OH': '089',
        'Logan County, OH': '091',
        'Lorain County, OH': '093',
        'Lucas County, OH': '095',
        'Madison County, OH': '097',
        'Mahoning County, OH': '099',
        'Marion County, OH': '101',
        'Medina County, OH': '103',
        'Meigs County, OH': '105',
        'Mercer County, OH': '107',
        'Miami County, OH': '109',
        'Monroe County, OH': '111',
        'Montgomery County, OH': '113',
        'Morgan County, OH': '115',
        'Morrow County, OH': '117',
        'Muskingum County, OH': '119',
        'Noble County, OH': '121',
        'Ottawa County, OH': '123',
        'Paulding County, OH': '125',
        'Perry County, OH': '127',
        'Pickaway County, OH': '129',
        'Pike County, OH': '131',
        'Portage County, OH': '133',
        'Preble County, OH': '135',
        'Putnam County, OH': '137',
        'Richland County, OH': '139',
        'Ross County, OH': '141',
        'Sandusky County, OH': '143',
        'Scioto County, OH': '145',
        'Seneca County, OH': '147',
        'Shelby County, OH': '149',
        'Stark County, OH': '151',
        'Summit County, OH': '153',
        'Trumbull County, OH': '155',
        'Tuscarawas County, OH': '157',
        'Union County, OH': '159',
        'Van Wert County, OH': '161',
        'Vinton County, OH': '163',
        'Warren County, OH': '165',
        'Washington County, OH': '167',
        'Wayne County, OH': '169',
        'Williams County, OH': '171',
        'Wood County, OH': '173',
        'Wyandot County, OH': '175'},
  40:  {'--All--': '%',
        'Adair County, OK': '001',
        'Alfalfa County, OK': '003',
        'Atoka County, OK': '005',
        'Beaver County, OK': '007',
        'Beckham County, OK': '009',
        'Blaine County, OK': '011',
        'Bryan County, OK': '013',
        'Caddo County, OK': '015',
        'Canadian County, OK': '017',
        'Carter County, OK': '019',
        'Cherokee County, OK': '021',
        'Choctaw County, OK': '023',
        'Cimarron County, OK': '025',
        'Cleveland County, OK': '027',
        'Coal County, OK': '029',
        'Comanche County, OK': '031',
        'Cotton County, OK': '033',
        'Craig County, OK': '035',
        'Creek County, OK': '037',
        'Custer County, OK': '039',
        'Delaware County, OK': '041',
        'Dewey County, OK': '043',
        'Ellis County, OK': '045',
        'Garfield County, OK': '047',
        'Garvin County, OK': '049',
        'Grady County, OK': '051',
        'Grant County, OK': '053',
        'Greer County, OK': '055',
        'Harmon County, OK': '057',
        'Harper County, OK': '059',
        'Haskell County, OK': '061',
        'Hughes County, OK': '063',
        'Jackson County, OK': '065',
        'Jefferson County, OK': '067',
        'Johnston County, OK': '069',
        'Kay County, OK': '071',
        'Kingfisher County, OK': '073',
        'Kiowa County, OK': '075',
        'Latimer County, OK': '077',
        'Le Flore County, OK': '079',
        'Lincoln County, OK': '081',
        'Logan County, OK': '083',
        'Love County, OK': '085',
        'Major County, OK': '093',
        'Marshall County, OK': '095',
        'Mayes County, OK': '097',
        'McClain County, OK': '087',
        'McCurtain County, OK': '089',
        'McIntosh County, OK': '091',
        'Murray County, OK': '099',
        'Muskogee County, OK': '101',
        'Noble County, OK': '103',
        'Nowata County, OK': '105',
        'Okfuskee County, OK': '107',
        'Oklahoma County, OK': '109',
        'Okmulgee County, OK': '111',
        'Osage County, OK': '113',
        'Ottawa County, OK': '115',
        'Pawnee County, OK': '117',
        'Payne County, OK': '119',
        'Pittsburg County, OK': '121',
        'Pontotoc County, OK': '123',
        'Pottawatomie County, OK': '125',
        'Pushmataha County, OK': '127',
        'Roger Mills County, OK': '129',
        'Rogers County, OK': '131',
        'Seminole County, OK': '133',
        'Sequoyah County, OK': '135',
        'Stephens County, OK': '137',
        'Texas County, OK': '139',
        'Tillman County, OK': '141',
        'Tulsa County, OK': '143',
        'Wagoner County, OK': '145',
        'Washington County, OK': '147',
        'Washita County, OK': '149',
        'Woods County, OK': '151',
        'Woodward County, OK': '153'},
  41:  {'--All--': '%',
        'Baker County, OR': '001',
        'Benton County, OR': '003',
        'Clackamas County, OR': '005',
        'Clatsop County, OR': '007',
        'Columbia County, OR': '009',
        'Coos County, OR': '011',
        'Crook County, OR': '013',
        'Curry County, OR': '015',
        'Deschutes County, OR': '017',
        'Douglas County, OR': '019',
        'Gilliam County, OR': '021',
        'Grant County, OR': '023',
        'Harney County, OR': '025',
        'Hood River County, OR': '027',
        'Jackson County, OR': '029',
        'Jefferson County, OR': '031',
        'Josephine County, OR': '033',
        'Klamath County, OR': '035',
        'Lake County, OR': '037',
        'Lane County, OR': '039',
        'Lincoln County, OR': '041',
        'Linn County, OR': '043',
        'Malheur County, OR': '045',
        'Marion County, OR': '047',
        'Morrow County, OR': '049',
        'Multnomah County, OR': '051',
        'Polk County, OR': '053',
        'Sherman County, OR': '055',
        'Tillamook County, OR': '057',
        'Umatilla County, OR': '059',
        'Union County, OR': '061',
        'Wallowa County, OR': '063',
        'Wasco County, OR': '065',
        'Washington County, OR': '067',
        'Wheeler County, OR': '069',
        'Yamhill County, OR': '071'},
  42:  {'--All--': '%',
        'Adams County, PA': '001',
        'Allegheny County, PA': '003',
        'Armstrong County, PA': '005',
        'Beaver County, PA': '007',
        'Bedford County, PA': '009',
        'Berks County, PA': '011',
        'Blair County, PA': '013',
        'Bradford County, PA': '015',
        'Bucks County, PA': '017',
        'Butler County, PA': '019',
        'Cambria County, PA': '021',
        'Cameron County, PA': '023',
        'Carbon County, PA': '025',
        'Centre County, PA': '027',
        'Chester County, PA': '029',
        'Clarion County, PA': '031',
        'Clearfield County, PA': '033',
        'Clinton County, PA': '035',
        'Columbia County, PA': '037',
        'Crawford County, PA': '039',
        'Cumberland County, PA': '041',
        'Dauphin County, PA': '043',
        'Delaware County, PA': '045',
        'Elk County, PA': '047',
        'Erie County, PA': '049',
        'Fayette County, PA': '051',
        'Forest County, PA': '053',
        'Franklin County, PA': '055',
        'Fulton County, PA': '057',
        'Greene County, PA': '059',
        'Huntingdon County, PA': '061',
        'Indiana County, PA': '063',
        'Jefferson County, PA': '065',
        'Juniata County, PA': '067',
        'Lackawanna County, PA': '069',
        'Lancaster County, PA': '071',
        'Lawrence County, PA': '073',
        'Lebanon County, PA': '075',
        'Lehigh County, PA': '077',
        'Luzerne County, PA': '079',
        'Lycoming County, PA': '081',
        'McKean County, PA': '083',
        'Mercer County, PA': '085',
        'Mifflin County, PA': '087',
        'Monroe County, PA': '089',
        'Montgomery County, PA': '091',
        'Montour County, PA': '093',
        'Northampton County, PA': '095',
        'Northumberland County, PA': '097',
        'Perry County, PA': '099',
        'Philadelphia County/city, PA': '101',
        'Pike County, PA': '103',
        'Potter County, PA': '105',
        'Schuylkill County, PA': '107',
        'Snyder County, PA': '109',
        'Somerset County, PA': '111',
        'Sullivan County, PA': '113',
        'Susquehanna County, PA': '115',
        'Tioga County, PA': '117',
        'Union County, PA': '119',
        'Venango County, PA': '121',
        'Warren County, PA': '123',
        'Washington County, PA': '125',
        'Wayne County, PA': '127',
        'Westmoreland County, PA': '129',
        'Wyoming County, PA': '131',
        'York County, PA': '133'},
  44:  {'--All--': '%',
        'Bristol County, RI': '001',
        'Kent County, RI': '003',
        'Newport County, RI': '005',
        'Providence County, RI': '007',
        'Washington County, RI': '009'},
  45:  {'--All--': '%',
        'Abbeville County, SC': '001',
        'Aiken County, SC': '003',
        'Allendale County, SC': '005',
        'Anderson County, SC': '007',
        'Bamberg County, SC': '009',
        'Barnwell County, SC': '011',
        'Beaufort County, SC': '013',
        'Berkeley County, SC': '015',
        'Calhoun County, SC': '017',
        'Charleston County, SC': '019',
        'Cherokee County, SC': '021',
        'Chester County, SC': '023',
        'Chesterfield County, SC': '025',
        'Clarendon County, SC': '027',
        'Colleton County, SC': '029',
        'Darlington County, SC': '031',
        'Dillon County, SC': '033',
        'Dorchester County, SC': '035',
        'Edgefield County, SC': '037',
        'Fairfield County, SC': '039',
        'Florence County, SC': '041',
        'Georgetown County, SC': '043',
        'Greenville County, SC': '045',
        'Greenwood County, SC': '047',
        'Hampton County, SC': '049',
        'Horry County, SC': '051',
        'Jasper County, SC': '053',
        'Kershaw County, SC': '055',
        'Lancaster County, SC': '057',
        'Laurens County, SC': '059',
        'Lee County, SC': '061',
        'Lexington County, SC': '063',
        'Marion County, SC': '067',
        'Marlboro County, SC': '069',
        'McCormick County, SC': '065',
        'Newberry County, SC': '071',
        'Oconee County, SC': '073',
        'Orangeburg County, SC': '075',
        'Pickens County, SC': '077',
        'Richland County, SC': '079',
        'Saluda County, SC': '081',
        'Spartanburg County, SC': '083',
        'Sumter County, SC': '085',
        'Union County, SC': '087',
        'Williamsburg County, SC': '089',
        'York County, SC': '091'},
  46:  {'--All--': '%',
        'Aurora County, SD': '003',
        'Beadle County, SD': '005',
        'Bennett County, SD': '007',
        'Bon Homme County, SD': '009',
        'Brookings County, SD': '011',
        'Brown County, SD': '013',
        'Brule County, SD': '015',
        'Buffalo County, SD': '017',
        'Butte County, SD': '019',
        'Campbell County, SD': '021',
        'Charles Mix County, SD': '023',
        'Clark County, SD': '025',
        'Clay County, SD': '027',
        'Codington County, SD': '029',
        'Corson County, SD': '031',
        'Custer County, SD': '033',
        'Davison County, SD': '035',
        'Day County, SD': '037',
        'Deuel County, SD': '039',
        'Dewey County, SD': '041',
        'Douglas County, SD': '043',
        'Edmunds County, SD': '045',
        'Fall River County, SD': '047',
        'Faulk County, SD': '049',
        'Grant County, SD': '051',
        'Gregory County, SD': '053',
        'Haakon County, SD': '055',
        'Hamlin County, SD': '057',
        'Hand County, SD': '059',
        'Hanson County, SD': '061',
        'Harding County, SD': '063',
        'Hughes County, SD': '065',
        'Hutchinson County, SD': '067',
        'Hyde County, SD': '069',
        'Jackson County, SD': '071',
        'Jerauld County, SD': '073',
        'Jones County, SD': '075',
        'Kingsbury County, SD': '077',
        'Lake County, SD': '079',
        'Lawrence County, SD': '081',
        'Lincoln County, SD': '083',
        'Lyman County, SD': '085',
        'Marshall County, SD': '091',
        'McCook County, SD': '087',
        'McPherson County, SD': '089',
        'Meade County, SD': '093',
        'Mellette County, SD': '095',
        'Miner County, SD': '097',
        'Minnehaha County, SD': '099',
        'Moody County, SD': '101',
        'Pennington County, SD': '103',
        'Perkins County, SD': '105',
        'Potter County, SD': '107',
        'Roberts County, SD': '109',
        'Sanborn County, SD': '111',
        'Shannon County, SD': '113',
        'Spink County, SD': '115',
        'Stanley County, SD': '117',
        'Sully County, SD': '119',
        'Todd County, SD': '121',
        'Tripp County, SD': '123',
        'Turner County, SD': '125',
        'Union County, SD': '127',
        'Walworth County, SD': '129',
        'Yankton County, SD': '135',
        'Ziebach County, SD': '137'},
  47:  {'--All--': '%',
        'Anderson County, TN': '001',
        'Bedford County, TN': '003',
        'Benton County, TN': '005',
        'Bledsoe County, TN': '007',
        'Blount County, TN': '009',
        'Bradley County, TN': '011',
        'Campbell County, TN': '013',
        'Cannon County, TN': '015',
        'Carroll County, TN': '017',
        'Carter County, TN': '019',
        'Cheatham County, TN': '021',
        'Chester County, TN': '023',
        'Claiborne County, TN': '025',
        'Clay County, TN': '027',
        'Cocke County, TN': '029',
        'Coffee County, TN': '031',
        'Crockett County, TN': '033',
        'Cumberland County, TN': '035',
        'Davidson County, TN': '037',
        'DeKalb County, TN': '041',
        'Decatur County, TN': '039',
        'Dickson County, TN': '043',
        'Dyer County, TN': '045',
        'Fayette County, TN': '047',
        'Fentress County, TN': '049',
        'Franklin County, TN': '051',
        'Gibson County, TN': '053',
        'Giles County, TN': '055',
        'Grainger County, TN': '057',
        'Greene County, TN': '059',
        'Grundy County, TN': '061',
        'Hamblen County, TN': '063',
        'Hamilton County, TN': '065',
        'Hancock County, TN': '067',
        'Hardeman County, TN': '069',
        'Hardin County, TN': '071',
        'Hawkins County, TN': '073',
        'Haywood County, TN': '075',
        'Henderson County, TN': '077',
        'Henry County, TN': '079',
        'Hickman County, TN': '081',
        'Houston County, TN': '083',
        'Humphreys County, TN': '085',
        'Jackson County, TN': '087',
        'Jefferson County, TN': '089',
        'Johnson County, TN': '091',
        'Knox County, TN': '093',
        'Lake County, TN': '095',
        'Lauderdale County, TN': '097',
        'Lawrence County, TN': '099',
        'Lewis County, TN': '101',
        'Lincoln County, TN': '103',
        'Loudon County, TN': '105',
        'Macon County, TN': '111',
        'Madison County, TN': '113',
        'Marion County, TN': '115',
        'Marshall County, TN': '117',
        'Maury County, TN': '119',
        'McMinn County, TN': '107',
        'McNairy County, TN': '109',
        'Meigs County, TN': '121',
        'Monroe County, TN': '123',
        'Montgomery County, TN': '125',
        'Moore County, TN': '127',
        'Morgan County, TN': '129',
        'Obion County, TN': '131',
        'Overton County, TN': '133',
        'Perry County, TN': '135',
        'Pickett County, TN': '137',
        'Polk County, TN': '139',
        'Putnam County, TN': '141',
        'Rhea County, TN': '143',
        'Roane County, TN': '145',
        'Robertson County, TN': '147',
        'Rutherford County, TN': '149',
        'Scott County, TN': '151',
        'Sequatchie County, TN': '153',
        'Sevier County, TN': '155',
        'Shelby County, TN': '157',
        'Smith County, TN': '159',
        'Stewart County, TN': '161',
        'Sullivan County, TN': '163',
        'Sumner County, TN': '165',
        'Tipton County, TN': '167',
        'Trousdale County, TN': '169',
        'Unicoi County, TN': '171',
        'Union County, TN': '173',
        'Van Buren County, TN': '175',
        'Warren County, TN': '177',
        'Washington County, TN': '179',
        'Wayne County, TN': '181',
        'Weakley County, TN': '183',
        'White County, TN': '185',
        'Williamson County, TN': '187',
        'Wilson County, TN': '189'},
  48:  {'--All--': '%',
        'Anderson County, TX': '001',
        'Andrews County, TX': '003',
        'Angelina County, TX': '005',
        'Aransas County, TX': '007',
        'Archer County, TX': '009',
        'Armstrong County, TX': '011',
        'Atascosa County, TX': '013',
        'Austin County, TX': '015',
        'Bailey County, TX': '017',
        'Bandera County, TX': '019',
        'Bastrop County, TX': '021',
        'Baylor County, TX': '023',
        'Bee County, TX': '025',
        'Bell County, TX': '027',
        'Bexar County, TX': '029',
        'Blanco County, TX': '031',
        'Borden County, TX': '033',
        'Bosque County, TX': '035',
        'Bowie County, TX': '037',
        'Brazoria County, TX': '039',
        'Brazos County, TX': '041',
        'Brewster County, TX': '043',
        'Briscoe County, TX': '045',
        'Brooks County, TX': '047',
        'Brown County, TX': '049',
        'Burleson County, TX': '051',
        'Burnet County, TX': '053',
        'Caldwell County, TX': '055',
        'Calhoun County, TX': '057',
        'Callahan County, TX': '059',
        'Cameron County, TX': '061',
        'Camp County, TX': '063',
        'Carson County, TX': '065',
        'Cass County, TX': '067',
        'Castro County, TX': '069',
        'Chambers County, TX': '071',
        'Cherokee County, TX': '073',
        'Childress County, TX': '075',
        'Clay County, TX': '077',
        'Cochran County, TX': '079',
        'Coke County, TX': '081',
        'Coleman County, TX': '083',
        'Collin County, TX': '085',
        'Collingsworth County, TX': '087',
        'Colorado County, TX': '089',
        'Comal County, TX': '091',
        'Comanche County, TX': '093',
        'Concho County, TX': '095',
        'Cooke County, TX': '097',
        'Coryell County, TX': '099',
        'Cottle County, TX': '101',
        'Crane County, TX': '103',
        'Crockett County, TX': '105',
        'Crosby County, TX': '107',
        'Culberson County, TX': '109',
        'Dallam County, TX': '111',
        'Dallas County, TX': '113',
        'Dawson County, TX': '115',
        'DeWitt County, TX': '123',
        'Deaf Smith County, TX': '117',
        'Delta County, TX': '119',
        'Denton County, TX': '121',
        'Dickens County, TX': '125',
        'Dimmit County, TX': '127',
        'Donley County, TX': '129',
        'Duval County, TX': '131',
        'Eastland County, TX': '133',
        'Ector County, TX': '135',
        'Edwards County, TX': '137',
        'El Paso County, TX': '141',
        'Ellis County, TX': '139',
        'Erath County, TX': '143',
        'Falls County, TX': '145',
        'Fannin County, TX': '147',
        'Fayette County, TX': '149',
        'Fisher County, TX': '151',
        'Floyd County, TX': '153',
        'Foard County, TX': '155',
        'Fort Bend County, TX': '157',
        'Franklin County, TX': '159',
        'Freestone County, TX': '161',
        'Frio County, TX': '163',
        'Gaines County, TX': '165',
        'Galveston County, TX': '167',
        'Garza County, TX': '169',
        'Gillespie County, TX': '171',
        'Glasscock County, TX': '173',
        'Goliad County, TX': '175',
        'Gonzales County, TX': '177',
        'Gray County, TX': '179',
        'Grayson County, TX': '181',
        'Gregg County, TX': '183',
        'Grimes County, TX': '185',
        'Guadalupe County, TX': '187',
        'Hale County, TX': '189',
        'Hall County, TX': '191',
        'Hamilton County, TX': '193',
        'Hansford County, TX': '195',
        'Hardeman County, TX': '197',
        'Hardin County, TX': '199',
        'Harris County, TX': '201',
        'Harrison County, TX': '203',
        'Hartley County, TX': '205',
        'Haskell County, TX': '207',
        'Hays County, TX': '209',
        'Hemphill County, TX': '211',
        'Henderson County, TX': '213',
        'Hidalgo County, TX': '215',
        'Hill County, TX': '217',
        'Hockley County, TX': '219',
        'Hood County, TX': '221',
        'Hopkins County, TX': '223',
        'Houston County, TX': '225',
        'Howard County, TX': '227',
        'Hudspeth County, TX': '229',
        'Hunt County, TX': '231',
        'Hutchinson County, TX': '233',
        'Irion County, TX': '235',
        'Jack County, TX': '237',
        'Jackson County, TX': '239',
        'Jasper County, TX': '241',
        'Jeff Davis County, TX': '243',
        'Jefferson County, TX': '245',
        'Jim Hogg County, TX': '247',
        'Jim Wells County, TX': '249',
        'Johnson County, TX': '251',
        'Jones County, TX': '253',
        'Karnes County, TX': '255',
        'Kaufman County, TX': '257',
        'Kendall County, TX': '259',
        'Kenedy County, TX': '261',
        'Kent County, TX': '263',
        'Kerr County, TX': '265',
        'Kimble County, TX': '267',
        'King County, TX': '269',
        'Kinney County, TX': '271',
        'Kleberg County, TX': '273',
        'Knox County, TX': '275',
        'La Salle County, TX': '283',
        'Lamar County, TX': '277',
        'Lamb County, TX': '279',
        'Lampasas County, TX': '281',
        'Lavaca County, TX': '285',
        'Lee County, TX': '287',
        'Leon County, TX': '289',
        'Liberty County, TX': '291',
        'Limestone County, TX': '293',
        'Lipscomb County, TX': '295',
        'Live Oak County, TX': '297',
        'Llano County, TX': '299',
        'Loving County, TX': '301',
        'Lubbock County, TX': '303',
        'Lynn County, TX': '305',
        'Madison County, TX': '313',
        'Marion County, TX': '315',
        'Martin County, TX': '317',
        'Mason County, TX': '319',
        'Matagorda County, TX': '321',
        'Maverick County, TX': '323',
        'McCulloch County, TX': '307',
        'McLennan County, TX': '309',
        'McMullen County, TX': '311',
        'Medina County, TX': '325',
        'Menard County, TX': '327',
        'Midland County, TX': '329',
        'Milam County, TX': '331',
        'Mills County, TX': '333',
        'Mitchell County, TX': '335',
        'Montague County, TX': '337',
        'Montgomery County, TX': '339',
        'Moore County, TX': '341',
        'Morris County, TX': '343',
        'Motley County, TX': '345',
        'Nacogdoches County, TX': '347',
        'Navarro County, TX': '349',
        'Newton County, TX': '351',
        'Nolan County, TX': '353',
        'Nueces County, TX': '355',
        'Ochiltree County, TX': '357',
        'Oldham County, TX': '359',
        'Orange County, TX': '361',
        'Palo Pinto County, TX': '363',
        'Panola County, TX': '365',
        'Parker County, TX': '367',
        'Parmer County, TX': '369',
        'Pecos County, TX': '371',
        'Polk County, TX': '373',
        'Potter County, TX': '375',
        'Presidio County, TX': '377',
        'Rains County, TX': '379',
        'Randall County, TX': '381',
        'Reagan County, TX': '383',
        'Real County, TX': '385',
        'Red River County, TX': '387',
        'Reeves County, TX': '389',
        'Refugio County, TX': '391',
        'Roberts County, TX': '393',
        'Robertson County, TX': '395',
        'Rockwall County, TX': '397',
        'Runnels County, TX': '399',
        'Rusk County, TX': '401',
        'Sabine County, TX': '403',
        'San Augustine County, TX': '405',
        'San Jacinto County, TX': '407',
        'San Patricio County, TX': '409',
        'San Saba County, TX': '411',
        'Schleicher County, TX': '413',
        'Scurry County, TX': '415',
        'Shackelford County, TX': '417',
        'Shelby County, TX': '419',
        'Sherman County, TX': '421',
        'Smith County, TX': '423',
        'Somervell County, TX': '425',
        'Starr County, TX': '427',
        'Stephens County, TX': '429',
        'Sterling County, TX': '431',
        'Stonewall County, TX': '433',
        'Sutton County, TX': '435',
        'Swisher County, TX': '437',
        'Tarrant County, TX': '439',
        'Taylor County, TX': '441',
        'Terrell County, TX': '443',
        'Terry County, TX': '445',
        'Throckmorton County, TX': '447',
        'Titus County, TX': '449',
        'Tom Green County, TX': '451',
        'Travis County, TX': '453',
        'Trinity County, TX': '455',
        'Tyler County, TX': '457',
        'Upshur County, TX': '459',
        'Upton County, TX': '461',
        'Uvalde County, TX': '463',
        'Val Verde County, TX': '465',
        'Van Zandt County, TX': '467',
        'Victoria County, TX': '469',
        'Walker County, TX': '471',
        'Waller County, TX': '473',
        'Ward County, TX': '475',
        'Washington County, TX': '477',
        'Webb County, TX': '479',
        'Wharton County, TX': '481',
        'Wheeler County, TX': '483',
        'Wichita County, TX': '485',
        'Wilbarger County, TX': '487',
        'Willacy County, TX': '489',
        'Williamson County, TX': '491',
        'Wilson County, TX': '493',
        'Winkler County, TX': '495',
        'Wise County, TX': '497',
        'Wood County, TX': '499',
        'Yoakum County, TX': '501',
        'Young County, TX': '503',
        'Zapata County, TX': '505',
        'Zavala County, TX': '507'},
  49:  {'--All--': '%',
        'Beaver County, UT': '001',
        'Box Elder County, UT': '003',
        'Cache County, UT': '005',
        'Carbon County, UT': '007',
        'Daggett County, UT': '009',
        'Davis County, UT': '011',
        'Duchesne County, UT': '013',
        'Emery County, UT': '015',
        'Garfield County, UT': '017',
        'Grand County, UT': '019',
        'Iron County, UT': '021',
        'Juab County, UT': '023',
        'Kane County, UT': '025',
        'Millard County, UT': '027',
        'Morgan County, UT': '029',
        'Piute County, UT': '031',
        'Rich County, UT': '033',
        'Salt Lake County, UT': '035',
        'San Juan County, UT': '037',
        'Sanpete County, UT': '039',
        'Sevier County, UT': '041',
        'Summit County, UT': '043',
        'Tooele County, UT': '045',
        'Uintah County, UT': '047',
        'Utah County, UT': '049',
        'Wasatch County, UT': '051',
        'Washington County, UT': '053',
        'Wayne County, UT': '055',
        'Weber County, UT': '057'},
  50:  {'--All--': '%',
        'Addison County, VT': '001',
        'Bennington County, VT': '003',
        'Caledonia County, VT': '005',
        'Chittenden County, VT': '007',
        'Essex County, VT': '009',
        'Franklin County, VT': '011',
        'Grand Isle County, VT': '013',
        'Lamoille County, VT': '015',
        'Orange County, VT': '017',
        'Orleans County, VT': '019',
        'Rutland County, VT': '021',
        'Washington County, VT': '023',
        'Windham County, VT': '025',
        'Windsor County, VT': '027'},
  51:  {'--All--': '%',
        'Accomack County, VA': '001',
        'Albemarle County, VA': '003',
        'Alexandria city, VA': '510',
        'Alleghany County, VA': '005',
        'Amelia County, VA': '007',
        'Amherst County, VA': '009',
        'Appomattox County, VA': '011',
        'Arlington County, VA': '013',
        'Augusta County, VA': '015',
        'Bath County, VA': '017',
        'Bedford County, VA': '019',
        'Bedford city, VA': '515',
        'Bland County, VA': '021',
        'Botetourt County, VA': '023',
        'Bristol city, VA': '520',
        'Brunswick County, VA': '025',
        'Buchanan County, VA': '027',
        'Buckingham County, VA': '029',
        'Buena Vista city, VA': '530',
        'Campbell County, VA': '031',
        'Caroline County, VA': '033',
        'Carroll County, VA': '035',
        'Charles City County, VA': '036',
        'Charlotte County, VA': '037',
        'Charlottesville city, VA': '540',
        'Chesapeake city, VA': '550',
        'Chesterfield County, VA': '041',
        'Clarke County, VA': '043',
        'Colonial Heights city, VA': '570',
        'Covington city, VA': '580',
        'Craig County, VA': '045',
        'Culpeper County, VA': '047',
        'Cumberland County, VA': '049',
        'Danville city, VA': '590',
        'Dickenson County, VA': '051',
        'Dinwiddie County, VA': '053',
        'Emporia city, VA': '595',
        'Essex County, VA': '057',
        'Fairfax County, VA': '059',
        'Fairfax city, VA': '600',
        'Falls Church city, VA': '610',
        'Fauquier County, VA': '061',
        'Floyd County, VA': '063',
        'Fluvanna County, VA': '065',
        'Franklin County, VA': '067',
        'Franklin city, VA': '620',
        'Frederick County, VA': '069',
        'Fredericksburg city, VA': '630',
        'Galax city, VA': '640',
        'Giles County, VA': '071',
        'Gloucester County, VA': '073',
        'Goochland County, VA': '075',
        'Grayson County, VA': '077',
        'Greene County, VA': '079',
        'Greensville County, VA': '081',
        'Halifax County, VA': '083',
        'Hampton city, VA': '650',
        'Hanover County, VA': '085',
        'Harrisonburg city, VA': '660',
        'Henrico County, VA': '087',
        'Henry County, VA': '089',
        'Highland County, VA': '091',
        'Hopewell city, VA': '670',
        'Isle of Wight County, VA': '093',
        'James City County, VA': '095',
        'King George County, VA': '099',
        'King William County, VA': '101',
        'King and Queen County, VA': '097',
        'Lancaster County, VA': '103',
        'Lee County, VA': '105',
        'Lexington city, VA': '678',
        'Loudoun County, VA': '107',
        'Louisa County, VA': '109',
        'Lunenburg County, VA': '111',
        'Lynchburg city, VA': '680',
        'Madison County, VA': '113',
        'Manassas Park city, VA': '685',
        'Manassas city, VA': '683',
        'Martinsville city, VA': '690',
        'Mathews County, VA': '115',
        'Mecklenburg County, VA': '117',
        'Middlesex County, VA': '119',
        'Montgomery County, VA': '121',
        'Nelson County, VA': '125',
        'New Kent County, VA': '127',
        'Newport News city, VA': '700',
        'Norfolk city, VA': '710',
        'Northampton County, VA': '131',
        'Northumberland County, VA': '133',
        'Norton city, VA': '720',
        'Nottoway County, VA': '135',
        'Orange County, VA': '137',
        'Page County, VA': '139',
        'Patrick County, VA': '141',
        'Petersburg city, VA': '730',
        'Pittsylvania County, VA': '143',
        'Poquoson city, VA': '735',
        'Portsmouth city, VA': '740',
        'Powhatan County, VA': '145',
        'Prince Edward County, VA': '147',
        'Prince George County, VA': '149',
        'Prince William County, VA': '153',
        'Pulaski County, VA': '155',
        'Radford city, VA': '750',
        'Rappahannock County, VA': '157',
        'Richmond County, VA': '159',
        'Richmond city, VA': '760',
        'Roanoke County, VA': '161',
        'Roanoke city, VA': '770',
        'Rockbridge County, VA': '163',
        'Rockingham County, VA': '165',
        'Russell County, VA': '167',
        'Salem city, VA': '775',
        'Scott County, VA': '169',
        'Shenandoah County, VA': '171',
        'Smyth County, VA': '173',
        'Southampton County, VA': '175',
        'Spotsylvania County, VA': '177',
        'Stafford County, VA': '179',
        'Staunton city, VA': '790',
        'Suffolk city, VA': '800',
        'Surry County, VA': '181',
        'Sussex County, VA': '183',
        'Tazewell County, VA': '185',
        'Virginia Beach city, VA': '810',
        'Warren County, VA': '187',
        'Washington County, VA': '191',
        'Waynesboro city, VA': '820',
        'Westmoreland County, VA': '193',
        'Williamsburg city, VA': '830',
        'Winchester city, VA': '840',
        'Wise County, VA': '195',
        'Wythe County, VA': '197',
        'York County, VA': '199'},
  53:  {'--All--': '%',
        'Adams County, WA': '001',
        'Asotin County, WA': '003',
        'Benton County, WA': '005',
        'Chelan County, WA': '007',
        'Clallam County, WA': '009',
        'Clark County, WA': '011',
        'Columbia County, WA': '013',
        'Cowlitz County, WA': '015',
        'Douglas County, WA': '017',
        'Ferry County, WA': '019',
        'Franklin County, WA': '021',
        'Garfield County, WA': '023',
        'Grant County, WA': '025',
        'Grays Harbor County, WA': '027',
        'Island County, WA': '029',
        'Jefferson County, WA': '031',
        'King County, WA': '033',
        'Kitsap County, WA': '035',
        'Kittitas County, WA': '037',
        'Klickitat County, WA': '039',
        'Lewis County, WA': '041',
        'Lincoln County, WA': '043',
        'Mason County, WA': '045',
        'Okanogan County, WA': '047',
        'Pacific County, WA': '049',
        'Pend Oreille County, WA': '051',
        'Pierce County, WA': '053',
        'San Juan County, WA': '055',
        'Skagit County, WA': '057',
        'Skamania County, WA': '059',
        'Snohomish County, WA': '061',
        'Spokane County, WA': '063',
        'Stevens County, WA': '065',
        'Thurston County, WA': '067',
        'Wahkiakum County, WA': '069',
        'Walla Walla County, WA': '071',
        'Whatcom County, WA': '073',
        'Whitman County, WA': '075',
        'Yakima County, WA': '077'},
  54:  {'--All--': '%',
        'Barbour County, WV': '001',
        'Berkeley County, WV': '003',
        'Boone County, WV': '005',
        'Braxton County, WV': '007',
        'Brooke County, WV': '009',
        'Cabell County, WV': '011',
        'Calhoun County, WV': '013',
        'Clay County, WV': '015',
        'Doddridge County, WV': '017',
        'Fayette County, WV': '019',
        'Gilmer County, WV': '021',
        'Grant County, WV': '023',
        'Greenbrier County, WV': '025',
        'Hampshire County, WV': '027',
        'Hancock County, WV': '029',
        'Hardy County, WV': '031',
        'Harrison County, WV': '033',
        'Jackson County, WV': '035',
        'Jefferson County, WV': '037',
        'Kanawha County, WV': '039',
        'Lewis County, WV': '041',
        'Lincoln County, WV': '043',
        'Logan County, WV': '045',
        'Marion County, WV': '049',
        'Marshall County, WV': '051',
        'Mason County, WV': '053',
        'McDowell County, WV': '047',
        'Mercer County, WV': '055',
        'Mineral County, WV': '057',
        'Mingo County, WV': '059',
        'Monongalia County, WV': '061',
        'Monroe County, WV': '063',
        'Morgan County, WV': '065',
        'Nicholas County, WV': '067',
        'Ohio County, WV': '069',
        'Pendleton County, WV': '071',
        'Pleasants County, WV': '073',
        'Pocahontas County, WV': '075',
        'Preston County, WV': '077',
        'Putnam County, WV': '079',
        'Raleigh County, WV': '081',
        'Randolph County, WV': '083',
        'Ritchie County, WV': '085',
        'Roane County, WV': '087',
        'Summers County, WV': '089',
        'Taylor County, WV': '091',
        'Tucker County, WV': '093',
        'Tyler County, WV': '095',
        'Upshur County, WV': '097',
        'Wayne County, WV': '099',
        'Webster County, WV': '101',
        'Wetzel County, WV': '103',
        'Wirt County, WV': '105',
        'Wood County, WV': '107',
        'Wyoming County, WV': '109'},
  55:  {'--All--': '%',
        'Adams County, WI': '001',
        'Ashland County, WI': '003',
        'Barron County, WI': '005',
        'Bayfield County, WI': '007',
        'Brown County, WI': '009',
        'Buffalo County, WI': '011',
        'Burnett County, WI': '013',
        'Calumet County, WI': '015',
        'Chippewa County, WI': '017',
        'Clark County, WI': '019',
        'Columbia County, WI': '021',
        'Crawford County, WI': '023',
        'Dane County, WI': '025',
        'Dodge County, WI': '027',
        'Door County, WI': '029',
        'Douglas County, WI': '031',
        'Dunn County, WI': '033',
        'Eau Claire County, WI': '035',
        'Florence County, WI': '037',
        'Fond du Lac County, WI': '039',
        'Forest County, WI': '041',
        'Grant County, WI': '043',
        'Green County, WI': '045',
        'Green Lake County, WI': '047',
        'Iowa County, WI': '049',
        'Iron County, WI': '051',
        'Jackson County, WI': '053',
        'Jefferson County, WI': '055',
        'Juneau County, WI': '057',
        'Kenosha County, WI': '059',
        'Kewaunee County, WI': '061',
        'La Crosse County, WI': '063',
        'Lafayette County, WI': '065',
        'Langlade County, WI': '067',
        'Lincoln County, WI': '069',
        'Manitowoc County, WI': '071',
        'Marathon County, WI': '073',
        'Marinette County, WI': '075',
        'Marquette County, WI': '077',
        'Menominee County, WI': '078',
        'Milwaukee County, WI': '079',
        'Monroe County, WI': '081',
        'Oconto County, WI': '083',
        'Oneida County, WI': '085',
        'Outagamie County, WI': '087',
        'Ozaukee County, WI': '089',
        'Pepin County, WI': '091',
        'Pierce County, WI': '093',
        'Polk County, WI': '095',
        'Portage County, WI': '097',
        'Price County, WI': '099',
        'Racine County, WI': '101',
        'Richland County, WI': '103',
        'Rock County, WI': '105',
        'Rusk County, WI': '107',
        'Sauk County, WI': '111',
        'Sawyer County, WI': '113',
        'Shawano County, WI': '115',
        'Sheboygan County, WI': '117',
        'St. Croix County, WI': '109',
        'Taylor County, WI': '119',
        'Trempealeau County, WI': '121',
        'Vernon County, WI': '123',
        'Vilas County, WI': '125',
        'Walworth County, WI': '127',
        'Washburn County, WI': '129',
        'Washington County, WI': '131',
        'Waukesha County, WI': '133',
        'Waupaca County, WI': '135',
        'Waushara County, WI': '137',
        'Winnebago County, WI': '139',
        'Wood County, WI': '141'},
  56:  {'--All--': '%',
        'Albany County, WY': '001',
        'Big Horn County, WY': '003',
        'Campbell County, WY': '005',
        'Carbon County, WY': '007',
        'Converse County, WY': '009',
        'Crook County, WY': '011',
        'Fremont County, WY': '013',
        'Goshen County, WY': '015',
        'Hot Springs County, WY': '017',
        'Johnson County, WY': '019',
        'Laramie County, WY': '021',
        'Lincoln County, WY': '023',
        'Natrona County, WY': '025',
        'Niobrara County, WY': '027',
        'Park County, WY': '029',
        'Platte County, WY': '031',
        'Sheridan County, WY': '033',
        'Sublette County, WY': '035',
        'Sweetwater County, WY': '037',
        'Teton County, WY': '039',
        'Uinta County, WY': '041',
        'Washakie County, WY': '043',
        'Weston County, WY': '045'},
  72:  {'--All--': '%',
        'Adjuntas Municipio, PR': '001',
        'Aguada Municipio, PR': '003',
        'Aguadilla Municipio, PR': '005',
        'Aguas Buenas Municipio, PR': '007',
        'Aibonito Municipio, PR': '009',
        'Anasco Municipio, PR': '011',
        'Arecibo Municipio, PR': '013',
        'Arroyo Municipio, PR': '015',
        'Barceloneta Municipio, PR': '017',
        'Barranquitas Municipio, PR': '019',
        'Bayamon Municipio, PR': '021',
        'Cabo Rojo Municipio, PR': '023',
        'Caguas Municipio, PR': '025',
        'Camuy Municipio, PR': '027',
        'Canovanas Municipio, PR': '029',
        'Carolina Municipio, PR': '031',
        'Catano Municipio, PR': '033',
        'Cayey Municipio, PR': '035',
        'Ceiba Municipio, PR': '037',
        'Ciales Municipio, PR': '039',
        'Cidra Municipio, PR': '041',
        'Coamo Municipio, PR': '043',
        'Comerio Municipio, PR': '045',
        'Corozal Municipio, PR': '047',
        'Culebra Municipio, PR': '049',
        'Dorado Municipio, PR': '051',
        'Fajardo Municipio, PR': '053',
        'Florida Municipio, PR': '054',
        'Guanica Municipio, PR': '055',
        'Guayama Municipio, PR': '057',
        'Guayanilla Municipio, PR': '059',
        'Guaynabo Municipio, PR': '061',
        'Gurabo Municipio, PR': '063',
        'Hatillo Municipio, PR': '065',
        'Hormigueros Municipio, PR': '067',
        'Humacao Municipio, PR': '069',
        'Isabela Municipio, PR': '071',
        'Jayuya Municipio, PR': '073',
        'Juana Diaz Municipio, PR': '075',
        'Juncos Municipio, PR': '077',
        'Lajas Municipio, PR': '079',
        'Lares Municipio, PR': '081',
        'Las Marias Municipio, PR': '083',
        'Las Piedras Municipio, PR': '085',
        'Loiza Municipio, PR': '087',
        'Luquillo Municipio, PR': '089',
        'Manati Municipio, PR': '091',
        'Maricao Municipio, PR': '093',
        'Maunabo Municipio, PR': '095',
        'Mayaguez Municipio, PR': '097',
        'Moca Municipio, PR': '099',
        'Morovis Municipio, PR': '101',
        'Naguabo Municipio, PR': '103',
        'Naranjito Municipio, PR': '105',
        'Orocovis Municipio, PR': '107',
        'Patillas Municipio, PR': '109',
        'Penuelas Municipio, PR': '111',
        'Ponce Municipio, PR': '113',
        'Quebradillas Municipio, PR': '115',
        'Rincon Municipio, PR': '117',
        'Rio Grande Municipio, PR': '119',
        'Sabana Grande Municipio, PR': '121',
        'Salinas Municipio, PR': '123',
        'San German Municipio, PR': '125',
        'San Juan Municipio, PR': '127',
        'San Lorenzo Municipio, PR': '129',
        'San Sebastian Municipio, PR': '131',
        'Santa Isabel Municipio, PR': '133',
        'Toa Alta Municipio, PR': '135',
        'Toa Baja Municipio, PR': '137',
        'Trujillo Alto Municipio, PR': '139',
        'Utuado Municipio, PR': '141',
        'Vega Alta Municipio, PR': '143',
        'Vega Baja Municipio, PR': '145',
        'Vieques Municipio, PR': '147',
        'Villalba Municipio, PR': '149',
        'Yabucoa Municipio, PR': '151',
        'Yauco Municipio, PR': '153'},
  '01':  {'Autauga County, AL': '001',
          'Baldwin County, AL': '003',
          'Barbour County, AL': '005',
          'Bibb County, AL': '007',
          'Blount County, AL': '009',
          'Bullock County, AL': '011',
          'Butler County, AL': '013',
          'Calhoun County, AL': '015',
          'Chambers County, AL': '017',
          'Cherokee County, AL': '019',
          'Chilton County, AL': '021',
          'Choctaw County, AL': '023',
          'Clarke County, AL': '025',
          'Clay County, AL': '027',
          'Cleburne County, AL': '029',
          'Coffee County, AL': '031',
          'Colbert County, AL': '033',
          'Conecuh County, AL': '035',
          'Coosa County, AL': '037',
          'Covington County, AL': '039',
          'Crenshaw County, AL': '041',
          'Cullman County, AL': '043',
          'Dale County, AL': '045',
          'Dallas County, AL': '047',
          'DeKalb County, AL': '049',
          'Elmore County, AL': '051',
          'Escambia County, AL': '053',
          'Etowah County, AL': '055',
          'Fayette County, AL': '057',
          'Franklin County, AL': '059',
          'Geneva County, AL': '061',
          'Greene County, AL': '063',
          'Hale County, AL': '065',
          'Henry County, AL': '067',
          'Houston County, AL': '069',
          'Jackson County, AL': '071',
          'Jefferson County, AL': '073',
          'Lamar County, AL': '075',
          'Lauderdale County, AL': '077',
          'Lawrence County, AL': '079',
          'Lee County, AL': '081',
          'Limestone County, AL': '083',
          'Lowndes County, AL': '085',
          'Macon County, AL': '087',
          'Madison County, AL': '089',
          'Marengo County, AL': '091',
          'Marion County, AL': '093',
          'Marshall County, AL': '095',
          'Mobile County, AL': '097',
          'Monroe County, AL': '099',
          'Montgomery County, AL': '101',
          'Morgan County, AL': '103',
          'Perry County, AL': '105',
          'Pickens County, AL': '107',
          'Pike County, AL': '109',
          'Randolph County, AL': '111',
          'Russell County, AL': '113',
          'Shelby County, AL': '117',
          'St. Clair County, AL': '115',
          'Sumter County, AL': '119',
          'Talladega County, AL': '121',
          'Tallapoosa County, AL': '123',
          'Tuscaloosa County, AL': '125',
          'Walker County, AL': '127',
          'Washington County, AL': '129',
          'Wilcox County, AL': '131',
          'Winston County, AL': '133'},
  '02':  {'Aleutians East Borough, AK': '013',
          'Aleutians West Census Area, AK': '016',
          'Anchorage Borough/municipality, AK': '020',
          'Bethel Census Area, AK': '050',
          'Bristol Bay Borough, AK': '060',
          'Denali Borough, AK': '068',
          'Dillingham Census Area, AK': '070',
          'Fairbanks North Star Borough, AK': '090',
          'Haines Borough, AK': '100',
          'Juneau Borough/city, AK': '110',
          'Kenai Peninsula Borough, AK': '122',
          'Ketchikan Gateway Borough, AK': '130',
          'Kodiak Island Borough, AK': '150',
          'Lake and Peninsula Borough, AK': '164',
          'Matanuska-Susitna Borough, AK': '170',
          'Nome Census Area, AK': '180',
          'North Slope Borough, AK': '185',
          'Northwest Arctic Borough, AK': '188',
          'Prince of Wales-Outer Ketchikan Census Area, AK': '201',
          'Sitka Borough/city, AK': '220',
          'Skagway-Hoonah-Angoon Census Area, AK': '232',
          'Southeast Fairbanks Census Area, AK': '240',
          'Valdez-Cordova Census Area, AK': '261',
          'Wade Hampton Census Area, AK': '270',
          'Wrangell-Petersburg Census Area, AK': '280',
          'Yakutat Borough, AK': '282',
          'Yukon-Koyukuk Census Area, AK': '290'},
  '04':  {'Apache County, AZ': '001',
          'Cochise County, AZ': '003',
          'Coconino County, AZ': '005',
          'Gila County, AZ': '007',
          'Graham County, AZ': '009',
          'Greenlee County, AZ': '011',
          'La Paz County, AZ': '012',
          'Maricopa County, AZ': '013',
          'Mohave County, AZ': '015',
          'Navajo County, AZ': '017',
          'Pima County, AZ': '019',
          'Pinal County, AZ': '021',
          'Santa Cruz County, AZ': '023',
          'Yavapai County, AZ': '025',
          'Yuma County, AZ': '027'},
  '05':  {'Arkansas County, AR': '001',
          'Ashley County, AR': '003',
          'Baxter County, AR': '005',
          'Benton County, AR': '007',
          'Boone County, AR': '009',
          'Bradley County, AR': '011',
          'Calhoun County, AR': '013',
          'Carroll County, AR': '015',
          'Chicot County, AR': '017',
          'Clark County, AR': '019',
          'Clay County, AR': '021',
          'Cleburne County, AR': '023',
          'Cleveland County, AR': '025',
          'Columbia County, AR': '027',
          'Conway County, AR': '029',
          'Craighead County, AR': '031',
          'Crawford County, AR': '033',
          'Crittenden County, AR': '035',
          'Cross County, AR': '037',
          'Dallas County, AR': '039',
          'Desha County, AR': '041',
          'Drew County, AR': '043',
          'Faulkner County, AR': '045',
          'Franklin County, AR': '047',
          'Fulton County, AR': '049',
          'Garland County, AR': '051',
          'Grant County, AR': '053',
          'Greene County, AR': '055',
          'Hempstead County, AR': '057',
          'Hot Spring County, AR': '059',
          'Howard County, AR': '061',
          'Independence County, AR': '063',
          'Izard County, AR': '065',
          'Jackson County, AR': '067',
          'Jefferson County, AR': '069',
          'Johnson County, AR': '071',
          'Lafayette County, AR': '073',
          'Lawrence County, AR': '075',
          'Lee County, AR': '077',
          'Lincoln County, AR': '079',
          'Little River County, AR': '081',
          'Logan County, AR': '083',
          'Lonoke County, AR': '085',
          'Madison County, AR': '087',
          'Marion County, AR': '089',
          'Miller County, AR': '091',
          'Mississippi County, AR': '093',
          'Monroe County, AR': '095',
          'Montgomery County, AR': '097',
          'Nevada County, AR': '099',
          'Newton County, AR': '101',
          'Ouachita County, AR': '103',
          'Perry County, AR': '105',
          'Phillips County, AR': '107',
          'Pike County, AR': '109',
          'Poinsett County, AR': '111',
          'Polk County, AR': '113',
          'Pope County, AR': '115',
          'Prairie County, AR': '117',
          'Pulaski County, AR': '119',
          'Randolph County, AR': '121',
          'Saline County, AR': '125',
          'Scott County, AR': '127',
          'Searcy County, AR': '129',
          'Sebastian County, AR': '131',
          'Sevier County, AR': '133',
          'Sharp County, AR': '135',
          'St. Francis County, AR': '123',
          'Stone County, AR': '137',
          'Union County, AR': '139',
          'Van Buren County, AR': '141',
          'Washington County, AR': '143',
          'White County, AR': '145',
          'Woodruff County, AR': '147',
          'Yell County, AR': '149'},
  '06':  {'Alameda County, CA': '001',
          'Alpine County, CA': '003',
          'Amador County, CA': '005',
          'Butte County, CA': '007',
          'Calaveras County, CA': '009',
          'Colusa County, CA': '011',
          'Contra Costa County, CA': '013',
          'Del Norte County, CA': '015',
          'El Dorado County, CA': '017',
          'Fresno County, CA': '019',
          'Glenn County, CA': '021',
          'Humboldt County, CA': '023',
          'Imperial County, CA': '025',
          'Inyo County, CA': '027',
          'Kern County, CA': '029',
          'Kings County, CA': '031',
          'Lake County, CA': '033',
          'Lassen County, CA': '035',
          'Los Angeles County, CA': '037',
          'Madera County, CA': '039',
          'Marin County, CA': '041',
          'Mariposa County, CA': '043',
          'Mendocino County, CA': '045',
          'Merced County, CA': '047',
          'Modoc County, CA': '049',
          'Mono County, CA': '051',
          'Monterey County, CA': '053',
          'Napa County, CA': '055',
          'Nevada County, CA': '057',
          'Orange County, CA': '059',
          'Placer County, CA': '061',
          'Plumas County, CA': '063',
          'Riverside County, CA': '065',
          'Sacramento County, CA': '067',
          'San Benito County, CA': '069',
          'San Bernardino County, CA': '071',
          'San Diego County, CA': '073',
          'San Francisco County/city, CA': '075',
          'San Joaquin County, CA': '077',
          'San Luis Obispo County, CA': '079',
          'San Mateo County, CA': '081',
          'Santa Barbara County, CA': '083',
          'Santa Clara County, CA': '085',
          'Santa Cruz County, CA': '087',
          'Shasta County, CA': '089',
          'Sierra County, CA': '091',
          'Siskiyou County, CA': '093',
          'Solano County, CA': '095',
          'Sonoma County, CA': '097',
          'Stanislaus County, CA': '099',
          'Sutter County, CA': '101',
          'Tehama County, CA': '103',
          'Trinity County, CA': '105',
          'Tulare County, CA': '107',
          'Tuolumne County, CA': '109',
          'Ventura County, CA': '111',
          'Yolo County, CA': '113',
          'Yuba County, CA': '115'},
  '08':  {'Adams County, CO': '001',
          'Alamosa County, CO': '003',
          'Arapahoe County, CO': '005',
          'Archuleta County, CO': '007',
          'Baca County, CO': '009',
          'Bent County, CO': '011',
          'Boulder County, CO': '013',
          'Broomfield County/city, CO': '014',
          'Chaffee County, CO': '015',
          'Cheyenne County, CO': '017',
          'Clear Creek County, CO': '019',
          'Conejos County, CO': '021',
          'Costilla County, CO': '023',
          'Crowley County, CO': '025',
          'Custer County, CO': '027',
          'Delta County, CO': '029',
          'Denver County/city, CO': '031',
          'Dolores County, CO': '033',
          'Douglas County, CO': '035',
          'Eagle County, CO': '037',
          'El Paso County, CO': '041',
          'Elbert County, CO': '039',
          'Fremont County, CO': '043',
          'Garfield County, CO': '045',
          'Gilpin County, CO': '047',
          'Grand County, CO': '049',
          'Gunnison County, CO': '051',
          'Hinsdale County, CO': '053',
          'Huerfano County, CO': '055',
          'Jackson County, CO': '057',
          'Jefferson County, CO': '059',
          'Kiowa County, CO': '061',
          'Kit Carson County, CO': '063',
          'La Plata County, CO': '067',
          'Lake County, CO': '065',
          'Larimer County, CO': '069',
          'Las Animas County, CO': '071',
          'Lincoln County, CO': '073',
          'Logan County, CO': '075',
          'Mesa County, CO': '077',
          'Mineral County, CO': '079',
          'Moffat County, CO': '081',
          'Montezuma County, CO': '083',
          'Montrose County, CO': '085',
          'Morgan County, CO': '087',
          'Otero County, CO': '089',
          'Ouray County, CO': '091',
          'Park County, CO': '093',
          'Phillips County, CO': '095',
          'Pitkin County, CO': '097',
          'Prowers County, CO': '099',
          'Pueblo County, CO': '101',
          'Rio Blanco County, CO': '103',
          'Rio Grande County, CO': '105',
          'Routt County, CO': '107',
          'Saguache County, CO': '109',
          'San Juan County, CO': '111',
          'San Miguel County, CO': '113',
          'Sedgwick County, CO': '115',
          'Summit County, CO': '117',
          'Teller County, CO': '119',
          'Washington County, CO': '121',
          'Weld County, CO': '123',
          'Yuma County, CO': '125'},
  '09':  {'Fairfield County, CT': '001',
          'Hartford County, CT': '003',
          'Litchfield County, CT': '005',
          'Middlesex County, CT': '007',
          'New Haven County, CT': '009',
          'New London County, CT': '011',
          'Tolland County, CT': '013',
          'Windham County, CT': '015'},
  '10':  {'Kent County, DE': '001',
          'New Castle County, DE': '003',
          'Sussex County, DE': '005'},
  '11':  {'District of Columbia': '001'},
  '12':  {'Alachua County, FL': '001',
          'Baker County, FL': '003',
          'Bay County, FL': '005',
          'Bradford County, FL': '007',
          'Brevard County, FL': '009',
          'Broward County, FL': '011',
          'Calhoun County, FL': '013',
          'Charlotte County, FL': '015',
          'Citrus County, FL': '017',
          'Clay County, FL': '019',
          'Collier County, FL': '021',
          'Columbia County, FL': '023',
          'DeSoto County, FL': '027',
          'Dixie County, FL': '029',
          'Duval County, FL': '031',
          'Escambia County, FL': '033',
          'Flagler County, FL': '035',
          'Franklin County, FL': '037',
          'Gadsden County, FL': '039',
          'Gilchrist County, FL': '041',
          'Glades County, FL': '043',
          'Gulf County, FL': '045',
          'Hamilton County, FL': '047',
          'Hardee County, FL': '049',
          'Hendry County, FL': '051',
          'Hernando County, FL': '053',
          'Highlands County, FL': '055',
          'Hillsborough County, FL': '057',
          'Holmes County, FL': '059',
          'Indian River County, FL': '061',
          'Jackson County, FL': '063',
          'Jefferson County, FL': '065',
          'Lafayette County, FL': '067',
          'Lake County, FL': '069',
          'Lee County, FL': '071',
          'Leon County, FL': '073',
          'Levy County, FL': '075',
          'Liberty County, FL': '077',
          'Madison County, FL': '079',
          'Manatee County, FL': '081',
          'Marion County, FL': '083',
          'Martin County, FL': '085',
          'Miami-Dade County, FL': '086',
          'Monroe County, FL': '087',
          'Nassau County, FL': '089',
          'Okaloosa County, FL': '091',
          'Okeechobee County, FL': '093',
          'Orange County, FL': '095',
          'Osceola County, FL': '097',
          'Palm Beach County, FL': '099',
          'Pasco County, FL': '101',
          'Pinellas County, FL': '103',
          'Polk County, FL': '105',
          'Putnam County, FL': '107',
          'Santa Rosa County, FL': '113',
          'Sarasota County, FL': '115',
          'Seminole County, FL': '117',
          'St. Johns County, FL': '109',
          'St. Lucie County, FL': '111',
          'Sumter County, FL': '119',
          'Suwannee County, FL': '121',
          'Taylor County, FL': '123',
          'Union County, FL': '125',
          'Volusia County, FL': '127',
          'Wakulla County, FL': '129',
          'Walton County, FL': '131',
          'Washington County, FL': '133'},
  '13':  {'Appling County, GA': '001',
          'Atkinson County, GA': '003',
          'Bacon County, GA': '005',
          'Baker County, GA': '007',
          'Baldwin County, GA': '009',
          'Banks County, GA': '011',
          'Barrow County, GA': '013',
          'Bartow County, GA': '015',
          'Ben Hill County, GA': '017',
          'Berrien County, GA': '019',
          'Bibb County, GA': '021',
          'Bleckley County, GA': '023',
          'Brantley County, GA': '025',
          'Brooks County, GA': '027',
          'Bryan County, GA': '029',
          'Bulloch County, GA': '031',
          'Burke County, GA': '033',
          'Butts County, GA': '035',
          'Calhoun County, GA': '037',
          'Camden County, GA': '039',
          'Candler County, GA': '043',
          'Carroll County, GA': '045',
          'Catoosa County, GA': '047',
          'Charlton County, GA': '049',
          'Chatham County, GA': '051',
          'Chattahoochee County, GA': '053',
          'Chattooga County, GA': '055',
          'Cherokee County, GA': '057',
          'Clarke County, GA': '059',
          'Clay County, GA': '061',
          'Clayton County, GA': '063',
          'Clinch County, GA': '065',
          'Cobb County, GA': '067',
          'Coffee County, GA': '069',
          'Colquitt County, GA': '071',
          'Columbia County, GA': '073',
          'Cook County, GA': '075',
          'Coweta County, GA': '077',
          'Crawford County, GA': '079',
          'Crisp County, GA': '081',
          'Dade County, GA': '083',
          'Dawson County, GA': '085',
          'DeKalb County, GA': '089',
          'Decatur County, GA': '087',
          'Dodge County, GA': '091',
          'Dooly County, GA': '093',
          'Dougherty County, GA': '095',
          'Douglas County, GA': '097',
          'Early County, GA': '099',
          'Echols County, GA': '101',
          'Effingham County, GA': '103',
          'Elbert County, GA': '105',
          'Emanuel County, GA': '107',
          'Evans County, GA': '109',
          'Fannin County, GA': '111',
          'Fayette County, GA': '113',
          'Floyd County, GA': '115',
          'Forsyth County, GA': '117',
          'Franklin County, GA': '119',
          'Fulton County, GA': '121',
          'Gilmer County, GA': '123',
          'Glascock County, GA': '125',
          'Glynn County, GA': '127',
          'Gordon County, GA': '129',
          'Grady County, GA': '131',
          'Greene County, GA': '133',
          'Gwinnett County, GA': '135',
          'Habersham County, GA': '137',
          'Hall County, GA': '139',
          'Hancock County, GA': '141',
          'Haralson County, GA': '143',
          'Harris County, GA': '145',
          'Hart County, GA': '147',
          'Heard County, GA': '149',
          'Henry County, GA': '151',
          'Houston County, GA': '153',
          'Irwin County, GA': '155',
          'Jackson County, GA': '157',
          'Jasper County, GA': '159',
          'Jeff Davis County, GA': '161',
          'Jefferson County, GA': '163',
          'Jenkins County, GA': '165',
          'Johnson County, GA': '167',
          'Jones County, GA': '169',
          'Lamar County, GA': '171',
          'Lanier County, GA': '173',
          'Laurens County, GA': '175',
          'Lee County, GA': '177',
          'Liberty County, GA': '179',
          'Lincoln County, GA': '181',
          'Long County, GA': '183',
          'Lowndes County, GA': '185',
          'Lumpkin County, GA': '187',
          'Macon County, GA': '193',
          'Madison County, GA': '195',
          'Marion County, GA': '197',
          'McDuffie County, GA': '189',
          'McIntosh County, GA': '191',
          'Meriwether County, GA': '199',
          'Miller County, GA': '201',
          'Mitchell County, GA': '205',
          'Monroe County, GA': '207',
          'Montgomery County, GA': '209',
          'Morgan County, GA': '211',
          'Murray County, GA': '213',
          'Muscogee County, GA': '215',
          'Newton County, GA': '217',
          'Oconee County, GA': '219',
          'Oglethorpe County, GA': '221',
          'Paulding County, GA': '223',
          'Peach County, GA': '225',
          'Pickens County, GA': '227',
          'Pierce County, GA': '229',
          'Pike County, GA': '231',
          'Polk County, GA': '233',
          'Pulaski County, GA': '235',
          'Putnam County, GA': '237',
          'Quitman County, GA': '239',
          'Rabun County, GA': '241',
          'Randolph County, GA': '243',
          'Richmond County, GA': '245',
          'Rockdale County, GA': '247',
          'Schley County, GA': '249',
          'Screven County, GA': '251',
          'Seminole County, GA': '253',
          'Spalding County, GA': '255',
          'Stephens County, GA': '257',
          'Stewart County, GA': '259',
          'Sumter County, GA': '261',
          'Talbot County, GA': '263',
          'Taliaferro County, GA': '265',
          'Tattnall County, GA': '267',
          'Taylor County, GA': '269',
          'Telfair County, GA': '271',
          'Terrell County, GA': '273',
          'Thomas County, GA': '275',
          'Tift County, GA': '277',
          'Toombs County, GA': '279',
          'Towns County, GA': '281',
          'Treutlen County, GA': '283',
          'Troup County, GA': '285',
          'Turner County, GA': '287',
          'Twiggs County, GA': '289',
          'Union County, GA': '291',
          'Upson County, GA': '293',
          'Walker County, GA': '295',
          'Walton County, GA': '297',
          'Ware County, GA': '299',
          'Warren County, GA': '301',
          'Washington County, GA': '303',
          'Wayne County, GA': '305',
          'Webster County, GA': '307',
          'Wheeler County, GA': '309',
          'White County, GA': '311',
          'Whitfield County, GA': '313',
          'Wilcox County, GA': '315',
          'Wilkes County, GA': '317',
          'Wilkinson County, GA': '319',
          'Worth County, GA': '321'},
  '15':  {'Hawaii County, HI': '001',
          'Honolulu County/city, HI': '003',
          'Kauai County, HI': '007',
          'Maui County, HI': '009'},
  '16':  {'Ada County, ID': '001',
          'Adams County, ID': '003',
          'Bannock County, ID': '005',
          'Bear Lake County, ID': '007',
          'Benewah County, ID': '009',
          'Bingham County, ID': '011',
          'Blaine County, ID': '013',
          'Boise County, ID': '015',
          'Bonner County, ID': '017',
          'Bonneville County, ID': '019',
          'Boundary County, ID': '021',
          'Butte County, ID': '023',
          'Camas County, ID': '025',
          'Canyon County, ID': '027',
          'Caribou County, ID': '029',
          'Cassia County, ID': '031',
          'Clark County, ID': '033',
          'Clearwater County, ID': '035',
          'Custer County, ID': '037',
          'Elmore County, ID': '039',
          'Franklin County, ID': '041',
          'Fremont County, ID': '043',
          'Gem County, ID': '045',
          'Gooding County, ID': '047',
          'Idaho County, ID': '049',
          'Jefferson County, ID': '051',
          'Jerome County, ID': '053',
          'Kootenai County, ID': '055',
          'Latah County, ID': '057',
          'Lemhi County, ID': '059',
          'Lewis County, ID': '061',
          'Lincoln County, ID': '063',
          'Madison County, ID': '065',
          'Minidoka County, ID': '067',
          'Nez Perce County, ID': '069',
          'Oneida County, ID': '071',
          'Owyhee County, ID': '073',
          'Payette County, ID': '075',
          'Power County, ID': '077',
          'Shoshone County, ID': '079',
          'Teton County, ID': '081',
          'Twin Falls County, ID': '083',
          'Valley County, ID': '085',
          'Washington County, ID': '087'},
  '17':  {'Adams County, IL': '001',
          'Alexander County, IL': '003',
          'Bond County, IL': '005',
          'Boone County, IL': '007',
          'Brown County, IL': '009',
          'Bureau County, IL': '011',
          'Calhoun County, IL': '013',
          'Carroll County, IL': '015',
          'Cass County, IL': '017',
          'Champaign County, IL': '019',
          'Christian County, IL': '021',
          'Clark County, IL': '023',
          'Clay County, IL': '025',
          'Clinton County, IL': '027',
          'Coles County, IL': '029',
          'Cook County, IL': '031',
          'Crawford County, IL': '033',
          'Cumberland County, IL': '035',
          'De Witt County, IL': '039',
          'DeKalb County, IL': '037',
          'Douglas County, IL': '041',
          'DuPage County, IL': '043',
          'Edgar County, IL': '045',
          'Edwards County, IL': '047',
          'Effingham County, IL': '049',
          'Fayette County, IL': '051',
          'Ford County, IL': '053',
          'Franklin County, IL': '055',
          'Fulton County, IL': '057',
          'Gallatin County, IL': '059',
          'Greene County, IL': '061',
          'Grundy County, IL': '063',
          'Hamilton County, IL': '065',
          'Hancock County, IL': '067',
          'Hardin County, IL': '069',
          'Henderson County, IL': '071',
          'Henry County, IL': '073',
          'Iroquois County, IL': '075',
          'Jackson County, IL': '077',
          'Jasper County, IL': '079',
          'Jefferson County, IL': '081',
          'Jersey County, IL': '083',
          'Jo Daviess County, IL': '085',
          'Johnson County, IL': '087',
          'Kane County, IL': '089',
          'Kankakee County, IL': '091',
          'Kendall County, IL': '093',
          'Knox County, IL': '095',
          'La Salle County, IL': '099',
          'Lake County, IL': '097',
          'Lawrence County, IL': '101',
          'Lee County, IL': '103',
          'Livingston County, IL': '105',
          'Logan County, IL': '107',
          'Macon County, IL': '115',
          'Macoupin County, IL': '117',
          'Madison County, IL': '119',
          'Marion County, IL': '121',
          'Marshall County, IL': '123',
          'Mason County, IL': '125',
          'Massac County, IL': '127',
          'McDonough County, IL': '109',
          'McHenry County, IL': '111',
          'McLean County, IL': '113',
          'Menard County, IL': '129',
          'Mercer County, IL': '131',
          'Monroe County, IL': '133',
          'Montgomery County, IL': '135',
          'Morgan County, IL': '137',
          'Moultrie County, IL': '139',
          'Ogle County, IL': '141',
          'Peoria County, IL': '143',
          'Perry County, IL': '145',
          'Piatt County, IL': '147',
          'Pike County, IL': '149',
          'Pope County, IL': '151',
          'Pulaski County, IL': '153',
          'Putnam County, IL': '155',
          'Randolph County, IL': '157',
          'Richland County, IL': '159',
          'Rock Island County, IL': '161',
          'Saline County, IL': '165',
          'Sangamon County, IL': '167',
          'Schuyler County, IL': '169',
          'Scott County, IL': '171',
          'Shelby County, IL': '173',
          'St. Clair County, IL': '163',
          'Stark County, IL': '175',
          'Stephenson County, IL': '177',
          'Tazewell County, IL': '179',
          'Union County, IL': '181',
          'Vermilion County, IL': '183',
          'Wabash County, IL': '185',
          'Warren County, IL': '187',
          'Washington County, IL': '189',
          'Wayne County, IL': '191',
          'White County, IL': '193',
          'Whiteside County, IL': '195',
          'Will County, IL': '197',
          'Williamson County, IL': '199',
          'Winnebago County, IL': '201',
          'Woodford County, IL': '203'},
  '18':  {'Adams County, IN': '001',
          'Allen County, IN': '003',
          'Bartholomew County, IN': '005',
          'Benton County, IN': '007',
          'Blackford County, IN': '009',
          'Boone County, IN': '011',
          'Brown County, IN': '013',
          'Carroll County, IN': '015',
          'Cass County, IN': '017',
          'Clark County, IN': '019',
          'Clay County, IN': '021',
          'Clinton County, IN': '023',
          'Crawford County, IN': '025',
          'Daviess County, IN': '027',
          'DeKalb County, IN': '033',
          'Dearborn County, IN': '029',
          'Decatur County, IN': '031',
          'Delaware County, IN': '035',
          'Dubois County, IN': '037',
          'Elkhart County, IN': '039',
          'Fayette County, IN': '041',
          'Floyd County, IN': '043',
          'Fountain County, IN': '045',
          'Franklin County, IN': '047',
          'Fulton County, IN': '049',
          'Gibson County, IN': '051',
          'Grant County, IN': '053',
          'Greene County, IN': '055',
          'Hamilton County, IN': '057',
          'Hancock County, IN': '059',
          'Harrison County, IN': '061',
          'Hendricks County, IN': '063',
          'Henry County, IN': '065',
          'Howard County, IN': '067',
          'Huntington County, IN': '069',
          'Jackson County, IN': '071',
          'Jasper County, IN': '073',
          'Jay County, IN': '075',
          'Jefferson County, IN': '077',
          'Jennings County, IN': '079',
          'Johnson County, IN': '081',
          'Knox County, IN': '083',
          'Kosciusko County, IN': '085',
          'LaGrange County, IN': '087',
          'LaPorte County, IN': '091',
          'Lake County, IN': '089',
          'Lawrence County, IN': '093',
          'Madison County, IN': '095',
          'Marion County, IN': '097',
          'Marshall County, IN': '099',
          'Martin County, IN': '101',
          'Miami County, IN': '103',
          'Monroe County, IN': '105',
          'Montgomery County, IN': '107',
          'Morgan County, IN': '109',
          'Newton County, IN': '111',
          'Noble County, IN': '113',
          'Ohio County, IN': '115',
          'Orange County, IN': '117',
          'Owen County, IN': '119',
          'Parke County, IN': '121',
          'Perry County, IN': '123',
          'Pike County, IN': '125',
          'Porter County, IN': '127',
          'Posey County, IN': '129',
          'Pulaski County, IN': '131',
          'Putnam County, IN': '133',
          'Randolph County, IN': '135',
          'Ripley County, IN': '137',
          'Rush County, IN': '139',
          'Scott County, IN': '143',
          'Shelby County, IN': '145',
          'Spencer County, IN': '147',
          'St. Joseph County, IN': '141',
          'Starke County, IN': '149',
          'Steuben County, IN': '151',
          'Sullivan County, IN': '153',
          'Switzerland County, IN': '155',
          'Tippecanoe County, IN': '157',
          'Tipton County, IN': '159',
          'Union County, IN': '161',
          'Vanderburgh County, IN': '163',
          'Vermillion County, IN': '165',
          'Vigo County, IN': '167',
          'Wabash County, IN': '169',
          'Warren County, IN': '171',
          'Warrick County, IN': '173',
          'Washington County, IN': '175',
          'Wayne County, IN': '177',
          'Wells County, IN': '179',
          'White County, IN': '181',
          'Whitley County, IN': '183'},
  '19':  {'Adair County, IA': '001',
          'Adams County, IA': '003',
          'Allamakee County, IA': '005',
          'Appanoose County, IA': '007',
          'Audubon County, IA': '009',
          'Benton County, IA': '011',
          'Black Hawk County, IA': '013',
          'Boone County, IA': '015',
          'Bremer County, IA': '017',
          'Buchanan County, IA': '019',
          'Buena Vista County, IA': '021',
          'Butler County, IA': '023',
          'Calhoun County, IA': '025',
          'Carroll County, IA': '027',
          'Cass County, IA': '029',
          'Cedar County, IA': '031',
          'Cerro Gordo County, IA': '033',
          'Cherokee County, IA': '035',
          'Chickasaw County, IA': '037',
          'Clarke County, IA': '039',
          'Clay County, IA': '041',
          'Clayton County, IA': '043',
          'Clinton County, IA': '045',
          'Crawford County, IA': '047',
          'Dallas County, IA': '049',
          'Davis County, IA': '051',
          'Decatur County, IA': '053',
          'Delaware County, IA': '055',
          'Des Moines County, IA': '057',
          'Dickinson County, IA': '059',
          'Dubuque County, IA': '061',
          'Emmet County, IA': '063',
          'Fayette County, IA': '065',
          'Floyd County, IA': '067',
          'Franklin County, IA': '069',
          'Fremont County, IA': '071',
          'Greene County, IA': '073',
          'Grundy County, IA': '075',
          'Guthrie County, IA': '077',
          'Hamilton County, IA': '079',
          'Hancock County, IA': '081',
          'Hardin County, IA': '083',
          'Harrison County, IA': '085',
          'Henry County, IA': '087',
          'Howard County, IA': '089',
          'Humboldt County, IA': '091',
          'Ida County, IA': '093',
          'Iowa County, IA': '095',
          'Jackson County, IA': '097',
          'Jasper County, IA': '099',
          'Jefferson County, IA': '101',
          'Johnson County, IA': '103',
          'Jones County, IA': '105',
          'Keokuk County, IA': '107',
          'Kossuth County, IA': '109',
          'Lee County, IA': '111',
          'Linn County, IA': '113',
          'Louisa County, IA': '115',
          'Lucas County, IA': '117',
          'Lyon County, IA': '119',
          'Madison County, IA': '121',
          'Mahaska County, IA': '123',
          'Marion County, IA': '125',
          'Marshall County, IA': '127',
          'Mills County, IA': '129',
          'Mitchell County, IA': '131',
          'Monona County, IA': '133',
          'Monroe County, IA': '135',
          'Montgomery County, IA': '137',
          'Muscatine County, IA': '139',
          "O'Brien County, IA": '141',
          'Osceola County, IA': '143',
          'Page County, IA': '145',
          'Palo Alto County, IA': '147',
          'Plymouth County, IA': '149',
          'Pocahontas County, IA': '151',
          'Polk County, IA': '153',
          'Pottawattamie County, IA': '155',
          'Poweshiek County, IA': '157',
          'Ringgold County, IA': '159',
          'Sac County, IA': '161',
          'Scott County, IA': '163',
          'Shelby County, IA': '165',
          'Sioux County, IA': '167',
          'Story County, IA': '169',
          'Tama County, IA': '171',
          'Taylor County, IA': '173',
          'Union County, IA': '175',
          'Van Buren County, IA': '177',
          'Wapello County, IA': '179',
          'Warren County, IA': '181',
          'Washington County, IA': '183',
          'Wayne County, IA': '185',
          'Webster County, IA': '187',
          'Winnebago County, IA': '189',
          'Winneshiek County, IA': '191',
          'Woodbury County, IA': '193',
          'Worth County, IA': '195',
          'Wright County, IA': '197'},
  '20':  {'Allen County, KS': '001',
          'Anderson County, KS': '003',
          'Atchison County, KS': '005',
          'Barber County, KS': '007',
          'Barton County, KS': '009',
          'Bourbon County, KS': '011',
          'Brown County, KS': '013',
          'Butler County, KS': '015',
          'Chase County, KS': '017',
          'Chautauqua County, KS': '019',
          'Cherokee County, KS': '021',
          'Cheyenne County, KS': '023',
          'Clark County, KS': '025',
          'Clay County, KS': '027',
          'Cloud County, KS': '029',
          'Coffey County, KS': '031',
          'Comanche County, KS': '033',
          'Cowley County, KS': '035',
          'Crawford County, KS': '037',
          'Decatur County, KS': '039',
          'Dickinson County, KS': '041',
          'Doniphan County, KS': '043',
          'Douglas County, KS': '045',
          'Edwards County, KS': '047',
          'Elk County, KS': '049',
          'Ellis County, KS': '051',
          'Ellsworth County, KS': '053',
          'Finney County, KS': '055',
          'Ford County, KS': '057',
          'Franklin County, KS': '059',
          'Geary County, KS': '061',
          'Gove County, KS': '063',
          'Graham County, KS': '065',
          'Grant County, KS': '067',
          'Gray County, KS': '069',
          'Greeley County, KS': '071',
          'Greenwood County, KS': '073',
          'Hamilton County, KS': '075',
          'Harper County, KS': '077',
          'Harvey County, KS': '079',
          'Haskell County, KS': '081',
          'Hodgeman County, KS': '083',
          'Jackson County, KS': '085',
          'Jefferson County, KS': '087',
          'Jewell County, KS': '089',
          'Johnson County, KS': '091',
          'Kearny County, KS': '093',
          'Kingman County, KS': '095',
          'Kiowa County, KS': '097',
          'Labette County, KS': '099',
          'Lane County, KS': '101',
          'Leavenworth County, KS': '103',
          'Lincoln County, KS': '105',
          'Linn County, KS': '107',
          'Logan County, KS': '109',
          'Lyon County, KS': '111',
          'Marion County, KS': '115',
          'Marshall County, KS': '117',
          'McPherson County, KS': '113',
          'Meade County, KS': '119',
          'Miami County, KS': '121',
          'Mitchell County, KS': '123',
          'Montgomery County, KS': '125',
          'Morris County, KS': '127',
          'Morton County, KS': '129',
          'Nemaha County, KS': '131',
          'Neosho County, KS': '133',
          'Ness County, KS': '135',
          'Norton County, KS': '137',
          'Osage County, KS': '139',
          'Osborne County, KS': '141',
          'Ottawa County, KS': '143',
          'Pawnee County, KS': '145',
          'Phillips County, KS': '147',
          'Pottawatomie County, KS': '149',
          'Pratt County, KS': '151',
          'Rawlins County, KS': '153',
          'Reno County, KS': '155',
          'Republic County, KS': '157',
          'Rice County, KS': '159',
          'Riley County, KS': '161',
          'Rooks County, KS': '163',
          'Rush County, KS': '165',
          'Russell County, KS': '167',
          'Saline County, KS': '169',
          'Scott County, KS': '171',
          'Sedgwick County, KS': '173',
          'Seward County, KS': '175',
          'Shawnee County, KS': '177',
          'Sheridan County, KS': '179',
          'Sherman County, KS': '181',
          'Smith County, KS': '183',
          'Stafford County, KS': '185',
          'Stanton County, KS': '187',
          'Stevens County, KS': '189',
          'Sumner County, KS': '191',
          'Thomas County, KS': '193',
          'Trego County, KS': '195',
          'Wabaunsee County, KS': '197',
          'Wallace County, KS': '199',
          'Washington County, KS': '201',
          'Wichita County, KS': '203',
          'Wilson County, KS': '205',
          'Woodson County, KS': '207',
          'Wyandotte County, KS': '209'},
  '21':  {'Adair County, KY': '001',
          'Allen County, KY': '003',
          'Anderson County, KY': '005',
          'Ballard County, KY': '007',
          'Barren County, KY': '009',
          'Bath County, KY': '011',
          'Bell County, KY': '013',
          'Boone County, KY': '015',
          'Bourbon County, KY': '017',
          'Boyd County, KY': '019',
          'Boyle County, KY': '021',
          'Bracken County, KY': '023',
          'Breathitt County, KY': '025',
          'Breckinridge County, KY': '027',
          'Bullitt County, KY': '029',
          'Butler County, KY': '031',
          'Caldwell County, KY': '033',
          'Calloway County, KY': '035',
          'Campbell County, KY': '037',
          'Carlisle County, KY': '039',
          'Carroll County, KY': '041',
          'Carter County, KY': '043',
          'Casey County, KY': '045',
          'Christian County, KY': '047',
          'Clark County, KY': '049',
          'Clay County, KY': '051',
          'Clinton County, KY': '053',
          'Crittenden County, KY': '055',
          'Cumberland County, KY': '057',
          'Daviess County, KY': '059',
          'Edmonson County, KY': '061',
          'Elliott County, KY': '063',
          'Estill County, KY': '065',
          'Fayette County, KY': '067',
          'Fleming County, KY': '069',
          'Floyd County, KY': '071',
          'Franklin County, KY': '073',
          'Fulton County, KY': '075',
          'Gallatin County, KY': '077',
          'Garrard County, KY': '079',
          'Grant County, KY': '081',
          'Graves County, KY': '083',
          'Grayson County, KY': '085',
          'Green County, KY': '087',
          'Greenup County, KY': '089',
          'Hancock County, KY': '091',
          'Hardin County, KY': '093',
          'Harlan County, KY': '095',
          'Harrison County, KY': '097',
          'Hart County, KY': '099',
          'Henderson County, KY': '101',
          'Henry County, KY': '103',
          'Hickman County, KY': '105',
          'Hopkins County, KY': '107',
          'Jackson County, KY': '109',
          'Jefferson County, KY': '111',
          'Jessamine County, KY': '113',
          'Johnson County, KY': '115',
          'Kenton County, KY': '117',
          'Knott County, KY': '119',
          'Knox County, KY': '121',
          'Larue County, KY': '123',
          'Laurel County, KY': '125',
          'Lawrence County, KY': '127',
          'Lee County, KY': '129',
          'Leslie County, KY': '131',
          'Letcher County, KY': '133',
          'Lewis County, KY': '135',
          'Lincoln County, KY': '137',
          'Livingston County, KY': '139',
          'Logan County, KY': '141',
          'Lyon County, KY': '143',
          'Madison County, KY': '151',
          'Magoffin County, KY': '153',
          'Marion County, KY': '155',
          'Marshall County, KY': '157',
          'Martin County, KY': '159',
          'Mason County, KY': '161',
          'McCracken County, KY': '145',
          'McCreary County, KY': '147',
          'McLean County, KY': '149',
          'Meade County, KY': '163',
          'Menifee County, KY': '165',
          'Mercer County, KY': '167',
          'Metcalfe County, KY': '169',
          'Monroe County, KY': '171',
          'Montgomery County, KY': '173',
          'Morgan County, KY': '175',
          'Muhlenberg County, KY': '177',
          'Nelson County, KY': '179',
          'Nicholas County, KY': '181',
          'Ohio County, KY': '183',
          'Oldham County, KY': '185',
          'Owen County, KY': '187',
          'Owsley County, KY': '189',
          'Pendleton County, KY': '191',
          'Perry County, KY': '193',
          'Pike County, KY': '195',
          'Powell County, KY': '197',
          'Pulaski County, KY': '199',
          'Robertson County, KY': '201',
          'Rockcastle County, KY': '203',
          'Rowan County, KY': '205',
          'Russell County, KY': '207',
          'Scott County, KY': '209',
          'Shelby County, KY': '211',
          'Simpson County, KY': '213',
          'Spencer County, KY': '215',
          'Taylor County, KY': '217',
          'Todd County, KY': '219',
          'Trigg County, KY': '221',
          'Trimble County, KY': '223',
          'Union County, KY': '225',
          'Warren County, KY': '227',
          'Washington County, KY': '229',
          'Wayne County, KY': '231',
          'Webster County, KY': '233',
          'Whitley County, KY': '235',
          'Wolfe County, KY': '237',
          'Woodford County, KY': '239'},
  '22':  {'Acadia Parish, LA': '001',
          'Allen Parish, LA': '003',
          'Ascension Parish, LA': '005',
          'Assumption Parish, LA': '007',
          'Avoyelles Parish, LA': '009',
          'Beauregard Parish, LA': '011',
          'Bienville Parish, LA': '013',
          'Bossier Parish, LA': '015',
          'Caddo Parish, LA': '017',
          'Calcasieu Parish, LA': '019',
          'Caldwell Parish, LA': '021',
          'Cameron Parish, LA': '023',
          'Catahoula Parish, LA': '025',
          'Claiborne Parish, LA': '027',
          'Concordia Parish, LA': '029',
          'De Soto Parish, LA': '031',
          'East Baton Rouge Parish, LA': '033',
          'East Carroll Parish, LA': '035',
          'East Feliciana Parish, LA': '037',
          'Evangeline Parish, LA': '039',
          'Franklin Parish, LA': '041',
          'Grant Parish, LA': '043',
          'Iberia Parish, LA': '045',
          'Iberville Parish, LA': '047',
          'Jackson Parish, LA': '049',
          'Jefferson Davis Parish, LA': '053',
          'Jefferson Parish, LA': '051',
          'La Salle Parish, LA': '059',
          'Lafayette Parish, LA': '055',
          'Lafourche Parish, LA': '057',
          'Lincoln Parish, LA': '061',
          'Livingston Parish, LA': '063',
          'Madison Parish, LA': '065',
          'Morehouse Parish, LA': '067',
          'Natchitoches Parish, LA': '069',
          'Orleans Parish, LA': '071',
          'Ouachita Parish, LA': '073',
          'Plaquemines Parish, LA': '075',
          'Pointe Coupee Parish, LA': '077',
          'Rapides Parish, LA': '079',
          'Red River Parish, LA': '081',
          'Richland Parish, LA': '083',
          'Sabine Parish, LA': '085',
          'St. Bernard Parish, LA': '087',
          'St. Charles Parish, LA': '089',
          'St. Helena Parish, LA': '091',
          'St. James Parish, LA': '093',
          'St. John the Baptist Parish, LA': '095',
          'St. Landry Parish, LA': '097',
          'St. Martin Parish, LA': '099',
          'St. Mary Parish, LA': '101',
          'St. Tammany Parish, LA': '103',
          'Tangipahoa Parish, LA': '105',
          'Tensas Parish, LA': '107',
          'Terrebonne Parish, LA': '109',
          'Union Parish, LA': '111',
          'Vermilion Parish, LA': '113',
          'Vernon Parish, LA': '115',
          'Washington Parish, LA': '117',
          'Webster Parish, LA': '119',
          'West Baton Rouge Parish, LA': '121',
          'West Carroll Parish, LA': '123',
          'West Feliciana Parish, LA': '125',
          'Winn Parish, LA': '127'},
  '23':  {'Androscoggin County, ME': '001',
          'Aroostook County, ME': '003',
          'Cumberland County, ME': '005',
          'Franklin County, ME': '007',
          'Hancock County, ME': '009',
          'Kennebec County, ME': '011',
          'Knox County, ME': '013',
          'Lincoln County, ME': '015',
          'Oxford County, ME': '017',
          'Penobscot County, ME': '019',
          'Piscataquis County, ME': '021',
          'Sagadahoc County, ME': '023',
          'Somerset County, ME': '025',
          'Waldo County, ME': '027',
          'Washington County, ME': '029',
          'York County, ME': '031'},
  '24':  {'Allegany County, MD': '001',
          'Anne Arundel County, MD': '003',
          'Baltimore County, MD': '005',
          'Baltimore city, MD': '510',
          'Calvert County, MD': '009',
          'Caroline County, MD': '011',
          'Carroll County, MD': '013',
          'Cecil County, MD': '015',
          'Charles County, MD': '017',
          'Dorchester County, MD': '019',
          'Frederick County, MD': '021',
          'Garrett County, MD': '023',
          'Harford County, MD': '025',
          'Howard County, MD': '027',
          'Kent County, MD': '029',
          'Montgomery County, MD': '031',
          "Prince George's County, MD": '033',
          "Queen Anne's County, MD": '035',
          'Somerset County, MD': '039',
          "St. Mary's County, MD": '037',
          'Talbot County, MD': '041',
          'Washington County, MD': '043',
          'Wicomico County, MD': '045',
          'Worcester County, MD': '047'},
  '25':  {'Barnstable County, MA': '001',
          'Berkshire County, MA': '003',
          'Bristol County, MA': '005',
          'Dukes County, MA': '007',
          'Essex County, MA': '009',
          'Franklin County, MA': '011',
          'Hampden County, MA': '013',
          'Hampshire County, MA': '015',
          'Middlesex County, MA': '017',
          'Nantucket County/town, MA': '019',
          'Norfolk County, MA': '021',
          'Plymouth County, MA': '023',
          'Suffolk County, MA': '025',
          'Worcester County, MA': '027'},
  '26':  {'Alcona County, MI': '001',
          'Alger County, MI': '003',
          'Allegan County, MI': '005',
          'Alpena County, MI': '007',
          'Antrim County, MI': '009',
          'Arenac County, MI': '011',
          'Baraga County, MI': '013',
          'Barry County, MI': '015',
          'Bay County, MI': '017',
          'Benzie County, MI': '019',
          'Berrien County, MI': '021',
          'Branch County, MI': '023',
          'Calhoun County, MI': '025',
          'Cass County, MI': '027',
          'Charlevoix County, MI': '029',
          'Cheboygan County, MI': '031',
          'Chippewa County, MI': '033',
          'Clare County, MI': '035',
          'Clinton County, MI': '037',
          'Crawford County, MI': '039',
          'Delta County, MI': '041',
          'Dickinson County, MI': '043',
          'Eaton County, MI': '045',
          'Emmet County, MI': '047',
          'Genesee County, MI': '049',
          'Gladwin County, MI': '051',
          'Gogebic County, MI': '053',
          'Grand Traverse County, MI': '055',
          'Gratiot County, MI': '057',
          'Hillsdale County, MI': '059',
          'Houghton County, MI': '061',
          'Huron County, MI': '063',
          'Ingham County, MI': '065',
          'Ionia County, MI': '067',
          'Iosco County, MI': '069',
          'Iron County, MI': '071',
          'Isabella County, MI': '073',
          'Jackson County, MI': '075',
          'Kalamazoo County, MI': '077',
          'Kalkaska County, MI': '079',
          'Kent County, MI': '081',
          'Keweenaw County, MI': '083',
          'Lake County, MI': '085',
          'Lapeer County, MI': '087',
          'Leelanau County, MI': '089',
          'Lenawee County, MI': '091',
          'Livingston County, MI': '093',
          'Luce County, MI': '095',
          'Mackinac County, MI': '097',
          'Macomb County, MI': '099',
          'Manistee County, MI': '101',
          'Marquette County, MI': '103',
          'Mason County, MI': '105',
          'Mecosta County, MI': '107',
          'Menominee County, MI': '109',
          'Midland County, MI': '111',
          'Missaukee County, MI': '113',
          'Monroe County, MI': '115',
          'Montcalm County, MI': '117',
          'Montmorency County, MI': '119',
          'Muskegon County, MI': '121',
          'Newaygo County, MI': '123',
          'Oakland County, MI': '125',
          'Oceana County, MI': '127',
          'Ogemaw County, MI': '129',
          'Ontonagon County, MI': '131',
          'Osceola County, MI': '133',
          'Oscoda County, MI': '135',
          'Otsego County, MI': '137',
          'Ottawa County, MI': '139',
          'Presque Isle County, MI': '141',
          'Roscommon County, MI': '143',
          'Saginaw County, MI': '145',
          'Sanilac County, MI': '151',
          'Schoolcraft County, MI': '153',
          'Shiawassee County, MI': '155',
          'St. Clair County, MI': '147',
          'St. Joseph County, MI': '149',
          'Tuscola County, MI': '157',
          'Van Buren County, MI': '159',
          'Washtenaw County, MI': '161',
          'Wayne County, MI': '163',
          'Wexford County, MI': '165'},
  '27':  {'Aitkin County, MN': '001',
          'Anoka County, MN': '003',
          'Becker County, MN': '005',
          'Beltrami County, MN': '007',
          'Benton County, MN': '009',
          'Big Stone County, MN': '011',
          'Blue Earth County, MN': '013',
          'Brown County, MN': '015',
          'Carlton County, MN': '017',
          'Carver County, MN': '019',
          'Cass County, MN': '021',
          'Chippewa County, MN': '023',
          'Chisago County, MN': '025',
          'Clay County, MN': '027',
          'Clearwater County, MN': '029',
          'Cook County, MN': '031',
          'Cottonwood County, MN': '033',
          'Crow Wing County, MN': '035',
          'Dakota County, MN': '037',
          'Dodge County, MN': '039',
          'Douglas County, MN': '041',
          'Faribault County, MN': '043',
          'Fillmore County, MN': '045',
          'Freeborn County, MN': '047',
          'Goodhue County, MN': '049',
          'Grant County, MN': '051',
          'Hennepin County, MN': '053',
          'Houston County, MN': '055',
          'Hubbard County, MN': '057',
          'Isanti County, MN': '059',
          'Itasca County, MN': '061',
          'Jackson County, MN': '063',
          'Kanabec County, MN': '065',
          'Kandiyohi County, MN': '067',
          'Kittson County, MN': '069',
          'Koochiching County, MN': '071',
          'Lac qui Parle County, MN': '073',
          'Lake County, MN': '075',
          'Lake of the Woods County, MN': '077',
          'Le Sueur County, MN': '079',
          'Lincoln County, MN': '081',
          'Lyon County, MN': '083',
          'Mahnomen County, MN': '087',
          'Marshall County, MN': '089',
          'Martin County, MN': '091',
          'McLeod County, MN': '085',
          'Meeker County, MN': '093',
          'Mille Lacs County, MN': '095',
          'Morrison County, MN': '097',
          'Mower County, MN': '099',
          'Murray County, MN': '101',
          'Nicollet County, MN': '103',
          'Nobles County, MN': '105',
          'Norman County, MN': '107',
          'Olmsted County, MN': '109',
          'Otter Tail County, MN': '111',
          'Pennington County, MN': '113',
          'Pine County, MN': '115',
          'Pipestone County, MN': '117',
          'Polk County, MN': '119',
          'Pope County, MN': '121',
          'Ramsey County, MN': '123',
          'Red Lake County, MN': '125',
          'Redwood County, MN': '127',
          'Renville County, MN': '129',
          'Rice County, MN': '131',
          'Rock County, MN': '133',
          'Roseau County, MN': '135',
          'Scott County, MN': '139',
          'Sherburne County, MN': '141',
          'Sibley County, MN': '143',
          'St. Louis County, MN': '137',
          'Stearns County, MN': '145',
          'Steele County, MN': '147',
          'Stevens County, MN': '149',
          'Swift County, MN': '151',
          'Todd County, MN': '153',
          'Traverse County, MN': '155',
          'Wabasha County, MN': '157',
          'Wadena County, MN': '159',
          'Waseca County, MN': '161',
          'Washington County, MN': '163',
          'Watonwan County, MN': '165',
          'Wilkin County, MN': '167',
          'Winona County, MN': '169',
          'Wright County, MN': '171',
          'Yellow Medicine County, MN': '173'},
  '28':  {'Adams County, MS': '001',
          'Alcorn County, MS': '003',
          'Amite County, MS': '005',
          'Attala County, MS': '007',
          'Benton County, MS': '009',
          'Bolivar County, MS': '011',
          'Calhoun County, MS': '013',
          'Carroll County, MS': '015',
          'Chickasaw County, MS': '017',
          'Choctaw County, MS': '019',
          'Claiborne County, MS': '021',
          'Clarke County, MS': '023',
          'Clay County, MS': '025',
          'Coahoma County, MS': '027',
          'Copiah County, MS': '029',
          'Covington County, MS': '031',
          'DeSoto County, MS': '033',
          'Forrest County, MS': '035',
          'Franklin County, MS': '037',
          'George County, MS': '039',
          'Greene County, MS': '041',
          'Grenada County, MS': '043',
          'Hancock County, MS': '045',
          'Harrison County, MS': '047',
          'Hinds County, MS': '049',
          'Holmes County, MS': '051',
          'Humphreys County, MS': '053',
          'Issaquena County, MS': '055',
          'Itawamba County, MS': '057',
          'Jackson County, MS': '059',
          'Jasper County, MS': '061',
          'Jefferson County, MS': '063',
          'Jefferson Davis County, MS': '065',
          'Jones County, MS': '067',
          'Kemper County, MS': '069',
          'Lafayette County, MS': '071',
          'Lamar County, MS': '073',
          'Lauderdale County, MS': '075',
          'Lawrence County, MS': '077',
          'Leake County, MS': '079',
          'Lee County, MS': '081',
          'Leflore County, MS': '083',
          'Lincoln County, MS': '085',
          'Lowndes County, MS': '087',
          'Madison County, MS': '089',
          'Marion County, MS': '091',
          'Marshall County, MS': '093',
          'Monroe County, MS': '095',
          'Montgomery County, MS': '097',
          'Neshoba County, MS': '099',
          'Newton County, MS': '101',
          'Noxubee County, MS': '103',
          'Oktibbeha County, MS': '105',
          'Panola County, MS': '107',
          'Pearl River County, MS': '109',
          'Perry County, MS': '111',
          'Pike County, MS': '113',
          'Pontotoc County, MS': '115',
          'Prentiss County, MS': '117',
          'Quitman County, MS': '119',
          'Rankin County, MS': '121',
          'Scott County, MS': '123',
          'Sharkey County, MS': '125',
          'Simpson County, MS': '127',
          'Smith County, MS': '129',
          'Stone County, MS': '131',
          'Sunflower County, MS': '133',
          'Tallahatchie County, MS': '135',
          'Tate County, MS': '137',
          'Tippah County, MS': '139',
          'Tishomingo County, MS': '141',
          'Tunica County, MS': '143',
          'Union County, MS': '145',
          'Walthall County, MS': '147',
          'Warren County, MS': '149',
          'Washington County, MS': '151',
          'Wayne County, MS': '153',
          'Webster County, MS': '155',
          'Wilkinson County, MS': '157',
          'Winston County, MS': '159',
          'Yalobusha County, MS': '161',
          'Yazoo County, MS': '163'},
  '29':  {'Adair County, MO': '001',
          'Andrew County, MO': '003',
          'Atchison County, MO': '005',
          'Audrain County, MO': '007',
          'Barry County, MO': '009',
          'Barton County, MO': '011',
          'Bates County, MO': '013',
          'Benton County, MO': '015',
          'Bollinger County, MO': '017',
          'Boone County, MO': '019',
          'Buchanan County, MO': '021',
          'Butler County, MO': '023',
          'Caldwell County, MO': '025',
          'Callaway County, MO': '027',
          'Camden County, MO': '029',
          'Cape Girardeau County, MO': '031',
          'Carroll County, MO': '033',
          'Carter County, MO': '035',
          'Cass County, MO': '037',
          'Cedar County, MO': '039',
          'Chariton County, MO': '041',
          'Christian County, MO': '043',
          'Clark County, MO': '045',
          'Clay County, MO': '047',
          'Clinton County, MO': '049',
          'Cole County, MO': '051',
          'Cooper County, MO': '053',
          'Crawford County, MO': '055',
          'Dade County, MO': '057',
          'Dallas County, MO': '059',
          'Daviess County, MO': '061',
          'DeKalb County, MO': '063',
          'Dent County, MO': '065',
          'Douglas County, MO': '067',
          'Dunklin County, MO': '069',
          'Franklin County, MO': '071',
          'Gasconade County, MO': '073',
          'Gentry County, MO': '075',
          'Greene County, MO': '077',
          'Grundy County, MO': '079',
          'Harrison County, MO': '081',
          'Henry County, MO': '083',
          'Hickory County, MO': '085',
          'Holt County, MO': '087',
          'Howard County, MO': '089',
          'Howell County, MO': '091',
          'Iron County, MO': '093',
          'Jackson County, MO': '095',
          'Jasper County, MO': '097',
          'Jefferson County, MO': '099',
          'Johnson County, MO': '101',
          'Knox County, MO': '103',
          'Laclede County, MO': '105',
          'Lafayette County, MO': '107',
          'Lawrence County, MO': '109',
          'Lewis County, MO': '111',
          'Lincoln County, MO': '113',
          'Linn County, MO': '115',
          'Livingston County, MO': '117',
          'Macon County, MO': '121',
          'Madison County, MO': '123',
          'Maries County, MO': '125',
          'Marion County, MO': '127',
          'McDonald County, MO': '119',
          'Mercer County, MO': '129',
          'Miller County, MO': '131',
          'Mississippi County, MO': '133',
          'Moniteau County, MO': '135',
          'Monroe County, MO': '137',
          'Montgomery County, MO': '139',
          'Morgan County, MO': '141',
          'New Madrid County, MO': '143',
          'Newton County, MO': '145',
          'Nodaway County, MO': '147',
          'Oregon County, MO': '149',
          'Osage County, MO': '151',
          'Ozark County, MO': '153',
          'Pemiscot County, MO': '155',
          'Perry County, MO': '157',
          'Pettis County, MO': '159',
          'Phelps County, MO': '161',
          'Pike County, MO': '163',
          'Platte County, MO': '165',
          'Polk County, MO': '167',
          'Pulaski County, MO': '169',
          'Putnam County, MO': '171',
          'Ralls County, MO': '173',
          'Randolph County, MO': '175',
          'Ray County, MO': '177',
          'Reynolds County, MO': '179',
          'Ripley County, MO': '181',
          'Saline County, MO': '195',
          'Schuyler County, MO': '197',
          'Scotland County, MO': '199',
          'Scott County, MO': '201',
          'Shannon County, MO': '203',
          'Shelby County, MO': '205',
          'St. Charles County, MO': '183',
          'St. Clair County, MO': '185',
          'St. Francois County, MO': '187',
          'St. Louis County, MO': '189',
          'St. Louis city, MO': '510',
          'Ste. Genevieve County, MO': '186',
          'Stoddard County, MO': '207',
          'Stone County, MO': '209',
          'Sullivan County, MO': '211',
          'Taney County, MO': '213',
          'Texas County, MO': '215',
          'Vernon County, MO': '217',
          'Warren County, MO': '219',
          'Washington County, MO': '221',
          'Wayne County, MO': '223',
          'Webster County, MO': '225',
          'Worth County, MO': '227',
          'Wright County, MO': '229'},
  '30':  {'Beaverhead County, MT': '001',
          'Big Horn County, MT': '003',
          'Blaine County, MT': '005',
          'Broadwater County, MT': '007',
          'Carbon County, MT': '009',
          'Carter County, MT': '011',
          'Cascade County, MT': '013',
          'Chouteau County, MT': '015',
          'Custer County, MT': '017',
          'Daniels County, MT': '019',
          'Dawson County, MT': '021',
          'Deer Lodge County, MT': '023',
          'Fallon County, MT': '025',
          'Fergus County, MT': '027',
          'Flathead County, MT': '029',
          'Gallatin County, MT': '031',
          'Garfield County, MT': '033',
          'Glacier County, MT': '035',
          'Golden Valley County, MT': '037',
          'Granite County, MT': '039',
          'Hill County, MT': '041',
          'Jefferson County, MT': '043',
          'Judith Basin County, MT': '045',
          'Lake County, MT': '047',
          'Lewis and Clark County, MT': '049',
          'Liberty County, MT': '051',
          'Lincoln County, MT': '053',
          'Madison County, MT': '057',
          'McCone County, MT': '055',
          'Meagher County, MT': '059',
          'Mineral County, MT': '061',
          'Missoula County, MT': '063',
          'Musselshell County, MT': '065',
          'Park County, MT': '067',
          'Petroleum County, MT': '069',
          'Phillips County, MT': '071',
          'Pondera County, MT': '073',
          'Powder River County, MT': '075',
          'Powell County, MT': '077',
          'Prairie County, MT': '079',
          'Ravalli County, MT': '081',
          'Richland County, MT': '083',
          'Roosevelt County, MT': '085',
          'Rosebud County, MT': '087',
          'Sanders County, MT': '089',
          'Sheridan County, MT': '091',
          'Silver Bow County, MT': '093',
          'Stillwater County, MT': '095',
          'Sweet Grass County, MT': '097',
          'Teton County, MT': '099',
          'Toole County, MT': '101',
          'Treasure County, MT': '103',
          'Valley County, MT': '105',
          'Wheatland County, MT': '107',
          'Wibaux County, MT': '109',
          'Yellowstone County, MT': '111'},
  '31':  {'Adams County, NE': '001',
          'Antelope County, NE': '003',
          'Arthur County, NE': '005',
          'Banner County, NE': '007',
          'Blaine County, NE': '009',
          'Boone County, NE': '011',
          'Box Butte County, NE': '013',
          'Boyd County, NE': '015',
          'Brown County, NE': '017',
          'Buffalo County, NE': '019',
          'Burt County, NE': '021',
          'Butler County, NE': '023',
          'Cass County, NE': '025',
          'Cedar County, NE': '027',
          'Chase County, NE': '029',
          'Cherry County, NE': '031',
          'Cheyenne County, NE': '033',
          'Clay County, NE': '035',
          'Colfax County, NE': '037',
          'Cuming County, NE': '039',
          'Custer County, NE': '041',
          'Dakota County, NE': '043',
          'Dawes County, NE': '045',
          'Dawson County, NE': '047',
          'Deuel County, NE': '049',
          'Dixon County, NE': '051',
          'Dodge County, NE': '053',
          'Douglas County, NE': '055',
          'Dundy County, NE': '057',
          'Fillmore County, NE': '059',
          'Franklin County, NE': '061',
          'Frontier County, NE': '063',
          'Furnas County, NE': '065',
          'Gage County, NE': '067',
          'Garden County, NE': '069',
          'Garfield County, NE': '071',
          'Gosper County, NE': '073',
          'Grant County, NE': '075',
          'Greeley County, NE': '077',
          'Hall County, NE': '079',
          'Hamilton County, NE': '081',
          'Harlan County, NE': '083',
          'Hayes County, NE': '085',
          'Hitchcock County, NE': '087',
          'Holt County, NE': '089',
          'Hooker County, NE': '091',
          'Howard County, NE': '093',
          'Jefferson County, NE': '095',
          'Johnson County, NE': '097',
          'Kearney County, NE': '099',
          'Keith County, NE': '101',
          'Keya Paha County, NE': '103',
          'Kimball County, NE': '105',
          'Knox County, NE': '107',
          'Lancaster County, NE': '109',
          'Lincoln County, NE': '111',
          'Logan County, NE': '113',
          'Loup County, NE': '115',
          'Madison County, NE': '119',
          'McPherson County, NE': '117',
          'Merrick County, NE': '121',
          'Morrill County, NE': '123',
          'Nance County, NE': '125',
          'Nemaha County, NE': '127',
          'Nuckolls County, NE': '129',
          'Otoe County, NE': '131',
          'Pawnee County, NE': '133',
          'Perkins County, NE': '135',
          'Phelps County, NE': '137',
          'Pierce County, NE': '139',
          'Platte County, NE': '141',
          'Polk County, NE': '143',
          'Red Willow County, NE': '145',
          'Richardson County, NE': '147',
          'Rock County, NE': '149',
          'Saline County, NE': '151',
          'Sarpy County, NE': '153',
          'Saunders County, NE': '155',
          'Scotts Bluff County, NE': '157',
          'Seward County, NE': '159',
          'Sheridan County, NE': '161',
          'Sherman County, NE': '163',
          'Sioux County, NE': '165',
          'Stanton County, NE': '167',
          'Thayer County, NE': '169',
          'Thomas County, NE': '171',
          'Thurston County, NE': '173',
          'Valley County, NE': '175',
          'Washington County, NE': '177',
          'Wayne County, NE': '179',
          'Webster County, NE': '181',
          'Wheeler County, NE': '183',
          'York County, NE': '185'},
  '32':  {'Carson City, NV': '510',
          'Churchill County, NV': '001',
          'Clark County, NV': '003',
          'Douglas County, NV': '005',
          'Elko County, NV': '007',
          'Esmeralda County, NV': '009',
          'Eureka County, NV': '011',
          'Humboldt County, NV': '013',
          'Lander County, NV': '015',
          'Lincoln County, NV': '017',
          'Lyon County, NV': '019',
          'Mineral County, NV': '021',
          'Nye County, NV': '023',
          'Pershing County, NV': '027',
          'Storey County, NV': '029',
          'Washoe County, NV': '031',
          'White Pine County, NV': '033'},
  '33':  {'Belknap County, NH': '001',
          'Carroll County, NH': '003',
          'Cheshire County, NH': '005',
          'Coos County, NH': '007',
          'Grafton County, NH': '009',
          'Hillsborough County, NH': '011',
          'Merrimack County, NH': '013',
          'Rockingham County, NH': '015',
          'Strafford County, NH': '017',
          'Sullivan County, NH': '019'},
  '34':  {'Atlantic County, NJ': '001',
          'Bergen County, NJ': '003',
          'Burlington County, NJ': '005',
          'Camden County, NJ': '007',
          'Cape May County, NJ': '009',
          'Cumberland County, NJ': '011',
          'Essex County, NJ': '013',
          'Gloucester County, NJ': '015',
          'Hudson County, NJ': '017',
          'Hunterdon County, NJ': '019',
          'Mercer County, NJ': '021',
          'Middlesex County, NJ': '023',
          'Monmouth County, NJ': '025',
          'Morris County, NJ': '027',
          'Ocean County, NJ': '029',
          'Passaic County, NJ': '031',
          'Salem County, NJ': '033',
          'Somerset County, NJ': '035',
          'Sussex County, NJ': '037',
          'Union County, NJ': '039',
          'Warren County, NJ': '041'},
  '35':  {'Bernalillo County, NM': '001',
          'Catron County, NM': '003',
          'Chaves County, NM': '005',
          'Cibola County, NM': '006',
          'Colfax County, NM': '007',
          'Curry County, NM': '009',
          'DeBaca County, NM': '011',
          'Dona Ana County, NM': '013',
          'Eddy County, NM': '015',
          'Grant County, NM': '017',
          'Guadalupe County, NM': '019',
          'Harding County, NM': '021',
          'Hidalgo County, NM': '023',
          'Lea County, NM': '025',
          'Lincoln County, NM': '027',
          'Los Alamos County, NM': '028',
          'Luna County, NM': '029',
          'McKinley County, NM': '031',
          'Mora County, NM': '033',
          'Otero County, NM': '035',
          'Quay County, NM': '037',
          'Rio Arriba County, NM': '039',
          'Roosevelt County, NM': '041',
          'San Juan County, NM': '045',
          'San Miguel County, NM': '047',
          'Sandoval County, NM': '043',
          'Santa Fe County, NM': '049',
          'Sierra County, NM': '051',
          'Socorro County, NM': '053',
          'Taos County, NM': '055',
          'Torrance County, NM': '057',
          'Union County, NM': '059',
          'Valencia County, NM': '061'},
  '36':  {'Albany County, NY': '001',
          'Allegany County, NY': '003',
          'Bronx County, NY': '005',
          'Broome County, NY': '007',
          'Cattaraugus County, NY': '009',
          'Cayuga County, NY': '011',
          'Chautauqua County, NY': '013',
          'Chemung County, NY': '015',
          'Chenango County, NY': '017',
          'Clinton County, NY': '019',
          'Columbia County, NY': '021',
          'Cortland County, NY': '023',
          'Delaware County, NY': '025',
          'Dutchess County, NY': '027',
          'Erie County, NY': '029',
          'Essex County, NY': '031',
          'Franklin County, NY': '033',
          'Fulton County, NY': '035',
          'Genesee County, NY': '037',
          'Greene County, NY': '039',
          'Hamilton County, NY': '041',
          'Herkimer County, NY': '043',
          'Jefferson County, NY': '045',
          'Kings County, NY': '047',
          'Lewis County, NY': '049',
          'Livingston County, NY': '051',
          'Madison County, NY': '053',
          'Monroe County, NY': '055',
          'Montgomery County, NY': '057',
          'Nassau County, NY': '059',
          'New York County, NY': '061',
          'Niagara County, NY': '063',
          'Oneida County, NY': '065',
          'Onondaga County, NY': '067',
          'Ontario County, NY': '069',
          'Orange County, NY': '071',
          'Orleans County, NY': '073',
          'Oswego County, NY': '075',
          'Otsego County, NY': '077',
          'Putnam County, NY': '079',
          'Queens County, NY': '081',
          'Rensselaer County, NY': '083',
          'Richmond County, NY': '085',
          'Rockland County, NY': '087',
          'Saratoga County, NY': '091',
          'Schenectady County, NY': '093',
          'Schoharie County, NY': '095',
          'Schuyler County, NY': '097',
          'Seneca County, NY': '099',
          'St. Lawrence County, NY': '089',
          'Steuben County, NY': '101',
          'Suffolk County, NY': '103',
          'Sullivan County, NY': '105',
          'Tioga County, NY': '107',
          'Tompkins County, NY': '109',
          'Ulster County, NY': '111',
          'Warren County, NY': '113',
          'Washington County, NY': '115',
          'Wayne County, NY': '117',
          'Westchester County, NY': '119',
          'Wyoming County, NY': '121',
          'Yates County, NY': '123'},
  '37':  {'Alamance County, NC': '001',
          'Alexander County, NC': '003',
          'Alleghany County, NC': '005',
          'Anson County, NC': '007',
          'Ashe County, NC': '009',
          'Avery County, NC': '011',
          'Beaufort County, NC': '013',
          'Bertie County, NC': '015',
          'Bladen County, NC': '017',
          'Brunswick County, NC': '019',
          'Buncombe County, NC': '021',
          'Burke County, NC': '023',
          'Cabarrus County, NC': '025',
          'Caldwell County, NC': '027',
          'Camden County, NC': '029',
          'Carteret County, NC': '031',
          'Caswell County, NC': '033',
          'Catawba County, NC': '035',
          'Chatham County, NC': '037',
          'Cherokee County, NC': '039',
          'Chowan County, NC': '041',
          'Clay County, NC': '043',
          'Cleveland County, NC': '045',
          'Columbus County, NC': '047',
          'Craven County, NC': '049',
          'Cumberland County, NC': '051',
          'Currituck County, NC': '053',
          'Dare County, NC': '055',
          'Davidson County, NC': '057',
          'Davie County, NC': '059',
          'Duplin County, NC': '061',
          'Durham County, NC': '063',
          'Edgecombe County, NC': '065',
          'Forsyth County, NC': '067',
          'Franklin County, NC': '069',
          'Gaston County, NC': '071',
          'Gates County, NC': '073',
          'Graham County, NC': '075',
          'Granville County, NC': '077',
          'Greene County, NC': '079',
          'Guilford County, NC': '081',
          'Halifax County, NC': '083',
          'Harnett County, NC': '085',
          'Haywood County, NC': '087',
          'Henderson County, NC': '089',
          'Hertford County, NC': '091',
          'Hoke County, NC': '093',
          'Hyde County, NC': '095',
          'Iredell County, NC': '097',
          'Jackson County, NC': '099',
          'Johnston County, NC': '101',
          'Jones County, NC': '103',
          'Lee County, NC': '105',
          'Lenoir County, NC': '107',
          'Lincoln County, NC': '109',
          'Macon County, NC': '113',
          'Madison County, NC': '115',
          'Martin County, NC': '117',
          'McDowell County, NC': '111',
          'Mecklenburg County, NC': '119',
          'Mitchell County, NC': '121',
          'Montgomery County, NC': '123',
          'Moore County, NC': '125',
          'Nash County, NC': '127',
          'New Hanover County, NC': '129',
          'Northampton County, NC': '131',
          'Onslow County, NC': '133',
          'Orange County, NC': '135',
          'Pamlico County, NC': '137',
          'Pasquotank County, NC': '139',
          'Pender County, NC': '141',
          'Perquimans County, NC': '143',
          'Person County, NC': '145',
          'Pitt County, NC': '147',
          'Polk County, NC': '149',
          'Randolph County, NC': '151',
          'Richmond County, NC': '153',
          'Robeson County, NC': '155',
          'Rockingham County, NC': '157',
          'Rowan County, NC': '159',
          'Rutherford County, NC': '161',
          'Sampson County, NC': '163',
          'Scotland County, NC': '165',
          'Stanly County, NC': '167',
          'Stokes County, NC': '169',
          'Surry County, NC': '171',
          'Swain County, NC': '173',
          'Transylvania County, NC': '175',
          'Tyrrell County, NC': '177',
          'Union County, NC': '179',
          'Vance County, NC': '181',
          'Wake County, NC': '183',
          'Warren County, NC': '185',
          'Washington County, NC': '187',
          'Watauga County, NC': '189',
          'Wayne County, NC': '191',
          'Wilkes County, NC': '193',
          'Wilson County, NC': '195',
          'Yadkin County, NC': '197',
          'Yancey County, NC': '199'},
  '38':  {'Adams County, ND': '001',
          'Barnes County, ND': '003',
          'Benson County, ND': '005',
          'Billings County, ND': '007',
          'Bottineau County, ND': '009',
          'Bowman County, ND': '011',
          'Burke County, ND': '013',
          'Burleigh County, ND': '015',
          'Cass County, ND': '017',
          'Cavalier County, ND': '019',
          'Dickey County, ND': '021',
          'Divide County, ND': '023',
          'Dunn County, ND': '025',
          'Eddy County, ND': '027',
          'Emmons County, ND': '029',
          'Foster County, ND': '031',
          'Golden Valley County, ND': '033',
          'Grand Forks County, ND': '035',
          'Grant County, ND': '037',
          'Griggs County, ND': '039',
          'Hettinger County, ND': '041',
          'Kidder County, ND': '043',
          'LaMoure County, ND': '045',
          'Logan County, ND': '047',
          'McHenry County, ND': '049',
          'McIntosh County, ND': '051',
          'McKenzie County, ND': '053',
          'McLean County, ND': '055',
          'Mercer County, ND': '057',
          'Morton County, ND': '059',
          'Mountrail County, ND': '061',
          'Nelson County, ND': '063',
          'Oliver County, ND': '065',
          'Pembina County, ND': '067',
          'Pierce County, ND': '069',
          'Ramsey County, ND': '071',
          'Ransom County, ND': '073',
          'Renville County, ND': '075',
          'Richland County, ND': '077',
          'Rolette County, ND': '079',
          'Sargent County, ND': '081',
          'Sheridan County, ND': '083',
          'Sioux County, ND': '085',
          'Slope County, ND': '087',
          'Stark County, ND': '089',
          'Steele County, ND': '091',
          'Stutsman County, ND': '093',
          'Towner County, ND': '095',
          'Traill County, ND': '097',
          'Walsh County, ND': '099',
          'Ward County, ND': '101',
          'Wells County, ND': '103',
          'Williams County, ND': '105'},
  '39':  {'Adams County, OH': '001',
          'Allen County, OH': '003',
          'Ashland County, OH': '005',
          'Ashtabula County, OH': '007',
          'Athens County, OH': '009',
          'Auglaize County, OH': '011',
          'Belmont County, OH': '013',
          'Brown County, OH': '015',
          'Butler County, OH': '017',
          'Carroll County, OH': '019',
          'Champaign County, OH': '021',
          'Clark County, OH': '023',
          'Clermont County, OH': '025',
          'Clinton County, OH': '027',
          'Columbiana County, OH': '029',
          'Coshocton County, OH': '031',
          'Crawford County, OH': '033',
          'Cuyahoga County, OH': '035',
          'Darke County, OH': '037',
          'Defiance County, OH': '039',
          'Delaware County, OH': '041',
          'Erie County, OH': '043',
          'Fairfield County, OH': '045',
          'Fayette County, OH': '047',
          'Franklin County, OH': '049',
          'Fulton County, OH': '051',
          'Gallia County, OH': '053',
          'Geauga County, OH': '055',
          'Greene County, OH': '057',
          'Guernsey County, OH': '059',
          'Hamilton County, OH': '061',
          'Hancock County, OH': '063',
          'Hardin County, OH': '065',
          'Harrison County, OH': '067',
          'Henry County, OH': '069',
          'Highland County, OH': '071',
          'Hocking County, OH': '073',
          'Holmes County, OH': '075',
          'Huron County, OH': '077',
          'Jackson County, OH': '079',
          'Jefferson County, OH': '081',
          'Knox County, OH': '083',
          'Lake County, OH': '085',
          'Lawrence County, OH': '087',
          'Licking County, OH': '089',
          'Logan County, OH': '091',
          'Lorain County, OH': '093',
          'Lucas County, OH': '095',
          'Madison County, OH': '097',
          'Mahoning County, OH': '099',
          'Marion County, OH': '101',
          'Medina County, OH': '103',
          'Meigs County, OH': '105',
          'Mercer County, OH': '107',
          'Miami County, OH': '109',
          'Monroe County, OH': '111',
          'Montgomery County, OH': '113',
          'Morgan County, OH': '115',
          'Morrow County, OH': '117',
          'Muskingum County, OH': '119',
          'Noble County, OH': '121',
          'Ottawa County, OH': '123',
          'Paulding County, OH': '125',
          'Perry County, OH': '127',
          'Pickaway County, OH': '129',
          'Pike County, OH': '131',
          'Portage County, OH': '133',
          'Preble County, OH': '135',
          'Putnam County, OH': '137',
          'Richland County, OH': '139',
          'Ross County, OH': '141',
          'Sandusky County, OH': '143',
          'Scioto County, OH': '145',
          'Seneca County, OH': '147',
          'Shelby County, OH': '149',
          'Stark County, OH': '151',
          'Summit County, OH': '153',
          'Trumbull County, OH': '155',
          'Tuscarawas County, OH': '157',
          'Union County, OH': '159',
          'Van Wert County, OH': '161',
          'Vinton County, OH': '163',
          'Warren County, OH': '165',
          'Washington County, OH': '167',
          'Wayne County, OH': '169',
          'Williams County, OH': '171',
          'Wood County, OH': '173',
          'Wyandot County, OH': '175'},
  '40':  {'Adair County, OK': '001',
          'Alfalfa County, OK': '003',
          'Atoka County, OK': '005',
          'Beaver County, OK': '007',
          'Beckham County, OK': '009',
          'Blaine County, OK': '011',
          'Bryan County, OK': '013',
          'Caddo County, OK': '015',
          'Canadian County, OK': '017',
          'Carter County, OK': '019',
          'Cherokee County, OK': '021',
          'Choctaw County, OK': '023',
          'Cimarron County, OK': '025',
          'Cleveland County, OK': '027',
          'Coal County, OK': '029',
          'Comanche County, OK': '031',
          'Cotton County, OK': '033',
          'Craig County, OK': '035',
          'Creek County, OK': '037',
          'Custer County, OK': '039',
          'Delaware County, OK': '041',
          'Dewey County, OK': '043',
          'Ellis County, OK': '045',
          'Garfield County, OK': '047',
          'Garvin County, OK': '049',
          'Grady County, OK': '051',
          'Grant County, OK': '053',
          'Greer County, OK': '055',
          'Harmon County, OK': '057',
          'Harper County, OK': '059',
          'Haskell County, OK': '061',
          'Hughes County, OK': '063',
          'Jackson County, OK': '065',
          'Jefferson County, OK': '067',
          'Johnston County, OK': '069',
          'Kay County, OK': '071',
          'Kingfisher County, OK': '073',
          'Kiowa County, OK': '075',
          'Latimer County, OK': '077',
          'Le Flore County, OK': '079',
          'Lincoln County, OK': '081',
          'Logan County, OK': '083',
          'Love County, OK': '085',
          'Major County, OK': '093',
          'Marshall County, OK': '095',
          'Mayes County, OK': '097',
          'McClain County, OK': '087',
          'McCurtain County, OK': '089',
          'McIntosh County, OK': '091',
          'Murray County, OK': '099',
          'Muskogee County, OK': '101',
          'Noble County, OK': '103',
          'Nowata County, OK': '105',
          'Okfuskee County, OK': '107',
          'Oklahoma County, OK': '109',
          'Okmulgee County, OK': '111',
          'Osage County, OK': '113',
          'Ottawa County, OK': '115',
          'Pawnee County, OK': '117',
          'Payne County, OK': '119',
          'Pittsburg County, OK': '121',
          'Pontotoc County, OK': '123',
          'Pottawatomie County, OK': '125',
          'Pushmataha County, OK': '127',
          'Roger Mills County, OK': '129',
          'Rogers County, OK': '131',
          'Seminole County, OK': '133',
          'Sequoyah County, OK': '135',
          'Stephens County, OK': '137',
          'Texas County, OK': '139',
          'Tillman County, OK': '141',
          'Tulsa County, OK': '143',
          'Wagoner County, OK': '145',
          'Washington County, OK': '147',
          'Washita County, OK': '149',
          'Woods County, OK': '151',
          'Woodward County, OK': '153'},
  '41':  {'Baker County, OR': '001',
          'Benton County, OR': '003',
          'Clackamas County, OR': '005',
          'Clatsop County, OR': '007',
          'Columbia County, OR': '009',
          'Coos County, OR': '011',
          'Crook County, OR': '013',
          'Curry County, OR': '015',
          'Deschutes County, OR': '017',
          'Douglas County, OR': '019',
          'Gilliam County, OR': '021',
          'Grant County, OR': '023',
          'Harney County, OR': '025',
          'Hood River County, OR': '027',
          'Jackson County, OR': '029',
          'Jefferson County, OR': '031',
          'Josephine County, OR': '033',
          'Klamath County, OR': '035',
          'Lake County, OR': '037',
          'Lane County, OR': '039',
          'Lincoln County, OR': '041',
          'Linn County, OR': '043',
          'Malheur County, OR': '045',
          'Marion County, OR': '047',
          'Morrow County, OR': '049',
          'Multnomah County, OR': '051',
          'Polk County, OR': '053',
          'Sherman County, OR': '055',
          'Tillamook County, OR': '057',
          'Umatilla County, OR': '059',
          'Union County, OR': '061',
          'Wallowa County, OR': '063',
          'Wasco County, OR': '065',
          'Washington County, OR': '067',
          'Wheeler County, OR': '069',
          'Yamhill County, OR': '071'},
  '42':  {'Adams County, PA': '001',
          'Allegheny County, PA': '003',
          'Armstrong County, PA': '005',
          'Beaver County, PA': '007',
          'Bedford County, PA': '009',
          'Berks County, PA': '011',
          'Blair County, PA': '013',
          'Bradford County, PA': '015',
          'Bucks County, PA': '017',
          'Butler County, PA': '019',
          'Cambria County, PA': '021',
          'Cameron County, PA': '023',
          'Carbon County, PA': '025',
          'Centre County, PA': '027',
          'Chester County, PA': '029',
          'Clarion County, PA': '031',
          'Clearfield County, PA': '033',
          'Clinton County, PA': '035',
          'Columbia County, PA': '037',
          'Crawford County, PA': '039',
          'Cumberland County, PA': '041',
          'Dauphin County, PA': '043',
          'Delaware County, PA': '045',
          'Elk County, PA': '047',
          'Erie County, PA': '049',
          'Fayette County, PA': '051',
          'Forest County, PA': '053',
          'Franklin County, PA': '055',
          'Fulton County, PA': '057',
          'Greene County, PA': '059',
          'Huntingdon County, PA': '061',
          'Indiana County, PA': '063',
          'Jefferson County, PA': '065',
          'Juniata County, PA': '067',
          'Lackawanna County, PA': '069',
          'Lancaster County, PA': '071',
          'Lawrence County, PA': '073',
          'Lebanon County, PA': '075',
          'Lehigh County, PA': '077',
          'Luzerne County, PA': '079',
          'Lycoming County, PA': '081',
          'McKean County, PA': '083',
          'Mercer County, PA': '085',
          'Mifflin County, PA': '087',
          'Monroe County, PA': '089',
          'Montgomery County, PA': '091',
          'Montour County, PA': '093',
          'Northampton County, PA': '095',
          'Northumberland County, PA': '097',
          'Perry County, PA': '099',
          'Philadelphia County/city, PA': '101',
          'Pike County, PA': '103',
          'Potter County, PA': '105',
          'Schuylkill County, PA': '107',
          'Snyder County, PA': '109',
          'Somerset County, PA': '111',
          'Sullivan County, PA': '113',
          'Susquehanna County, PA': '115',
          'Tioga County, PA': '117',
          'Union County, PA': '119',
          'Venango County, PA': '121',
          'Warren County, PA': '123',
          'Washington County, PA': '125',
          'Wayne County, PA': '127',
          'Westmoreland County, PA': '129',
          'Wyoming County, PA': '131',
          'York County, PA': '133'},
  '44':  {'Bristol County, RI': '001',
          'Kent County, RI': '003',
          'Newport County, RI': '005',
          'Providence County, RI': '007',
          'Washington County, RI': '009'},
  '45':  {'Abbeville County, SC': '001',
          'Aiken County, SC': '003',
          'Allendale County, SC': '005',
          'Anderson County, SC': '007',
          'Bamberg County, SC': '009',
          'Barnwell County, SC': '011',
          'Beaufort County, SC': '013',
          'Berkeley County, SC': '015',
          'Calhoun County, SC': '017',
          'Charleston County, SC': '019',
          'Cherokee County, SC': '021',
          'Chester County, SC': '023',
          'Chesterfield County, SC': '025',
          'Clarendon County, SC': '027',
          'Colleton County, SC': '029',
          'Darlington County, SC': '031',
          'Dillon County, SC': '033',
          'Dorchester County, SC': '035',
          'Edgefield County, SC': '037',
          'Fairfield County, SC': '039',
          'Florence County, SC': '041',
          'Georgetown County, SC': '043',
          'Greenville County, SC': '045',
          'Greenwood County, SC': '047',
          'Hampton County, SC': '049',
          'Horry County, SC': '051',
          'Jasper County, SC': '053',
          'Kershaw County, SC': '055',
          'Lancaster County, SC': '057',
          'Laurens County, SC': '059',
          'Lee County, SC': '061',
          'Lexington County, SC': '063',
          'Marion County, SC': '067',
          'Marlboro County, SC': '069',
          'McCormick County, SC': '065',
          'Newberry County, SC': '071',
          'Oconee County, SC': '073',
          'Orangeburg County, SC': '075',
          'Pickens County, SC': '077',
          'Richland County, SC': '079',
          'Saluda County, SC': '081',
          'Spartanburg County, SC': '083',
          'Sumter County, SC': '085',
          'Union County, SC': '087',
          'Williamsburg County, SC': '089',
          'York County, SC': '091'},
  '46':  {'Aurora County, SD': '003',
          'Beadle County, SD': '005',
          'Bennett County, SD': '007',
          'Bon Homme County, SD': '009',
          'Brookings County, SD': '011',
          'Brown County, SD': '013',
          'Brule County, SD': '015',
          'Buffalo County, SD': '017',
          'Butte County, SD': '019',
          'Campbell County, SD': '021',
          'Charles Mix County, SD': '023',
          'Clark County, SD': '025',
          'Clay County, SD': '027',
          'Codington County, SD': '029',
          'Corson County, SD': '031',
          'Custer County, SD': '033',
          'Davison County, SD': '035',
          'Day County, SD': '037',
          'Deuel County, SD': '039',
          'Dewey County, SD': '041',
          'Douglas County, SD': '043',
          'Edmunds County, SD': '045',
          'Fall River County, SD': '047',
          'Faulk County, SD': '049',
          'Grant County, SD': '051',
          'Gregory County, SD': '053',
          'Haakon County, SD': '055',
          'Hamlin County, SD': '057',
          'Hand County, SD': '059',
          'Hanson County, SD': '061',
          'Harding County, SD': '063',
          'Hughes County, SD': '065',
          'Hutchinson County, SD': '067',
          'Hyde County, SD': '069',
          'Jackson County, SD': '071',
          'Jerauld County, SD': '073',
          'Jones County, SD': '075',
          'Kingsbury County, SD': '077',
          'Lake County, SD': '079',
          'Lawrence County, SD': '081',
          'Lincoln County, SD': '083',
          'Lyman County, SD': '085',
          'Marshall County, SD': '091',
          'McCook County, SD': '087',
          'McPherson County, SD': '089',
          'Meade County, SD': '093',
          'Mellette County, SD': '095',
          'Miner County, SD': '097',
          'Minnehaha County, SD': '099',
          'Moody County, SD': '101',
          'Pennington County, SD': '103',
          'Perkins County, SD': '105',
          'Potter County, SD': '107',
          'Roberts County, SD': '109',
          'Sanborn County, SD': '111',
          'Shannon County, SD': '113',
          'Spink County, SD': '115',
          'Stanley County, SD': '117',
          'Sully County, SD': '119',
          'Todd County, SD': '121',
          'Tripp County, SD': '123',
          'Turner County, SD': '125',
          'Union County, SD': '127',
          'Walworth County, SD': '129',
          'Yankton County, SD': '135',
          'Ziebach County, SD': '137'},
  '47':  {'Anderson County, TN': '001',
          'Bedford County, TN': '003',
          'Benton County, TN': '005',
          'Bledsoe County, TN': '007',
          'Blount County, TN': '009',
          'Bradley County, TN': '011',
          'Campbell County, TN': '013',
          'Cannon County, TN': '015',
          'Carroll County, TN': '017',
          'Carter County, TN': '019',
          'Cheatham County, TN': '021',
          'Chester County, TN': '023',
          'Claiborne County, TN': '025',
          'Clay County, TN': '027',
          'Cocke County, TN': '029',
          'Coffee County, TN': '031',
          'Crockett County, TN': '033',
          'Cumberland County, TN': '035',
          'Davidson County, TN': '037',
          'DeKalb County, TN': '041',
          'Decatur County, TN': '039',
          'Dickson County, TN': '043',
          'Dyer County, TN': '045',
          'Fayette County, TN': '047',
          'Fentress County, TN': '049',
          'Franklin County, TN': '051',
          'Gibson County, TN': '053',
          'Giles County, TN': '055',
          'Grainger County, TN': '057',
          'Greene County, TN': '059',
          'Grundy County, TN': '061',
          'Hamblen County, TN': '063',
          'Hamilton County, TN': '065',
          'Hancock County, TN': '067',
          'Hardeman County, TN': '069',
          'Hardin County, TN': '071',
          'Hawkins County, TN': '073',
          'Haywood County, TN': '075',
          'Henderson County, TN': '077',
          'Henry County, TN': '079',
          'Hickman County, TN': '081',
          'Houston County, TN': '083',
          'Humphreys County, TN': '085',
          'Jackson County, TN': '087',
          'Jefferson County, TN': '089',
          'Johnson County, TN': '091',
          'Knox County, TN': '093',
          'Lake County, TN': '095',
          'Lauderdale County, TN': '097',
          'Lawrence County, TN': '099',
          'Lewis County, TN': '101',
          'Lincoln County, TN': '103',
          'Loudon County, TN': '105',
          'Macon County, TN': '111',
          'Madison County, TN': '113',
          'Marion County, TN': '115',
          'Marshall County, TN': '117',
          'Maury County, TN': '119',
          'McMinn County, TN': '107',
          'McNairy County, TN': '109',
          'Meigs County, TN': '121',
          'Monroe County, TN': '123',
          'Montgomery County, TN': '125',
          'Moore County, TN': '127',
          'Morgan County, TN': '129',
          'Obion County, TN': '131',
          'Overton County, TN': '133',
          'Perry County, TN': '135',
          'Pickett County, TN': '137',
          'Polk County, TN': '139',
          'Putnam County, TN': '141',
          'Rhea County, TN': '143',
          'Roane County, TN': '145',
          'Robertson County, TN': '147',
          'Rutherford County, TN': '149',
          'Scott County, TN': '151',
          'Sequatchie County, TN': '153',
          'Sevier County, TN': '155',
          'Shelby County, TN': '157',
          'Smith County, TN': '159',
          'Stewart County, TN': '161',
          'Sullivan County, TN': '163',
          'Sumner County, TN': '165',
          'Tipton County, TN': '167',
          'Trousdale County, TN': '169',
          'Unicoi County, TN': '171',
          'Union County, TN': '173',
          'Van Buren County, TN': '175',
          'Warren County, TN': '177',
          'Washington County, TN': '179',
          'Wayne County, TN': '181',
          'Weakley County, TN': '183',
          'White County, TN': '185',
          'Williamson County, TN': '187',
          'Wilson County, TN': '189'},
  '48':  {'Anderson County, TX': '001',
          'Andrews County, TX': '003',
          'Angelina County, TX': '005',
          'Aransas County, TX': '007',
          'Archer County, TX': '009',
          'Armstrong County, TX': '011',
          'Atascosa County, TX': '013',
          'Austin County, TX': '015',
          'Bailey County, TX': '017',
          'Bandera County, TX': '019',
          'Bastrop County, TX': '021',
          'Baylor County, TX': '023',
          'Bee County, TX': '025',
          'Bell County, TX': '027',
          'Bexar County, TX': '029',
          'Blanco County, TX': '031',
          'Borden County, TX': '033',
          'Bosque County, TX': '035',
          'Bowie County, TX': '037',
          'Brazoria County, TX': '039',
          'Brazos County, TX': '041',
          'Brewster County, TX': '043',
          'Briscoe County, TX': '045',
          'Brooks County, TX': '047',
          'Brown County, TX': '049',
          'Burleson County, TX': '051',
          'Burnet County, TX': '053',
          'Caldwell County, TX': '055',
          'Calhoun County, TX': '057',
          'Callahan County, TX': '059',
          'Cameron County, TX': '061',
          'Camp County, TX': '063',
          'Carson County, TX': '065',
          'Cass County, TX': '067',
          'Castro County, TX': '069',
          'Chambers County, TX': '071',
          'Cherokee County, TX': '073',
          'Childress County, TX': '075',
          'Clay County, TX': '077',
          'Cochran County, TX': '079',
          'Coke County, TX': '081',
          'Coleman County, TX': '083',
          'Collin County, TX': '085',
          'Collingsworth County, TX': '087',
          'Colorado County, TX': '089',
          'Comal County, TX': '091',
          'Comanche County, TX': '093',
          'Concho County, TX': '095',
          'Cooke County, TX': '097',
          'Coryell County, TX': '099',
          'Cottle County, TX': '101',
          'Crane County, TX': '103',
          'Crockett County, TX': '105',
          'Crosby County, TX': '107',
          'Culberson County, TX': '109',
          'Dallam County, TX': '111',
          'Dallas County, TX': '113',
          'Dawson County, TX': '115',
          'DeWitt County, TX': '123',
          'Deaf Smith County, TX': '117',
          'Delta County, TX': '119',
          'Denton County, TX': '121',
          'Dickens County, TX': '125',
          'Dimmit County, TX': '127',
          'Donley County, TX': '129',
          'Duval County, TX': '131',
          'Eastland County, TX': '133',
          'Ector County, TX': '135',
          'Edwards County, TX': '137',
          'El Paso County, TX': '141',
          'Ellis County, TX': '139',
          'Erath County, TX': '143',
          'Falls County, TX': '145',
          'Fannin County, TX': '147',
          'Fayette County, TX': '149',
          'Fisher County, TX': '151',
          'Floyd County, TX': '153',
          'Foard County, TX': '155',
          'Fort Bend County, TX': '157',
          'Franklin County, TX': '159',
          'Freestone County, TX': '161',
          'Frio County, TX': '163',
          'Gaines County, TX': '165',
          'Galveston County, TX': '167',
          'Garza County, TX': '169',
          'Gillespie County, TX': '171',
          'Glasscock County, TX': '173',
          'Goliad County, TX': '175',
          'Gonzales County, TX': '177',
          'Gray County, TX': '179',
          'Grayson County, TX': '181',
          'Gregg County, TX': '183',
          'Grimes County, TX': '185',
          'Guadalupe County, TX': '187',
          'Hale County, TX': '189',
          'Hall County, TX': '191',
          'Hamilton County, TX': '193',
          'Hansford County, TX': '195',
          'Hardeman County, TX': '197',
          'Hardin County, TX': '199',
          'Harris County, TX': '201',
          'Harrison County, TX': '203',
          'Hartley County, TX': '205',
          'Haskell County, TX': '207',
          'Hays County, TX': '209',
          'Hemphill County, TX': '211',
          'Henderson County, TX': '213',
          'Hidalgo County, TX': '215',
          'Hill County, TX': '217',
          'Hockley County, TX': '219',
          'Hood County, TX': '221',
          'Hopkins County, TX': '223',
          'Houston County, TX': '225',
          'Howard County, TX': '227',
          'Hudspeth County, TX': '229',
          'Hunt County, TX': '231',
          'Hutchinson County, TX': '233',
          'Irion County, TX': '235',
          'Jack County, TX': '237',
          'Jackson County, TX': '239',
          'Jasper County, TX': '241',
          'Jeff Davis County, TX': '243',
          'Jefferson County, TX': '245',
          'Jim Hogg County, TX': '247',
          'Jim Wells County, TX': '249',
          'Johnson County, TX': '251',
          'Jones County, TX': '253',
          'Karnes County, TX': '255',
          'Kaufman County, TX': '257',
          'Kendall County, TX': '259',
          'Kenedy County, TX': '261',
          'Kent County, TX': '263',
          'Kerr County, TX': '265',
          'Kimble County, TX': '267',
          'King County, TX': '269',
          'Kinney County, TX': '271',
          'Kleberg County, TX': '273',
          'Knox County, TX': '275',
          'La Salle County, TX': '283',
          'Lamar County, TX': '277',
          'Lamb County, TX': '279',
          'Lampasas County, TX': '281',
          'Lavaca County, TX': '285',
          'Lee County, TX': '287',
          'Leon County, TX': '289',
          'Liberty County, TX': '291',
          'Limestone County, TX': '293',
          'Lipscomb County, TX': '295',
          'Live Oak County, TX': '297',
          'Llano County, TX': '299',
          'Loving County, TX': '301',
          'Lubbock County, TX': '303',
          'Lynn County, TX': '305',
          'Madison County, TX': '313',
          'Marion County, TX': '315',
          'Martin County, TX': '317',
          'Mason County, TX': '319',
          'Matagorda County, TX': '321',
          'Maverick County, TX': '323',
          'McCulloch County, TX': '307',
          'McLennan County, TX': '309',
          'McMullen County, TX': '311',
          'Medina County, TX': '325',
          'Menard County, TX': '327',
          'Midland County, TX': '329',
          'Milam County, TX': '331',
          'Mills County, TX': '333',
          'Mitchell County, TX': '335',
          'Montague County, TX': '337',
          'Montgomery County, TX': '339',
          'Moore County, TX': '341',
          'Morris County, TX': '343',
          'Motley County, TX': '345',
          'Nacogdoches County, TX': '347',
          'Navarro County, TX': '349',
          'Newton County, TX': '351',
          'Nolan County, TX': '353',
          'Nueces County, TX': '355',
          'Ochiltree County, TX': '357',
          'Oldham County, TX': '359',
          'Orange County, TX': '361',
          'Palo Pinto County, TX': '363',
          'Panola County, TX': '365',
          'Parker County, TX': '367',
          'Parmer County, TX': '369',
          'Pecos County, TX': '371',
          'Polk County, TX': '373',
          'Potter County, TX': '375',
          'Presidio County, TX': '377',
          'Rains County, TX': '379',
          'Randall County, TX': '381',
          'Reagan County, TX': '383',
          'Real County, TX': '385',
          'Red River County, TX': '387',
          'Reeves County, TX': '389',
          'Refugio County, TX': '391',
          'Roberts County, TX': '393',
          'Robertson County, TX': '395',
          'Rockwall County, TX': '397',
          'Runnels County, TX': '399',
          'Rusk County, TX': '401',
          'Sabine County, TX': '403',
          'San Augustine County, TX': '405',
          'San Jacinto County, TX': '407',
          'San Patricio County, TX': '409',
          'San Saba County, TX': '411',
          'Schleicher County, TX': '413',
          'Scurry County, TX': '415',
          'Shackelford County, TX': '417',
          'Shelby County, TX': '419',
          'Sherman County, TX': '421',
          'Smith County, TX': '423',
          'Somervell County, TX': '425',
          'Starr County, TX': '427',
          'Stephens County, TX': '429',
          'Sterling County, TX': '431',
          'Stonewall County, TX': '433',
          'Sutton County, TX': '435',
          'Swisher County, TX': '437',
          'Tarrant County, TX': '439',
          'Taylor County, TX': '441',
          'Terrell County, TX': '443',
          'Terry County, TX': '445',
          'Throckmorton County, TX': '447',
          'Titus County, TX': '449',
          'Tom Green County, TX': '451',
          'Travis County, TX': '453',
          'Trinity County, TX': '455',
          'Tyler County, TX': '457',
          'Upshur County, TX': '459',
          'Upton County, TX': '461',
          'Uvalde County, TX': '463',
          'Val Verde County, TX': '465',
          'Van Zandt County, TX': '467',
          'Victoria County, TX': '469',
          'Walker County, TX': '471',
          'Waller County, TX': '473',
          'Ward County, TX': '475',
          'Washington County, TX': '477',
          'Webb County, TX': '479',
          'Wharton County, TX': '481',
          'Wheeler County, TX': '483',
          'Wichita County, TX': '485',
          'Wilbarger County, TX': '487',
          'Willacy County, TX': '489',
          'Williamson County, TX': '491',
          'Wilson County, TX': '493',
          'Winkler County, TX': '495',
          'Wise County, TX': '497',
          'Wood County, TX': '499',
          'Yoakum County, TX': '501',
          'Young County, TX': '503',
          'Zapata County, TX': '505',
          'Zavala County, TX': '507'},
  '49':  {'Beaver County, UT': '001',
          'Box Elder County, UT': '003',
          'Cache County, UT': '005',
          'Carbon County, UT': '007',
          'Daggett County, UT': '009',
          'Davis County, UT': '011',
          'Duchesne County, UT': '013',
          'Emery County, UT': '015',
          'Garfield County, UT': '017',
          'Grand County, UT': '019',
          'Iron County, UT': '021',
          'Juab County, UT': '023',
          'Kane County, UT': '025',
          'Millard County, UT': '027',
          'Morgan County, UT': '029',
          'Piute County, UT': '031',
          'Rich County, UT': '033',
          'Salt Lake County, UT': '035',
          'San Juan County, UT': '037',
          'Sanpete County, UT': '039',
          'Sevier County, UT': '041',
          'Summit County, UT': '043',
          'Tooele County, UT': '045',
          'Uintah County, UT': '047',
          'Utah County, UT': '049',
          'Wasatch County, UT': '051',
          'Washington County, UT': '053',
          'Wayne County, UT': '055',
          'Weber County, UT': '057'},
  '50':  {'Addison County, VT': '001',
          'Bennington County, VT': '003',
          'Caledonia County, VT': '005',
          'Chittenden County, VT': '007',
          'Essex County, VT': '009',
          'Franklin County, VT': '011',
          'Grand Isle County, VT': '013',
          'Lamoille County, VT': '015',
          'Orange County, VT': '017',
          'Orleans County, VT': '019',
          'Rutland County, VT': '021',
          'Washington County, VT': '023',
          'Windham County, VT': '025',
          'Windsor County, VT': '027'},
  '51':  {'Accomack County, VA': '001',
          'Albemarle County, VA': '003',
          'Alexandria city, VA': '510',
          'Alleghany County, VA': '005',
          'Amelia County, VA': '007',
          'Amherst County, VA': '009',
          'Appomattox County, VA': '011',
          'Arlington County, VA': '013',
          'Augusta County, VA': '015',
          'Bath County, VA': '017',
          'Bedford County, VA': '019',
          'Bedford city, VA': '515',
          'Bland County, VA': '021',
          'Botetourt County, VA': '023',
          'Bristol city, VA': '520',
          'Brunswick County, VA': '025',
          'Buchanan County, VA': '027',
          'Buckingham County, VA': '029',
          'Buena Vista city, VA': '530',
          'Campbell County, VA': '031',
          'Caroline County, VA': '033',
          'Carroll County, VA': '035',
          'Charles City County, VA': '036',
          'Charlotte County, VA': '037',
          'Charlottesville city, VA': '540',
          'Chesapeake city, VA': '550',
          'Chesterfield County, VA': '041',
          'Clarke County, VA': '043',
          'Colonial Heights city, VA': '570',
          'Covington city, VA': '580',
          'Craig County, VA': '045',
          'Culpeper County, VA': '047',
          'Cumberland County, VA': '049',
          'Danville city, VA': '590',
          'Dickenson County, VA': '051',
          'Dinwiddie County, VA': '053',
          'Emporia city, VA': '595',
          'Essex County, VA': '057',
          'Fairfax County, VA': '059',
          'Fairfax city, VA': '600',
          'Falls Church city, VA': '610',
          'Fauquier County, VA': '061',
          'Floyd County, VA': '063',
          'Fluvanna County, VA': '065',
          'Franklin County, VA': '067',
          'Franklin city, VA': '620',
          'Frederick County, VA': '069',
          'Fredericksburg city, VA': '630',
          'Galax city, VA': '640',
          'Giles County, VA': '071',
          'Gloucester County, VA': '073',
          'Goochland County, VA': '075',
          'Grayson County, VA': '077',
          'Greene County, VA': '079',
          'Greensville County, VA': '081',
          'Halifax County, VA': '083',
          'Hampton city, VA': '650',
          'Hanover County, VA': '085',
          'Harrisonburg city, VA': '660',
          'Henrico County, VA': '087',
          'Henry County, VA': '089',
          'Highland County, VA': '091',
          'Hopewell city, VA': '670',
          'Isle of Wight County, VA': '093',
          'James City County, VA': '095',
          'King George County, VA': '099',
          'King William County, VA': '101',
          'King and Queen County, VA': '097',
          'Lancaster County, VA': '103',
          'Lee County, VA': '105',
          'Lexington city, VA': '678',
          'Loudoun County, VA': '107',
          'Louisa County, VA': '109',
          'Lunenburg County, VA': '111',
          'Lynchburg city, VA': '680',
          'Madison County, VA': '113',
          'Manassas Park city, VA': '685',
          'Manassas city, VA': '683',
          'Martinsville city, VA': '690',
          'Mathews County, VA': '115',
          'Mecklenburg County, VA': '117',
          'Middlesex County, VA': '119',
          'Montgomery County, VA': '121',
          'Nelson County, VA': '125',
          'New Kent County, VA': '127',
          'Newport News city, VA': '700',
          'Norfolk city, VA': '710',
          'Northampton County, VA': '131',
          'Northumberland County, VA': '133',
          'Norton city, VA': '720',
          'Nottoway County, VA': '135',
          'Orange County, VA': '137',
          'Page County, VA': '139',
          'Patrick County, VA': '141',
          'Petersburg city, VA': '730',
          'Pittsylvania County, VA': '143',
          'Poquoson city, VA': '735',
          'Portsmouth city, VA': '740',
          'Powhatan County, VA': '145',
          'Prince Edward County, VA': '147',
          'Prince George County, VA': '149',
          'Prince William County, VA': '153',
          'Pulaski County, VA': '155',
          'Radford city, VA': '750',
          'Rappahannock County, VA': '157',
          'Richmond County, VA': '159',
          'Richmond city, VA': '760',
          'Roanoke County, VA': '161',
          'Roanoke city, VA': '770',
          'Rockbridge County, VA': '163',
          'Rockingham County, VA': '165',
          'Russell County, VA': '167',
          'Salem city, VA': '775',
          'Scott County, VA': '169',
          'Shenandoah County, VA': '171',
          'Smyth County, VA': '173',
          'Southampton County, VA': '175',
          'Spotsylvania County, VA': '177',
          'Stafford County, VA': '179',
          'Staunton city, VA': '790',
          'Suffolk city, VA': '800',
          'Surry County, VA': '181',
          'Sussex County, VA': '183',
          'Tazewell County, VA': '185',
          'Virginia Beach city, VA': '810',
          'Warren County, VA': '187',
          'Washington County, VA': '191',
          'Waynesboro city, VA': '820',
          'Westmoreland County, VA': '193',
          'Williamsburg city, VA': '830',
          'Winchester city, VA': '840',
          'Wise County, VA': '195',
          'Wythe County, VA': '197',
          'York County, VA': '199'},
  '53':  {'Adams County, WA': '001',
          'Asotin County, WA': '003',
          'Benton County, WA': '005',
          'Chelan County, WA': '007',
          'Clallam County, WA': '009',
          'Clark County, WA': '011',
          'Columbia County, WA': '013',
          'Cowlitz County, WA': '015',
          'Douglas County, WA': '017',
          'Ferry County, WA': '019',
          'Franklin County, WA': '021',
          'Garfield County, WA': '023',
          'Grant County, WA': '025',
          'Grays Harbor County, WA': '027',
          'Island County, WA': '029',
          'Jefferson County, WA': '031',
          'King County, WA': '033',
          'Kitsap County, WA': '035',
          'Kittitas County, WA': '037',
          'Klickitat County, WA': '039',
          'Lewis County, WA': '041',
          'Lincoln County, WA': '043',
          'Mason County, WA': '045',
          'Okanogan County, WA': '047',
          'Pacific County, WA': '049',
          'Pend Oreille County, WA': '051',
          'Pierce County, WA': '053',
          'San Juan County, WA': '055',
          'Skagit County, WA': '057',
          'Skamania County, WA': '059',
          'Snohomish County, WA': '061',
          'Spokane County, WA': '063',
          'Stevens County, WA': '065',
          'Thurston County, WA': '067',
          'Wahkiakum County, WA': '069',
          'Walla Walla County, WA': '071',
          'Whatcom County, WA': '073',
          'Whitman County, WA': '075',
          'Yakima County, WA': '077'},
  '54':  {'Barbour County, WV': '001',
          'Berkeley County, WV': '003',
          'Boone County, WV': '005',
          'Braxton County, WV': '007',
          'Brooke County, WV': '009',
          'Cabell County, WV': '011',
          'Calhoun County, WV': '013',
          'Clay County, WV': '015',
          'Doddridge County, WV': '017',
          'Fayette County, WV': '019',
          'Gilmer County, WV': '021',
          'Grant County, WV': '023',
          'Greenbrier County, WV': '025',
          'Hampshire County, WV': '027',
          'Hancock County, WV': '029',
          'Hardy County, WV': '031',
          'Harrison County, WV': '033',
          'Jackson County, WV': '035',
          'Jefferson County, WV': '037',
          'Kanawha County, WV': '039',
          'Lewis County, WV': '041',
          'Lincoln County, WV': '043',
          'Logan County, WV': '045',
          'Marion County, WV': '049',
          'Marshall County, WV': '051',
          'Mason County, WV': '053',
          'McDowell County, WV': '047',
          'Mercer County, WV': '055',
          'Mineral County, WV': '057',
          'Mingo County, WV': '059',
          'Monongalia County, WV': '061',
          'Monroe County, WV': '063',
          'Morgan County, WV': '065',
          'Nicholas County, WV': '067',
          'Ohio County, WV': '069',
          'Pendleton County, WV': '071',
          'Pleasants County, WV': '073',
          'Pocahontas County, WV': '075',
          'Preston County, WV': '077',
          'Putnam County, WV': '079',
          'Raleigh County, WV': '081',
          'Randolph County, WV': '083',
          'Ritchie County, WV': '085',
          'Roane County, WV': '087',
          'Summers County, WV': '089',
          'Taylor County, WV': '091',
          'Tucker County, WV': '093',
          'Tyler County, WV': '095',
          'Upshur County, WV': '097',
          'Wayne County, WV': '099',
          'Webster County, WV': '101',
          'Wetzel County, WV': '103',
          'Wirt County, WV': '105',
          'Wood County, WV': '107',
          'Wyoming County, WV': '109'},
  '55':  {'Adams County, WI': '001',
          'Ashland County, WI': '003',
          'Barron County, WI': '005',
          'Bayfield County, WI': '007',
          'Brown County, WI': '009',
          'Buffalo County, WI': '011',
          'Burnett County, WI': '013',
          'Calumet County, WI': '015',
          'Chippewa County, WI': '017',
          'Clark County, WI': '019',
          'Columbia County, WI': '021',
          'Crawford County, WI': '023',
          'Dane County, WI': '025',
          'Dodge County, WI': '027',
          'Door County, WI': '029',
          'Douglas County, WI': '031',
          'Dunn County, WI': '033',
          'Eau Claire County, WI': '035',
          'Florence County, WI': '037',
          'Fond du Lac County, WI': '039',
          'Forest County, WI': '041',
          'Grant County, WI': '043',
          'Green County, WI': '045',
          'Green Lake County, WI': '047',
          'Iowa County, WI': '049',
          'Iron County, WI': '051',
          'Jackson County, WI': '053',
          'Jefferson County, WI': '055',
          'Juneau County, WI': '057',
          'Kenosha County, WI': '059',
          'Kewaunee County, WI': '061',
          'La Crosse County, WI': '063',
          'Lafayette County, WI': '065',
          'Langlade County, WI': '067',
          'Lincoln County, WI': '069',
          'Manitowoc County, WI': '071',
          'Marathon County, WI': '073',
          'Marinette County, WI': '075',
          'Marquette County, WI': '077',
          'Menominee County, WI': '078',
          'Milwaukee County, WI': '079',
          'Monroe County, WI': '081',
          'Oconto County, WI': '083',
          'Oneida County, WI': '085',
          'Outagamie County, WI': '087',
          'Ozaukee County, WI': '089',
          'Pepin County, WI': '091',
          'Pierce County, WI': '093',
          'Polk County, WI': '095',
          'Portage County, WI': '097',
          'Price County, WI': '099',
          'Racine County, WI': '101',
          'Richland County, WI': '103',
          'Rock County, WI': '105',
          'Rusk County, WI': '107',
          'Sauk County, WI': '111',
          'Sawyer County, WI': '113',
          'Shawano County, WI': '115',
          'Sheboygan County, WI': '117',
          'St. Croix County, WI': '109',
          'Taylor County, WI': '119',
          'Trempealeau County, WI': '121',
          'Vernon County, WI': '123',
          'Vilas County, WI': '125',
          'Walworth County, WI': '127',
          'Washburn County, WI': '129',
          'Washington County, WI': '131',
          'Waukesha County, WI': '133',
          'Waupaca County, WI': '135',
          'Waushara County, WI': '137',
          'Winnebago County, WI': '139',
          'Wood County, WI': '141'},
  '56':  {'Albany County, WY': '001',
          'Big Horn County, WY': '003',
          'Campbell County, WY': '005',
          'Carbon County, WY': '007',
          'Converse County, WY': '009',
          'Crook County, WY': '011',
          'Fremont County, WY': '013',
          'Goshen County, WY': '015',
          'Hot Springs County, WY': '017',
          'Johnson County, WY': '019',
          'Laramie County, WY': '021',
          'Lincoln County, WY': '023',
          'Natrona County, WY': '025',
          'Niobrara County, WY': '027',
          'Park County, WY': '029',
          'Platte County, WY': '031',
          'Sheridan County, WY': '033',
          'Sublette County, WY': '035',
          'Sweetwater County, WY': '037',
          'Teton County, WY': '039',
          'Uinta County, WY': '041',
          'Washakie County, WY': '043',
          'Weston County, WY': '045'},
  '72':  {'Adjuntas Municipio, PR': '001',
          'Aguada Municipio, PR': '003',
          'Aguadilla Municipio, PR': '005',
          'Aguas Buenas Municipio, PR': '007',
          'Aibonito Municipio, PR': '009',
          'Anasco Municipio, PR': '011',
          'Arecibo Municipio, PR': '013',
          'Arroyo Municipio, PR': '015',
          'Barceloneta Municipio, PR': '017',
          'Barranquitas Municipio, PR': '019',
          'Bayamon Municipio, PR': '021',
          'Cabo Rojo Municipio, PR': '023',
          'Caguas Municipio, PR': '025',
          'Camuy Municipio, PR': '027',
          'Canovanas Municipio, PR': '029',
          'Carolina Municipio, PR': '031',
          'Catano Municipio, PR': '033',
          'Cayey Municipio, PR': '035',
          'Ceiba Municipio, PR': '037',
          'Ciales Municipio, PR': '039',
          'Cidra Municipio, PR': '041',
          'Coamo Municipio, PR': '043',
          'Comerio Municipio, PR': '045',
          'Corozal Municipio, PR': '047',
          'Culebra Municipio, PR': '049',
          'Dorado Municipio, PR': '051',
          'Fajardo Municipio, PR': '053',
          'Florida Municipio, PR': '054',
          'Guanica Municipio, PR': '055',
          'Guayama Municipio, PR': '057',
          'Guayanilla Municipio, PR': '059',
          'Guaynabo Municipio, PR': '061',
          'Gurabo Municipio, PR': '063',
          'Hatillo Municipio, PR': '065',
          'Hormigueros Municipio, PR': '067',
          'Humacao Municipio, PR': '069',
          'Isabela Municipio, PR': '071',
          'Jayuya Municipio, PR': '073',
          'Juana Diaz Municipio, PR': '075',
          'Juncos Municipio, PR': '077',
          'Lajas Municipio, PR': '079',
          'Lares Municipio, PR': '081',
          'Las Marias Municipio, PR': '083',
          'Las Piedras Municipio, PR': '085',
          'Loiza Municipio, PR': '087',
          'Luquillo Municipio, PR': '089',
          'Manati Municipio, PR': '091',
          'Maricao Municipio, PR': '093',
          'Maunabo Municipio, PR': '095',
          'Mayaguez Municipio, PR': '097',
          'Moca Municipio, PR': '099',
          'Morovis Municipio, PR': '101',
          'Naguabo Municipio, PR': '103',
          'Naranjito Municipio, PR': '105',
          'Orocovis Municipio, PR': '107',
          'Patillas Municipio, PR': '109',
          'Penuelas Municipio, PR': '111',
          'Ponce Municipio, PR': '113',
          'Quebradillas Municipio, PR': '115',
          'Rincon Municipio, PR': '117',
          'Rio Grande Municipio, PR': '119',
          'Sabana Grande Municipio, PR': '121',
          'Salinas Municipio, PR': '123',
          'San German Municipio, PR': '125',
          'San Juan Municipio, PR': '127',
          'San Lorenzo Municipio, PR': '129',
          'San Sebastian Municipio, PR': '131',
          'Santa Isabel Municipio, PR': '133',
          'Toa Alta Municipio, PR': '135',
          'Toa Baja Municipio, PR': '137',
          'Trujillo Alto Municipio, PR': '139',
          'Utuado Municipio, PR': '141',
          'Vega Alta Municipio, PR': '143',
          'Vega Baja Municipio, PR': '145',
          'Vieques Municipio, PR': '147',
          'Villalba Municipio, PR': '149',
          'Yabucoa Municipio, PR': '151',
          'Yauco Municipio, PR': '153'},
  "CA01": {'--All--': '%', },
  "CA02": {'--All--': '%', },
  "CA03": {'--All--': '%', },
  "CA04": {'--All--': '%', },
  "CA05": {'--All--': '%', },
  "CA13": {'--All--': '%', },
  "CA07": {'--All--': '%', },
  "CA14": {'--All--': '%', },
  "CA08": {'--All--': '%', },
  "CA09": {'--All--': '%', },
  "CA10": {'--All--': '%', },
  "CA11": {'--All--': '%', },
  "CA12": {'--All--': '%', },
}


if __name__ == "__main__":
    from sys import argv
    from pprint import PrettyPrinter
    pp = PrettyPrinter(indent=2)

    import csv
    fipsreader = csv.reader(open(argv[1], 'rb'), delimiter=',', quotechar='"')
    for row in fipsreader:
        try:
            FIPS_COUNTIES[int(row[1])][row[3]] = row[2]
        except KeyError:
            FIPS_COUNTIES[int(row[1])] = {'--All--': '%'}
            FIPS_COUNTIES[int(row[1])][row[3]] = row[2]

    pp.pprint(FIPS_COUNTIES)
