'''OpenGL extension EXT.clip_control

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.clip_control to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides additional clip control modes to configure how
	clip space is mapped to window space.  This extension's goal is to 1)
	allow OpenGL to effectively match Direct3D's coordinate system
	conventions, and 2) potentially improve the numerical precision of the Z
	coordinate mapping.
	
	This extension is a port of GL_ARB_clip_control to OpenGL ES. For the
	complete overview of this extension, refer to the "Overview" section of
	GL_ARB_clip_control.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/clip_control.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.clip_control import *
from OpenGL.raw.GLES2.EXT.clip_control import _EXTENSION_NAME

def glInitClipControlEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION