# Config module for Waffle
#
# Provides the following variables
# Waffle_INCLUDE_DIRS - Directories to include
# Waffle_LIBRARIES    - Libraries to link
# Waffle_LIBRARY_DIRS - Library directories to search for link libraries


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was WaffleConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

####################################################################################

set_and_check(Waffle_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include/waffle-1")
set_and_check(Waffle_LIBRARY_DIRS "${PACKAGE_PREFIX_DIR}/lib")
set(Waffle_LIBRARIES "waffle-1")
